/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.confirmation.VolatilityCap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="VolatilityCapChoice")
@ImplementedBy(value=Default.class)
public interface VolatilityCapChoice
extends Validator<VolatilityCap> {
    public static final String NAME = "VolatilityCapChoice";
    public static final String DEFINITION = "optional choice totalVolatilityCap, volatilityCapSequence";

    public static class NoOp
    implements VolatilityCapChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, VolatilityCap volatilityCap) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements VolatilityCapChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, VolatilityCap volatilityCap) {
            ComparisonResult result = this.executeDataRule(volatilityCap);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)VolatilityCapChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"VolatilityCap", (RosettaPath)path, (String)VolatilityCapChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)VolatilityCapChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"VolatilityCap", (RosettaPath)path, (String)VolatilityCapChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(VolatilityCap volatilityCap) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)volatilityCap), Arrays.asList("totalVolatilityCap", "volatilityCapSequence"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.OPTIONAL);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

