/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.confirmation.Underlyer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="UnderlyerChoice")
@ImplementedBy(value=Default.class)
public interface UnderlyerChoice
extends Validator<Underlyer> {
    public static final String NAME = "UnderlyerChoice";
    public static final String DEFINITION = "one-of";

    public static class NoOp
    implements UnderlyerChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Underlyer underlyer) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements UnderlyerChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Underlyer underlyer) {
            ComparisonResult result = this.executeDataRule(underlyer);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)UnderlyerChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Underlyer", (RosettaPath)path, (String)UnderlyerChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)UnderlyerChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Underlyer", (RosettaPath)path, (String)UnderlyerChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(Underlyer underlyer) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)underlyer), Arrays.asList("singleUnderlyer", "basket"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

