/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.confirmation.TransformTypeChoice;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="TransformTypeChoiceChoice")
@ImplementedBy(value=Default.class)
public interface TransformTypeChoiceChoice
extends Validator<TransformTypeChoice> {
    public static final String NAME = "TransformTypeChoiceChoice";
    public static final String DEFINITION = "optional choice anyContents, xPath";

    public static class NoOp
    implements TransformTypeChoiceChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, TransformTypeChoice transformTypeChoice) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements TransformTypeChoiceChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, TransformTypeChoice transformTypeChoice) {
            ComparisonResult result = this.executeDataRule(transformTypeChoice);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)TransformTypeChoiceChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"TransformTypeChoice", (RosettaPath)path, (String)TransformTypeChoiceChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)TransformTypeChoiceChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"TransformTypeChoice", (RosettaPath)path, (String)TransformTypeChoiceChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(TransformTypeChoice transformTypeChoice) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)transformTypeChoice), Arrays.asList("anyContents", "xPath"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.OPTIONAL);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

