/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.confirmation.PeriodicPayment;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="PeriodicPaymentChoice")
@ImplementedBy(value=Default.class)
public interface PeriodicPaymentChoice
extends Validator<PeriodicPayment> {
    public static final String NAME = "PeriodicPaymentChoice";
    public static final String DEFINITION = "required choice fixedAmount, fixedAmountCalculation , floatingAmountCalculation";

    public static class NoOp
    implements PeriodicPaymentChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, PeriodicPayment periodicPayment) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements PeriodicPaymentChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, PeriodicPayment periodicPayment) {
            ComparisonResult result = this.executeDataRule(periodicPayment);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)PeriodicPaymentChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PeriodicPayment", (RosettaPath)path, (String)PeriodicPaymentChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)PeriodicPaymentChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PeriodicPayment", (RosettaPath)path, (String)PeriodicPaymentChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(PeriodicPayment periodicPayment) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)periodicPayment), Arrays.asList("fixedAmount", "fixedAmountCalculation", "floatingAmountCalculation"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

