/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.confirmation.PartialExerciseModel;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="PartialExerciseModelChoice")
@ImplementedBy(value=Default.class)
public interface PartialExerciseModelChoice
extends Validator<PartialExerciseModel> {
    public static final String NAME = "PartialExerciseModelChoice";
    public static final String DEFINITION = "required choice minimumNotionalAmount, minimumNumberOfOptions";

    public static class NoOp
    implements PartialExerciseModelChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, PartialExerciseModel partialExerciseModel) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements PartialExerciseModelChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, PartialExerciseModel partialExerciseModel) {
            ComparisonResult result = this.executeDataRule(partialExerciseModel);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)PartialExerciseModelChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PartialExerciseModel", (RosettaPath)path, (String)PartialExerciseModelChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)PartialExerciseModelChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PartialExerciseModel", (RosettaPath)path, (String)PartialExerciseModelChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(PartialExerciseModel partialExerciseModel) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)partialExerciseModel), Arrays.asList("minimumNotionalAmount", "minimumNumberOfOptions"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

