/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.confirmation.EventsChoice;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="EventsChoiceChoice")
@ImplementedBy(value=Default.class)
public interface EventsChoiceChoice
extends Validator<EventsChoice> {
    public static final String NAME = "EventsChoiceChoice";
    public static final String DEFINITION = "one-of";

    public static class NoOp
    implements EventsChoiceChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, EventsChoice eventsChoice) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements EventsChoiceChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, EventsChoice eventsChoice) {
            ComparisonResult result = this.executeDataRule(eventsChoice);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)EventsChoiceChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"EventsChoice", (RosettaPath)path, (String)EventsChoiceChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)EventsChoiceChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"EventsChoice", (RosettaPath)path, (String)EventsChoiceChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(EventsChoice eventsChoice) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)eventsChoice), Arrays.asList("tradingEventsBaseModel", "postTradeEventsBaseModel", "changeEventsBaseModel", "optionsEventsBaseModel", "additionalEvent"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

