/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.confirmation.CreditEntityModel;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="CreditEntityModelChoice")
@ImplementedBy(value=Default.class)
public interface CreditEntityModelChoice
extends Validator<CreditEntityModel> {
    public static final String NAME = "CreditEntityModelChoice";
    public static final String DEFINITION = "one-of";

    public static class NoOp
    implements CreditEntityModelChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CreditEntityModel creditEntityModel) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements CreditEntityModelChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CreditEntityModel creditEntityModel) {
            ComparisonResult result = this.executeDataRule(creditEntityModel);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)CreditEntityModelChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CreditEntityModel", (RosettaPath)path, (String)CreditEntityModelChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)CreditEntityModelChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CreditEntityModel", (RosettaPath)path, (String)CreditEntityModelChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(CreditEntityModel creditEntityModel) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)creditEntityModel), Arrays.asList("referenceEntity", "creditEntityReference"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

