/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.confirmation.CommodityOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="CommodityOptionChoice")
@ImplementedBy(value=Default.class)
public interface CommodityOptionChoice
extends Validator<CommodityOption> {
    public static final String NAME = "CommodityOptionChoice";
    public static final String DEFINITION = "required choice commodityFinancialOptionModel, commodityPhysicalOptionModel , commodityWeatherOptionModel";

    public static class NoOp
    implements CommodityOptionChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CommodityOption commodityOption) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements CommodityOptionChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CommodityOption commodityOption) {
            ComparisonResult result = this.executeDataRule(commodityOption);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)CommodityOptionChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CommodityOption", (RosettaPath)path, (String)CommodityOptionChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)CommodityOptionChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CommodityOption", (RosettaPath)path, (String)CommodityOptionChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(CommodityOption commodityOption) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)commodityOption), Arrays.asList("commodityFinancialOptionModel", "commodityPhysicalOptionModel", "commodityWeatherOptionModel"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

