/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.confirmation.CommodityFx;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="CommodityFxChoice")
@ImplementedBy(value=Default.class)
public interface CommodityFxChoice
extends Validator<CommodityFx> {
    public static final String NAME = "CommodityFxChoice";
    public static final String DEFINITION = "optional choice fixingTime, commodityFxSequence";

    public static class NoOp
    implements CommodityFxChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CommodityFx commodityFx) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements CommodityFxChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CommodityFx commodityFx) {
            ComparisonResult result = this.executeDataRule(commodityFx);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)CommodityFxChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CommodityFx", (RosettaPath)path, (String)CommodityFxChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)CommodityFxChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CommodityFx", (RosettaPath)path, (String)CommodityFxChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(CommodityFx commodityFx) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)commodityFx), Arrays.asList("fixingTime", "commodityFxSequence"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.OPTIONAL);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

