/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.confirmation.BlockTradeModel;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="BlockTradeModelChoice")
@ImplementedBy(value=Default.class)
public interface BlockTradeModelChoice
extends Validator<BlockTradeModel> {
    public static final String NAME = "BlockTradeModelChoice";
    public static final String DEFINITION = "optional choice largeSizeTrade, blockTradeIndicator";

    public static class NoOp
    implements BlockTradeModelChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, BlockTradeModel blockTradeModel) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements BlockTradeModelChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, BlockTradeModel blockTradeModel) {
            ComparisonResult result = this.executeDataRule(blockTradeModel);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)BlockTradeModelChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"BlockTradeModel", (RosettaPath)path, (String)BlockTradeModelChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)BlockTradeModelChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"BlockTradeModel", (RosettaPath)path, (String)BlockTradeModelChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(BlockTradeModel blockTradeModel) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)blockTradeModel), Arrays.asList("largeSizeTrade", "blockTradeIndicator"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.OPTIONAL);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

