/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.confirmation.BasketIdentifierModel;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="BasketIdentifierModelChoice")
@ImplementedBy(value=Default.class)
public interface BasketIdentifierModelChoice
extends Validator<BasketIdentifierModel> {
    public static final String NAME = "BasketIdentifierModelChoice";
    public static final String DEFINITION = "one-of";

    public static class NoOp
    implements BasketIdentifierModelChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, BasketIdentifierModel basketIdentifierModel) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements BasketIdentifierModelChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, BasketIdentifierModel basketIdentifierModel) {
            ComparisonResult result = this.executeDataRule(basketIdentifierModel);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)BasketIdentifierModelChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"BasketIdentifierModel", (RosettaPath)path, (String)BasketIdentifierModelChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)BasketIdentifierModelChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"BasketIdentifierModel", (RosettaPath)path, (String)BasketIdentifierModelChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(BasketIdentifierModel basketIdentifierModel) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)basketIdentifierModel), Arrays.asList("basketIdentifierModelSequence", "basketId"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

