/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation.custom.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.confirmation.custom.RateChoice;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="RateChoiceChoice")
@ImplementedBy(value=Default.class)
public interface RateChoiceChoice
extends Validator<RateChoice> {
    public static final String NAME = "RateChoiceChoice";
    public static final String DEFINITION = "";

    public static class NoOp
    implements RateChoiceChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, RateChoice rateChoice) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements RateChoiceChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, RateChoice rateChoice) {
            ComparisonResult result = this.executeDataRule(rateChoice);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)RateChoiceChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"RateChoice", (RosettaPath)path, (String)RateChoiceChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == RateChoiceChoice.DEFINITION) {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)RateChoiceChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"RateChoice", (RosettaPath)path, (String)RateChoiceChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(RateChoice rateChoice) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)rateChoice), Arrays.asList("StubFloatingRate", "LoanFloatingRate", "FloatingRateCalculation", "InflationRateCalculation"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

