/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation.custom.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import fpml.confirmation.Leg;
import fpml.confirmation.custom.LegChoice;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=ToLegChoiceDefault.class)
public abstract class ToLegChoice
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public LegChoice evaluate(Leg leg) {
        LegChoice legChoice;
        LegChoice.LegChoiceBuilder legChoiceBuilder = this.doEvaluate(leg);
        if (legChoiceBuilder == null) {
            legChoice = null;
        } else {
            legChoice = legChoiceBuilder.build();
            this.objectValidator.validate(LegChoice.class, (RosettaModelObject)legChoice);
        }
        return legChoice;
    }

    protected abstract LegChoice.LegChoiceBuilder doEvaluate(Leg var1);

    public static class ToLegChoiceDefault
    extends ToLegChoice {
        @Override
        protected LegChoice.LegChoiceBuilder doEvaluate(Leg leg) {
            LegChoice.LegChoiceBuilder legChoice = LegChoice.builder();
            return this.assignOutput(legChoice, leg);
        }

        protected LegChoice.LegChoiceBuilder assignOutput(LegChoice.LegChoiceBuilder legChoice, Leg leg) {
            return Optional.ofNullable(legChoice).map(o -> o.prune()).orElse(null);
        }
    }
}

