/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation.custom;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.Basket;
import fpml.confirmation.Bond;
import fpml.confirmation.Cash;
import fpml.confirmation.Commodity;
import fpml.confirmation.ConvertibleBond;
import fpml.confirmation.Deal;
import fpml.confirmation.DelayedDraw;
import fpml.confirmation.Deposit;
import fpml.confirmation.Equity;
import fpml.confirmation.ExchangeTradedContract;
import fpml.confirmation.ExchangeTradedFund;
import fpml.confirmation.Future;
import fpml.confirmation.Fx;
import fpml.confirmation.Index;
import fpml.confirmation.LetterOfCreditFacility;
import fpml.confirmation.Loan;
import fpml.confirmation.Mortgage;
import fpml.confirmation.MutualFund;
import fpml.confirmation.OptionElement;
import fpml.confirmation.RateIndex;
import fpml.confirmation.Revolver;
import fpml.confirmation.Security;
import fpml.confirmation.SimpleCreditDefaultSwap;
import fpml.confirmation.SimpleFra;
import fpml.confirmation.SimpleIRSwap;
import fpml.confirmation.TermLoan;
import fpml.confirmation.Warrant;
import fpml.confirmation.custom.meta.AssetChoiceMeta;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="AssetChoice", builder=AssetChoiceBuilderImpl.class, version="0.17.2")
@RuneDataType(value="AssetChoice", model="fpml", builder=AssetChoiceBuilderImpl.class, version="0.17.2")
public interface AssetChoice
extends RosettaModelObject {
    public static final AssetChoiceMeta metaData = new AssetChoiceMeta();

    public Cash getCash();

    public TermLoan getTermLoan();

    public DelayedDraw getDelayedDraw();

    public Revolver getRevolver();

    public LetterOfCreditFacility getLetterOfCreditFacility();

    public Deal getDeal();

    public SimpleIRSwap getSimpleIRSwap();

    public MutualFund getMutualFund();

    public RateIndex getRateIndex();

    public Deposit getDeposit();

    public Fx getFx();

    public Loan getLoan();

    public ConvertibleBond getConvertibleBond();

    public Bond getBond();

    public SimpleFra getSimpleFra();

    public OptionElement getOptionElement();

    public Warrant getWarrant();

    public ExchangeTradedContract getExchangeTradedContract();

    public Index getIndex();

    public ExchangeTradedFund getExchangeTradedFund();

    public Equity getEquity();

    public Future getFuture();

    public Mortgage getMortgage();

    public SimpleCreditDefaultSwap getSimpleCreditDefaultSwap();

    public Commodity getCommodity();

    public Security getSecurity();

    public Basket getBasket();

    public AssetChoice build();

    public AssetChoiceBuilder toBuilder();

    public static AssetChoiceBuilder builder() {
        return new AssetChoiceBuilderImpl();
    }

    default public RosettaMetaData<? extends AssetChoice> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends AssetChoice> getType() {
        return AssetChoice.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("Cash"), processor, Cash.class, this.getCash(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("TermLoan"), processor, TermLoan.class, this.getTermLoan(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("DelayedDraw"), processor, DelayedDraw.class, this.getDelayedDraw(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("Revolver"), processor, Revolver.class, this.getRevolver(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("LetterOfCreditFacility"), processor, LetterOfCreditFacility.class, this.getLetterOfCreditFacility(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("Deal"), processor, Deal.class, this.getDeal(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("SimpleIRSwap"), processor, SimpleIRSwap.class, this.getSimpleIRSwap(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("MutualFund"), processor, MutualFund.class, this.getMutualFund(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("RateIndex"), processor, RateIndex.class, this.getRateIndex(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("Deposit"), processor, Deposit.class, this.getDeposit(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("Fx"), processor, Fx.class, this.getFx(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("Loan"), processor, Loan.class, this.getLoan(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("ConvertibleBond"), processor, ConvertibleBond.class, this.getConvertibleBond(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("Bond"), processor, Bond.class, this.getBond(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("SimpleFra"), processor, SimpleFra.class, this.getSimpleFra(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("OptionElement"), processor, OptionElement.class, this.getOptionElement(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("Warrant"), processor, Warrant.class, this.getWarrant(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("ExchangeTradedContract"), processor, ExchangeTradedContract.class, this.getExchangeTradedContract(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("Index"), processor, Index.class, this.getIndex(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("ExchangeTradedFund"), processor, ExchangeTradedFund.class, this.getExchangeTradedFund(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("Equity"), processor, Equity.class, this.getEquity(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("Future"), processor, Future.class, this.getFuture(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("Mortgage"), processor, Mortgage.class, this.getMortgage(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("SimpleCreditDefaultSwap"), processor, SimpleCreditDefaultSwap.class, this.getSimpleCreditDefaultSwap(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("Commodity"), processor, Commodity.class, this.getCommodity(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("Security"), processor, Security.class, this.getSecurity(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("Basket"), processor, Basket.class, this.getBasket(), new AttributeMeta[0]);
    }

    public static class AssetChoiceBuilderImpl
    implements AssetChoiceBuilder {
        protected Cash.CashBuilder cash;
        protected TermLoan.TermLoanBuilder termLoan;
        protected DelayedDraw.DelayedDrawBuilder delayedDraw;
        protected Revolver.RevolverBuilder revolver;
        protected LetterOfCreditFacility.LetterOfCreditFacilityBuilder letterOfCreditFacility;
        protected Deal.DealBuilder deal;
        protected SimpleIRSwap.SimpleIRSwapBuilder simpleIRSwap;
        protected MutualFund.MutualFundBuilder mutualFund;
        protected RateIndex.RateIndexBuilder rateIndex;
        protected Deposit.DepositBuilder deposit;
        protected Fx.FxBuilder fx;
        protected Loan.LoanBuilder loan;
        protected ConvertibleBond.ConvertibleBondBuilder convertibleBond;
        protected Bond.BondBuilder bond;
        protected SimpleFra.SimpleFraBuilder simpleFra;
        protected OptionElement.OptionElementBuilder optionElement;
        protected Warrant.WarrantBuilder warrant;
        protected ExchangeTradedContract.ExchangeTradedContractBuilder exchangeTradedContract;
        protected Index.IndexBuilder index;
        protected ExchangeTradedFund.ExchangeTradedFundBuilder exchangeTradedFund;
        protected Equity.EquityBuilder equity;
        protected Future.FutureBuilder future;
        protected Mortgage.MortgageBuilder mortgage;
        protected SimpleCreditDefaultSwap.SimpleCreditDefaultSwapBuilder simpleCreditDefaultSwap;
        protected Commodity.CommodityBuilder commodity;
        protected Security.SecurityBuilder security;
        protected Basket.BasketBuilder basket;

        @Override
        @RosettaAttribute(value="Cash")
        @RuneAttribute(value="Cash")
        public Cash.CashBuilder getCash() {
            return this.cash;
        }

        @Override
        public Cash.CashBuilder getOrCreateCash() {
            Cash.CashBuilder result = this.cash != null ? this.cash : (this.cash = Cash.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="TermLoan")
        @RuneAttribute(value="TermLoan")
        public TermLoan.TermLoanBuilder getTermLoan() {
            return this.termLoan;
        }

        @Override
        public TermLoan.TermLoanBuilder getOrCreateTermLoan() {
            TermLoan.TermLoanBuilder result = this.termLoan != null ? this.termLoan : (this.termLoan = TermLoan.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="DelayedDraw")
        @RuneAttribute(value="DelayedDraw")
        public DelayedDraw.DelayedDrawBuilder getDelayedDraw() {
            return this.delayedDraw;
        }

        @Override
        public DelayedDraw.DelayedDrawBuilder getOrCreateDelayedDraw() {
            DelayedDraw.DelayedDrawBuilder result = this.delayedDraw != null ? this.delayedDraw : (this.delayedDraw = DelayedDraw.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="Revolver")
        @RuneAttribute(value="Revolver")
        public Revolver.RevolverBuilder getRevolver() {
            return this.revolver;
        }

        @Override
        public Revolver.RevolverBuilder getOrCreateRevolver() {
            Revolver.RevolverBuilder result = this.revolver != null ? this.revolver : (this.revolver = Revolver.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="LetterOfCreditFacility")
        @RuneAttribute(value="LetterOfCreditFacility")
        public LetterOfCreditFacility.LetterOfCreditFacilityBuilder getLetterOfCreditFacility() {
            return this.letterOfCreditFacility;
        }

        @Override
        public LetterOfCreditFacility.LetterOfCreditFacilityBuilder getOrCreateLetterOfCreditFacility() {
            LetterOfCreditFacility.LetterOfCreditFacilityBuilder result = this.letterOfCreditFacility != null ? this.letterOfCreditFacility : (this.letterOfCreditFacility = LetterOfCreditFacility.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="Deal")
        @RuneAttribute(value="Deal")
        public Deal.DealBuilder getDeal() {
            return this.deal;
        }

        @Override
        public Deal.DealBuilder getOrCreateDeal() {
            Deal.DealBuilder result = this.deal != null ? this.deal : (this.deal = Deal.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="SimpleIRSwap")
        @RuneAttribute(value="SimpleIRSwap")
        public SimpleIRSwap.SimpleIRSwapBuilder getSimpleIRSwap() {
            return this.simpleIRSwap;
        }

        @Override
        public SimpleIRSwap.SimpleIRSwapBuilder getOrCreateSimpleIRSwap() {
            SimpleIRSwap.SimpleIRSwapBuilder result = this.simpleIRSwap != null ? this.simpleIRSwap : (this.simpleIRSwap = SimpleIRSwap.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="MutualFund")
        @RuneAttribute(value="MutualFund")
        public MutualFund.MutualFundBuilder getMutualFund() {
            return this.mutualFund;
        }

        @Override
        public MutualFund.MutualFundBuilder getOrCreateMutualFund() {
            MutualFund.MutualFundBuilder result = this.mutualFund != null ? this.mutualFund : (this.mutualFund = MutualFund.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="RateIndex")
        @RuneAttribute(value="RateIndex")
        public RateIndex.RateIndexBuilder getRateIndex() {
            return this.rateIndex;
        }

        @Override
        public RateIndex.RateIndexBuilder getOrCreateRateIndex() {
            RateIndex.RateIndexBuilder result = this.rateIndex != null ? this.rateIndex : (this.rateIndex = RateIndex.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="Deposit")
        @RuneAttribute(value="Deposit")
        public Deposit.DepositBuilder getDeposit() {
            return this.deposit;
        }

        @Override
        public Deposit.DepositBuilder getOrCreateDeposit() {
            Deposit.DepositBuilder result = this.deposit != null ? this.deposit : (this.deposit = Deposit.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="Fx")
        @RuneAttribute(value="Fx")
        public Fx.FxBuilder getFx() {
            return this.fx;
        }

        @Override
        public Fx.FxBuilder getOrCreateFx() {
            Fx.FxBuilder result = this.fx != null ? this.fx : (this.fx = Fx.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="Loan")
        @RuneAttribute(value="Loan")
        public Loan.LoanBuilder getLoan() {
            return this.loan;
        }

        @Override
        public Loan.LoanBuilder getOrCreateLoan() {
            Loan.LoanBuilder result = this.loan != null ? this.loan : (this.loan = Loan.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="ConvertibleBond")
        @RuneAttribute(value="ConvertibleBond")
        public ConvertibleBond.ConvertibleBondBuilder getConvertibleBond() {
            return this.convertibleBond;
        }

        @Override
        public ConvertibleBond.ConvertibleBondBuilder getOrCreateConvertibleBond() {
            ConvertibleBond.ConvertibleBondBuilder result = this.convertibleBond != null ? this.convertibleBond : (this.convertibleBond = ConvertibleBond.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="Bond")
        @RuneAttribute(value="Bond")
        public Bond.BondBuilder getBond() {
            return this.bond;
        }

        @Override
        public Bond.BondBuilder getOrCreateBond() {
            Bond.BondBuilder result = this.bond != null ? this.bond : (this.bond = Bond.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="SimpleFra")
        @RuneAttribute(value="SimpleFra")
        public SimpleFra.SimpleFraBuilder getSimpleFra() {
            return this.simpleFra;
        }

        @Override
        public SimpleFra.SimpleFraBuilder getOrCreateSimpleFra() {
            SimpleFra.SimpleFraBuilder result = this.simpleFra != null ? this.simpleFra : (this.simpleFra = SimpleFra.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="OptionElement")
        @RuneAttribute(value="OptionElement")
        public OptionElement.OptionElementBuilder getOptionElement() {
            return this.optionElement;
        }

        @Override
        public OptionElement.OptionElementBuilder getOrCreateOptionElement() {
            OptionElement.OptionElementBuilder result = this.optionElement != null ? this.optionElement : (this.optionElement = OptionElement.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="Warrant")
        @RuneAttribute(value="Warrant")
        public Warrant.WarrantBuilder getWarrant() {
            return this.warrant;
        }

        @Override
        public Warrant.WarrantBuilder getOrCreateWarrant() {
            Warrant.WarrantBuilder result = this.warrant != null ? this.warrant : (this.warrant = Warrant.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="ExchangeTradedContract")
        @RuneAttribute(value="ExchangeTradedContract")
        public ExchangeTradedContract.ExchangeTradedContractBuilder getExchangeTradedContract() {
            return this.exchangeTradedContract;
        }

        @Override
        public ExchangeTradedContract.ExchangeTradedContractBuilder getOrCreateExchangeTradedContract() {
            ExchangeTradedContract.ExchangeTradedContractBuilder result = this.exchangeTradedContract != null ? this.exchangeTradedContract : (this.exchangeTradedContract = ExchangeTradedContract.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="Index")
        @RuneAttribute(value="Index")
        public Index.IndexBuilder getIndex() {
            return this.index;
        }

        @Override
        public Index.IndexBuilder getOrCreateIndex() {
            Index.IndexBuilder result = this.index != null ? this.index : (this.index = Index.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="ExchangeTradedFund")
        @RuneAttribute(value="ExchangeTradedFund")
        public ExchangeTradedFund.ExchangeTradedFundBuilder getExchangeTradedFund() {
            return this.exchangeTradedFund;
        }

        @Override
        public ExchangeTradedFund.ExchangeTradedFundBuilder getOrCreateExchangeTradedFund() {
            ExchangeTradedFund.ExchangeTradedFundBuilder result = this.exchangeTradedFund != null ? this.exchangeTradedFund : (this.exchangeTradedFund = ExchangeTradedFund.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="Equity")
        @RuneAttribute(value="Equity")
        public Equity.EquityBuilder getEquity() {
            return this.equity;
        }

        @Override
        public Equity.EquityBuilder getOrCreateEquity() {
            Equity.EquityBuilder result = this.equity != null ? this.equity : (this.equity = Equity.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="Future")
        @RuneAttribute(value="Future")
        public Future.FutureBuilder getFuture() {
            return this.future;
        }

        @Override
        public Future.FutureBuilder getOrCreateFuture() {
            Future.FutureBuilder result = this.future != null ? this.future : (this.future = Future.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="Mortgage")
        @RuneAttribute(value="Mortgage")
        public Mortgage.MortgageBuilder getMortgage() {
            return this.mortgage;
        }

        @Override
        public Mortgage.MortgageBuilder getOrCreateMortgage() {
            Mortgage.MortgageBuilder result = this.mortgage != null ? this.mortgage : (this.mortgage = Mortgage.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="SimpleCreditDefaultSwap")
        @RuneAttribute(value="SimpleCreditDefaultSwap")
        public SimpleCreditDefaultSwap.SimpleCreditDefaultSwapBuilder getSimpleCreditDefaultSwap() {
            return this.simpleCreditDefaultSwap;
        }

        @Override
        public SimpleCreditDefaultSwap.SimpleCreditDefaultSwapBuilder getOrCreateSimpleCreditDefaultSwap() {
            SimpleCreditDefaultSwap.SimpleCreditDefaultSwapBuilder result = this.simpleCreditDefaultSwap != null ? this.simpleCreditDefaultSwap : (this.simpleCreditDefaultSwap = SimpleCreditDefaultSwap.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="Commodity")
        @RuneAttribute(value="Commodity")
        public Commodity.CommodityBuilder getCommodity() {
            return this.commodity;
        }

        @Override
        public Commodity.CommodityBuilder getOrCreateCommodity() {
            Commodity.CommodityBuilder result = this.commodity != null ? this.commodity : (this.commodity = Commodity.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="Security")
        @RuneAttribute(value="Security")
        public Security.SecurityBuilder getSecurity() {
            return this.security;
        }

        @Override
        public Security.SecurityBuilder getOrCreateSecurity() {
            Security.SecurityBuilder result = this.security != null ? this.security : (this.security = Security.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="Basket")
        @RuneAttribute(value="Basket")
        public Basket.BasketBuilder getBasket() {
            return this.basket;
        }

        @Override
        public Basket.BasketBuilder getOrCreateBasket() {
            Basket.BasketBuilder result = this.basket != null ? this.basket : (this.basket = Basket.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="Cash")
        @RuneAttribute(value="Cash")
        public AssetChoiceBuilder setCash(Cash _cash) {
            this.cash = _cash == null ? null : _cash.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="TermLoan")
        @RuneAttribute(value="TermLoan")
        public AssetChoiceBuilder setTermLoan(TermLoan _termLoan) {
            this.termLoan = _termLoan == null ? null : _termLoan.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="DelayedDraw")
        @RuneAttribute(value="DelayedDraw")
        public AssetChoiceBuilder setDelayedDraw(DelayedDraw _delayedDraw) {
            this.delayedDraw = _delayedDraw == null ? null : _delayedDraw.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="Revolver")
        @RuneAttribute(value="Revolver")
        public AssetChoiceBuilder setRevolver(Revolver _revolver) {
            this.revolver = _revolver == null ? null : _revolver.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="LetterOfCreditFacility")
        @RuneAttribute(value="LetterOfCreditFacility")
        public AssetChoiceBuilder setLetterOfCreditFacility(LetterOfCreditFacility _letterOfCreditFacility) {
            this.letterOfCreditFacility = _letterOfCreditFacility == null ? null : _letterOfCreditFacility.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="Deal")
        @RuneAttribute(value="Deal")
        public AssetChoiceBuilder setDeal(Deal _deal) {
            this.deal = _deal == null ? null : _deal.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="SimpleIRSwap")
        @RuneAttribute(value="SimpleIRSwap")
        public AssetChoiceBuilder setSimpleIRSwap(SimpleIRSwap _simpleIRSwap) {
            this.simpleIRSwap = _simpleIRSwap == null ? null : _simpleIRSwap.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="MutualFund")
        @RuneAttribute(value="MutualFund")
        public AssetChoiceBuilder setMutualFund(MutualFund _mutualFund) {
            this.mutualFund = _mutualFund == null ? null : _mutualFund.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="RateIndex")
        @RuneAttribute(value="RateIndex")
        public AssetChoiceBuilder setRateIndex(RateIndex _rateIndex) {
            this.rateIndex = _rateIndex == null ? null : _rateIndex.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="Deposit")
        @RuneAttribute(value="Deposit")
        public AssetChoiceBuilder setDeposit(Deposit _deposit) {
            this.deposit = _deposit == null ? null : _deposit.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="Fx")
        @RuneAttribute(value="Fx")
        public AssetChoiceBuilder setFx(Fx _fx) {
            this.fx = _fx == null ? null : _fx.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="Loan")
        @RuneAttribute(value="Loan")
        public AssetChoiceBuilder setLoan(Loan _loan) {
            this.loan = _loan == null ? null : _loan.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="ConvertibleBond")
        @RuneAttribute(value="ConvertibleBond")
        public AssetChoiceBuilder setConvertibleBond(ConvertibleBond _convertibleBond) {
            this.convertibleBond = _convertibleBond == null ? null : _convertibleBond.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="Bond")
        @RuneAttribute(value="Bond")
        public AssetChoiceBuilder setBond(Bond _bond) {
            this.bond = _bond == null ? null : _bond.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="SimpleFra")
        @RuneAttribute(value="SimpleFra")
        public AssetChoiceBuilder setSimpleFra(SimpleFra _simpleFra) {
            this.simpleFra = _simpleFra == null ? null : _simpleFra.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="OptionElement")
        @RuneAttribute(value="OptionElement")
        public AssetChoiceBuilder setOptionElement(OptionElement _optionElement) {
            this.optionElement = _optionElement == null ? null : _optionElement.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="Warrant")
        @RuneAttribute(value="Warrant")
        public AssetChoiceBuilder setWarrant(Warrant _warrant) {
            this.warrant = _warrant == null ? null : _warrant.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="ExchangeTradedContract")
        @RuneAttribute(value="ExchangeTradedContract")
        public AssetChoiceBuilder setExchangeTradedContract(ExchangeTradedContract _exchangeTradedContract) {
            this.exchangeTradedContract = _exchangeTradedContract == null ? null : _exchangeTradedContract.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="Index")
        @RuneAttribute(value="Index")
        public AssetChoiceBuilder setIndex(Index _index) {
            this.index = _index == null ? null : _index.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="ExchangeTradedFund")
        @RuneAttribute(value="ExchangeTradedFund")
        public AssetChoiceBuilder setExchangeTradedFund(ExchangeTradedFund _exchangeTradedFund) {
            this.exchangeTradedFund = _exchangeTradedFund == null ? null : _exchangeTradedFund.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="Equity")
        @RuneAttribute(value="Equity")
        public AssetChoiceBuilder setEquity(Equity _equity) {
            this.equity = _equity == null ? null : _equity.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="Future")
        @RuneAttribute(value="Future")
        public AssetChoiceBuilder setFuture(Future _future) {
            this.future = _future == null ? null : _future.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="Mortgage")
        @RuneAttribute(value="Mortgage")
        public AssetChoiceBuilder setMortgage(Mortgage _mortgage) {
            this.mortgage = _mortgage == null ? null : _mortgage.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="SimpleCreditDefaultSwap")
        @RuneAttribute(value="SimpleCreditDefaultSwap")
        public AssetChoiceBuilder setSimpleCreditDefaultSwap(SimpleCreditDefaultSwap _simpleCreditDefaultSwap) {
            this.simpleCreditDefaultSwap = _simpleCreditDefaultSwap == null ? null : _simpleCreditDefaultSwap.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="Commodity")
        @RuneAttribute(value="Commodity")
        public AssetChoiceBuilder setCommodity(Commodity _commodity) {
            this.commodity = _commodity == null ? null : _commodity.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="Security")
        @RuneAttribute(value="Security")
        public AssetChoiceBuilder setSecurity(Security _security) {
            this.security = _security == null ? null : _security.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="Basket")
        @RuneAttribute(value="Basket")
        public AssetChoiceBuilder setBasket(Basket _basket) {
            this.basket = _basket == null ? null : _basket.toBuilder();
            return this;
        }

        @Override
        public AssetChoice build() {
            return new AssetChoiceImpl(this);
        }

        @Override
        public AssetChoiceBuilder toBuilder() {
            return this;
        }

        @Override
        public AssetChoiceBuilder prune() {
            if (this.cash != null && !this.cash.prune().hasData()) {
                this.cash = null;
            }
            if (this.termLoan != null && !this.termLoan.prune().hasData()) {
                this.termLoan = null;
            }
            if (this.delayedDraw != null && !this.delayedDraw.prune().hasData()) {
                this.delayedDraw = null;
            }
            if (this.revolver != null && !this.revolver.prune().hasData()) {
                this.revolver = null;
            }
            if (this.letterOfCreditFacility != null && !this.letterOfCreditFacility.prune().hasData()) {
                this.letterOfCreditFacility = null;
            }
            if (this.deal != null && !this.deal.prune().hasData()) {
                this.deal = null;
            }
            if (this.simpleIRSwap != null && !this.simpleIRSwap.prune().hasData()) {
                this.simpleIRSwap = null;
            }
            if (this.mutualFund != null && !this.mutualFund.prune().hasData()) {
                this.mutualFund = null;
            }
            if (this.rateIndex != null && !this.rateIndex.prune().hasData()) {
                this.rateIndex = null;
            }
            if (this.deposit != null && !this.deposit.prune().hasData()) {
                this.deposit = null;
            }
            if (this.fx != null && !this.fx.prune().hasData()) {
                this.fx = null;
            }
            if (this.loan != null && !this.loan.prune().hasData()) {
                this.loan = null;
            }
            if (this.convertibleBond != null && !this.convertibleBond.prune().hasData()) {
                this.convertibleBond = null;
            }
            if (this.bond != null && !this.bond.prune().hasData()) {
                this.bond = null;
            }
            if (this.simpleFra != null && !this.simpleFra.prune().hasData()) {
                this.simpleFra = null;
            }
            if (this.optionElement != null && !this.optionElement.prune().hasData()) {
                this.optionElement = null;
            }
            if (this.warrant != null && !this.warrant.prune().hasData()) {
                this.warrant = null;
            }
            if (this.exchangeTradedContract != null && !this.exchangeTradedContract.prune().hasData()) {
                this.exchangeTradedContract = null;
            }
            if (this.index != null && !this.index.prune().hasData()) {
                this.index = null;
            }
            if (this.exchangeTradedFund != null && !this.exchangeTradedFund.prune().hasData()) {
                this.exchangeTradedFund = null;
            }
            if (this.equity != null && !this.equity.prune().hasData()) {
                this.equity = null;
            }
            if (this.future != null && !this.future.prune().hasData()) {
                this.future = null;
            }
            if (this.mortgage != null && !this.mortgage.prune().hasData()) {
                this.mortgage = null;
            }
            if (this.simpleCreditDefaultSwap != null && !this.simpleCreditDefaultSwap.prune().hasData()) {
                this.simpleCreditDefaultSwap = null;
            }
            if (this.commodity != null && !this.commodity.prune().hasData()) {
                this.commodity = null;
            }
            if (this.security != null && !this.security.prune().hasData()) {
                this.security = null;
            }
            if (this.basket != null && !this.basket.prune().hasData()) {
                this.basket = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getCash() != null && this.getCash().hasData()) {
                return true;
            }
            if (this.getTermLoan() != null && this.getTermLoan().hasData()) {
                return true;
            }
            if (this.getDelayedDraw() != null && this.getDelayedDraw().hasData()) {
                return true;
            }
            if (this.getRevolver() != null && this.getRevolver().hasData()) {
                return true;
            }
            if (this.getLetterOfCreditFacility() != null && this.getLetterOfCreditFacility().hasData()) {
                return true;
            }
            if (this.getDeal() != null && this.getDeal().hasData()) {
                return true;
            }
            if (this.getSimpleIRSwap() != null && this.getSimpleIRSwap().hasData()) {
                return true;
            }
            if (this.getMutualFund() != null && this.getMutualFund().hasData()) {
                return true;
            }
            if (this.getRateIndex() != null && this.getRateIndex().hasData()) {
                return true;
            }
            if (this.getDeposit() != null && this.getDeposit().hasData()) {
                return true;
            }
            if (this.getFx() != null && this.getFx().hasData()) {
                return true;
            }
            if (this.getLoan() != null && this.getLoan().hasData()) {
                return true;
            }
            if (this.getConvertibleBond() != null && this.getConvertibleBond().hasData()) {
                return true;
            }
            if (this.getBond() != null && this.getBond().hasData()) {
                return true;
            }
            if (this.getSimpleFra() != null && this.getSimpleFra().hasData()) {
                return true;
            }
            if (this.getOptionElement() != null && this.getOptionElement().hasData()) {
                return true;
            }
            if (this.getWarrant() != null && this.getWarrant().hasData()) {
                return true;
            }
            if (this.getExchangeTradedContract() != null && this.getExchangeTradedContract().hasData()) {
                return true;
            }
            if (this.getIndex() != null && this.getIndex().hasData()) {
                return true;
            }
            if (this.getExchangeTradedFund() != null && this.getExchangeTradedFund().hasData()) {
                return true;
            }
            if (this.getEquity() != null && this.getEquity().hasData()) {
                return true;
            }
            if (this.getFuture() != null && this.getFuture().hasData()) {
                return true;
            }
            if (this.getMortgage() != null && this.getMortgage().hasData()) {
                return true;
            }
            if (this.getSimpleCreditDefaultSwap() != null && this.getSimpleCreditDefaultSwap().hasData()) {
                return true;
            }
            if (this.getCommodity() != null && this.getCommodity().hasData()) {
                return true;
            }
            if (this.getSecurity() != null && this.getSecurity().hasData()) {
                return true;
            }
            return this.getBasket() != null && this.getBasket().hasData();
        }

        public AssetChoiceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            AssetChoiceBuilder o = (AssetChoiceBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCash(), (RosettaModelObjectBuilder)o.getCash(), this::setCash);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTermLoan(), (RosettaModelObjectBuilder)o.getTermLoan(), this::setTermLoan);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDelayedDraw(), (RosettaModelObjectBuilder)o.getDelayedDraw(), this::setDelayedDraw);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getRevolver(), (RosettaModelObjectBuilder)o.getRevolver(), this::setRevolver);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLetterOfCreditFacility(), (RosettaModelObjectBuilder)o.getLetterOfCreditFacility(), this::setLetterOfCreditFacility);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDeal(), (RosettaModelObjectBuilder)o.getDeal(), this::setDeal);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSimpleIRSwap(), (RosettaModelObjectBuilder)o.getSimpleIRSwap(), this::setSimpleIRSwap);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMutualFund(), (RosettaModelObjectBuilder)o.getMutualFund(), this::setMutualFund);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getRateIndex(), (RosettaModelObjectBuilder)o.getRateIndex(), this::setRateIndex);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDeposit(), (RosettaModelObjectBuilder)o.getDeposit(), this::setDeposit);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFx(), (RosettaModelObjectBuilder)o.getFx(), this::setFx);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLoan(), (RosettaModelObjectBuilder)o.getLoan(), this::setLoan);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getConvertibleBond(), (RosettaModelObjectBuilder)o.getConvertibleBond(), this::setConvertibleBond);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBond(), (RosettaModelObjectBuilder)o.getBond(), this::setBond);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSimpleFra(), (RosettaModelObjectBuilder)o.getSimpleFra(), this::setSimpleFra);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getOptionElement(), (RosettaModelObjectBuilder)o.getOptionElement(), this::setOptionElement);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getWarrant(), (RosettaModelObjectBuilder)o.getWarrant(), this::setWarrant);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExchangeTradedContract(), (RosettaModelObjectBuilder)o.getExchangeTradedContract(), this::setExchangeTradedContract);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getIndex(), (RosettaModelObjectBuilder)o.getIndex(), this::setIndex);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExchangeTradedFund(), (RosettaModelObjectBuilder)o.getExchangeTradedFund(), this::setExchangeTradedFund);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEquity(), (RosettaModelObjectBuilder)o.getEquity(), this::setEquity);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFuture(), (RosettaModelObjectBuilder)o.getFuture(), this::setFuture);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMortgage(), (RosettaModelObjectBuilder)o.getMortgage(), this::setMortgage);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSimpleCreditDefaultSwap(), (RosettaModelObjectBuilder)o.getSimpleCreditDefaultSwap(), this::setSimpleCreditDefaultSwap);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCommodity(), (RosettaModelObjectBuilder)o.getCommodity(), this::setCommodity);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSecurity(), (RosettaModelObjectBuilder)o.getSecurity(), this::setSecurity);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBasket(), (RosettaModelObjectBuilder)o.getBasket(), this::setBasket);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AssetChoice _that = this.getType().cast(o);
            if (!Objects.equals(this.cash, _that.getCash())) {
                return false;
            }
            if (!Objects.equals(this.termLoan, _that.getTermLoan())) {
                return false;
            }
            if (!Objects.equals(this.delayedDraw, _that.getDelayedDraw())) {
                return false;
            }
            if (!Objects.equals(this.revolver, _that.getRevolver())) {
                return false;
            }
            if (!Objects.equals(this.letterOfCreditFacility, _that.getLetterOfCreditFacility())) {
                return false;
            }
            if (!Objects.equals(this.deal, _that.getDeal())) {
                return false;
            }
            if (!Objects.equals(this.simpleIRSwap, _that.getSimpleIRSwap())) {
                return false;
            }
            if (!Objects.equals(this.mutualFund, _that.getMutualFund())) {
                return false;
            }
            if (!Objects.equals(this.rateIndex, _that.getRateIndex())) {
                return false;
            }
            if (!Objects.equals(this.deposit, _that.getDeposit())) {
                return false;
            }
            if (!Objects.equals(this.fx, _that.getFx())) {
                return false;
            }
            if (!Objects.equals(this.loan, _that.getLoan())) {
                return false;
            }
            if (!Objects.equals(this.convertibleBond, _that.getConvertibleBond())) {
                return false;
            }
            if (!Objects.equals(this.bond, _that.getBond())) {
                return false;
            }
            if (!Objects.equals(this.simpleFra, _that.getSimpleFra())) {
                return false;
            }
            if (!Objects.equals(this.optionElement, _that.getOptionElement())) {
                return false;
            }
            if (!Objects.equals(this.warrant, _that.getWarrant())) {
                return false;
            }
            if (!Objects.equals(this.exchangeTradedContract, _that.getExchangeTradedContract())) {
                return false;
            }
            if (!Objects.equals(this.index, _that.getIndex())) {
                return false;
            }
            if (!Objects.equals(this.exchangeTradedFund, _that.getExchangeTradedFund())) {
                return false;
            }
            if (!Objects.equals(this.equity, _that.getEquity())) {
                return false;
            }
            if (!Objects.equals(this.future, _that.getFuture())) {
                return false;
            }
            if (!Objects.equals(this.mortgage, _that.getMortgage())) {
                return false;
            }
            if (!Objects.equals(this.simpleCreditDefaultSwap, _that.getSimpleCreditDefaultSwap())) {
                return false;
            }
            if (!Objects.equals(this.commodity, _that.getCommodity())) {
                return false;
            }
            if (!Objects.equals(this.security, _that.getSecurity())) {
                return false;
            }
            return Objects.equals(this.basket, _that.getBasket());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.cash != null ? this.cash.hashCode() : 0);
            _result = 31 * _result + (this.termLoan != null ? this.termLoan.hashCode() : 0);
            _result = 31 * _result + (this.delayedDraw != null ? this.delayedDraw.hashCode() : 0);
            _result = 31 * _result + (this.revolver != null ? this.revolver.hashCode() : 0);
            _result = 31 * _result + (this.letterOfCreditFacility != null ? this.letterOfCreditFacility.hashCode() : 0);
            _result = 31 * _result + (this.deal != null ? this.deal.hashCode() : 0);
            _result = 31 * _result + (this.simpleIRSwap != null ? this.simpleIRSwap.hashCode() : 0);
            _result = 31 * _result + (this.mutualFund != null ? this.mutualFund.hashCode() : 0);
            _result = 31 * _result + (this.rateIndex != null ? this.rateIndex.hashCode() : 0);
            _result = 31 * _result + (this.deposit != null ? this.deposit.hashCode() : 0);
            _result = 31 * _result + (this.fx != null ? this.fx.hashCode() : 0);
            _result = 31 * _result + (this.loan != null ? this.loan.hashCode() : 0);
            _result = 31 * _result + (this.convertibleBond != null ? this.convertibleBond.hashCode() : 0);
            _result = 31 * _result + (this.bond != null ? this.bond.hashCode() : 0);
            _result = 31 * _result + (this.simpleFra != null ? this.simpleFra.hashCode() : 0);
            _result = 31 * _result + (this.optionElement != null ? this.optionElement.hashCode() : 0);
            _result = 31 * _result + (this.warrant != null ? this.warrant.hashCode() : 0);
            _result = 31 * _result + (this.exchangeTradedContract != null ? this.exchangeTradedContract.hashCode() : 0);
            _result = 31 * _result + (this.index != null ? this.index.hashCode() : 0);
            _result = 31 * _result + (this.exchangeTradedFund != null ? this.exchangeTradedFund.hashCode() : 0);
            _result = 31 * _result + (this.equity != null ? this.equity.hashCode() : 0);
            _result = 31 * _result + (this.future != null ? this.future.hashCode() : 0);
            _result = 31 * _result + (this.mortgage != null ? this.mortgage.hashCode() : 0);
            _result = 31 * _result + (this.simpleCreditDefaultSwap != null ? this.simpleCreditDefaultSwap.hashCode() : 0);
            _result = 31 * _result + (this.commodity != null ? this.commodity.hashCode() : 0);
            _result = 31 * _result + (this.security != null ? this.security.hashCode() : 0);
            _result = 31 * _result + (this.basket != null ? this.basket.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AssetChoiceBuilder {Cash=" + this.cash + ", TermLoan=" + this.termLoan + ", DelayedDraw=" + this.delayedDraw + ", Revolver=" + this.revolver + ", LetterOfCreditFacility=" + this.letterOfCreditFacility + ", Deal=" + this.deal + ", SimpleIRSwap=" + this.simpleIRSwap + ", MutualFund=" + this.mutualFund + ", RateIndex=" + this.rateIndex + ", Deposit=" + this.deposit + ", Fx=" + this.fx + ", Loan=" + this.loan + ", ConvertibleBond=" + this.convertibleBond + ", Bond=" + this.bond + ", SimpleFra=" + this.simpleFra + ", OptionElement=" + this.optionElement + ", Warrant=" + this.warrant + ", ExchangeTradedContract=" + this.exchangeTradedContract + ", Index=" + this.index + ", ExchangeTradedFund=" + this.exchangeTradedFund + ", Equity=" + this.equity + ", Future=" + this.future + ", Mortgage=" + this.mortgage + ", SimpleCreditDefaultSwap=" + this.simpleCreditDefaultSwap + ", Commodity=" + this.commodity + ", Security=" + this.security + ", Basket=" + this.basket + '}';
        }
    }

    public static interface AssetChoiceBuilder
    extends AssetChoice,
    RosettaModelObjectBuilder {
        public Cash.CashBuilder getOrCreateCash();

        @Override
        public Cash.CashBuilder getCash();

        public TermLoan.TermLoanBuilder getOrCreateTermLoan();

        @Override
        public TermLoan.TermLoanBuilder getTermLoan();

        public DelayedDraw.DelayedDrawBuilder getOrCreateDelayedDraw();

        @Override
        public DelayedDraw.DelayedDrawBuilder getDelayedDraw();

        public Revolver.RevolverBuilder getOrCreateRevolver();

        @Override
        public Revolver.RevolverBuilder getRevolver();

        public LetterOfCreditFacility.LetterOfCreditFacilityBuilder getOrCreateLetterOfCreditFacility();

        @Override
        public LetterOfCreditFacility.LetterOfCreditFacilityBuilder getLetterOfCreditFacility();

        public Deal.DealBuilder getOrCreateDeal();

        @Override
        public Deal.DealBuilder getDeal();

        public SimpleIRSwap.SimpleIRSwapBuilder getOrCreateSimpleIRSwap();

        @Override
        public SimpleIRSwap.SimpleIRSwapBuilder getSimpleIRSwap();

        public MutualFund.MutualFundBuilder getOrCreateMutualFund();

        @Override
        public MutualFund.MutualFundBuilder getMutualFund();

        public RateIndex.RateIndexBuilder getOrCreateRateIndex();

        @Override
        public RateIndex.RateIndexBuilder getRateIndex();

        public Deposit.DepositBuilder getOrCreateDeposit();

        @Override
        public Deposit.DepositBuilder getDeposit();

        public Fx.FxBuilder getOrCreateFx();

        @Override
        public Fx.FxBuilder getFx();

        public Loan.LoanBuilder getOrCreateLoan();

        @Override
        public Loan.LoanBuilder getLoan();

        public ConvertibleBond.ConvertibleBondBuilder getOrCreateConvertibleBond();

        @Override
        public ConvertibleBond.ConvertibleBondBuilder getConvertibleBond();

        public Bond.BondBuilder getOrCreateBond();

        @Override
        public Bond.BondBuilder getBond();

        public SimpleFra.SimpleFraBuilder getOrCreateSimpleFra();

        @Override
        public SimpleFra.SimpleFraBuilder getSimpleFra();

        public OptionElement.OptionElementBuilder getOrCreateOptionElement();

        @Override
        public OptionElement.OptionElementBuilder getOptionElement();

        public Warrant.WarrantBuilder getOrCreateWarrant();

        @Override
        public Warrant.WarrantBuilder getWarrant();

        public ExchangeTradedContract.ExchangeTradedContractBuilder getOrCreateExchangeTradedContract();

        @Override
        public ExchangeTradedContract.ExchangeTradedContractBuilder getExchangeTradedContract();

        public Index.IndexBuilder getOrCreateIndex();

        @Override
        public Index.IndexBuilder getIndex();

        public ExchangeTradedFund.ExchangeTradedFundBuilder getOrCreateExchangeTradedFund();

        @Override
        public ExchangeTradedFund.ExchangeTradedFundBuilder getExchangeTradedFund();

        public Equity.EquityBuilder getOrCreateEquity();

        @Override
        public Equity.EquityBuilder getEquity();

        public Future.FutureBuilder getOrCreateFuture();

        @Override
        public Future.FutureBuilder getFuture();

        public Mortgage.MortgageBuilder getOrCreateMortgage();

        @Override
        public Mortgage.MortgageBuilder getMortgage();

        public SimpleCreditDefaultSwap.SimpleCreditDefaultSwapBuilder getOrCreateSimpleCreditDefaultSwap();

        @Override
        public SimpleCreditDefaultSwap.SimpleCreditDefaultSwapBuilder getSimpleCreditDefaultSwap();

        public Commodity.CommodityBuilder getOrCreateCommodity();

        @Override
        public Commodity.CommodityBuilder getCommodity();

        public Security.SecurityBuilder getOrCreateSecurity();

        @Override
        public Security.SecurityBuilder getSecurity();

        public Basket.BasketBuilder getOrCreateBasket();

        @Override
        public Basket.BasketBuilder getBasket();

        public AssetChoiceBuilder setCash(Cash var1);

        public AssetChoiceBuilder setTermLoan(TermLoan var1);

        public AssetChoiceBuilder setDelayedDraw(DelayedDraw var1);

        public AssetChoiceBuilder setRevolver(Revolver var1);

        public AssetChoiceBuilder setLetterOfCreditFacility(LetterOfCreditFacility var1);

        public AssetChoiceBuilder setDeal(Deal var1);

        public AssetChoiceBuilder setSimpleIRSwap(SimpleIRSwap var1);

        public AssetChoiceBuilder setMutualFund(MutualFund var1);

        public AssetChoiceBuilder setRateIndex(RateIndex var1);

        public AssetChoiceBuilder setDeposit(Deposit var1);

        public AssetChoiceBuilder setFx(Fx var1);

        public AssetChoiceBuilder setLoan(Loan var1);

        public AssetChoiceBuilder setConvertibleBond(ConvertibleBond var1);

        public AssetChoiceBuilder setBond(Bond var1);

        public AssetChoiceBuilder setSimpleFra(SimpleFra var1);

        public AssetChoiceBuilder setOptionElement(OptionElement var1);

        public AssetChoiceBuilder setWarrant(Warrant var1);

        public AssetChoiceBuilder setExchangeTradedContract(ExchangeTradedContract var1);

        public AssetChoiceBuilder setIndex(Index var1);

        public AssetChoiceBuilder setExchangeTradedFund(ExchangeTradedFund var1);

        public AssetChoiceBuilder setEquity(Equity var1);

        public AssetChoiceBuilder setFuture(Future var1);

        public AssetChoiceBuilder setMortgage(Mortgage var1);

        public AssetChoiceBuilder setSimpleCreditDefaultSwap(SimpleCreditDefaultSwap var1);

        public AssetChoiceBuilder setCommodity(Commodity var1);

        public AssetChoiceBuilder setSecurity(Security var1);

        public AssetChoiceBuilder setBasket(Basket var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("Cash"), processor, Cash.CashBuilder.class, this.getCash(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("TermLoan"), processor, TermLoan.TermLoanBuilder.class, this.getTermLoan(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("DelayedDraw"), processor, DelayedDraw.DelayedDrawBuilder.class, this.getDelayedDraw(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("Revolver"), processor, Revolver.RevolverBuilder.class, this.getRevolver(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("LetterOfCreditFacility"), processor, LetterOfCreditFacility.LetterOfCreditFacilityBuilder.class, this.getLetterOfCreditFacility(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("Deal"), processor, Deal.DealBuilder.class, this.getDeal(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("SimpleIRSwap"), processor, SimpleIRSwap.SimpleIRSwapBuilder.class, this.getSimpleIRSwap(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("MutualFund"), processor, MutualFund.MutualFundBuilder.class, this.getMutualFund(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("RateIndex"), processor, RateIndex.RateIndexBuilder.class, this.getRateIndex(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("Deposit"), processor, Deposit.DepositBuilder.class, this.getDeposit(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("Fx"), processor, Fx.FxBuilder.class, this.getFx(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("Loan"), processor, Loan.LoanBuilder.class, this.getLoan(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("ConvertibleBond"), processor, ConvertibleBond.ConvertibleBondBuilder.class, this.getConvertibleBond(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("Bond"), processor, Bond.BondBuilder.class, this.getBond(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("SimpleFra"), processor, SimpleFra.SimpleFraBuilder.class, this.getSimpleFra(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("OptionElement"), processor, OptionElement.OptionElementBuilder.class, this.getOptionElement(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("Warrant"), processor, Warrant.WarrantBuilder.class, this.getWarrant(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("ExchangeTradedContract"), processor, ExchangeTradedContract.ExchangeTradedContractBuilder.class, this.getExchangeTradedContract(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("Index"), processor, Index.IndexBuilder.class, this.getIndex(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("ExchangeTradedFund"), processor, ExchangeTradedFund.ExchangeTradedFundBuilder.class, this.getExchangeTradedFund(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("Equity"), processor, Equity.EquityBuilder.class, this.getEquity(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("Future"), processor, Future.FutureBuilder.class, this.getFuture(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("Mortgage"), processor, Mortgage.MortgageBuilder.class, this.getMortgage(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("SimpleCreditDefaultSwap"), processor, SimpleCreditDefaultSwap.SimpleCreditDefaultSwapBuilder.class, this.getSimpleCreditDefaultSwap(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("Commodity"), processor, Commodity.CommodityBuilder.class, this.getCommodity(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("Security"), processor, Security.SecurityBuilder.class, this.getSecurity(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("Basket"), processor, Basket.BasketBuilder.class, this.getBasket(), new AttributeMeta[0]);
        }

        public AssetChoiceBuilder prune();
    }

    public static class AssetChoiceImpl
    implements AssetChoice {
        private final Cash cash;
        private final TermLoan termLoan;
        private final DelayedDraw delayedDraw;
        private final Revolver revolver;
        private final LetterOfCreditFacility letterOfCreditFacility;
        private final Deal deal;
        private final SimpleIRSwap simpleIRSwap;
        private final MutualFund mutualFund;
        private final RateIndex rateIndex;
        private final Deposit deposit;
        private final Fx fx;
        private final Loan loan;
        private final ConvertibleBond convertibleBond;
        private final Bond bond;
        private final SimpleFra simpleFra;
        private final OptionElement optionElement;
        private final Warrant warrant;
        private final ExchangeTradedContract exchangeTradedContract;
        private final Index index;
        private final ExchangeTradedFund exchangeTradedFund;
        private final Equity equity;
        private final Future future;
        private final Mortgage mortgage;
        private final SimpleCreditDefaultSwap simpleCreditDefaultSwap;
        private final Commodity commodity;
        private final Security security;
        private final Basket basket;

        protected AssetChoiceImpl(AssetChoiceBuilder builder) {
            this.cash = Optional.ofNullable(builder.getCash()).map(f -> f.build()).orElse(null);
            this.termLoan = Optional.ofNullable(builder.getTermLoan()).map(f -> f.build()).orElse(null);
            this.delayedDraw = Optional.ofNullable(builder.getDelayedDraw()).map(f -> f.build()).orElse(null);
            this.revolver = Optional.ofNullable(builder.getRevolver()).map(f -> f.build()).orElse(null);
            this.letterOfCreditFacility = Optional.ofNullable(builder.getLetterOfCreditFacility()).map(f -> f.build()).orElse(null);
            this.deal = Optional.ofNullable(builder.getDeal()).map(f -> f.build()).orElse(null);
            this.simpleIRSwap = Optional.ofNullable(builder.getSimpleIRSwap()).map(f -> f.build()).orElse(null);
            this.mutualFund = Optional.ofNullable(builder.getMutualFund()).map(f -> f.build()).orElse(null);
            this.rateIndex = Optional.ofNullable(builder.getRateIndex()).map(f -> f.build()).orElse(null);
            this.deposit = Optional.ofNullable(builder.getDeposit()).map(f -> f.build()).orElse(null);
            this.fx = Optional.ofNullable(builder.getFx()).map(f -> f.build()).orElse(null);
            this.loan = Optional.ofNullable(builder.getLoan()).map(f -> f.build()).orElse(null);
            this.convertibleBond = Optional.ofNullable(builder.getConvertibleBond()).map(f -> f.build()).orElse(null);
            this.bond = Optional.ofNullable(builder.getBond()).map(f -> f.build()).orElse(null);
            this.simpleFra = Optional.ofNullable(builder.getSimpleFra()).map(f -> f.build()).orElse(null);
            this.optionElement = Optional.ofNullable(builder.getOptionElement()).map(f -> f.build()).orElse(null);
            this.warrant = Optional.ofNullable(builder.getWarrant()).map(f -> f.build()).orElse(null);
            this.exchangeTradedContract = Optional.ofNullable(builder.getExchangeTradedContract()).map(f -> f.build()).orElse(null);
            this.index = Optional.ofNullable(builder.getIndex()).map(f -> f.build()).orElse(null);
            this.exchangeTradedFund = Optional.ofNullable(builder.getExchangeTradedFund()).map(f -> f.build()).orElse(null);
            this.equity = Optional.ofNullable(builder.getEquity()).map(f -> f.build()).orElse(null);
            this.future = Optional.ofNullable(builder.getFuture()).map(f -> f.build()).orElse(null);
            this.mortgage = Optional.ofNullable(builder.getMortgage()).map(f -> f.build()).orElse(null);
            this.simpleCreditDefaultSwap = Optional.ofNullable(builder.getSimpleCreditDefaultSwap()).map(f -> f.build()).orElse(null);
            this.commodity = Optional.ofNullable(builder.getCommodity()).map(f -> f.build()).orElse(null);
            this.security = Optional.ofNullable(builder.getSecurity()).map(f -> f.build()).orElse(null);
            this.basket = Optional.ofNullable(builder.getBasket()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="Cash")
        @RuneAttribute(value="Cash")
        public Cash getCash() {
            return this.cash;
        }

        @Override
        @RosettaAttribute(value="TermLoan")
        @RuneAttribute(value="TermLoan")
        public TermLoan getTermLoan() {
            return this.termLoan;
        }

        @Override
        @RosettaAttribute(value="DelayedDraw")
        @RuneAttribute(value="DelayedDraw")
        public DelayedDraw getDelayedDraw() {
            return this.delayedDraw;
        }

        @Override
        @RosettaAttribute(value="Revolver")
        @RuneAttribute(value="Revolver")
        public Revolver getRevolver() {
            return this.revolver;
        }

        @Override
        @RosettaAttribute(value="LetterOfCreditFacility")
        @RuneAttribute(value="LetterOfCreditFacility")
        public LetterOfCreditFacility getLetterOfCreditFacility() {
            return this.letterOfCreditFacility;
        }

        @Override
        @RosettaAttribute(value="Deal")
        @RuneAttribute(value="Deal")
        public Deal getDeal() {
            return this.deal;
        }

        @Override
        @RosettaAttribute(value="SimpleIRSwap")
        @RuneAttribute(value="SimpleIRSwap")
        public SimpleIRSwap getSimpleIRSwap() {
            return this.simpleIRSwap;
        }

        @Override
        @RosettaAttribute(value="MutualFund")
        @RuneAttribute(value="MutualFund")
        public MutualFund getMutualFund() {
            return this.mutualFund;
        }

        @Override
        @RosettaAttribute(value="RateIndex")
        @RuneAttribute(value="RateIndex")
        public RateIndex getRateIndex() {
            return this.rateIndex;
        }

        @Override
        @RosettaAttribute(value="Deposit")
        @RuneAttribute(value="Deposit")
        public Deposit getDeposit() {
            return this.deposit;
        }

        @Override
        @RosettaAttribute(value="Fx")
        @RuneAttribute(value="Fx")
        public Fx getFx() {
            return this.fx;
        }

        @Override
        @RosettaAttribute(value="Loan")
        @RuneAttribute(value="Loan")
        public Loan getLoan() {
            return this.loan;
        }

        @Override
        @RosettaAttribute(value="ConvertibleBond")
        @RuneAttribute(value="ConvertibleBond")
        public ConvertibleBond getConvertibleBond() {
            return this.convertibleBond;
        }

        @Override
        @RosettaAttribute(value="Bond")
        @RuneAttribute(value="Bond")
        public Bond getBond() {
            return this.bond;
        }

        @Override
        @RosettaAttribute(value="SimpleFra")
        @RuneAttribute(value="SimpleFra")
        public SimpleFra getSimpleFra() {
            return this.simpleFra;
        }

        @Override
        @RosettaAttribute(value="OptionElement")
        @RuneAttribute(value="OptionElement")
        public OptionElement getOptionElement() {
            return this.optionElement;
        }

        @Override
        @RosettaAttribute(value="Warrant")
        @RuneAttribute(value="Warrant")
        public Warrant getWarrant() {
            return this.warrant;
        }

        @Override
        @RosettaAttribute(value="ExchangeTradedContract")
        @RuneAttribute(value="ExchangeTradedContract")
        public ExchangeTradedContract getExchangeTradedContract() {
            return this.exchangeTradedContract;
        }

        @Override
        @RosettaAttribute(value="Index")
        @RuneAttribute(value="Index")
        public Index getIndex() {
            return this.index;
        }

        @Override
        @RosettaAttribute(value="ExchangeTradedFund")
        @RuneAttribute(value="ExchangeTradedFund")
        public ExchangeTradedFund getExchangeTradedFund() {
            return this.exchangeTradedFund;
        }

        @Override
        @RosettaAttribute(value="Equity")
        @RuneAttribute(value="Equity")
        public Equity getEquity() {
            return this.equity;
        }

        @Override
        @RosettaAttribute(value="Future")
        @RuneAttribute(value="Future")
        public Future getFuture() {
            return this.future;
        }

        @Override
        @RosettaAttribute(value="Mortgage")
        @RuneAttribute(value="Mortgage")
        public Mortgage getMortgage() {
            return this.mortgage;
        }

        @Override
        @RosettaAttribute(value="SimpleCreditDefaultSwap")
        @RuneAttribute(value="SimpleCreditDefaultSwap")
        public SimpleCreditDefaultSwap getSimpleCreditDefaultSwap() {
            return this.simpleCreditDefaultSwap;
        }

        @Override
        @RosettaAttribute(value="Commodity")
        @RuneAttribute(value="Commodity")
        public Commodity getCommodity() {
            return this.commodity;
        }

        @Override
        @RosettaAttribute(value="Security")
        @RuneAttribute(value="Security")
        public Security getSecurity() {
            return this.security;
        }

        @Override
        @RosettaAttribute(value="Basket")
        @RuneAttribute(value="Basket")
        public Basket getBasket() {
            return this.basket;
        }

        @Override
        public AssetChoice build() {
            return this;
        }

        @Override
        public AssetChoiceBuilder toBuilder() {
            AssetChoiceBuilder builder = AssetChoice.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AssetChoiceBuilder builder) {
            Optional.ofNullable(this.getCash()).ifPresent(builder::setCash);
            Optional.ofNullable(this.getTermLoan()).ifPresent(builder::setTermLoan);
            Optional.ofNullable(this.getDelayedDraw()).ifPresent(builder::setDelayedDraw);
            Optional.ofNullable(this.getRevolver()).ifPresent(builder::setRevolver);
            Optional.ofNullable(this.getLetterOfCreditFacility()).ifPresent(builder::setLetterOfCreditFacility);
            Optional.ofNullable(this.getDeal()).ifPresent(builder::setDeal);
            Optional.ofNullable(this.getSimpleIRSwap()).ifPresent(builder::setSimpleIRSwap);
            Optional.ofNullable(this.getMutualFund()).ifPresent(builder::setMutualFund);
            Optional.ofNullable(this.getRateIndex()).ifPresent(builder::setRateIndex);
            Optional.ofNullable(this.getDeposit()).ifPresent(builder::setDeposit);
            Optional.ofNullable(this.getFx()).ifPresent(builder::setFx);
            Optional.ofNullable(this.getLoan()).ifPresent(builder::setLoan);
            Optional.ofNullable(this.getConvertibleBond()).ifPresent(builder::setConvertibleBond);
            Optional.ofNullable(this.getBond()).ifPresent(builder::setBond);
            Optional.ofNullable(this.getSimpleFra()).ifPresent(builder::setSimpleFra);
            Optional.ofNullable(this.getOptionElement()).ifPresent(builder::setOptionElement);
            Optional.ofNullable(this.getWarrant()).ifPresent(builder::setWarrant);
            Optional.ofNullable(this.getExchangeTradedContract()).ifPresent(builder::setExchangeTradedContract);
            Optional.ofNullable(this.getIndex()).ifPresent(builder::setIndex);
            Optional.ofNullable(this.getExchangeTradedFund()).ifPresent(builder::setExchangeTradedFund);
            Optional.ofNullable(this.getEquity()).ifPresent(builder::setEquity);
            Optional.ofNullable(this.getFuture()).ifPresent(builder::setFuture);
            Optional.ofNullable(this.getMortgage()).ifPresent(builder::setMortgage);
            Optional.ofNullable(this.getSimpleCreditDefaultSwap()).ifPresent(builder::setSimpleCreditDefaultSwap);
            Optional.ofNullable(this.getCommodity()).ifPresent(builder::setCommodity);
            Optional.ofNullable(this.getSecurity()).ifPresent(builder::setSecurity);
            Optional.ofNullable(this.getBasket()).ifPresent(builder::setBasket);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AssetChoice _that = this.getType().cast(o);
            if (!Objects.equals(this.cash, _that.getCash())) {
                return false;
            }
            if (!Objects.equals(this.termLoan, _that.getTermLoan())) {
                return false;
            }
            if (!Objects.equals(this.delayedDraw, _that.getDelayedDraw())) {
                return false;
            }
            if (!Objects.equals(this.revolver, _that.getRevolver())) {
                return false;
            }
            if (!Objects.equals(this.letterOfCreditFacility, _that.getLetterOfCreditFacility())) {
                return false;
            }
            if (!Objects.equals(this.deal, _that.getDeal())) {
                return false;
            }
            if (!Objects.equals(this.simpleIRSwap, _that.getSimpleIRSwap())) {
                return false;
            }
            if (!Objects.equals(this.mutualFund, _that.getMutualFund())) {
                return false;
            }
            if (!Objects.equals(this.rateIndex, _that.getRateIndex())) {
                return false;
            }
            if (!Objects.equals(this.deposit, _that.getDeposit())) {
                return false;
            }
            if (!Objects.equals(this.fx, _that.getFx())) {
                return false;
            }
            if (!Objects.equals(this.loan, _that.getLoan())) {
                return false;
            }
            if (!Objects.equals(this.convertibleBond, _that.getConvertibleBond())) {
                return false;
            }
            if (!Objects.equals(this.bond, _that.getBond())) {
                return false;
            }
            if (!Objects.equals(this.simpleFra, _that.getSimpleFra())) {
                return false;
            }
            if (!Objects.equals(this.optionElement, _that.getOptionElement())) {
                return false;
            }
            if (!Objects.equals(this.warrant, _that.getWarrant())) {
                return false;
            }
            if (!Objects.equals(this.exchangeTradedContract, _that.getExchangeTradedContract())) {
                return false;
            }
            if (!Objects.equals(this.index, _that.getIndex())) {
                return false;
            }
            if (!Objects.equals(this.exchangeTradedFund, _that.getExchangeTradedFund())) {
                return false;
            }
            if (!Objects.equals(this.equity, _that.getEquity())) {
                return false;
            }
            if (!Objects.equals(this.future, _that.getFuture())) {
                return false;
            }
            if (!Objects.equals(this.mortgage, _that.getMortgage())) {
                return false;
            }
            if (!Objects.equals(this.simpleCreditDefaultSwap, _that.getSimpleCreditDefaultSwap())) {
                return false;
            }
            if (!Objects.equals(this.commodity, _that.getCommodity())) {
                return false;
            }
            if (!Objects.equals(this.security, _that.getSecurity())) {
                return false;
            }
            return Objects.equals(this.basket, _that.getBasket());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.cash != null ? this.cash.hashCode() : 0);
            _result = 31 * _result + (this.termLoan != null ? this.termLoan.hashCode() : 0);
            _result = 31 * _result + (this.delayedDraw != null ? this.delayedDraw.hashCode() : 0);
            _result = 31 * _result + (this.revolver != null ? this.revolver.hashCode() : 0);
            _result = 31 * _result + (this.letterOfCreditFacility != null ? this.letterOfCreditFacility.hashCode() : 0);
            _result = 31 * _result + (this.deal != null ? this.deal.hashCode() : 0);
            _result = 31 * _result + (this.simpleIRSwap != null ? this.simpleIRSwap.hashCode() : 0);
            _result = 31 * _result + (this.mutualFund != null ? this.mutualFund.hashCode() : 0);
            _result = 31 * _result + (this.rateIndex != null ? this.rateIndex.hashCode() : 0);
            _result = 31 * _result + (this.deposit != null ? this.deposit.hashCode() : 0);
            _result = 31 * _result + (this.fx != null ? this.fx.hashCode() : 0);
            _result = 31 * _result + (this.loan != null ? this.loan.hashCode() : 0);
            _result = 31 * _result + (this.convertibleBond != null ? this.convertibleBond.hashCode() : 0);
            _result = 31 * _result + (this.bond != null ? this.bond.hashCode() : 0);
            _result = 31 * _result + (this.simpleFra != null ? this.simpleFra.hashCode() : 0);
            _result = 31 * _result + (this.optionElement != null ? this.optionElement.hashCode() : 0);
            _result = 31 * _result + (this.warrant != null ? this.warrant.hashCode() : 0);
            _result = 31 * _result + (this.exchangeTradedContract != null ? this.exchangeTradedContract.hashCode() : 0);
            _result = 31 * _result + (this.index != null ? this.index.hashCode() : 0);
            _result = 31 * _result + (this.exchangeTradedFund != null ? this.exchangeTradedFund.hashCode() : 0);
            _result = 31 * _result + (this.equity != null ? this.equity.hashCode() : 0);
            _result = 31 * _result + (this.future != null ? this.future.hashCode() : 0);
            _result = 31 * _result + (this.mortgage != null ? this.mortgage.hashCode() : 0);
            _result = 31 * _result + (this.simpleCreditDefaultSwap != null ? this.simpleCreditDefaultSwap.hashCode() : 0);
            _result = 31 * _result + (this.commodity != null ? this.commodity.hashCode() : 0);
            _result = 31 * _result + (this.security != null ? this.security.hashCode() : 0);
            _result = 31 * _result + (this.basket != null ? this.basket.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AssetChoice {Cash=" + this.cash + ", TermLoan=" + this.termLoan + ", DelayedDraw=" + this.delayedDraw + ", Revolver=" + this.revolver + ", LetterOfCreditFacility=" + this.letterOfCreditFacility + ", Deal=" + this.deal + ", SimpleIRSwap=" + this.simpleIRSwap + ", MutualFund=" + this.mutualFund + ", RateIndex=" + this.rateIndex + ", Deposit=" + this.deposit + ", Fx=" + this.fx + ", Loan=" + this.loan + ", ConvertibleBond=" + this.convertibleBond + ", Bond=" + this.bond + ", SimpleFra=" + this.simpleFra + ", OptionElement=" + this.optionElement + ", Warrant=" + this.warrant + ", ExchangeTradedContract=" + this.exchangeTradedContract + ", Index=" + this.index + ", ExchangeTradedFund=" + this.exchangeTradedFund + ", Equity=" + this.equity + ", Future=" + this.future + ", Mortgage=" + this.mortgage + ", SimpleCreditDefaultSwap=" + this.simpleCreditDefaultSwap + ", Commodity=" + this.commodity + ", Security=" + this.security + ", Basket=" + this.basket + '}';
        }
    }
}

