/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.confirmation.ClassifiablePayment;
import fpml.confirmation.ExtraordinaryEvents;
import fpml.confirmation.NettedSwapBase;
import fpml.confirmation.ProductModel;
import fpml.confirmation.VolatilityLeg;
import fpml.confirmation.meta.VolatilitySwapMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="VolatilitySwap", builder=VolatilitySwapBuilderImpl.class, version="0.17.2")
@RuneDataType(value="VolatilitySwap", model="fpml", builder=VolatilitySwapBuilderImpl.class, version="0.17.2")
public interface VolatilitySwap
extends NettedSwapBase {
    public static final VolatilitySwapMeta metaData = new VolatilitySwapMeta();

    public List<? extends VolatilityLeg> getVolatilityLeg();

    @Override
    public VolatilitySwap build();

    @Override
    public VolatilitySwapBuilder toBuilder();

    public static VolatilitySwapBuilder builder() {
        return new VolatilitySwapBuilderImpl();
    }

    default public RosettaMetaData<? extends VolatilitySwap> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends VolatilitySwap> getType() {
        return VolatilitySwap.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.class, this.getProductModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("additionalPayment"), processor, ClassifiablePayment.class, this.getAdditionalPayment(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("extraordinaryEvents"), processor, ExtraordinaryEvents.class, this.getExtraordinaryEvents(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("volatilityLeg"), processor, VolatilityLeg.class, this.getVolatilityLeg(), new AttributeMeta[0]);
    }

    public static class VolatilitySwapBuilderImpl
    extends NettedSwapBase.NettedSwapBaseBuilderImpl
    implements VolatilitySwapBuilder {
        protected List<VolatilityLeg.VolatilityLegBuilder> volatilityLeg = new ArrayList<VolatilityLeg.VolatilityLegBuilder>();

        @Override
        @RosettaAttribute(value="volatilityLeg", isRequired=true)
        @RuneAttribute(value="volatilityLeg", isRequired=true)
        public List<? extends VolatilityLeg.VolatilityLegBuilder> getVolatilityLeg() {
            return this.volatilityLeg;
        }

        @Override
        public VolatilityLeg.VolatilityLegBuilder getOrCreateVolatilityLeg(int index) {
            if (this.volatilityLeg == null) {
                this.volatilityLeg = new ArrayList<VolatilityLeg.VolatilityLegBuilder>();
            }
            return (VolatilityLeg.VolatilityLegBuilder)this.getIndex(this.volatilityLeg, index, () -> {
                VolatilityLeg.VolatilityLegBuilder newVolatilityLeg = VolatilityLeg.builder();
                return newVolatilityLeg;
            });
        }

        @Override
        @RosettaAttribute(value="productModel")
        @RuneAttribute(value="productModel")
        public VolatilitySwapBuilder setProductModel(ProductModel _productModel) {
            this.productModel = _productModel == null ? null : _productModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public VolatilitySwapBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="additionalPayment")
        @RuneAttribute(value="additionalPayment")
        public VolatilitySwapBuilder addAdditionalPayment(ClassifiablePayment _additionalPayment) {
            if (_additionalPayment != null) {
                this.additionalPayment.add(_additionalPayment.toBuilder());
            }
            return this;
        }

        @Override
        public VolatilitySwapBuilder addAdditionalPayment(ClassifiablePayment _additionalPayment, int idx) {
            this.getIndex(this.additionalPayment, idx, () -> _additionalPayment.toBuilder());
            return this;
        }

        @Override
        public VolatilitySwapBuilder addAdditionalPayment(List<? extends ClassifiablePayment> additionalPayments) {
            if (additionalPayments != null) {
                for (ClassifiablePayment classifiablePayment : additionalPayments) {
                    this.additionalPayment.add(classifiablePayment.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="additionalPayment")
        public VolatilitySwapBuilder setAdditionalPayment(List<? extends ClassifiablePayment> additionalPayments) {
            this.additionalPayment = additionalPayments == null ? new ArrayList() : (List)additionalPayments.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="extraordinaryEvents")
        @RuneAttribute(value="extraordinaryEvents")
        public VolatilitySwapBuilder setExtraordinaryEvents(ExtraordinaryEvents _extraordinaryEvents) {
            this.extraordinaryEvents = _extraordinaryEvents == null ? null : _extraordinaryEvents.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="volatilityLeg", isRequired=true)
        @RuneAttribute(value="volatilityLeg", isRequired=true)
        public VolatilitySwapBuilder addVolatilityLeg(VolatilityLeg _volatilityLeg) {
            if (_volatilityLeg != null) {
                this.volatilityLeg.add(_volatilityLeg.toBuilder());
            }
            return this;
        }

        @Override
        public VolatilitySwapBuilder addVolatilityLeg(VolatilityLeg _volatilityLeg, int idx) {
            this.getIndex(this.volatilityLeg, idx, () -> _volatilityLeg.toBuilder());
            return this;
        }

        @Override
        public VolatilitySwapBuilder addVolatilityLeg(List<? extends VolatilityLeg> volatilityLegs) {
            if (volatilityLegs != null) {
                for (VolatilityLeg volatilityLeg : volatilityLegs) {
                    this.volatilityLeg.add(volatilityLeg.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="volatilityLeg")
        public VolatilitySwapBuilder setVolatilityLeg(List<? extends VolatilityLeg> volatilityLegs) {
            this.volatilityLeg = volatilityLegs == null ? new ArrayList<VolatilityLeg.VolatilityLegBuilder>() : (List)volatilityLegs.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public VolatilitySwap build() {
            return new VolatilitySwapImpl(this);
        }

        @Override
        public VolatilitySwapBuilder toBuilder() {
            return this;
        }

        @Override
        public VolatilitySwapBuilder prune() {
            super.prune();
            this.volatilityLeg = this.volatilityLeg.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            return this.getVolatilityLeg() != null && this.getVolatilityLeg().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public VolatilitySwapBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            VolatilitySwapBuilder o = (VolatilitySwapBuilder)other;
            merger.mergeRosetta(this.getVolatilityLeg(), o.getVolatilityLeg(), this::getOrCreateVolatilityLeg);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            VolatilitySwap _that = (VolatilitySwap)this.getType().cast(o);
            return ListEquals.listEquals(this.volatilityLeg, _that.getVolatilityLeg());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.volatilityLeg != null ? this.volatilityLeg.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "VolatilitySwapBuilder {volatilityLeg=" + this.volatilityLeg + '}' + " " + super.toString();
        }
    }

    public static interface VolatilitySwapBuilder
    extends VolatilitySwap,
    NettedSwapBase.NettedSwapBaseBuilder {
        public VolatilityLeg.VolatilityLegBuilder getOrCreateVolatilityLeg(int var1);

        public List<? extends VolatilityLeg.VolatilityLegBuilder> getVolatilityLeg();

        @Override
        public VolatilitySwapBuilder setProductModel(ProductModel var1);

        @Override
        public VolatilitySwapBuilder setId(String var1);

        @Override
        public VolatilitySwapBuilder addAdditionalPayment(ClassifiablePayment var1);

        @Override
        public VolatilitySwapBuilder addAdditionalPayment(ClassifiablePayment var1, int var2);

        @Override
        public VolatilitySwapBuilder addAdditionalPayment(List<? extends ClassifiablePayment> var1);

        @Override
        public VolatilitySwapBuilder setAdditionalPayment(List<? extends ClassifiablePayment> var1);

        @Override
        public VolatilitySwapBuilder setExtraordinaryEvents(ExtraordinaryEvents var1);

        public VolatilitySwapBuilder addVolatilityLeg(VolatilityLeg var1);

        public VolatilitySwapBuilder addVolatilityLeg(VolatilityLeg var1, int var2);

        public VolatilitySwapBuilder addVolatilityLeg(List<? extends VolatilityLeg> var1);

        public VolatilitySwapBuilder setVolatilityLeg(List<? extends VolatilityLeg> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.ProductModelBuilder.class, (RosettaModelObjectBuilder)this.getProductModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("additionalPayment"), processor, ClassifiablePayment.ClassifiablePaymentBuilder.class, this.getAdditionalPayment(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("extraordinaryEvents"), processor, ExtraordinaryEvents.ExtraordinaryEventsBuilder.class, (RosettaModelObjectBuilder)this.getExtraordinaryEvents(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("volatilityLeg"), processor, VolatilityLeg.VolatilityLegBuilder.class, this.getVolatilityLeg(), new AttributeMeta[0]);
        }

        @Override
        public VolatilitySwapBuilder prune();
    }

    public static class VolatilitySwapImpl
    extends NettedSwapBase.NettedSwapBaseImpl
    implements VolatilitySwap {
        private final List<? extends VolatilityLeg> volatilityLeg;

        protected VolatilitySwapImpl(VolatilitySwapBuilder builder) {
            super(builder);
            this.volatilityLeg = Optional.ofNullable(builder.getVolatilityLeg()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="volatilityLeg", isRequired=true)
        @RuneAttribute(value="volatilityLeg", isRequired=true)
        public List<? extends VolatilityLeg> getVolatilityLeg() {
            return this.volatilityLeg;
        }

        @Override
        public VolatilitySwap build() {
            return this;
        }

        @Override
        public VolatilitySwapBuilder toBuilder() {
            VolatilitySwapBuilder builder = VolatilitySwap.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(VolatilitySwapBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getVolatilityLeg()).ifPresent(builder::setVolatilityLeg);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            VolatilitySwap _that = (VolatilitySwap)this.getType().cast(o);
            return ListEquals.listEquals(this.volatilityLeg, _that.getVolatilityLeg());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.volatilityLeg != null ? this.volatilityLeg.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "VolatilitySwap {volatilityLeg=" + this.volatilityLeg + '}' + " " + super.toString();
        }
    }
}

