/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.AdjustableOrRelativeDate;
import fpml.confirmation.AdjustableRelativeOrPeriodicDates;
import fpml.confirmation.CalculatedAmount;
import fpml.confirmation.DividendsModel;
import fpml.confirmation.Volatility;
import fpml.confirmation.meta.VolatilityAmountMeta;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="VolatilityAmount", builder=VolatilityAmountBuilderImpl.class, version="0.17.2")
@RuneDataType(value="VolatilityAmount", model="fpml", builder=VolatilityAmountBuilderImpl.class, version="0.17.2")
public interface VolatilityAmount
extends CalculatedAmount {
    public static final VolatilityAmountMeta metaData = new VolatilityAmountMeta();

    public Volatility getVolatility();

    @Override
    public VolatilityAmount build();

    @Override
    public VolatilityAmountBuilder toBuilder();

    public static VolatilityAmountBuilder builder() {
        return new VolatilityAmountBuilderImpl();
    }

    default public RosettaMetaData<? extends VolatilityAmount> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends VolatilityAmount> getType() {
        return VolatilityAmount.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("calculationDates"), processor, AdjustableRelativeOrPeriodicDates.class, this.getCalculationDates(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("observationStartDate"), processor, AdjustableOrRelativeDate.class, this.getObservationStartDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dividendsModel"), processor, DividendsModel.class, this.getDividendsModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("volatility"), processor, Volatility.class, this.getVolatility(), new AttributeMeta[0]);
    }

    public static class VolatilityAmountBuilderImpl
    extends CalculatedAmount.CalculatedAmountBuilderImpl
    implements VolatilityAmountBuilder {
        protected Volatility.VolatilityBuilder volatility;

        @Override
        @RosettaAttribute(value="volatility", isRequired=true)
        @RuneAttribute(value="volatility", isRequired=true)
        public Volatility.VolatilityBuilder getVolatility() {
            return this.volatility;
        }

        @Override
        public Volatility.VolatilityBuilder getOrCreateVolatility() {
            Volatility.VolatilityBuilder result = this.volatility != null ? this.volatility : (this.volatility = Volatility.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="calculationDates")
        @RuneAttribute(value="calculationDates")
        public VolatilityAmountBuilder setCalculationDates(AdjustableRelativeOrPeriodicDates _calculationDates) {
            this.calculationDates = _calculationDates == null ? null : _calculationDates.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="observationStartDate")
        @RuneAttribute(value="observationStartDate")
        public VolatilityAmountBuilder setObservationStartDate(AdjustableOrRelativeDate _observationStartDate) {
            this.observationStartDate = _observationStartDate == null ? null : _observationStartDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dividendsModel", isRequired=true)
        @RuneAttribute(value="dividendsModel", isRequired=true)
        public VolatilityAmountBuilder setDividendsModel(DividendsModel _dividendsModel) {
            this.dividendsModel = _dividendsModel == null ? null : _dividendsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="volatility", isRequired=true)
        @RuneAttribute(value="volatility", isRequired=true)
        public VolatilityAmountBuilder setVolatility(Volatility _volatility) {
            this.volatility = _volatility == null ? null : _volatility.toBuilder();
            return this;
        }

        @Override
        public VolatilityAmount build() {
            return new VolatilityAmountImpl(this);
        }

        @Override
        public VolatilityAmountBuilder toBuilder() {
            return this;
        }

        @Override
        public VolatilityAmountBuilder prune() {
            super.prune();
            if (this.volatility != null && !this.volatility.prune().hasData()) {
                this.volatility = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            return this.getVolatility() != null && this.getVolatility().hasData();
        }

        @Override
        public VolatilityAmountBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            VolatilityAmountBuilder o = (VolatilityAmountBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getVolatility(), (RosettaModelObjectBuilder)o.getVolatility(), this::setVolatility);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            VolatilityAmount _that = (VolatilityAmount)this.getType().cast(o);
            return Objects.equals(this.volatility, _that.getVolatility());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.volatility != null ? this.volatility.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "VolatilityAmountBuilder {volatility=" + this.volatility + '}' + " " + super.toString();
        }
    }

    public static interface VolatilityAmountBuilder
    extends VolatilityAmount,
    CalculatedAmount.CalculatedAmountBuilder {
        public Volatility.VolatilityBuilder getOrCreateVolatility();

        @Override
        public Volatility.VolatilityBuilder getVolatility();

        @Override
        public VolatilityAmountBuilder setCalculationDates(AdjustableRelativeOrPeriodicDates var1);

        @Override
        public VolatilityAmountBuilder setObservationStartDate(AdjustableOrRelativeDate var1);

        @Override
        public VolatilityAmountBuilder setDividendsModel(DividendsModel var1);

        public VolatilityAmountBuilder setVolatility(Volatility var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("calculationDates"), processor, AdjustableRelativeOrPeriodicDates.AdjustableRelativeOrPeriodicDatesBuilder.class, (RosettaModelObjectBuilder)this.getCalculationDates(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("observationStartDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, (RosettaModelObjectBuilder)this.getObservationStartDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dividendsModel"), processor, DividendsModel.DividendsModelBuilder.class, (RosettaModelObjectBuilder)this.getDividendsModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("volatility"), processor, Volatility.VolatilityBuilder.class, this.getVolatility(), new AttributeMeta[0]);
        }

        @Override
        public VolatilityAmountBuilder prune();
    }

    public static class VolatilityAmountImpl
    extends CalculatedAmount.CalculatedAmountImpl
    implements VolatilityAmount {
        private final Volatility volatility;

        protected VolatilityAmountImpl(VolatilityAmountBuilder builder) {
            super(builder);
            this.volatility = Optional.ofNullable(builder.getVolatility()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="volatility", isRequired=true)
        @RuneAttribute(value="volatility", isRequired=true)
        public Volatility getVolatility() {
            return this.volatility;
        }

        @Override
        public VolatilityAmount build() {
            return this;
        }

        @Override
        public VolatilityAmountBuilder toBuilder() {
            VolatilityAmountBuilder builder = VolatilityAmount.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(VolatilityAmountBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getVolatility()).ifPresent(builder::setVolatility);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            VolatilityAmount _that = (VolatilityAmount)this.getType().cast(o);
            return Objects.equals(this.volatility, _that.getVolatility());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.volatility != null ? this.volatility.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "VolatilityAmount {volatility=" + this.volatility + '}' + " " + super.toString();
        }
    }
}

