/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.NonNegativeMoney;
import fpml.confirmation.meta.UnitContractModelMeta;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="UnitContractModel", builder=UnitContractModelBuilderImpl.class, version="0.17.2")
@RuneDataType(value="UnitContractModel", model="fpml", builder=UnitContractModelBuilderImpl.class, version="0.17.2")
public interface UnitContractModel
extends RosettaModelObject {
    public static final UnitContractModelMeta metaData = new UnitContractModelMeta();

    public BigDecimal getNumberOfUnits();

    public NonNegativeMoney getUnitPrice();

    public UnitContractModel build();

    public UnitContractModelBuilder toBuilder();

    public static UnitContractModelBuilder builder() {
        return new UnitContractModelBuilderImpl();
    }

    default public RosettaMetaData<? extends UnitContractModel> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends UnitContractModel> getType() {
        return UnitContractModel.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("numberOfUnits"), BigDecimal.class, (Object)this.getNumberOfUnits(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("unitPrice"), processor, NonNegativeMoney.class, this.getUnitPrice(), new AttributeMeta[0]);
    }

    public static class UnitContractModelBuilderImpl
    implements UnitContractModelBuilder {
        protected BigDecimal numberOfUnits;
        protected NonNegativeMoney.NonNegativeMoneyBuilder unitPrice;

        @Override
        @RosettaAttribute(value="numberOfUnits", isRequired=true)
        @RuneAttribute(value="numberOfUnits", isRequired=true)
        public BigDecimal getNumberOfUnits() {
            return this.numberOfUnits;
        }

        @Override
        @RosettaAttribute(value="unitPrice", isRequired=true)
        @RuneAttribute(value="unitPrice", isRequired=true)
        public NonNegativeMoney.NonNegativeMoneyBuilder getUnitPrice() {
            return this.unitPrice;
        }

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateUnitPrice() {
            NonNegativeMoney.NonNegativeMoneyBuilder result = this.unitPrice != null ? this.unitPrice : (this.unitPrice = NonNegativeMoney.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="numberOfUnits", isRequired=true)
        @RuneAttribute(value="numberOfUnits", isRequired=true)
        public UnitContractModelBuilder setNumberOfUnits(BigDecimal _numberOfUnits) {
            this.numberOfUnits = _numberOfUnits == null ? null : _numberOfUnits;
            return this;
        }

        @Override
        @RosettaAttribute(value="unitPrice", isRequired=true)
        @RuneAttribute(value="unitPrice", isRequired=true)
        public UnitContractModelBuilder setUnitPrice(NonNegativeMoney _unitPrice) {
            this.unitPrice = _unitPrice == null ? null : _unitPrice.toBuilder();
            return this;
        }

        @Override
        public UnitContractModel build() {
            return new UnitContractModelImpl(this);
        }

        @Override
        public UnitContractModelBuilder toBuilder() {
            return this;
        }

        @Override
        public UnitContractModelBuilder prune() {
            if (this.unitPrice != null && !this.unitPrice.prune().hasData()) {
                this.unitPrice = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getNumberOfUnits() != null) {
                return true;
            }
            return this.getUnitPrice() != null && this.getUnitPrice().hasData();
        }

        public UnitContractModelBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            UnitContractModelBuilder o = (UnitContractModelBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getUnitPrice(), (RosettaModelObjectBuilder)o.getUnitPrice(), this::setUnitPrice);
            merger.mergeBasic((Object)this.getNumberOfUnits(), (Object)o.getNumberOfUnits(), this::setNumberOfUnits, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            UnitContractModel _that = this.getType().cast(o);
            if (!Objects.equals(this.numberOfUnits, _that.getNumberOfUnits())) {
                return false;
            }
            return Objects.equals(this.unitPrice, _that.getUnitPrice());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.numberOfUnits != null ? this.numberOfUnits.hashCode() : 0);
            _result = 31 * _result + (this.unitPrice != null ? this.unitPrice.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "UnitContractModelBuilder {numberOfUnits=" + this.numberOfUnits + ", unitPrice=" + this.unitPrice + '}';
        }
    }

    public static interface UnitContractModelBuilder
    extends UnitContractModel,
    RosettaModelObjectBuilder {
        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateUnitPrice();

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getUnitPrice();

        public UnitContractModelBuilder setNumberOfUnits(BigDecimal var1);

        public UnitContractModelBuilder setUnitPrice(NonNegativeMoney var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("numberOfUnits"), BigDecimal.class, (Object)this.getNumberOfUnits(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("unitPrice"), processor, NonNegativeMoney.NonNegativeMoneyBuilder.class, this.getUnitPrice(), new AttributeMeta[0]);
        }

        public UnitContractModelBuilder prune();
    }

    public static class UnitContractModelImpl
    implements UnitContractModel {
        private final BigDecimal numberOfUnits;
        private final NonNegativeMoney unitPrice;

        protected UnitContractModelImpl(UnitContractModelBuilder builder) {
            this.numberOfUnits = builder.getNumberOfUnits();
            this.unitPrice = Optional.ofNullable(builder.getUnitPrice()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="numberOfUnits", isRequired=true)
        @RuneAttribute(value="numberOfUnits", isRequired=true)
        public BigDecimal getNumberOfUnits() {
            return this.numberOfUnits;
        }

        @Override
        @RosettaAttribute(value="unitPrice", isRequired=true)
        @RuneAttribute(value="unitPrice", isRequired=true)
        public NonNegativeMoney getUnitPrice() {
            return this.unitPrice;
        }

        @Override
        public UnitContractModel build() {
            return this;
        }

        @Override
        public UnitContractModelBuilder toBuilder() {
            UnitContractModelBuilder builder = UnitContractModel.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(UnitContractModelBuilder builder) {
            Optional.ofNullable(this.getNumberOfUnits()).ifPresent(builder::setNumberOfUnits);
            Optional.ofNullable(this.getUnitPrice()).ifPresent(builder::setUnitPrice);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            UnitContractModel _that = this.getType().cast(o);
            if (!Objects.equals(this.numberOfUnits, _that.getNumberOfUnits())) {
                return false;
            }
            return Objects.equals(this.unitPrice, _that.getUnitPrice());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.numberOfUnits != null ? this.numberOfUnits.hashCode() : 0);
            _result = 31 * _result + (this.unitPrice != null ? this.unitPrice.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "UnitContractModel {numberOfUnits=" + this.numberOfUnits + ", unitPrice=" + this.unitPrice + '}';
        }
    }
}

