/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.ClearanceSystem;
import fpml.confirmation.ExchangeId;
import fpml.confirmation.IdentifiedAsset;
import fpml.confirmation.IdentifiedCurrency;
import fpml.confirmation.InstrumentId;
import fpml.confirmation.InstrumentType;
import fpml.confirmation.ProductReference;
import fpml.confirmation.meta.UnderlyingAssetMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="UnderlyingAsset", builder=UnderlyingAssetBuilderImpl.class, version="0.17.2")
@RuneDataType(value="UnderlyingAsset", model="fpml", builder=UnderlyingAssetBuilderImpl.class, version="0.17.2")
public interface UnderlyingAsset
extends IdentifiedAsset {
    public static final UnderlyingAssetMeta metaData = new UnderlyingAssetMeta();

    public IdentifiedCurrency getCurrency();

    public ExchangeId getExchangeId();

    public ClearanceSystem getClearanceSystem();

    public ProductReference getDefinition();

    @Override
    public UnderlyingAsset build();

    @Override
    public UnderlyingAssetBuilder toBuilder();

    public static UnderlyingAssetBuilder builder() {
        return new UnderlyingAssetBuilderImpl();
    }

    default public RosettaMetaData<? extends UnderlyingAsset> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends UnderlyingAsset> getType() {
        return UnderlyingAsset.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.class, this.getInstrumentId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("instrumentType"), processor, InstrumentType.class, this.getInstrumentType(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("currency"), processor, IdentifiedCurrency.class, this.getCurrency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exchangeId"), processor, ExchangeId.class, this.getExchangeId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("clearanceSystem"), processor, ClearanceSystem.class, this.getClearanceSystem(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("definition"), processor, ProductReference.class, this.getDefinition(), new AttributeMeta[0]);
    }

    public static class UnderlyingAssetBuilderImpl
    extends IdentifiedAsset.IdentifiedAssetBuilderImpl
    implements UnderlyingAssetBuilder {
        protected IdentifiedCurrency.IdentifiedCurrencyBuilder currency;
        protected ExchangeId.ExchangeIdBuilder exchangeId;
        protected ClearanceSystem.ClearanceSystemBuilder clearanceSystem;
        protected ProductReference.ProductReferenceBuilder definition;

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public IdentifiedCurrency.IdentifiedCurrencyBuilder getCurrency() {
            return this.currency;
        }

        @Override
        public IdentifiedCurrency.IdentifiedCurrencyBuilder getOrCreateCurrency() {
            IdentifiedCurrency.IdentifiedCurrencyBuilder result = this.currency != null ? this.currency : (this.currency = IdentifiedCurrency.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="exchangeId")
        @RuneAttribute(value="exchangeId")
        public ExchangeId.ExchangeIdBuilder getExchangeId() {
            return this.exchangeId;
        }

        @Override
        public ExchangeId.ExchangeIdBuilder getOrCreateExchangeId() {
            ExchangeId.ExchangeIdBuilder result = this.exchangeId != null ? this.exchangeId : (this.exchangeId = ExchangeId.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="clearanceSystem")
        @RuneAttribute(value="clearanceSystem")
        public ClearanceSystem.ClearanceSystemBuilder getClearanceSystem() {
            return this.clearanceSystem;
        }

        @Override
        public ClearanceSystem.ClearanceSystemBuilder getOrCreateClearanceSystem() {
            ClearanceSystem.ClearanceSystemBuilder result = this.clearanceSystem != null ? this.clearanceSystem : (this.clearanceSystem = ClearanceSystem.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="definition")
        @RuneAttribute(value="definition")
        public ProductReference.ProductReferenceBuilder getDefinition() {
            return this.definition;
        }

        @Override
        public ProductReference.ProductReferenceBuilder getOrCreateDefinition() {
            ProductReference.ProductReferenceBuilder result = this.definition != null ? this.definition : (this.definition = ProductReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public UnderlyingAssetBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="instrumentId", isRequired=true)
        @RuneAttribute(value="instrumentId", isRequired=true)
        public UnderlyingAssetBuilder addInstrumentId(InstrumentId _instrumentId) {
            if (_instrumentId != null) {
                this.instrumentId.add(_instrumentId.toBuilder());
            }
            return this;
        }

        @Override
        public UnderlyingAssetBuilder addInstrumentId(InstrumentId _instrumentId, int idx) {
            this.getIndex(this.instrumentId, idx, () -> _instrumentId.toBuilder());
            return this;
        }

        @Override
        public UnderlyingAssetBuilder addInstrumentId(List<? extends InstrumentId> instrumentIds) {
            if (instrumentIds != null) {
                for (InstrumentId instrumentId : instrumentIds) {
                    this.instrumentId.add(instrumentId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="instrumentId")
        public UnderlyingAssetBuilder setInstrumentId(List<? extends InstrumentId> instrumentIds) {
            this.instrumentId = instrumentIds == null ? new ArrayList() : (List)instrumentIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="instrumentType")
        @RuneAttribute(value="instrumentType")
        public UnderlyingAssetBuilder addInstrumentType(InstrumentType _instrumentType) {
            if (_instrumentType != null) {
                this.instrumentType.add(_instrumentType.toBuilder());
            }
            return this;
        }

        @Override
        public UnderlyingAssetBuilder addInstrumentType(InstrumentType _instrumentType, int idx) {
            this.getIndex(this.instrumentType, idx, () -> _instrumentType.toBuilder());
            return this;
        }

        @Override
        public UnderlyingAssetBuilder addInstrumentType(List<? extends InstrumentType> instrumentTypes) {
            if (instrumentTypes != null) {
                for (InstrumentType instrumentType : instrumentTypes) {
                    this.instrumentType.add(instrumentType.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="instrumentType")
        public UnderlyingAssetBuilder setInstrumentType(List<? extends InstrumentType> instrumentTypes) {
            this.instrumentType = instrumentTypes == null ? new ArrayList() : (List)instrumentTypes.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="description")
        @RuneAttribute(value="description")
        public UnderlyingAssetBuilder setDescription(String _description) {
            this.description = _description == null ? null : _description;
            return this;
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public UnderlyingAssetBuilder setCurrency(IdentifiedCurrency _currency) {
            this.currency = _currency == null ? null : _currency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exchangeId")
        @RuneAttribute(value="exchangeId")
        public UnderlyingAssetBuilder setExchangeId(ExchangeId _exchangeId) {
            this.exchangeId = _exchangeId == null ? null : _exchangeId.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="clearanceSystem")
        @RuneAttribute(value="clearanceSystem")
        public UnderlyingAssetBuilder setClearanceSystem(ClearanceSystem _clearanceSystem) {
            this.clearanceSystem = _clearanceSystem == null ? null : _clearanceSystem.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="definition")
        @RuneAttribute(value="definition")
        public UnderlyingAssetBuilder setDefinition(ProductReference _definition) {
            this.definition = _definition == null ? null : _definition.toBuilder();
            return this;
        }

        @Override
        public UnderlyingAsset build() {
            return new UnderlyingAssetImpl(this);
        }

        @Override
        public UnderlyingAssetBuilder toBuilder() {
            return this;
        }

        @Override
        public UnderlyingAssetBuilder prune() {
            super.prune();
            if (this.currency != null && !this.currency.prune().hasData()) {
                this.currency = null;
            }
            if (this.exchangeId != null && !this.exchangeId.prune().hasData()) {
                this.exchangeId = null;
            }
            if (this.clearanceSystem != null && !this.clearanceSystem.prune().hasData()) {
                this.clearanceSystem = null;
            }
            if (this.definition != null && !this.definition.prune().hasData()) {
                this.definition = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getCurrency() != null && this.getCurrency().hasData()) {
                return true;
            }
            if (this.getExchangeId() != null && this.getExchangeId().hasData()) {
                return true;
            }
            if (this.getClearanceSystem() != null && this.getClearanceSystem().hasData()) {
                return true;
            }
            return this.getDefinition() != null && this.getDefinition().hasData();
        }

        @Override
        public UnderlyingAssetBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            UnderlyingAssetBuilder o = (UnderlyingAssetBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCurrency(), (RosettaModelObjectBuilder)o.getCurrency(), this::setCurrency);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExchangeId(), (RosettaModelObjectBuilder)o.getExchangeId(), this::setExchangeId);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getClearanceSystem(), (RosettaModelObjectBuilder)o.getClearanceSystem(), this::setClearanceSystem);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDefinition(), (RosettaModelObjectBuilder)o.getDefinition(), this::setDefinition);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            UnderlyingAsset _that = (UnderlyingAsset)this.getType().cast(o);
            if (!Objects.equals(this.currency, _that.getCurrency())) {
                return false;
            }
            if (!Objects.equals(this.exchangeId, _that.getExchangeId())) {
                return false;
            }
            if (!Objects.equals(this.clearanceSystem, _that.getClearanceSystem())) {
                return false;
            }
            return Objects.equals(this.definition, _that.getDefinition());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.currency != null ? this.currency.hashCode() : 0);
            _result = 31 * _result + (this.exchangeId != null ? this.exchangeId.hashCode() : 0);
            _result = 31 * _result + (this.clearanceSystem != null ? this.clearanceSystem.hashCode() : 0);
            _result = 31 * _result + (this.definition != null ? this.definition.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "UnderlyingAssetBuilder {currency=" + this.currency + ", exchangeId=" + this.exchangeId + ", clearanceSystem=" + this.clearanceSystem + ", definition=" + this.definition + '}' + " " + super.toString();
        }
    }

    public static interface UnderlyingAssetBuilder
    extends UnderlyingAsset,
    IdentifiedAsset.IdentifiedAssetBuilder {
        public IdentifiedCurrency.IdentifiedCurrencyBuilder getOrCreateCurrency();

        @Override
        public IdentifiedCurrency.IdentifiedCurrencyBuilder getCurrency();

        public ExchangeId.ExchangeIdBuilder getOrCreateExchangeId();

        @Override
        public ExchangeId.ExchangeIdBuilder getExchangeId();

        public ClearanceSystem.ClearanceSystemBuilder getOrCreateClearanceSystem();

        @Override
        public ClearanceSystem.ClearanceSystemBuilder getClearanceSystem();

        public ProductReference.ProductReferenceBuilder getOrCreateDefinition();

        @Override
        public ProductReference.ProductReferenceBuilder getDefinition();

        @Override
        public UnderlyingAssetBuilder setId(String var1);

        @Override
        public UnderlyingAssetBuilder addInstrumentId(InstrumentId var1);

        @Override
        public UnderlyingAssetBuilder addInstrumentId(InstrumentId var1, int var2);

        @Override
        public UnderlyingAssetBuilder addInstrumentId(List<? extends InstrumentId> var1);

        @Override
        public UnderlyingAssetBuilder setInstrumentId(List<? extends InstrumentId> var1);

        @Override
        public UnderlyingAssetBuilder addInstrumentType(InstrumentType var1);

        @Override
        public UnderlyingAssetBuilder addInstrumentType(InstrumentType var1, int var2);

        @Override
        public UnderlyingAssetBuilder addInstrumentType(List<? extends InstrumentType> var1);

        @Override
        public UnderlyingAssetBuilder setInstrumentType(List<? extends InstrumentType> var1);

        @Override
        public UnderlyingAssetBuilder setDescription(String var1);

        public UnderlyingAssetBuilder setCurrency(IdentifiedCurrency var1);

        public UnderlyingAssetBuilder setExchangeId(ExchangeId var1);

        public UnderlyingAssetBuilder setClearanceSystem(ClearanceSystem var1);

        public UnderlyingAssetBuilder setDefinition(ProductReference var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.InstrumentIdBuilder.class, this.getInstrumentId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("instrumentType"), processor, InstrumentType.InstrumentTypeBuilder.class, this.getInstrumentType(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("currency"), processor, IdentifiedCurrency.IdentifiedCurrencyBuilder.class, this.getCurrency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exchangeId"), processor, ExchangeId.ExchangeIdBuilder.class, this.getExchangeId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("clearanceSystem"), processor, ClearanceSystem.ClearanceSystemBuilder.class, this.getClearanceSystem(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("definition"), processor, ProductReference.ProductReferenceBuilder.class, this.getDefinition(), new AttributeMeta[0]);
        }

        @Override
        public UnderlyingAssetBuilder prune();
    }

    public static class UnderlyingAssetImpl
    extends IdentifiedAsset.IdentifiedAssetImpl
    implements UnderlyingAsset {
        private final IdentifiedCurrency currency;
        private final ExchangeId exchangeId;
        private final ClearanceSystem clearanceSystem;
        private final ProductReference definition;

        protected UnderlyingAssetImpl(UnderlyingAssetBuilder builder) {
            super(builder);
            this.currency = Optional.ofNullable(builder.getCurrency()).map(f -> f.build()).orElse(null);
            this.exchangeId = Optional.ofNullable(builder.getExchangeId()).map(f -> f.build()).orElse(null);
            this.clearanceSystem = Optional.ofNullable(builder.getClearanceSystem()).map(f -> f.build()).orElse(null);
            this.definition = Optional.ofNullable(builder.getDefinition()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public IdentifiedCurrency getCurrency() {
            return this.currency;
        }

        @Override
        @RosettaAttribute(value="exchangeId")
        @RuneAttribute(value="exchangeId")
        public ExchangeId getExchangeId() {
            return this.exchangeId;
        }

        @Override
        @RosettaAttribute(value="clearanceSystem")
        @RuneAttribute(value="clearanceSystem")
        public ClearanceSystem getClearanceSystem() {
            return this.clearanceSystem;
        }

        @Override
        @RosettaAttribute(value="definition")
        @RuneAttribute(value="definition")
        public ProductReference getDefinition() {
            return this.definition;
        }

        @Override
        public UnderlyingAsset build() {
            return this;
        }

        @Override
        public UnderlyingAssetBuilder toBuilder() {
            UnderlyingAssetBuilder builder = UnderlyingAsset.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(UnderlyingAssetBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getCurrency()).ifPresent(builder::setCurrency);
            Optional.ofNullable(this.getExchangeId()).ifPresent(builder::setExchangeId);
            Optional.ofNullable(this.getClearanceSystem()).ifPresent(builder::setClearanceSystem);
            Optional.ofNullable(this.getDefinition()).ifPresent(builder::setDefinition);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            UnderlyingAsset _that = (UnderlyingAsset)this.getType().cast(o);
            if (!Objects.equals(this.currency, _that.getCurrency())) {
                return false;
            }
            if (!Objects.equals(this.exchangeId, _that.getExchangeId())) {
                return false;
            }
            if (!Objects.equals(this.clearanceSystem, _that.getClearanceSystem())) {
                return false;
            }
            return Objects.equals(this.definition, _that.getDefinition());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.currency != null ? this.currency.hashCode() : 0);
            _result = 31 * _result + (this.exchangeId != null ? this.exchangeId.hashCode() : 0);
            _result = 31 * _result + (this.clearanceSystem != null ? this.clearanceSystem.hashCode() : 0);
            _result = 31 * _result + (this.definition != null ? this.definition.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "UnderlyingAsset {currency=" + this.currency + ", exchangeId=" + this.exchangeId + ", clearanceSystem=" + this.clearanceSystem + ", definition=" + this.definition + '}' + " " + super.toString();
        }
    }
}

