/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.confirmation.OriginatingEvent;
import fpml.confirmation.PartyTradeIdentifier;
import fpml.confirmation.PartyTradeInformation;
import fpml.confirmation.ProductId;
import fpml.confirmation.ProductType;
import fpml.confirmation.TerminatingEvent;
import fpml.confirmation.meta.TradeReferenceInformationMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="TradeReferenceInformation", builder=TradeReferenceInformationBuilderImpl.class, version="0.17.2")
@RuneDataType(value="TradeReferenceInformation", model="fpml", builder=TradeReferenceInformationBuilderImpl.class, version="0.17.2")
public interface TradeReferenceInformation
extends RosettaModelObject {
    public static final TradeReferenceInformationMeta metaData = new TradeReferenceInformationMeta();

    public OriginatingEvent getOriginatingEvent();

    public TerminatingEvent getTerminatingEvent();

    public List<? extends PartyTradeIdentifier> getPartyTradeIdentifier();

    public List<? extends PartyTradeInformation> getPartyTradeInformation();

    public ProductType getProductType();

    public ProductId getProductId();

    public TradeReferenceInformation build();

    public TradeReferenceInformationBuilder toBuilder();

    public static TradeReferenceInformationBuilder builder() {
        return new TradeReferenceInformationBuilderImpl();
    }

    default public RosettaMetaData<? extends TradeReferenceInformation> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends TradeReferenceInformation> getType() {
        return TradeReferenceInformation.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("originatingEvent"), processor, OriginatingEvent.class, this.getOriginatingEvent(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("terminatingEvent"), processor, TerminatingEvent.class, this.getTerminatingEvent(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partyTradeIdentifier"), processor, PartyTradeIdentifier.class, this.getPartyTradeIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partyTradeInformation"), processor, PartyTradeInformation.class, this.getPartyTradeInformation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("productType"), processor, ProductType.class, this.getProductType(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("productId"), processor, ProductId.class, this.getProductId(), new AttributeMeta[0]);
    }

    public static class TradeReferenceInformationBuilderImpl
    implements TradeReferenceInformationBuilder {
        protected OriginatingEvent.OriginatingEventBuilder originatingEvent;
        protected TerminatingEvent.TerminatingEventBuilder terminatingEvent;
        protected List<PartyTradeIdentifier.PartyTradeIdentifierBuilder> partyTradeIdentifier = new ArrayList<PartyTradeIdentifier.PartyTradeIdentifierBuilder>();
        protected List<PartyTradeInformation.PartyTradeInformationBuilder> partyTradeInformation = new ArrayList<PartyTradeInformation.PartyTradeInformationBuilder>();
        protected ProductType.ProductTypeBuilder productType;
        protected ProductId.ProductIdBuilder productId;

        @Override
        @RosettaAttribute(value="originatingEvent")
        @RuneAttribute(value="originatingEvent")
        public OriginatingEvent.OriginatingEventBuilder getOriginatingEvent() {
            return this.originatingEvent;
        }

        @Override
        public OriginatingEvent.OriginatingEventBuilder getOrCreateOriginatingEvent() {
            OriginatingEvent.OriginatingEventBuilder result = this.originatingEvent != null ? this.originatingEvent : (this.originatingEvent = OriginatingEvent.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="terminatingEvent")
        @RuneAttribute(value="terminatingEvent")
        public TerminatingEvent.TerminatingEventBuilder getTerminatingEvent() {
            return this.terminatingEvent;
        }

        @Override
        public TerminatingEvent.TerminatingEventBuilder getOrCreateTerminatingEvent() {
            TerminatingEvent.TerminatingEventBuilder result = this.terminatingEvent != null ? this.terminatingEvent : (this.terminatingEvent = TerminatingEvent.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="partyTradeIdentifier", isRequired=true)
        @RuneAttribute(value="partyTradeIdentifier", isRequired=true)
        public List<? extends PartyTradeIdentifier.PartyTradeIdentifierBuilder> getPartyTradeIdentifier() {
            return this.partyTradeIdentifier;
        }

        @Override
        public PartyTradeIdentifier.PartyTradeIdentifierBuilder getOrCreatePartyTradeIdentifier(int index) {
            if (this.partyTradeIdentifier == null) {
                this.partyTradeIdentifier = new ArrayList<PartyTradeIdentifier.PartyTradeIdentifierBuilder>();
            }
            return (PartyTradeIdentifier.PartyTradeIdentifierBuilder)this.getIndex(this.partyTradeIdentifier, index, () -> {
                PartyTradeIdentifier.PartyTradeIdentifierBuilder newPartyTradeIdentifier = PartyTradeIdentifier.builder();
                return newPartyTradeIdentifier;
            });
        }

        @Override
        @RosettaAttribute(value="partyTradeInformation")
        @RuneAttribute(value="partyTradeInformation")
        public List<? extends PartyTradeInformation.PartyTradeInformationBuilder> getPartyTradeInformation() {
            return this.partyTradeInformation;
        }

        @Override
        public PartyTradeInformation.PartyTradeInformationBuilder getOrCreatePartyTradeInformation(int index) {
            if (this.partyTradeInformation == null) {
                this.partyTradeInformation = new ArrayList<PartyTradeInformation.PartyTradeInformationBuilder>();
            }
            return (PartyTradeInformation.PartyTradeInformationBuilder)this.getIndex(this.partyTradeInformation, index, () -> {
                PartyTradeInformation.PartyTradeInformationBuilder newPartyTradeInformation = PartyTradeInformation.builder();
                return newPartyTradeInformation;
            });
        }

        @Override
        @RosettaAttribute(value="productType")
        @RuneAttribute(value="productType")
        public ProductType.ProductTypeBuilder getProductType() {
            return this.productType;
        }

        @Override
        public ProductType.ProductTypeBuilder getOrCreateProductType() {
            ProductType.ProductTypeBuilder result = this.productType != null ? this.productType : (this.productType = ProductType.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="productId")
        @RuneAttribute(value="productId")
        public ProductId.ProductIdBuilder getProductId() {
            return this.productId;
        }

        @Override
        public ProductId.ProductIdBuilder getOrCreateProductId() {
            ProductId.ProductIdBuilder result = this.productId != null ? this.productId : (this.productId = ProductId.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="originatingEvent")
        @RuneAttribute(value="originatingEvent")
        public TradeReferenceInformationBuilder setOriginatingEvent(OriginatingEvent _originatingEvent) {
            this.originatingEvent = _originatingEvent == null ? null : _originatingEvent.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="terminatingEvent")
        @RuneAttribute(value="terminatingEvent")
        public TradeReferenceInformationBuilder setTerminatingEvent(TerminatingEvent _terminatingEvent) {
            this.terminatingEvent = _terminatingEvent == null ? null : _terminatingEvent.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="partyTradeIdentifier", isRequired=true)
        @RuneAttribute(value="partyTradeIdentifier", isRequired=true)
        public TradeReferenceInformationBuilder addPartyTradeIdentifier(PartyTradeIdentifier _partyTradeIdentifier) {
            if (_partyTradeIdentifier != null) {
                this.partyTradeIdentifier.add(_partyTradeIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public TradeReferenceInformationBuilder addPartyTradeIdentifier(PartyTradeIdentifier _partyTradeIdentifier, int idx) {
            this.getIndex(this.partyTradeIdentifier, idx, () -> _partyTradeIdentifier.toBuilder());
            return this;
        }

        @Override
        public TradeReferenceInformationBuilder addPartyTradeIdentifier(List<? extends PartyTradeIdentifier> partyTradeIdentifiers) {
            if (partyTradeIdentifiers != null) {
                for (PartyTradeIdentifier partyTradeIdentifier : partyTradeIdentifiers) {
                    this.partyTradeIdentifier.add(partyTradeIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="partyTradeIdentifier")
        public TradeReferenceInformationBuilder setPartyTradeIdentifier(List<? extends PartyTradeIdentifier> partyTradeIdentifiers) {
            this.partyTradeIdentifier = partyTradeIdentifiers == null ? new ArrayList<PartyTradeIdentifier.PartyTradeIdentifierBuilder>() : (List)partyTradeIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="partyTradeInformation")
        @RuneAttribute(value="partyTradeInformation")
        public TradeReferenceInformationBuilder addPartyTradeInformation(PartyTradeInformation _partyTradeInformation) {
            if (_partyTradeInformation != null) {
                this.partyTradeInformation.add(_partyTradeInformation.toBuilder());
            }
            return this;
        }

        @Override
        public TradeReferenceInformationBuilder addPartyTradeInformation(PartyTradeInformation _partyTradeInformation, int idx) {
            this.getIndex(this.partyTradeInformation, idx, () -> _partyTradeInformation.toBuilder());
            return this;
        }

        @Override
        public TradeReferenceInformationBuilder addPartyTradeInformation(List<? extends PartyTradeInformation> partyTradeInformations) {
            if (partyTradeInformations != null) {
                for (PartyTradeInformation partyTradeInformation : partyTradeInformations) {
                    this.partyTradeInformation.add(partyTradeInformation.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="partyTradeInformation")
        public TradeReferenceInformationBuilder setPartyTradeInformation(List<? extends PartyTradeInformation> partyTradeInformations) {
            this.partyTradeInformation = partyTradeInformations == null ? new ArrayList<PartyTradeInformation.PartyTradeInformationBuilder>() : (List)partyTradeInformations.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="productType")
        @RuneAttribute(value="productType")
        public TradeReferenceInformationBuilder setProductType(ProductType _productType) {
            this.productType = _productType == null ? null : _productType.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="productId")
        @RuneAttribute(value="productId")
        public TradeReferenceInformationBuilder setProductId(ProductId _productId) {
            this.productId = _productId == null ? null : _productId.toBuilder();
            return this;
        }

        @Override
        public TradeReferenceInformation build() {
            return new TradeReferenceInformationImpl(this);
        }

        @Override
        public TradeReferenceInformationBuilder toBuilder() {
            return this;
        }

        @Override
        public TradeReferenceInformationBuilder prune() {
            if (this.originatingEvent != null && !this.originatingEvent.prune().hasData()) {
                this.originatingEvent = null;
            }
            if (this.terminatingEvent != null && !this.terminatingEvent.prune().hasData()) {
                this.terminatingEvent = null;
            }
            this.partyTradeIdentifier = this.partyTradeIdentifier.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.partyTradeInformation = this.partyTradeInformation.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.productType != null && !this.productType.prune().hasData()) {
                this.productType = null;
            }
            if (this.productId != null && !this.productId.prune().hasData()) {
                this.productId = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getOriginatingEvent() != null && this.getOriginatingEvent().hasData()) {
                return true;
            }
            if (this.getTerminatingEvent() != null && this.getTerminatingEvent().hasData()) {
                return true;
            }
            if (this.getPartyTradeIdentifier() != null && this.getPartyTradeIdentifier().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getPartyTradeInformation() != null && this.getPartyTradeInformation().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getProductType() != null && this.getProductType().hasData()) {
                return true;
            }
            return this.getProductId() != null && this.getProductId().hasData();
        }

        public TradeReferenceInformationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            TradeReferenceInformationBuilder o = (TradeReferenceInformationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getOriginatingEvent(), (RosettaModelObjectBuilder)o.getOriginatingEvent(), this::setOriginatingEvent);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTerminatingEvent(), (RosettaModelObjectBuilder)o.getTerminatingEvent(), this::setTerminatingEvent);
            merger.mergeRosetta(this.getPartyTradeIdentifier(), o.getPartyTradeIdentifier(), this::getOrCreatePartyTradeIdentifier);
            merger.mergeRosetta(this.getPartyTradeInformation(), o.getPartyTradeInformation(), this::getOrCreatePartyTradeInformation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getProductType(), (RosettaModelObjectBuilder)o.getProductType(), this::setProductType);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getProductId(), (RosettaModelObjectBuilder)o.getProductId(), this::setProductId);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            TradeReferenceInformation _that = this.getType().cast(o);
            if (!Objects.equals(this.originatingEvent, _that.getOriginatingEvent())) {
                return false;
            }
            if (!Objects.equals(this.terminatingEvent, _that.getTerminatingEvent())) {
                return false;
            }
            if (!ListEquals.listEquals(this.partyTradeIdentifier, _that.getPartyTradeIdentifier())) {
                return false;
            }
            if (!ListEquals.listEquals(this.partyTradeInformation, _that.getPartyTradeInformation())) {
                return false;
            }
            if (!Objects.equals(this.productType, _that.getProductType())) {
                return false;
            }
            return Objects.equals(this.productId, _that.getProductId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.originatingEvent != null ? this.originatingEvent.hashCode() : 0);
            _result = 31 * _result + (this.terminatingEvent != null ? this.terminatingEvent.hashCode() : 0);
            _result = 31 * _result + (this.partyTradeIdentifier != null ? this.partyTradeIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.partyTradeInformation != null ? this.partyTradeInformation.hashCode() : 0);
            _result = 31 * _result + (this.productType != null ? this.productType.hashCode() : 0);
            _result = 31 * _result + (this.productId != null ? this.productId.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TradeReferenceInformationBuilder {originatingEvent=" + this.originatingEvent + ", terminatingEvent=" + this.terminatingEvent + ", partyTradeIdentifier=" + this.partyTradeIdentifier + ", partyTradeInformation=" + this.partyTradeInformation + ", productType=" + this.productType + ", productId=" + this.productId + '}';
        }
    }

    public static interface TradeReferenceInformationBuilder
    extends TradeReferenceInformation,
    RosettaModelObjectBuilder {
        public OriginatingEvent.OriginatingEventBuilder getOrCreateOriginatingEvent();

        @Override
        public OriginatingEvent.OriginatingEventBuilder getOriginatingEvent();

        public TerminatingEvent.TerminatingEventBuilder getOrCreateTerminatingEvent();

        @Override
        public TerminatingEvent.TerminatingEventBuilder getTerminatingEvent();

        public PartyTradeIdentifier.PartyTradeIdentifierBuilder getOrCreatePartyTradeIdentifier(int var1);

        public List<? extends PartyTradeIdentifier.PartyTradeIdentifierBuilder> getPartyTradeIdentifier();

        public PartyTradeInformation.PartyTradeInformationBuilder getOrCreatePartyTradeInformation(int var1);

        public List<? extends PartyTradeInformation.PartyTradeInformationBuilder> getPartyTradeInformation();

        public ProductType.ProductTypeBuilder getOrCreateProductType();

        @Override
        public ProductType.ProductTypeBuilder getProductType();

        public ProductId.ProductIdBuilder getOrCreateProductId();

        @Override
        public ProductId.ProductIdBuilder getProductId();

        public TradeReferenceInformationBuilder setOriginatingEvent(OriginatingEvent var1);

        public TradeReferenceInformationBuilder setTerminatingEvent(TerminatingEvent var1);

        public TradeReferenceInformationBuilder addPartyTradeIdentifier(PartyTradeIdentifier var1);

        public TradeReferenceInformationBuilder addPartyTradeIdentifier(PartyTradeIdentifier var1, int var2);

        public TradeReferenceInformationBuilder addPartyTradeIdentifier(List<? extends PartyTradeIdentifier> var1);

        public TradeReferenceInformationBuilder setPartyTradeIdentifier(List<? extends PartyTradeIdentifier> var1);

        public TradeReferenceInformationBuilder addPartyTradeInformation(PartyTradeInformation var1);

        public TradeReferenceInformationBuilder addPartyTradeInformation(PartyTradeInformation var1, int var2);

        public TradeReferenceInformationBuilder addPartyTradeInformation(List<? extends PartyTradeInformation> var1);

        public TradeReferenceInformationBuilder setPartyTradeInformation(List<? extends PartyTradeInformation> var1);

        public TradeReferenceInformationBuilder setProductType(ProductType var1);

        public TradeReferenceInformationBuilder setProductId(ProductId var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("originatingEvent"), processor, OriginatingEvent.OriginatingEventBuilder.class, this.getOriginatingEvent(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("terminatingEvent"), processor, TerminatingEvent.TerminatingEventBuilder.class, this.getTerminatingEvent(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partyTradeIdentifier"), processor, PartyTradeIdentifier.PartyTradeIdentifierBuilder.class, this.getPartyTradeIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partyTradeInformation"), processor, PartyTradeInformation.PartyTradeInformationBuilder.class, this.getPartyTradeInformation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("productType"), processor, ProductType.ProductTypeBuilder.class, this.getProductType(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("productId"), processor, ProductId.ProductIdBuilder.class, this.getProductId(), new AttributeMeta[0]);
        }

        public TradeReferenceInformationBuilder prune();
    }

    public static class TradeReferenceInformationImpl
    implements TradeReferenceInformation {
        private final OriginatingEvent originatingEvent;
        private final TerminatingEvent terminatingEvent;
        private final List<? extends PartyTradeIdentifier> partyTradeIdentifier;
        private final List<? extends PartyTradeInformation> partyTradeInformation;
        private final ProductType productType;
        private final ProductId productId;

        protected TradeReferenceInformationImpl(TradeReferenceInformationBuilder builder) {
            this.originatingEvent = Optional.ofNullable(builder.getOriginatingEvent()).map(f -> f.build()).orElse(null);
            this.terminatingEvent = Optional.ofNullable(builder.getTerminatingEvent()).map(f -> f.build()).orElse(null);
            this.partyTradeIdentifier = Optional.ofNullable(builder.getPartyTradeIdentifier()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.partyTradeInformation = Optional.ofNullable(builder.getPartyTradeInformation()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.productType = Optional.ofNullable(builder.getProductType()).map(f -> f.build()).orElse(null);
            this.productId = Optional.ofNullable(builder.getProductId()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="originatingEvent")
        @RuneAttribute(value="originatingEvent")
        public OriginatingEvent getOriginatingEvent() {
            return this.originatingEvent;
        }

        @Override
        @RosettaAttribute(value="terminatingEvent")
        @RuneAttribute(value="terminatingEvent")
        public TerminatingEvent getTerminatingEvent() {
            return this.terminatingEvent;
        }

        @Override
        @RosettaAttribute(value="partyTradeIdentifier", isRequired=true)
        @RuneAttribute(value="partyTradeIdentifier", isRequired=true)
        public List<? extends PartyTradeIdentifier> getPartyTradeIdentifier() {
            return this.partyTradeIdentifier;
        }

        @Override
        @RosettaAttribute(value="partyTradeInformation")
        @RuneAttribute(value="partyTradeInformation")
        public List<? extends PartyTradeInformation> getPartyTradeInformation() {
            return this.partyTradeInformation;
        }

        @Override
        @RosettaAttribute(value="productType")
        @RuneAttribute(value="productType")
        public ProductType getProductType() {
            return this.productType;
        }

        @Override
        @RosettaAttribute(value="productId")
        @RuneAttribute(value="productId")
        public ProductId getProductId() {
            return this.productId;
        }

        @Override
        public TradeReferenceInformation build() {
            return this;
        }

        @Override
        public TradeReferenceInformationBuilder toBuilder() {
            TradeReferenceInformationBuilder builder = TradeReferenceInformation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(TradeReferenceInformationBuilder builder) {
            Optional.ofNullable(this.getOriginatingEvent()).ifPresent(builder::setOriginatingEvent);
            Optional.ofNullable(this.getTerminatingEvent()).ifPresent(builder::setTerminatingEvent);
            Optional.ofNullable(this.getPartyTradeIdentifier()).ifPresent(builder::setPartyTradeIdentifier);
            Optional.ofNullable(this.getPartyTradeInformation()).ifPresent(builder::setPartyTradeInformation);
            Optional.ofNullable(this.getProductType()).ifPresent(builder::setProductType);
            Optional.ofNullable(this.getProductId()).ifPresent(builder::setProductId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            TradeReferenceInformation _that = this.getType().cast(o);
            if (!Objects.equals(this.originatingEvent, _that.getOriginatingEvent())) {
                return false;
            }
            if (!Objects.equals(this.terminatingEvent, _that.getTerminatingEvent())) {
                return false;
            }
            if (!ListEquals.listEquals(this.partyTradeIdentifier, _that.getPartyTradeIdentifier())) {
                return false;
            }
            if (!ListEquals.listEquals(this.partyTradeInformation, _that.getPartyTradeInformation())) {
                return false;
            }
            if (!Objects.equals(this.productType, _that.getProductType())) {
                return false;
            }
            return Objects.equals(this.productId, _that.getProductId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.originatingEvent != null ? this.originatingEvent.hashCode() : 0);
            _result = 31 * _result + (this.terminatingEvent != null ? this.terminatingEvent.hashCode() : 0);
            _result = 31 * _result + (this.partyTradeIdentifier != null ? this.partyTradeIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.partyTradeInformation != null ? this.partyTradeInformation.hashCode() : 0);
            _result = 31 * _result + (this.productType != null ? this.productType.hashCode() : 0);
            _result = 31 * _result + (this.productId != null ? this.productId.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TradeReferenceInformation {originatingEvent=" + this.originatingEvent + ", terminatingEvent=" + this.terminatingEvent + ", partyTradeIdentifier=" + this.partyTradeIdentifier + ", partyTradeInformation=" + this.partyTradeInformation + ", productType=" + this.productType + ", productId=" + this.productId + '}';
        }
    }
}

