/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.confirmation.InstrumentId;
import fpml.confirmation.Reference;
import fpml.confirmation.meta.TradeLegPriceChangeMeta;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="TradeLegPriceChange", builder=TradeLegPriceChangeBuilderImpl.class, version="0.17.2")
@RuneDataType(value="TradeLegPriceChange", model="fpml", builder=TradeLegPriceChangeBuilderImpl.class, version="0.17.2")
public interface TradeLegPriceChange
extends RosettaModelObject {
    public static final TradeLegPriceChangeMeta metaData = new TradeLegPriceChangeMeta();

    public Reference getPriceReference();

    public List<? extends InstrumentId> getInstrumentId();

    public BigDecimal getPriceChangeAmount();

    public BigDecimal getNewPrice();

    public TradeLegPriceChange build();

    public TradeLegPriceChangeBuilder toBuilder();

    public static TradeLegPriceChangeBuilder builder() {
        return new TradeLegPriceChangeBuilderImpl();
    }

    default public RosettaMetaData<? extends TradeLegPriceChange> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends TradeLegPriceChange> getType() {
        return TradeLegPriceChange.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("priceReference"), processor, Reference.class, this.getPriceReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.class, this.getInstrumentId(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priceChangeAmount"), BigDecimal.class, (Object)this.getPriceChangeAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("newPrice"), BigDecimal.class, (Object)this.getNewPrice(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class TradeLegPriceChangeBuilderImpl
    implements TradeLegPriceChangeBuilder {
        protected Reference.ReferenceBuilder priceReference;
        protected List<InstrumentId.InstrumentIdBuilder> instrumentId = new ArrayList<InstrumentId.InstrumentIdBuilder>();
        protected BigDecimal priceChangeAmount;
        protected BigDecimal newPrice;

        @Override
        @RosettaAttribute(value="priceReference")
        @RuneAttribute(value="priceReference")
        public Reference.ReferenceBuilder getPriceReference() {
            return this.priceReference;
        }

        @Override
        public Reference.ReferenceBuilder getOrCreatePriceReference() {
            Reference.ReferenceBuilder result = this.priceReference != null ? this.priceReference : (this.priceReference = Reference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="instrumentId")
        @RuneAttribute(value="instrumentId")
        public List<? extends InstrumentId.InstrumentIdBuilder> getInstrumentId() {
            return this.instrumentId;
        }

        @Override
        public InstrumentId.InstrumentIdBuilder getOrCreateInstrumentId(int index) {
            if (this.instrumentId == null) {
                this.instrumentId = new ArrayList<InstrumentId.InstrumentIdBuilder>();
            }
            return (InstrumentId.InstrumentIdBuilder)this.getIndex(this.instrumentId, index, () -> {
                InstrumentId.InstrumentIdBuilder newInstrumentId = InstrumentId.builder();
                return newInstrumentId;
            });
        }

        @Override
        @RosettaAttribute(value="priceChangeAmount", isRequired=true)
        @RuneAttribute(value="priceChangeAmount", isRequired=true)
        public BigDecimal getPriceChangeAmount() {
            return this.priceChangeAmount;
        }

        @Override
        @RosettaAttribute(value="newPrice", isRequired=true)
        @RuneAttribute(value="newPrice", isRequired=true)
        public BigDecimal getNewPrice() {
            return this.newPrice;
        }

        @Override
        @RosettaAttribute(value="priceReference")
        @RuneAttribute(value="priceReference")
        public TradeLegPriceChangeBuilder setPriceReference(Reference _priceReference) {
            this.priceReference = _priceReference == null ? null : _priceReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="instrumentId")
        @RuneAttribute(value="instrumentId")
        public TradeLegPriceChangeBuilder addInstrumentId(InstrumentId _instrumentId) {
            if (_instrumentId != null) {
                this.instrumentId.add(_instrumentId.toBuilder());
            }
            return this;
        }

        @Override
        public TradeLegPriceChangeBuilder addInstrumentId(InstrumentId _instrumentId, int idx) {
            this.getIndex(this.instrumentId, idx, () -> _instrumentId.toBuilder());
            return this;
        }

        @Override
        public TradeLegPriceChangeBuilder addInstrumentId(List<? extends InstrumentId> instrumentIds) {
            if (instrumentIds != null) {
                for (InstrumentId instrumentId : instrumentIds) {
                    this.instrumentId.add(instrumentId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="instrumentId")
        public TradeLegPriceChangeBuilder setInstrumentId(List<? extends InstrumentId> instrumentIds) {
            this.instrumentId = instrumentIds == null ? new ArrayList<InstrumentId.InstrumentIdBuilder>() : (List)instrumentIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="priceChangeAmount", isRequired=true)
        @RuneAttribute(value="priceChangeAmount", isRequired=true)
        public TradeLegPriceChangeBuilder setPriceChangeAmount(BigDecimal _priceChangeAmount) {
            this.priceChangeAmount = _priceChangeAmount == null ? null : _priceChangeAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="newPrice", isRequired=true)
        @RuneAttribute(value="newPrice", isRequired=true)
        public TradeLegPriceChangeBuilder setNewPrice(BigDecimal _newPrice) {
            this.newPrice = _newPrice == null ? null : _newPrice;
            return this;
        }

        @Override
        public TradeLegPriceChange build() {
            return new TradeLegPriceChangeImpl(this);
        }

        @Override
        public TradeLegPriceChangeBuilder toBuilder() {
            return this;
        }

        @Override
        public TradeLegPriceChangeBuilder prune() {
            if (this.priceReference != null && !this.priceReference.prune().hasData()) {
                this.priceReference = null;
            }
            this.instrumentId = this.instrumentId.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getPriceReference() != null && this.getPriceReference().hasData()) {
                return true;
            }
            if (this.getInstrumentId() != null && this.getInstrumentId().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getPriceChangeAmount() != null) {
                return true;
            }
            return this.getNewPrice() != null;
        }

        public TradeLegPriceChangeBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            TradeLegPriceChangeBuilder o = (TradeLegPriceChangeBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPriceReference(), (RosettaModelObjectBuilder)o.getPriceReference(), this::setPriceReference);
            merger.mergeRosetta(this.getInstrumentId(), o.getInstrumentId(), this::getOrCreateInstrumentId);
            merger.mergeBasic((Object)this.getPriceChangeAmount(), (Object)o.getPriceChangeAmount(), this::setPriceChangeAmount, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNewPrice(), (Object)o.getNewPrice(), this::setNewPrice, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            TradeLegPriceChange _that = this.getType().cast(o);
            if (!Objects.equals(this.priceReference, _that.getPriceReference())) {
                return false;
            }
            if (!ListEquals.listEquals(this.instrumentId, _that.getInstrumentId())) {
                return false;
            }
            if (!Objects.equals(this.priceChangeAmount, _that.getPriceChangeAmount())) {
                return false;
            }
            return Objects.equals(this.newPrice, _that.getNewPrice());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.priceReference != null ? this.priceReference.hashCode() : 0);
            _result = 31 * _result + (this.instrumentId != null ? this.instrumentId.hashCode() : 0);
            _result = 31 * _result + (this.priceChangeAmount != null ? this.priceChangeAmount.hashCode() : 0);
            _result = 31 * _result + (this.newPrice != null ? this.newPrice.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TradeLegPriceChangeBuilder {priceReference=" + this.priceReference + ", instrumentId=" + this.instrumentId + ", priceChangeAmount=" + this.priceChangeAmount + ", newPrice=" + this.newPrice + '}';
        }
    }

    public static interface TradeLegPriceChangeBuilder
    extends TradeLegPriceChange,
    RosettaModelObjectBuilder {
        public Reference.ReferenceBuilder getOrCreatePriceReference();

        @Override
        public Reference.ReferenceBuilder getPriceReference();

        public InstrumentId.InstrumentIdBuilder getOrCreateInstrumentId(int var1);

        public List<? extends InstrumentId.InstrumentIdBuilder> getInstrumentId();

        public TradeLegPriceChangeBuilder setPriceReference(Reference var1);

        public TradeLegPriceChangeBuilder addInstrumentId(InstrumentId var1);

        public TradeLegPriceChangeBuilder addInstrumentId(InstrumentId var1, int var2);

        public TradeLegPriceChangeBuilder addInstrumentId(List<? extends InstrumentId> var1);

        public TradeLegPriceChangeBuilder setInstrumentId(List<? extends InstrumentId> var1);

        public TradeLegPriceChangeBuilder setPriceChangeAmount(BigDecimal var1);

        public TradeLegPriceChangeBuilder setNewPrice(BigDecimal var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("priceReference"), processor, Reference.ReferenceBuilder.class, this.getPriceReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.InstrumentIdBuilder.class, this.getInstrumentId(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priceChangeAmount"), BigDecimal.class, (Object)this.getPriceChangeAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("newPrice"), BigDecimal.class, (Object)this.getNewPrice(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public TradeLegPriceChangeBuilder prune();
    }

    public static class TradeLegPriceChangeImpl
    implements TradeLegPriceChange {
        private final Reference priceReference;
        private final List<? extends InstrumentId> instrumentId;
        private final BigDecimal priceChangeAmount;
        private final BigDecimal newPrice;

        protected TradeLegPriceChangeImpl(TradeLegPriceChangeBuilder builder) {
            this.priceReference = Optional.ofNullable(builder.getPriceReference()).map(f -> f.build()).orElse(null);
            this.instrumentId = Optional.ofNullable(builder.getInstrumentId()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.priceChangeAmount = builder.getPriceChangeAmount();
            this.newPrice = builder.getNewPrice();
        }

        @Override
        @RosettaAttribute(value="priceReference")
        @RuneAttribute(value="priceReference")
        public Reference getPriceReference() {
            return this.priceReference;
        }

        @Override
        @RosettaAttribute(value="instrumentId")
        @RuneAttribute(value="instrumentId")
        public List<? extends InstrumentId> getInstrumentId() {
            return this.instrumentId;
        }

        @Override
        @RosettaAttribute(value="priceChangeAmount", isRequired=true)
        @RuneAttribute(value="priceChangeAmount", isRequired=true)
        public BigDecimal getPriceChangeAmount() {
            return this.priceChangeAmount;
        }

        @Override
        @RosettaAttribute(value="newPrice", isRequired=true)
        @RuneAttribute(value="newPrice", isRequired=true)
        public BigDecimal getNewPrice() {
            return this.newPrice;
        }

        @Override
        public TradeLegPriceChange build() {
            return this;
        }

        @Override
        public TradeLegPriceChangeBuilder toBuilder() {
            TradeLegPriceChangeBuilder builder = TradeLegPriceChange.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(TradeLegPriceChangeBuilder builder) {
            Optional.ofNullable(this.getPriceReference()).ifPresent(builder::setPriceReference);
            Optional.ofNullable(this.getInstrumentId()).ifPresent(builder::setInstrumentId);
            Optional.ofNullable(this.getPriceChangeAmount()).ifPresent(builder::setPriceChangeAmount);
            Optional.ofNullable(this.getNewPrice()).ifPresent(builder::setNewPrice);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            TradeLegPriceChange _that = this.getType().cast(o);
            if (!Objects.equals(this.priceReference, _that.getPriceReference())) {
                return false;
            }
            if (!ListEquals.listEquals(this.instrumentId, _that.getInstrumentId())) {
                return false;
            }
            if (!Objects.equals(this.priceChangeAmount, _that.getPriceChangeAmount())) {
                return false;
            }
            return Objects.equals(this.newPrice, _that.getNewPrice());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.priceReference != null ? this.priceReference.hashCode() : 0);
            _result = 31 * _result + (this.instrumentId != null ? this.instrumentId.hashCode() : 0);
            _result = 31 * _result + (this.priceChangeAmount != null ? this.priceChangeAmount.hashCode() : 0);
            _result = 31 * _result + (this.newPrice != null ? this.newPrice.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TradeLegPriceChange {priceReference=" + this.priceReference + ", instrumentId=" + this.instrumentId + ", priceChangeAmount=" + this.priceChangeAmount + ", newPrice=" + this.newPrice + '}';
        }
    }
}

