/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.confirmation.DayCountFraction;
import fpml.confirmation.FxTenorModel;
import fpml.confirmation.Money;
import fpml.confirmation.PayerReceiverModel;
import fpml.confirmation.Payment;
import fpml.confirmation.PositiveMoney;
import fpml.confirmation.Product;
import fpml.confirmation.ProductModel;
import fpml.confirmation.TermDepositFeatures;
import fpml.confirmation.meta.TermDepositMeta;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="TermDeposit", builder=TermDepositBuilderImpl.class, version="0.17.2")
@RuneDataType(value="TermDeposit", model="fpml", builder=TermDepositBuilderImpl.class, version="0.17.2")
public interface TermDeposit
extends Product {
    public static final TermDepositMeta metaData = new TermDepositMeta();

    public PayerReceiverModel getPayerReceiverModel();

    public ZonedDateTime getStartDate();

    public ZonedDateTime getMaturityDate();

    public FxTenorModel getFxTenorModel();

    public PositiveMoney getPrincipal();

    public BigDecimal getFixedRate();

    public DayCountFraction getDayCountFraction();

    public TermDepositFeatures getFeatures();

    public Money getInterest();

    public List<? extends Payment> getPayment();

    @Override
    public TermDeposit build();

    @Override
    public TermDepositBuilder toBuilder();

    public static TermDepositBuilder builder() {
        return new TermDepositBuilderImpl();
    }

    default public RosettaMetaData<? extends TermDeposit> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends TermDeposit> getType() {
        return TermDeposit.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.class, this.getProductModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("payerReceiverModel"), processor, PayerReceiverModel.class, this.getPayerReceiverModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("startDate"), ZonedDateTime.class, (Object)this.getStartDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("maturityDate"), ZonedDateTime.class, (Object)this.getMaturityDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fxTenorModel"), processor, FxTenorModel.class, this.getFxTenorModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("principal"), processor, PositiveMoney.class, this.getPrincipal(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fixedRate"), BigDecimal.class, (Object)this.getFixedRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dayCountFraction"), processor, DayCountFraction.class, this.getDayCountFraction(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("features"), processor, TermDepositFeatures.class, this.getFeatures(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("interest"), processor, Money.class, this.getInterest(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("payment"), processor, Payment.class, this.getPayment(), new AttributeMeta[0]);
    }

    public static class TermDepositBuilderImpl
    extends Product.ProductBuilderImpl
    implements TermDepositBuilder {
        protected PayerReceiverModel.PayerReceiverModelBuilder payerReceiverModel;
        protected ZonedDateTime startDate;
        protected ZonedDateTime maturityDate;
        protected FxTenorModel.FxTenorModelBuilder fxTenorModel;
        protected PositiveMoney.PositiveMoneyBuilder principal;
        protected BigDecimal fixedRate;
        protected DayCountFraction.DayCountFractionBuilder dayCountFraction;
        protected TermDepositFeatures.TermDepositFeaturesBuilder features;
        protected Money.MoneyBuilder interest;
        protected List<Payment.PaymentBuilder> payment = new ArrayList<Payment.PaymentBuilder>();

        @Override
        @RosettaAttribute(value="payerReceiverModel", isRequired=true)
        @RuneAttribute(value="payerReceiverModel", isRequired=true)
        public PayerReceiverModel.PayerReceiverModelBuilder getPayerReceiverModel() {
            return this.payerReceiverModel;
        }

        @Override
        public PayerReceiverModel.PayerReceiverModelBuilder getOrCreatePayerReceiverModel() {
            PayerReceiverModel.PayerReceiverModelBuilder result = this.payerReceiverModel != null ? this.payerReceiverModel : (this.payerReceiverModel = PayerReceiverModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="startDate", isRequired=true)
        @RuneAttribute(value="startDate", isRequired=true)
        public ZonedDateTime getStartDate() {
            return this.startDate;
        }

        @Override
        @RosettaAttribute(value="maturityDate", isRequired=true)
        @RuneAttribute(value="maturityDate", isRequired=true)
        public ZonedDateTime getMaturityDate() {
            return this.maturityDate;
        }

        @Override
        @RosettaAttribute(value="fxTenorModel")
        @RuneAttribute(value="fxTenorModel")
        public FxTenorModel.FxTenorModelBuilder getFxTenorModel() {
            return this.fxTenorModel;
        }

        @Override
        public FxTenorModel.FxTenorModelBuilder getOrCreateFxTenorModel() {
            FxTenorModel.FxTenorModelBuilder result = this.fxTenorModel != null ? this.fxTenorModel : (this.fxTenorModel = FxTenorModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="principal", isRequired=true)
        @RuneAttribute(value="principal", isRequired=true)
        public PositiveMoney.PositiveMoneyBuilder getPrincipal() {
            return this.principal;
        }

        @Override
        public PositiveMoney.PositiveMoneyBuilder getOrCreatePrincipal() {
            PositiveMoney.PositiveMoneyBuilder result = this.principal != null ? this.principal : (this.principal = PositiveMoney.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fixedRate", isRequired=true)
        @RuneAttribute(value="fixedRate", isRequired=true)
        public BigDecimal getFixedRate() {
            return this.fixedRate;
        }

        @Override
        @RosettaAttribute(value="dayCountFraction", isRequired=true)
        @RuneAttribute(value="dayCountFraction", isRequired=true)
        public DayCountFraction.DayCountFractionBuilder getDayCountFraction() {
            return this.dayCountFraction;
        }

        @Override
        public DayCountFraction.DayCountFractionBuilder getOrCreateDayCountFraction() {
            DayCountFraction.DayCountFractionBuilder result = this.dayCountFraction != null ? this.dayCountFraction : (this.dayCountFraction = DayCountFraction.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="features")
        @RuneAttribute(value="features")
        public TermDepositFeatures.TermDepositFeaturesBuilder getFeatures() {
            return this.features;
        }

        @Override
        public TermDepositFeatures.TermDepositFeaturesBuilder getOrCreateFeatures() {
            TermDepositFeatures.TermDepositFeaturesBuilder result = this.features != null ? this.features : (this.features = TermDepositFeatures.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="interest")
        @RuneAttribute(value="interest")
        public Money.MoneyBuilder getInterest() {
            return this.interest;
        }

        @Override
        public Money.MoneyBuilder getOrCreateInterest() {
            Money.MoneyBuilder result = this.interest != null ? this.interest : (this.interest = Money.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="payment")
        @RuneAttribute(value="payment")
        public List<? extends Payment.PaymentBuilder> getPayment() {
            return this.payment;
        }

        @Override
        public Payment.PaymentBuilder getOrCreatePayment(int index) {
            if (this.payment == null) {
                this.payment = new ArrayList<Payment.PaymentBuilder>();
            }
            return (Payment.PaymentBuilder)this.getIndex(this.payment, index, () -> {
                Payment.PaymentBuilder newPayment = Payment.builder();
                return newPayment;
            });
        }

        @Override
        @RosettaAttribute(value="productModel")
        @RuneAttribute(value="productModel")
        public TermDepositBuilder setProductModel(ProductModel _productModel) {
            this.productModel = _productModel == null ? null : _productModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public TermDepositBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="payerReceiverModel", isRequired=true)
        @RuneAttribute(value="payerReceiverModel", isRequired=true)
        public TermDepositBuilder setPayerReceiverModel(PayerReceiverModel _payerReceiverModel) {
            this.payerReceiverModel = _payerReceiverModel == null ? null : _payerReceiverModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="startDate", isRequired=true)
        @RuneAttribute(value="startDate", isRequired=true)
        public TermDepositBuilder setStartDate(ZonedDateTime _startDate) {
            this.startDate = _startDate == null ? null : _startDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="maturityDate", isRequired=true)
        @RuneAttribute(value="maturityDate", isRequired=true)
        public TermDepositBuilder setMaturityDate(ZonedDateTime _maturityDate) {
            this.maturityDate = _maturityDate == null ? null : _maturityDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="fxTenorModel")
        @RuneAttribute(value="fxTenorModel")
        public TermDepositBuilder setFxTenorModel(FxTenorModel _fxTenorModel) {
            this.fxTenorModel = _fxTenorModel == null ? null : _fxTenorModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="principal", isRequired=true)
        @RuneAttribute(value="principal", isRequired=true)
        public TermDepositBuilder setPrincipal(PositiveMoney _principal) {
            this.principal = _principal == null ? null : _principal.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fixedRate", isRequired=true)
        @RuneAttribute(value="fixedRate", isRequired=true)
        public TermDepositBuilder setFixedRate(BigDecimal _fixedRate) {
            this.fixedRate = _fixedRate == null ? null : _fixedRate;
            return this;
        }

        @Override
        @RosettaAttribute(value="dayCountFraction", isRequired=true)
        @RuneAttribute(value="dayCountFraction", isRequired=true)
        public TermDepositBuilder setDayCountFraction(DayCountFraction _dayCountFraction) {
            this.dayCountFraction = _dayCountFraction == null ? null : _dayCountFraction.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="features")
        @RuneAttribute(value="features")
        public TermDepositBuilder setFeatures(TermDepositFeatures _features) {
            this.features = _features == null ? null : _features.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="interest")
        @RuneAttribute(value="interest")
        public TermDepositBuilder setInterest(Money _interest) {
            this.interest = _interest == null ? null : _interest.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="payment")
        @RuneAttribute(value="payment")
        public TermDepositBuilder addPayment(Payment _payment) {
            if (_payment != null) {
                this.payment.add(_payment.toBuilder());
            }
            return this;
        }

        @Override
        public TermDepositBuilder addPayment(Payment _payment, int idx) {
            this.getIndex(this.payment, idx, () -> _payment.toBuilder());
            return this;
        }

        @Override
        public TermDepositBuilder addPayment(List<? extends Payment> payments) {
            if (payments != null) {
                for (Payment payment : payments) {
                    this.payment.add(payment.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="payment")
        public TermDepositBuilder setPayment(List<? extends Payment> payments) {
            this.payment = payments == null ? new ArrayList<Payment.PaymentBuilder>() : (List)payments.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public TermDeposit build() {
            return new TermDepositImpl(this);
        }

        @Override
        public TermDepositBuilder toBuilder() {
            return this;
        }

        @Override
        public TermDepositBuilder prune() {
            super.prune();
            if (this.payerReceiverModel != null && !this.payerReceiverModel.prune().hasData()) {
                this.payerReceiverModel = null;
            }
            if (this.fxTenorModel != null && !this.fxTenorModel.prune().hasData()) {
                this.fxTenorModel = null;
            }
            if (this.principal != null && !this.principal.prune().hasData()) {
                this.principal = null;
            }
            if (this.dayCountFraction != null && !this.dayCountFraction.prune().hasData()) {
                this.dayCountFraction = null;
            }
            if (this.features != null && !this.features.prune().hasData()) {
                this.features = null;
            }
            if (this.interest != null && !this.interest.prune().hasData()) {
                this.interest = null;
            }
            this.payment = this.payment.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getPayerReceiverModel() != null && this.getPayerReceiverModel().hasData()) {
                return true;
            }
            if (this.getStartDate() != null) {
                return true;
            }
            if (this.getMaturityDate() != null) {
                return true;
            }
            if (this.getFxTenorModel() != null && this.getFxTenorModel().hasData()) {
                return true;
            }
            if (this.getPrincipal() != null && this.getPrincipal().hasData()) {
                return true;
            }
            if (this.getFixedRate() != null) {
                return true;
            }
            if (this.getDayCountFraction() != null && this.getDayCountFraction().hasData()) {
                return true;
            }
            if (this.getFeatures() != null && this.getFeatures().hasData()) {
                return true;
            }
            if (this.getInterest() != null && this.getInterest().hasData()) {
                return true;
            }
            return this.getPayment() != null && this.getPayment().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public TermDepositBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            TermDepositBuilder o = (TermDepositBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPayerReceiverModel(), (RosettaModelObjectBuilder)o.getPayerReceiverModel(), this::setPayerReceiverModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFxTenorModel(), (RosettaModelObjectBuilder)o.getFxTenorModel(), this::setFxTenorModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPrincipal(), (RosettaModelObjectBuilder)o.getPrincipal(), this::setPrincipal);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDayCountFraction(), (RosettaModelObjectBuilder)o.getDayCountFraction(), this::setDayCountFraction);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFeatures(), (RosettaModelObjectBuilder)o.getFeatures(), this::setFeatures);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getInterest(), (RosettaModelObjectBuilder)o.getInterest(), this::setInterest);
            merger.mergeRosetta(this.getPayment(), o.getPayment(), this::getOrCreatePayment);
            merger.mergeBasic((Object)this.getStartDate(), (Object)o.getStartDate(), this::setStartDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getMaturityDate(), (Object)o.getMaturityDate(), this::setMaturityDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFixedRate(), (Object)o.getFixedRate(), this::setFixedRate, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            TermDeposit _that = (TermDeposit)this.getType().cast(o);
            if (!Objects.equals(this.payerReceiverModel, _that.getPayerReceiverModel())) {
                return false;
            }
            if (!Objects.equals(this.startDate, _that.getStartDate())) {
                return false;
            }
            if (!Objects.equals(this.maturityDate, _that.getMaturityDate())) {
                return false;
            }
            if (!Objects.equals(this.fxTenorModel, _that.getFxTenorModel())) {
                return false;
            }
            if (!Objects.equals(this.principal, _that.getPrincipal())) {
                return false;
            }
            if (!Objects.equals(this.fixedRate, _that.getFixedRate())) {
                return false;
            }
            if (!Objects.equals(this.dayCountFraction, _that.getDayCountFraction())) {
                return false;
            }
            if (!Objects.equals(this.features, _that.getFeatures())) {
                return false;
            }
            if (!Objects.equals(this.interest, _that.getInterest())) {
                return false;
            }
            return ListEquals.listEquals(this.payment, _that.getPayment());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.payerReceiverModel != null ? this.payerReceiverModel.hashCode() : 0);
            _result = 31 * _result + (this.startDate != null ? this.startDate.hashCode() : 0);
            _result = 31 * _result + (this.maturityDate != null ? this.maturityDate.hashCode() : 0);
            _result = 31 * _result + (this.fxTenorModel != null ? this.fxTenorModel.hashCode() : 0);
            _result = 31 * _result + (this.principal != null ? this.principal.hashCode() : 0);
            _result = 31 * _result + (this.fixedRate != null ? this.fixedRate.hashCode() : 0);
            _result = 31 * _result + (this.dayCountFraction != null ? this.dayCountFraction.hashCode() : 0);
            _result = 31 * _result + (this.features != null ? this.features.hashCode() : 0);
            _result = 31 * _result + (this.interest != null ? this.interest.hashCode() : 0);
            _result = 31 * _result + (this.payment != null ? this.payment.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "TermDepositBuilder {payerReceiverModel=" + this.payerReceiverModel + ", startDate=" + this.startDate + ", maturityDate=" + this.maturityDate + ", fxTenorModel=" + this.fxTenorModel + ", principal=" + this.principal + ", fixedRate=" + this.fixedRate + ", dayCountFraction=" + this.dayCountFraction + ", features=" + this.features + ", interest=" + this.interest + ", payment=" + this.payment + '}' + " " + super.toString();
        }
    }

    public static interface TermDepositBuilder
    extends TermDeposit,
    Product.ProductBuilder {
        public PayerReceiverModel.PayerReceiverModelBuilder getOrCreatePayerReceiverModel();

        @Override
        public PayerReceiverModel.PayerReceiverModelBuilder getPayerReceiverModel();

        public FxTenorModel.FxTenorModelBuilder getOrCreateFxTenorModel();

        @Override
        public FxTenorModel.FxTenorModelBuilder getFxTenorModel();

        public PositiveMoney.PositiveMoneyBuilder getOrCreatePrincipal();

        @Override
        public PositiveMoney.PositiveMoneyBuilder getPrincipal();

        public DayCountFraction.DayCountFractionBuilder getOrCreateDayCountFraction();

        @Override
        public DayCountFraction.DayCountFractionBuilder getDayCountFraction();

        public TermDepositFeatures.TermDepositFeaturesBuilder getOrCreateFeatures();

        @Override
        public TermDepositFeatures.TermDepositFeaturesBuilder getFeatures();

        public Money.MoneyBuilder getOrCreateInterest();

        @Override
        public Money.MoneyBuilder getInterest();

        public Payment.PaymentBuilder getOrCreatePayment(int var1);

        public List<? extends Payment.PaymentBuilder> getPayment();

        @Override
        public TermDepositBuilder setProductModel(ProductModel var1);

        @Override
        public TermDepositBuilder setId(String var1);

        public TermDepositBuilder setPayerReceiverModel(PayerReceiverModel var1);

        public TermDepositBuilder setStartDate(ZonedDateTime var1);

        public TermDepositBuilder setMaturityDate(ZonedDateTime var1);

        public TermDepositBuilder setFxTenorModel(FxTenorModel var1);

        public TermDepositBuilder setPrincipal(PositiveMoney var1);

        public TermDepositBuilder setFixedRate(BigDecimal var1);

        public TermDepositBuilder setDayCountFraction(DayCountFraction var1);

        public TermDepositBuilder setFeatures(TermDepositFeatures var1);

        public TermDepositBuilder setInterest(Money var1);

        public TermDepositBuilder addPayment(Payment var1);

        public TermDepositBuilder addPayment(Payment var1, int var2);

        public TermDepositBuilder addPayment(List<? extends Payment> var1);

        public TermDepositBuilder setPayment(List<? extends Payment> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.ProductModelBuilder.class, (RosettaModelObjectBuilder)this.getProductModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("payerReceiverModel"), processor, PayerReceiverModel.PayerReceiverModelBuilder.class, this.getPayerReceiverModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("startDate"), ZonedDateTime.class, (Object)this.getStartDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("maturityDate"), ZonedDateTime.class, (Object)this.getMaturityDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fxTenorModel"), processor, FxTenorModel.FxTenorModelBuilder.class, this.getFxTenorModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("principal"), processor, PositiveMoney.PositiveMoneyBuilder.class, this.getPrincipal(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fixedRate"), BigDecimal.class, (Object)this.getFixedRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dayCountFraction"), processor, DayCountFraction.DayCountFractionBuilder.class, this.getDayCountFraction(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("features"), processor, TermDepositFeatures.TermDepositFeaturesBuilder.class, this.getFeatures(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("interest"), processor, Money.MoneyBuilder.class, this.getInterest(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("payment"), processor, Payment.PaymentBuilder.class, this.getPayment(), new AttributeMeta[0]);
        }

        @Override
        public TermDepositBuilder prune();
    }

    public static class TermDepositImpl
    extends Product.ProductImpl
    implements TermDeposit {
        private final PayerReceiverModel payerReceiverModel;
        private final ZonedDateTime startDate;
        private final ZonedDateTime maturityDate;
        private final FxTenorModel fxTenorModel;
        private final PositiveMoney principal;
        private final BigDecimal fixedRate;
        private final DayCountFraction dayCountFraction;
        private final TermDepositFeatures features;
        private final Money interest;
        private final List<? extends Payment> payment;

        protected TermDepositImpl(TermDepositBuilder builder) {
            super(builder);
            this.payerReceiverModel = Optional.ofNullable(builder.getPayerReceiverModel()).map(f -> f.build()).orElse(null);
            this.startDate = builder.getStartDate();
            this.maturityDate = builder.getMaturityDate();
            this.fxTenorModel = Optional.ofNullable(builder.getFxTenorModel()).map(f -> f.build()).orElse(null);
            this.principal = Optional.ofNullable(builder.getPrincipal()).map(f -> f.build()).orElse(null);
            this.fixedRate = builder.getFixedRate();
            this.dayCountFraction = Optional.ofNullable(builder.getDayCountFraction()).map(f -> f.build()).orElse(null);
            this.features = Optional.ofNullable(builder.getFeatures()).map(f -> f.build()).orElse(null);
            this.interest = Optional.ofNullable(builder.getInterest()).map(f -> f.build()).orElse(null);
            this.payment = Optional.ofNullable(builder.getPayment()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="payerReceiverModel", isRequired=true)
        @RuneAttribute(value="payerReceiverModel", isRequired=true)
        public PayerReceiverModel getPayerReceiverModel() {
            return this.payerReceiverModel;
        }

        @Override
        @RosettaAttribute(value="startDate", isRequired=true)
        @RuneAttribute(value="startDate", isRequired=true)
        public ZonedDateTime getStartDate() {
            return this.startDate;
        }

        @Override
        @RosettaAttribute(value="maturityDate", isRequired=true)
        @RuneAttribute(value="maturityDate", isRequired=true)
        public ZonedDateTime getMaturityDate() {
            return this.maturityDate;
        }

        @Override
        @RosettaAttribute(value="fxTenorModel")
        @RuneAttribute(value="fxTenorModel")
        public FxTenorModel getFxTenorModel() {
            return this.fxTenorModel;
        }

        @Override
        @RosettaAttribute(value="principal", isRequired=true)
        @RuneAttribute(value="principal", isRequired=true)
        public PositiveMoney getPrincipal() {
            return this.principal;
        }

        @Override
        @RosettaAttribute(value="fixedRate", isRequired=true)
        @RuneAttribute(value="fixedRate", isRequired=true)
        public BigDecimal getFixedRate() {
            return this.fixedRate;
        }

        @Override
        @RosettaAttribute(value="dayCountFraction", isRequired=true)
        @RuneAttribute(value="dayCountFraction", isRequired=true)
        public DayCountFraction getDayCountFraction() {
            return this.dayCountFraction;
        }

        @Override
        @RosettaAttribute(value="features")
        @RuneAttribute(value="features")
        public TermDepositFeatures getFeatures() {
            return this.features;
        }

        @Override
        @RosettaAttribute(value="interest")
        @RuneAttribute(value="interest")
        public Money getInterest() {
            return this.interest;
        }

        @Override
        @RosettaAttribute(value="payment")
        @RuneAttribute(value="payment")
        public List<? extends Payment> getPayment() {
            return this.payment;
        }

        @Override
        public TermDeposit build() {
            return this;
        }

        @Override
        public TermDepositBuilder toBuilder() {
            TermDepositBuilder builder = TermDeposit.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(TermDepositBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getPayerReceiverModel()).ifPresent(builder::setPayerReceiverModel);
            Optional.ofNullable(this.getStartDate()).ifPresent(builder::setStartDate);
            Optional.ofNullable(this.getMaturityDate()).ifPresent(builder::setMaturityDate);
            Optional.ofNullable(this.getFxTenorModel()).ifPresent(builder::setFxTenorModel);
            Optional.ofNullable(this.getPrincipal()).ifPresent(builder::setPrincipal);
            Optional.ofNullable(this.getFixedRate()).ifPresent(builder::setFixedRate);
            Optional.ofNullable(this.getDayCountFraction()).ifPresent(builder::setDayCountFraction);
            Optional.ofNullable(this.getFeatures()).ifPresent(builder::setFeatures);
            Optional.ofNullable(this.getInterest()).ifPresent(builder::setInterest);
            Optional.ofNullable(this.getPayment()).ifPresent(builder::setPayment);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            TermDeposit _that = (TermDeposit)this.getType().cast(o);
            if (!Objects.equals(this.payerReceiverModel, _that.getPayerReceiverModel())) {
                return false;
            }
            if (!Objects.equals(this.startDate, _that.getStartDate())) {
                return false;
            }
            if (!Objects.equals(this.maturityDate, _that.getMaturityDate())) {
                return false;
            }
            if (!Objects.equals(this.fxTenorModel, _that.getFxTenorModel())) {
                return false;
            }
            if (!Objects.equals(this.principal, _that.getPrincipal())) {
                return false;
            }
            if (!Objects.equals(this.fixedRate, _that.getFixedRate())) {
                return false;
            }
            if (!Objects.equals(this.dayCountFraction, _that.getDayCountFraction())) {
                return false;
            }
            if (!Objects.equals(this.features, _that.getFeatures())) {
                return false;
            }
            if (!Objects.equals(this.interest, _that.getInterest())) {
                return false;
            }
            return ListEquals.listEquals(this.payment, _that.getPayment());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.payerReceiverModel != null ? this.payerReceiverModel.hashCode() : 0);
            _result = 31 * _result + (this.startDate != null ? this.startDate.hashCode() : 0);
            _result = 31 * _result + (this.maturityDate != null ? this.maturityDate.hashCode() : 0);
            _result = 31 * _result + (this.fxTenorModel != null ? this.fxTenorModel.hashCode() : 0);
            _result = 31 * _result + (this.principal != null ? this.principal.hashCode() : 0);
            _result = 31 * _result + (this.fixedRate != null ? this.fixedRate.hashCode() : 0);
            _result = 31 * _result + (this.dayCountFraction != null ? this.dayCountFraction.hashCode() : 0);
            _result = 31 * _result + (this.features != null ? this.features.hashCode() : 0);
            _result = 31 * _result + (this.interest != null ? this.interest.hashCode() : 0);
            _result = 31 * _result + (this.payment != null ? this.payment.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "TermDeposit {payerReceiverModel=" + this.payerReceiverModel + ", startDate=" + this.startDate + ", maturityDate=" + this.maturityDate + ", fxTenorModel=" + this.fxTenorModel + ", principal=" + this.principal + ", fixedRate=" + this.fixedRate + ", dayCountFraction=" + this.dayCountFraction + ", features=" + this.features + ", interest=" + this.interest + ", payment=" + this.payment + '}' + " " + super.toString();
        }
    }
}

