/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.AdjustableOrRelativeDate;
import fpml.confirmation.Money;
import fpml.confirmation.StubFloatingRate;
import fpml.confirmation.StubValue;
import fpml.confirmation.meta.StubMeta;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Stub", builder=StubBuilderImpl.class, version="0.17.2")
@RuneDataType(value="Stub", model="fpml", builder=StubBuilderImpl.class, version="0.17.2")
public interface Stub
extends StubValue {
    public static final StubMeta metaData = new StubMeta();

    public AdjustableOrRelativeDate getStubStartDate();

    public AdjustableOrRelativeDate getStubEndDate();

    @Override
    public Stub build();

    @Override
    public StubBuilder toBuilder();

    public static StubBuilder builder() {
        return new StubBuilderImpl();
    }

    default public RosettaMetaData<? extends Stub> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Stub> getType() {
        return Stub.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("floatingRate"), processor, StubFloatingRate.class, this.getFloatingRate(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("stubRate"), BigDecimal.class, (Object)this.getStubRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("stubAmount"), processor, Money.class, this.getStubAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("stubStartDate"), processor, AdjustableOrRelativeDate.class, this.getStubStartDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("stubEndDate"), processor, AdjustableOrRelativeDate.class, this.getStubEndDate(), new AttributeMeta[0]);
    }

    public static class StubBuilderImpl
    extends StubValue.StubValueBuilderImpl
    implements StubBuilder {
        protected AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder stubStartDate;
        protected AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder stubEndDate;

        @Override
        @RosettaAttribute(value="stubStartDate")
        @RuneAttribute(value="stubStartDate")
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getStubStartDate() {
            return this.stubStartDate;
        }

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateStubStartDate() {
            AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder result = this.stubStartDate != null ? this.stubStartDate : (this.stubStartDate = AdjustableOrRelativeDate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="stubEndDate")
        @RuneAttribute(value="stubEndDate")
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getStubEndDate() {
            return this.stubEndDate;
        }

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateStubEndDate() {
            AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder result = this.stubEndDate != null ? this.stubEndDate : (this.stubEndDate = AdjustableOrRelativeDate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="floatingRate")
        @RuneAttribute(value="floatingRate")
        public StubBuilder addFloatingRate(StubFloatingRate _floatingRate) {
            if (_floatingRate != null) {
                this.floatingRate.add(_floatingRate.toBuilder());
            }
            return this;
        }

        @Override
        public StubBuilder addFloatingRate(StubFloatingRate _floatingRate, int idx) {
            this.getIndex(this.floatingRate, idx, () -> _floatingRate.toBuilder());
            return this;
        }

        @Override
        public StubBuilder addFloatingRate(List<? extends StubFloatingRate> floatingRates) {
            if (floatingRates != null) {
                for (StubFloatingRate stubFloatingRate : floatingRates) {
                    this.floatingRate.add(stubFloatingRate.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="floatingRate")
        public StubBuilder setFloatingRate(List<? extends StubFloatingRate> floatingRates) {
            this.floatingRate = floatingRates == null ? new ArrayList() : (List)floatingRates.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="stubRate")
        @RuneAttribute(value="stubRate")
        public StubBuilder setStubRate(BigDecimal _stubRate) {
            this.stubRate = _stubRate == null ? null : _stubRate;
            return this;
        }

        @Override
        @RosettaAttribute(value="stubAmount")
        @RuneAttribute(value="stubAmount")
        public StubBuilder setStubAmount(Money _stubAmount) {
            this.stubAmount = _stubAmount == null ? null : _stubAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="stubStartDate")
        @RuneAttribute(value="stubStartDate")
        public StubBuilder setStubStartDate(AdjustableOrRelativeDate _stubStartDate) {
            this.stubStartDate = _stubStartDate == null ? null : _stubStartDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="stubEndDate")
        @RuneAttribute(value="stubEndDate")
        public StubBuilder setStubEndDate(AdjustableOrRelativeDate _stubEndDate) {
            this.stubEndDate = _stubEndDate == null ? null : _stubEndDate.toBuilder();
            return this;
        }

        @Override
        public Stub build() {
            return new StubImpl(this);
        }

        @Override
        public StubBuilder toBuilder() {
            return this;
        }

        @Override
        public StubBuilder prune() {
            super.prune();
            if (this.stubStartDate != null && !this.stubStartDate.prune().hasData()) {
                this.stubStartDate = null;
            }
            if (this.stubEndDate != null && !this.stubEndDate.prune().hasData()) {
                this.stubEndDate = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getStubStartDate() != null && this.getStubStartDate().hasData()) {
                return true;
            }
            return this.getStubEndDate() != null && this.getStubEndDate().hasData();
        }

        @Override
        public StubBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            StubBuilder o = (StubBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getStubStartDate(), (RosettaModelObjectBuilder)o.getStubStartDate(), this::setStubStartDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getStubEndDate(), (RosettaModelObjectBuilder)o.getStubEndDate(), this::setStubEndDate);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Stub _that = (Stub)this.getType().cast(o);
            if (!Objects.equals(this.stubStartDate, _that.getStubStartDate())) {
                return false;
            }
            return Objects.equals(this.stubEndDate, _that.getStubEndDate());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.stubStartDate != null ? this.stubStartDate.hashCode() : 0);
            _result = 31 * _result + (this.stubEndDate != null ? this.stubEndDate.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "StubBuilder {stubStartDate=" + this.stubStartDate + ", stubEndDate=" + this.stubEndDate + '}' + " " + super.toString();
        }
    }

    public static interface StubBuilder
    extends Stub,
    StubValue.StubValueBuilder {
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateStubStartDate();

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getStubStartDate();

        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateStubEndDate();

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getStubEndDate();

        @Override
        public StubBuilder addFloatingRate(StubFloatingRate var1);

        @Override
        public StubBuilder addFloatingRate(StubFloatingRate var1, int var2);

        @Override
        public StubBuilder addFloatingRate(List<? extends StubFloatingRate> var1);

        @Override
        public StubBuilder setFloatingRate(List<? extends StubFloatingRate> var1);

        @Override
        public StubBuilder setStubRate(BigDecimal var1);

        @Override
        public StubBuilder setStubAmount(Money var1);

        public StubBuilder setStubStartDate(AdjustableOrRelativeDate var1);

        public StubBuilder setStubEndDate(AdjustableOrRelativeDate var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("floatingRate"), processor, StubFloatingRate.StubFloatingRateBuilder.class, this.getFloatingRate(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("stubRate"), BigDecimal.class, (Object)this.getStubRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("stubAmount"), processor, Money.MoneyBuilder.class, (RosettaModelObjectBuilder)this.getStubAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("stubStartDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, this.getStubStartDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("stubEndDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, this.getStubEndDate(), new AttributeMeta[0]);
        }

        @Override
        public StubBuilder prune();
    }

    public static class StubImpl
    extends StubValue.StubValueImpl
    implements Stub {
        private final AdjustableOrRelativeDate stubStartDate;
        private final AdjustableOrRelativeDate stubEndDate;

        protected StubImpl(StubBuilder builder) {
            super(builder);
            this.stubStartDate = Optional.ofNullable(builder.getStubStartDate()).map(f -> f.build()).orElse(null);
            this.stubEndDate = Optional.ofNullable(builder.getStubEndDate()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="stubStartDate")
        @RuneAttribute(value="stubStartDate")
        public AdjustableOrRelativeDate getStubStartDate() {
            return this.stubStartDate;
        }

        @Override
        @RosettaAttribute(value="stubEndDate")
        @RuneAttribute(value="stubEndDate")
        public AdjustableOrRelativeDate getStubEndDate() {
            return this.stubEndDate;
        }

        @Override
        public Stub build() {
            return this;
        }

        @Override
        public StubBuilder toBuilder() {
            StubBuilder builder = Stub.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(StubBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getStubStartDate()).ifPresent(builder::setStubStartDate);
            Optional.ofNullable(this.getStubEndDate()).ifPresent(builder::setStubEndDate);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Stub _that = (Stub)this.getType().cast(o);
            if (!Objects.equals(this.stubStartDate, _that.getStubStartDate())) {
                return false;
            }
            return Objects.equals(this.stubEndDate, _that.getStubEndDate());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.stubStartDate != null ? this.stubStartDate.hashCode() : 0);
            _result = 31 * _result + (this.stubEndDate != null ? this.stubEndDate.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "Stub {stubStartDate=" + this.stubStartDate + ", stubEndDate=" + this.stubEndDate + '}' + " " + super.toString();
        }
    }
}

