/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.confirmation.Sensitivity;
import fpml.confirmation.SensitivitySetDefinitionReference;
import fpml.confirmation.meta.SensitivitySetMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="SensitivitySet", builder=SensitivitySetBuilderImpl.class, version="0.17.2")
@RuneDataType(value="SensitivitySet", model="fpml", builder=SensitivitySetBuilderImpl.class, version="0.17.2")
public interface SensitivitySet
extends RosettaModelObject {
    public static final SensitivitySetMeta metaData = new SensitivitySetMeta();

    public String getName();

    public SensitivitySetDefinitionReference getDefinitionReference();

    public List<? extends Sensitivity> getSensitivity();

    public String getId();

    public SensitivitySet build();

    public SensitivitySetBuilder toBuilder();

    public static SensitivitySetBuilder builder() {
        return new SensitivitySetBuilderImpl();
    }

    default public RosettaMetaData<? extends SensitivitySet> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends SensitivitySet> getType() {
        return SensitivitySet.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("name"), String.class, (Object)this.getName(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("definitionReference"), processor, SensitivitySetDefinitionReference.class, this.getDefinitionReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("sensitivity"), processor, Sensitivity.class, this.getSensitivity(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class SensitivitySetBuilderImpl
    implements SensitivitySetBuilder {
        protected String name;
        protected SensitivitySetDefinitionReference.SensitivitySetDefinitionReferenceBuilder definitionReference;
        protected List<Sensitivity.SensitivityBuilder> sensitivity = new ArrayList<Sensitivity.SensitivityBuilder>();
        protected String id;

        @Override
        @RosettaAttribute(value="name")
        @RuneAttribute(value="name")
        public String getName() {
            return this.name;
        }

        @Override
        @RosettaAttribute(value="definitionReference")
        @RuneAttribute(value="definitionReference")
        public SensitivitySetDefinitionReference.SensitivitySetDefinitionReferenceBuilder getDefinitionReference() {
            return this.definitionReference;
        }

        @Override
        public SensitivitySetDefinitionReference.SensitivitySetDefinitionReferenceBuilder getOrCreateDefinitionReference() {
            SensitivitySetDefinitionReference.SensitivitySetDefinitionReferenceBuilder result = this.definitionReference != null ? this.definitionReference : (this.definitionReference = SensitivitySetDefinitionReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="sensitivity")
        @RuneAttribute(value="sensitivity")
        public List<? extends Sensitivity.SensitivityBuilder> getSensitivity() {
            return this.sensitivity;
        }

        @Override
        public Sensitivity.SensitivityBuilder getOrCreateSensitivity(int index) {
            if (this.sensitivity == null) {
                this.sensitivity = new ArrayList<Sensitivity.SensitivityBuilder>();
            }
            return (Sensitivity.SensitivityBuilder)this.getIndex(this.sensitivity, index, () -> {
                Sensitivity.SensitivityBuilder newSensitivity = Sensitivity.builder();
                return newSensitivity;
            });
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        @RosettaAttribute(value="name")
        @RuneAttribute(value="name")
        public SensitivitySetBuilder setName(String _name) {
            this.name = _name == null ? null : _name;
            return this;
        }

        @Override
        @RosettaAttribute(value="definitionReference")
        @RuneAttribute(value="definitionReference")
        public SensitivitySetBuilder setDefinitionReference(SensitivitySetDefinitionReference _definitionReference) {
            this.definitionReference = _definitionReference == null ? null : _definitionReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="sensitivity")
        @RuneAttribute(value="sensitivity")
        public SensitivitySetBuilder addSensitivity(Sensitivity _sensitivity) {
            if (_sensitivity != null) {
                this.sensitivity.add(_sensitivity.toBuilder());
            }
            return this;
        }

        @Override
        public SensitivitySetBuilder addSensitivity(Sensitivity _sensitivity, int idx) {
            this.getIndex(this.sensitivity, idx, () -> _sensitivity.toBuilder());
            return this;
        }

        @Override
        public SensitivitySetBuilder addSensitivity(List<? extends Sensitivity> sensitivitys) {
            if (sensitivitys != null) {
                for (Sensitivity sensitivity : sensitivitys) {
                    this.sensitivity.add(sensitivity.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="sensitivity")
        public SensitivitySetBuilder setSensitivity(List<? extends Sensitivity> sensitivitys) {
            this.sensitivity = sensitivitys == null ? new ArrayList<Sensitivity.SensitivityBuilder>() : (List)sensitivitys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public SensitivitySetBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        public SensitivitySet build() {
            return new SensitivitySetImpl(this);
        }

        @Override
        public SensitivitySetBuilder toBuilder() {
            return this;
        }

        @Override
        public SensitivitySetBuilder prune() {
            if (this.definitionReference != null && !this.definitionReference.prune().hasData()) {
                this.definitionReference = null;
            }
            this.sensitivity = this.sensitivity.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getName() != null) {
                return true;
            }
            if (this.getDefinitionReference() != null && this.getDefinitionReference().hasData()) {
                return true;
            }
            if (this.getSensitivity() != null && this.getSensitivity().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getId() != null;
        }

        public SensitivitySetBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            SensitivitySetBuilder o = (SensitivitySetBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDefinitionReference(), (RosettaModelObjectBuilder)o.getDefinitionReference(), this::setDefinitionReference);
            merger.mergeRosetta(this.getSensitivity(), o.getSensitivity(), this::getOrCreateSensitivity);
            merger.mergeBasic((Object)this.getName(), (Object)o.getName(), this::setName, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getId(), (Object)o.getId(), this::setId, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            SensitivitySet _that = this.getType().cast(o);
            if (!Objects.equals(this.name, _that.getName())) {
                return false;
            }
            if (!Objects.equals(this.definitionReference, _that.getDefinitionReference())) {
                return false;
            }
            if (!ListEquals.listEquals(this.sensitivity, _that.getSensitivity())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.name != null ? this.name.hashCode() : 0);
            _result = 31 * _result + (this.definitionReference != null ? this.definitionReference.hashCode() : 0);
            _result = 31 * _result + (this.sensitivity != null ? this.sensitivity.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "SensitivitySetBuilder {name=" + this.name + ", definitionReference=" + this.definitionReference + ", sensitivity=" + this.sensitivity + ", id=" + this.id + '}';
        }
    }

    public static interface SensitivitySetBuilder
    extends SensitivitySet,
    RosettaModelObjectBuilder {
        public SensitivitySetDefinitionReference.SensitivitySetDefinitionReferenceBuilder getOrCreateDefinitionReference();

        @Override
        public SensitivitySetDefinitionReference.SensitivitySetDefinitionReferenceBuilder getDefinitionReference();

        public Sensitivity.SensitivityBuilder getOrCreateSensitivity(int var1);

        public List<? extends Sensitivity.SensitivityBuilder> getSensitivity();

        public SensitivitySetBuilder setName(String var1);

        public SensitivitySetBuilder setDefinitionReference(SensitivitySetDefinitionReference var1);

        public SensitivitySetBuilder addSensitivity(Sensitivity var1);

        public SensitivitySetBuilder addSensitivity(Sensitivity var1, int var2);

        public SensitivitySetBuilder addSensitivity(List<? extends Sensitivity> var1);

        public SensitivitySetBuilder setSensitivity(List<? extends Sensitivity> var1);

        public SensitivitySetBuilder setId(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("name"), String.class, (Object)this.getName(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("definitionReference"), processor, SensitivitySetDefinitionReference.SensitivitySetDefinitionReferenceBuilder.class, this.getDefinitionReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("sensitivity"), processor, Sensitivity.SensitivityBuilder.class, this.getSensitivity(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public SensitivitySetBuilder prune();
    }

    public static class SensitivitySetImpl
    implements SensitivitySet {
        private final String name;
        private final SensitivitySetDefinitionReference definitionReference;
        private final List<? extends Sensitivity> sensitivity;
        private final String id;

        protected SensitivitySetImpl(SensitivitySetBuilder builder) {
            this.name = builder.getName();
            this.definitionReference = Optional.ofNullable(builder.getDefinitionReference()).map(f -> f.build()).orElse(null);
            this.sensitivity = Optional.ofNullable(builder.getSensitivity()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.id = builder.getId();
        }

        @Override
        @RosettaAttribute(value="name")
        @RuneAttribute(value="name")
        public String getName() {
            return this.name;
        }

        @Override
        @RosettaAttribute(value="definitionReference")
        @RuneAttribute(value="definitionReference")
        public SensitivitySetDefinitionReference getDefinitionReference() {
            return this.definitionReference;
        }

        @Override
        @RosettaAttribute(value="sensitivity")
        @RuneAttribute(value="sensitivity")
        public List<? extends Sensitivity> getSensitivity() {
            return this.sensitivity;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        public SensitivitySet build() {
            return this;
        }

        @Override
        public SensitivitySetBuilder toBuilder() {
            SensitivitySetBuilder builder = SensitivitySet.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(SensitivitySetBuilder builder) {
            Optional.ofNullable(this.getName()).ifPresent(builder::setName);
            Optional.ofNullable(this.getDefinitionReference()).ifPresent(builder::setDefinitionReference);
            Optional.ofNullable(this.getSensitivity()).ifPresent(builder::setSensitivity);
            Optional.ofNullable(this.getId()).ifPresent(builder::setId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            SensitivitySet _that = this.getType().cast(o);
            if (!Objects.equals(this.name, _that.getName())) {
                return false;
            }
            if (!Objects.equals(this.definitionReference, _that.getDefinitionReference())) {
                return false;
            }
            if (!ListEquals.listEquals(this.sensitivity, _that.getSensitivity())) {
                return false;
            }
            return Objects.equals(this.id, _that.getId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.name != null ? this.name.hashCode() : 0);
            _result = 31 * _result + (this.definitionReference != null ? this.definitionReference.hashCode() : 0);
            _result = 31 * _result + (this.sensitivity != null ? this.sensitivity.hashCode() : 0);
            _result = 31 * _result + (this.id != null ? this.id.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "SensitivitySet {name=" + this.name + ", definitionReference=" + this.definitionReference + ", sensitivity=" + this.sensitivity + ", id=" + this.id + '}';
        }
    }
}

