/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.DeliveryMethod;
import fpml.confirmation.IdentifiedDate;
import fpml.confirmation.meta.SecLendTransferEventMeta;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="SecLendTransferEvent", builder=SecLendTransferEventBuilderImpl.class, version="0.17.2")
@RuneDataType(value="SecLendTransferEvent", model="fpml", builder=SecLendTransferEventBuilderImpl.class, version="0.17.2")
public interface SecLendTransferEvent
extends RosettaModelObject {
    public static final SecLendTransferEventMeta metaData = new SecLendTransferEventMeta();

    public IdentifiedDate getSettlementDate();

    public DeliveryMethod getDeliveryMethod();

    public SecLendTransferEvent build();

    public SecLendTransferEventBuilder toBuilder();

    public static SecLendTransferEventBuilder builder() {
        return new SecLendTransferEventBuilderImpl();
    }

    default public RosettaMetaData<? extends SecLendTransferEvent> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends SecLendTransferEvent> getType() {
        return SecLendTransferEvent.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("settlementDate"), processor, IdentifiedDate.class, this.getSettlementDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("deliveryMethod"), processor, DeliveryMethod.class, this.getDeliveryMethod(), new AttributeMeta[0]);
    }

    public static class SecLendTransferEventBuilderImpl
    implements SecLendTransferEventBuilder {
        protected IdentifiedDate.IdentifiedDateBuilder settlementDate;
        protected DeliveryMethod.DeliveryMethodBuilder deliveryMethod;

        @Override
        @RosettaAttribute(value="settlementDate", isRequired=true)
        @RuneAttribute(value="settlementDate", isRequired=true)
        public IdentifiedDate.IdentifiedDateBuilder getSettlementDate() {
            return this.settlementDate;
        }

        @Override
        public IdentifiedDate.IdentifiedDateBuilder getOrCreateSettlementDate() {
            IdentifiedDate.IdentifiedDateBuilder result = this.settlementDate != null ? this.settlementDate : (this.settlementDate = IdentifiedDate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="deliveryMethod")
        @RuneAttribute(value="deliveryMethod")
        public DeliveryMethod.DeliveryMethodBuilder getDeliveryMethod() {
            return this.deliveryMethod;
        }

        @Override
        public DeliveryMethod.DeliveryMethodBuilder getOrCreateDeliveryMethod() {
            DeliveryMethod.DeliveryMethodBuilder result = this.deliveryMethod != null ? this.deliveryMethod : (this.deliveryMethod = DeliveryMethod.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="settlementDate", isRequired=true)
        @RuneAttribute(value="settlementDate", isRequired=true)
        public SecLendTransferEventBuilder setSettlementDate(IdentifiedDate _settlementDate) {
            this.settlementDate = _settlementDate == null ? null : _settlementDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="deliveryMethod")
        @RuneAttribute(value="deliveryMethod")
        public SecLendTransferEventBuilder setDeliveryMethod(DeliveryMethod _deliveryMethod) {
            this.deliveryMethod = _deliveryMethod == null ? null : _deliveryMethod.toBuilder();
            return this;
        }

        @Override
        public SecLendTransferEvent build() {
            return new SecLendTransferEventImpl(this);
        }

        @Override
        public SecLendTransferEventBuilder toBuilder() {
            return this;
        }

        @Override
        public SecLendTransferEventBuilder prune() {
            if (this.settlementDate != null && !this.settlementDate.prune().hasData()) {
                this.settlementDate = null;
            }
            if (this.deliveryMethod != null && !this.deliveryMethod.prune().hasData()) {
                this.deliveryMethod = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getSettlementDate() != null && this.getSettlementDate().hasData()) {
                return true;
            }
            return this.getDeliveryMethod() != null && this.getDeliveryMethod().hasData();
        }

        public SecLendTransferEventBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            SecLendTransferEventBuilder o = (SecLendTransferEventBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSettlementDate(), (RosettaModelObjectBuilder)o.getSettlementDate(), this::setSettlementDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDeliveryMethod(), (RosettaModelObjectBuilder)o.getDeliveryMethod(), this::setDeliveryMethod);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            SecLendTransferEvent _that = this.getType().cast(o);
            if (!Objects.equals(this.settlementDate, _that.getSettlementDate())) {
                return false;
            }
            return Objects.equals(this.deliveryMethod, _that.getDeliveryMethod());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.settlementDate != null ? this.settlementDate.hashCode() : 0);
            _result = 31 * _result + (this.deliveryMethod != null ? this.deliveryMethod.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "SecLendTransferEventBuilder {settlementDate=" + this.settlementDate + ", deliveryMethod=" + this.deliveryMethod + '}';
        }
    }

    public static interface SecLendTransferEventBuilder
    extends SecLendTransferEvent,
    RosettaModelObjectBuilder {
        public IdentifiedDate.IdentifiedDateBuilder getOrCreateSettlementDate();

        @Override
        public IdentifiedDate.IdentifiedDateBuilder getSettlementDate();

        public DeliveryMethod.DeliveryMethodBuilder getOrCreateDeliveryMethod();

        @Override
        public DeliveryMethod.DeliveryMethodBuilder getDeliveryMethod();

        public SecLendTransferEventBuilder setSettlementDate(IdentifiedDate var1);

        public SecLendTransferEventBuilder setDeliveryMethod(DeliveryMethod var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("settlementDate"), processor, IdentifiedDate.IdentifiedDateBuilder.class, this.getSettlementDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("deliveryMethod"), processor, DeliveryMethod.DeliveryMethodBuilder.class, this.getDeliveryMethod(), new AttributeMeta[0]);
        }

        public SecLendTransferEventBuilder prune();
    }

    public static class SecLendTransferEventImpl
    implements SecLendTransferEvent {
        private final IdentifiedDate settlementDate;
        private final DeliveryMethod deliveryMethod;

        protected SecLendTransferEventImpl(SecLendTransferEventBuilder builder) {
            this.settlementDate = Optional.ofNullable(builder.getSettlementDate()).map(f -> f.build()).orElse(null);
            this.deliveryMethod = Optional.ofNullable(builder.getDeliveryMethod()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="settlementDate", isRequired=true)
        @RuneAttribute(value="settlementDate", isRequired=true)
        public IdentifiedDate getSettlementDate() {
            return this.settlementDate;
        }

        @Override
        @RosettaAttribute(value="deliveryMethod")
        @RuneAttribute(value="deliveryMethod")
        public DeliveryMethod getDeliveryMethod() {
            return this.deliveryMethod;
        }

        @Override
        public SecLendTransferEvent build() {
            return this;
        }

        @Override
        public SecLendTransferEventBuilder toBuilder() {
            SecLendTransferEventBuilder builder = SecLendTransferEvent.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(SecLendTransferEventBuilder builder) {
            Optional.ofNullable(this.getSettlementDate()).ifPresent(builder::setSettlementDate);
            Optional.ofNullable(this.getDeliveryMethod()).ifPresent(builder::setDeliveryMethod);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            SecLendTransferEvent _that = this.getType().cast(o);
            if (!Objects.equals(this.settlementDate, _that.getSettlementDate())) {
                return false;
            }
            return Objects.equals(this.deliveryMethod, _that.getDeliveryMethod());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.settlementDate != null ? this.settlementDate.hashCode() : 0);
            _result = 31 * _result + (this.deliveryMethod != null ? this.deliveryMethod.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "SecLendTransferEvent {settlementDate=" + this.settlementDate + ", deliveryMethod=" + this.deliveryMethod + '}';
        }
    }
}

