/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.ClearanceSystem;
import fpml.confirmation.DayCountFraction;
import fpml.confirmation.ExchangeId;
import fpml.confirmation.FloatingRateIndex;
import fpml.confirmation.IdentifiedCurrency;
import fpml.confirmation.InstrumentId;
import fpml.confirmation.InstrumentType;
import fpml.confirmation.Period;
import fpml.confirmation.ProductReference;
import fpml.confirmation.UnderlyingAsset;
import fpml.confirmation.meta.RateIndexMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="RateIndex", builder=RateIndexBuilderImpl.class, version="0.17.2")
@RuneDataType(value="RateIndex", model="fpml", builder=RateIndexBuilderImpl.class, version="0.17.2")
public interface RateIndex
extends UnderlyingAsset {
    public static final RateIndexMeta metaData = new RateIndexMeta();

    public FloatingRateIndex getFloatingRateIndex();

    public Period getTerm();

    public Period getPaymentFrequency();

    public DayCountFraction getDayCountFraction();

    @Override
    public RateIndex build();

    @Override
    public RateIndexBuilder toBuilder();

    public static RateIndexBuilder builder() {
        return new RateIndexBuilderImpl();
    }

    default public RosettaMetaData<? extends RateIndex> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends RateIndex> getType() {
        return RateIndex.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.class, this.getInstrumentId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("instrumentType"), processor, InstrumentType.class, this.getInstrumentType(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("currency"), processor, IdentifiedCurrency.class, this.getCurrency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exchangeId"), processor, ExchangeId.class, this.getExchangeId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("clearanceSystem"), processor, ClearanceSystem.class, this.getClearanceSystem(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("definition"), processor, ProductReference.class, this.getDefinition(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("floatingRateIndex"), processor, FloatingRateIndex.class, this.getFloatingRateIndex(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("term"), processor, Period.class, this.getTerm(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentFrequency"), processor, Period.class, this.getPaymentFrequency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dayCountFraction"), processor, DayCountFraction.class, this.getDayCountFraction(), new AttributeMeta[0]);
    }

    public static class RateIndexBuilderImpl
    extends UnderlyingAsset.UnderlyingAssetBuilderImpl
    implements RateIndexBuilder {
        protected FloatingRateIndex.FloatingRateIndexBuilder floatingRateIndex;
        protected Period.PeriodBuilder term;
        protected Period.PeriodBuilder paymentFrequency;
        protected DayCountFraction.DayCountFractionBuilder dayCountFraction;

        @Override
        @RosettaAttribute(value="floatingRateIndex", isRequired=true)
        @RuneAttribute(value="floatingRateIndex", isRequired=true)
        public FloatingRateIndex.FloatingRateIndexBuilder getFloatingRateIndex() {
            return this.floatingRateIndex;
        }

        @Override
        public FloatingRateIndex.FloatingRateIndexBuilder getOrCreateFloatingRateIndex() {
            FloatingRateIndex.FloatingRateIndexBuilder result = this.floatingRateIndex != null ? this.floatingRateIndex : (this.floatingRateIndex = FloatingRateIndex.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="term", isRequired=true)
        @RuneAttribute(value="term", isRequired=true)
        public Period.PeriodBuilder getTerm() {
            return this.term;
        }

        @Override
        public Period.PeriodBuilder getOrCreateTerm() {
            Period.PeriodBuilder result = this.term != null ? this.term : (this.term = Period.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="paymentFrequency")
        @RuneAttribute(value="paymentFrequency")
        public Period.PeriodBuilder getPaymentFrequency() {
            return this.paymentFrequency;
        }

        @Override
        public Period.PeriodBuilder getOrCreatePaymentFrequency() {
            Period.PeriodBuilder result = this.paymentFrequency != null ? this.paymentFrequency : (this.paymentFrequency = Period.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="dayCountFraction")
        @RuneAttribute(value="dayCountFraction")
        public DayCountFraction.DayCountFractionBuilder getDayCountFraction() {
            return this.dayCountFraction;
        }

        @Override
        public DayCountFraction.DayCountFractionBuilder getOrCreateDayCountFraction() {
            DayCountFraction.DayCountFractionBuilder result = this.dayCountFraction != null ? this.dayCountFraction : (this.dayCountFraction = DayCountFraction.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public RateIndexBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="instrumentId", isRequired=true)
        @RuneAttribute(value="instrumentId", isRequired=true)
        public RateIndexBuilder addInstrumentId(InstrumentId _instrumentId) {
            if (_instrumentId != null) {
                this.instrumentId.add(_instrumentId.toBuilder());
            }
            return this;
        }

        @Override
        public RateIndexBuilder addInstrumentId(InstrumentId _instrumentId, int idx) {
            this.getIndex(this.instrumentId, idx, () -> _instrumentId.toBuilder());
            return this;
        }

        @Override
        public RateIndexBuilder addInstrumentId(List<? extends InstrumentId> instrumentIds) {
            if (instrumentIds != null) {
                for (InstrumentId instrumentId : instrumentIds) {
                    this.instrumentId.add(instrumentId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="instrumentId")
        public RateIndexBuilder setInstrumentId(List<? extends InstrumentId> instrumentIds) {
            this.instrumentId = instrumentIds == null ? new ArrayList() : (List)instrumentIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="instrumentType")
        @RuneAttribute(value="instrumentType")
        public RateIndexBuilder addInstrumentType(InstrumentType _instrumentType) {
            if (_instrumentType != null) {
                this.instrumentType.add(_instrumentType.toBuilder());
            }
            return this;
        }

        @Override
        public RateIndexBuilder addInstrumentType(InstrumentType _instrumentType, int idx) {
            this.getIndex(this.instrumentType, idx, () -> _instrumentType.toBuilder());
            return this;
        }

        @Override
        public RateIndexBuilder addInstrumentType(List<? extends InstrumentType> instrumentTypes) {
            if (instrumentTypes != null) {
                for (InstrumentType instrumentType : instrumentTypes) {
                    this.instrumentType.add(instrumentType.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="instrumentType")
        public RateIndexBuilder setInstrumentType(List<? extends InstrumentType> instrumentTypes) {
            this.instrumentType = instrumentTypes == null ? new ArrayList() : (List)instrumentTypes.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="description")
        @RuneAttribute(value="description")
        public RateIndexBuilder setDescription(String _description) {
            this.description = _description == null ? null : _description;
            return this;
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public RateIndexBuilder setCurrency(IdentifiedCurrency _currency) {
            this.currency = _currency == null ? null : _currency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exchangeId")
        @RuneAttribute(value="exchangeId")
        public RateIndexBuilder setExchangeId(ExchangeId _exchangeId) {
            this.exchangeId = _exchangeId == null ? null : _exchangeId.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="clearanceSystem")
        @RuneAttribute(value="clearanceSystem")
        public RateIndexBuilder setClearanceSystem(ClearanceSystem _clearanceSystem) {
            this.clearanceSystem = _clearanceSystem == null ? null : _clearanceSystem.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="definition")
        @RuneAttribute(value="definition")
        public RateIndexBuilder setDefinition(ProductReference _definition) {
            this.definition = _definition == null ? null : _definition.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="floatingRateIndex", isRequired=true)
        @RuneAttribute(value="floatingRateIndex", isRequired=true)
        public RateIndexBuilder setFloatingRateIndex(FloatingRateIndex _floatingRateIndex) {
            this.floatingRateIndex = _floatingRateIndex == null ? null : _floatingRateIndex.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="term", isRequired=true)
        @RuneAttribute(value="term", isRequired=true)
        public RateIndexBuilder setTerm(Period _term) {
            this.term = _term == null ? null : _term.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentFrequency")
        @RuneAttribute(value="paymentFrequency")
        public RateIndexBuilder setPaymentFrequency(Period _paymentFrequency) {
            this.paymentFrequency = _paymentFrequency == null ? null : _paymentFrequency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dayCountFraction")
        @RuneAttribute(value="dayCountFraction")
        public RateIndexBuilder setDayCountFraction(DayCountFraction _dayCountFraction) {
            this.dayCountFraction = _dayCountFraction == null ? null : _dayCountFraction.toBuilder();
            return this;
        }

        @Override
        public RateIndex build() {
            return new RateIndexImpl(this);
        }

        @Override
        public RateIndexBuilder toBuilder() {
            return this;
        }

        @Override
        public RateIndexBuilder prune() {
            super.prune();
            if (this.floatingRateIndex != null && !this.floatingRateIndex.prune().hasData()) {
                this.floatingRateIndex = null;
            }
            if (this.term != null && !this.term.prune().hasData()) {
                this.term = null;
            }
            if (this.paymentFrequency != null && !this.paymentFrequency.prune().hasData()) {
                this.paymentFrequency = null;
            }
            if (this.dayCountFraction != null && !this.dayCountFraction.prune().hasData()) {
                this.dayCountFraction = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getFloatingRateIndex() != null && this.getFloatingRateIndex().hasData()) {
                return true;
            }
            if (this.getTerm() != null && this.getTerm().hasData()) {
                return true;
            }
            if (this.getPaymentFrequency() != null && this.getPaymentFrequency().hasData()) {
                return true;
            }
            return this.getDayCountFraction() != null && this.getDayCountFraction().hasData();
        }

        @Override
        public RateIndexBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            RateIndexBuilder o = (RateIndexBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFloatingRateIndex(), (RosettaModelObjectBuilder)o.getFloatingRateIndex(), this::setFloatingRateIndex);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTerm(), (RosettaModelObjectBuilder)o.getTerm(), this::setTerm);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPaymentFrequency(), (RosettaModelObjectBuilder)o.getPaymentFrequency(), this::setPaymentFrequency);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDayCountFraction(), (RosettaModelObjectBuilder)o.getDayCountFraction(), this::setDayCountFraction);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RateIndex _that = (RateIndex)this.getType().cast(o);
            if (!Objects.equals(this.floatingRateIndex, _that.getFloatingRateIndex())) {
                return false;
            }
            if (!Objects.equals(this.term, _that.getTerm())) {
                return false;
            }
            if (!Objects.equals(this.paymentFrequency, _that.getPaymentFrequency())) {
                return false;
            }
            return Objects.equals(this.dayCountFraction, _that.getDayCountFraction());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.floatingRateIndex != null ? this.floatingRateIndex.hashCode() : 0);
            _result = 31 * _result + (this.term != null ? this.term.hashCode() : 0);
            _result = 31 * _result + (this.paymentFrequency != null ? this.paymentFrequency.hashCode() : 0);
            _result = 31 * _result + (this.dayCountFraction != null ? this.dayCountFraction.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "RateIndexBuilder {floatingRateIndex=" + this.floatingRateIndex + ", term=" + this.term + ", paymentFrequency=" + this.paymentFrequency + ", dayCountFraction=" + this.dayCountFraction + '}' + " " + super.toString();
        }
    }

    public static interface RateIndexBuilder
    extends RateIndex,
    UnderlyingAsset.UnderlyingAssetBuilder {
        public FloatingRateIndex.FloatingRateIndexBuilder getOrCreateFloatingRateIndex();

        @Override
        public FloatingRateIndex.FloatingRateIndexBuilder getFloatingRateIndex();

        public Period.PeriodBuilder getOrCreateTerm();

        @Override
        public Period.PeriodBuilder getTerm();

        public Period.PeriodBuilder getOrCreatePaymentFrequency();

        @Override
        public Period.PeriodBuilder getPaymentFrequency();

        public DayCountFraction.DayCountFractionBuilder getOrCreateDayCountFraction();

        @Override
        public DayCountFraction.DayCountFractionBuilder getDayCountFraction();

        @Override
        public RateIndexBuilder setId(String var1);

        @Override
        public RateIndexBuilder addInstrumentId(InstrumentId var1);

        @Override
        public RateIndexBuilder addInstrumentId(InstrumentId var1, int var2);

        @Override
        public RateIndexBuilder addInstrumentId(List<? extends InstrumentId> var1);

        @Override
        public RateIndexBuilder setInstrumentId(List<? extends InstrumentId> var1);

        @Override
        public RateIndexBuilder addInstrumentType(InstrumentType var1);

        @Override
        public RateIndexBuilder addInstrumentType(InstrumentType var1, int var2);

        @Override
        public RateIndexBuilder addInstrumentType(List<? extends InstrumentType> var1);

        @Override
        public RateIndexBuilder setInstrumentType(List<? extends InstrumentType> var1);

        @Override
        public RateIndexBuilder setDescription(String var1);

        @Override
        public RateIndexBuilder setCurrency(IdentifiedCurrency var1);

        @Override
        public RateIndexBuilder setExchangeId(ExchangeId var1);

        @Override
        public RateIndexBuilder setClearanceSystem(ClearanceSystem var1);

        @Override
        public RateIndexBuilder setDefinition(ProductReference var1);

        public RateIndexBuilder setFloatingRateIndex(FloatingRateIndex var1);

        public RateIndexBuilder setTerm(Period var1);

        public RateIndexBuilder setPaymentFrequency(Period var1);

        public RateIndexBuilder setDayCountFraction(DayCountFraction var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.InstrumentIdBuilder.class, this.getInstrumentId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("instrumentType"), processor, InstrumentType.InstrumentTypeBuilder.class, this.getInstrumentType(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("currency"), processor, IdentifiedCurrency.IdentifiedCurrencyBuilder.class, (RosettaModelObjectBuilder)this.getCurrency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exchangeId"), processor, ExchangeId.ExchangeIdBuilder.class, (RosettaModelObjectBuilder)this.getExchangeId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("clearanceSystem"), processor, ClearanceSystem.ClearanceSystemBuilder.class, (RosettaModelObjectBuilder)this.getClearanceSystem(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("definition"), processor, ProductReference.ProductReferenceBuilder.class, (RosettaModelObjectBuilder)this.getDefinition(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("floatingRateIndex"), processor, FloatingRateIndex.FloatingRateIndexBuilder.class, this.getFloatingRateIndex(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("term"), processor, Period.PeriodBuilder.class, this.getTerm(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentFrequency"), processor, Period.PeriodBuilder.class, this.getPaymentFrequency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dayCountFraction"), processor, DayCountFraction.DayCountFractionBuilder.class, this.getDayCountFraction(), new AttributeMeta[0]);
        }

        @Override
        public RateIndexBuilder prune();
    }

    public static class RateIndexImpl
    extends UnderlyingAsset.UnderlyingAssetImpl
    implements RateIndex {
        private final FloatingRateIndex floatingRateIndex;
        private final Period term;
        private final Period paymentFrequency;
        private final DayCountFraction dayCountFraction;

        protected RateIndexImpl(RateIndexBuilder builder) {
            super(builder);
            this.floatingRateIndex = Optional.ofNullable(builder.getFloatingRateIndex()).map(f -> f.build()).orElse(null);
            this.term = Optional.ofNullable(builder.getTerm()).map(f -> f.build()).orElse(null);
            this.paymentFrequency = Optional.ofNullable(builder.getPaymentFrequency()).map(f -> f.build()).orElse(null);
            this.dayCountFraction = Optional.ofNullable(builder.getDayCountFraction()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="floatingRateIndex", isRequired=true)
        @RuneAttribute(value="floatingRateIndex", isRequired=true)
        public FloatingRateIndex getFloatingRateIndex() {
            return this.floatingRateIndex;
        }

        @Override
        @RosettaAttribute(value="term", isRequired=true)
        @RuneAttribute(value="term", isRequired=true)
        public Period getTerm() {
            return this.term;
        }

        @Override
        @RosettaAttribute(value="paymentFrequency")
        @RuneAttribute(value="paymentFrequency")
        public Period getPaymentFrequency() {
            return this.paymentFrequency;
        }

        @Override
        @RosettaAttribute(value="dayCountFraction")
        @RuneAttribute(value="dayCountFraction")
        public DayCountFraction getDayCountFraction() {
            return this.dayCountFraction;
        }

        @Override
        public RateIndex build() {
            return this;
        }

        @Override
        public RateIndexBuilder toBuilder() {
            RateIndexBuilder builder = RateIndex.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(RateIndexBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getFloatingRateIndex()).ifPresent(builder::setFloatingRateIndex);
            Optional.ofNullable(this.getTerm()).ifPresent(builder::setTerm);
            Optional.ofNullable(this.getPaymentFrequency()).ifPresent(builder::setPaymentFrequency);
            Optional.ofNullable(this.getDayCountFraction()).ifPresent(builder::setDayCountFraction);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RateIndex _that = (RateIndex)this.getType().cast(o);
            if (!Objects.equals(this.floatingRateIndex, _that.getFloatingRateIndex())) {
                return false;
            }
            if (!Objects.equals(this.term, _that.getTerm())) {
                return false;
            }
            if (!Objects.equals(this.paymentFrequency, _that.getPaymentFrequency())) {
                return false;
            }
            return Objects.equals(this.dayCountFraction, _that.getDayCountFraction());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.floatingRateIndex != null ? this.floatingRateIndex.hashCode() : 0);
            _result = 31 * _result + (this.term != null ? this.term.hashCode() : 0);
            _result = 31 * _result + (this.paymentFrequency != null ? this.paymentFrequency.hashCode() : 0);
            _result = 31 * _result + (this.dayCountFraction != null ? this.dayCountFraction.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "RateIndex {floatingRateIndex=" + this.floatingRateIndex + ", term=" + this.term + ", paymentFrequency=" + this.paymentFrequency + ", dayCountFraction=" + this.dayCountFraction + '}' + " " + super.toString();
        }
    }
}

