/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.FloatingRateIndexModel;
import fpml.confirmation.meta.PrepaidRateMeta;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="PrepaidRate", builder=PrepaidRateBuilderImpl.class, version="0.17.2")
@RuneDataType(value="PrepaidRate", model="fpml", builder=PrepaidRateBuilderImpl.class, version="0.17.2")
public interface PrepaidRate
extends RosettaModelObject {
    public static final PrepaidRateMeta metaData = new PrepaidRateMeta();

    public BigDecimal getFixedRate();

    public FloatingRateIndexModel getFloatingRateIndexModel();

    public PrepaidRate build();

    public PrepaidRateBuilder toBuilder();

    public static PrepaidRateBuilder builder() {
        return new PrepaidRateBuilderImpl();
    }

    default public RosettaMetaData<? extends PrepaidRate> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends PrepaidRate> getType() {
        return PrepaidRate.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("fixedRate"), BigDecimal.class, (Object)this.getFixedRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("floatingRateIndexModel"), processor, FloatingRateIndexModel.class, this.getFloatingRateIndexModel(), new AttributeMeta[0]);
    }

    public static class PrepaidRateBuilderImpl
    implements PrepaidRateBuilder {
        protected BigDecimal fixedRate;
        protected FloatingRateIndexModel.FloatingRateIndexModelBuilder floatingRateIndexModel;

        @Override
        @RosettaAttribute(value="fixedRate")
        @RuneAttribute(value="fixedRate")
        public BigDecimal getFixedRate() {
            return this.fixedRate;
        }

        @Override
        @RosettaAttribute(value="floatingRateIndexModel")
        @RuneAttribute(value="floatingRateIndexModel")
        public FloatingRateIndexModel.FloatingRateIndexModelBuilder getFloatingRateIndexModel() {
            return this.floatingRateIndexModel;
        }

        @Override
        public FloatingRateIndexModel.FloatingRateIndexModelBuilder getOrCreateFloatingRateIndexModel() {
            FloatingRateIndexModel.FloatingRateIndexModelBuilder result = this.floatingRateIndexModel != null ? this.floatingRateIndexModel : (this.floatingRateIndexModel = FloatingRateIndexModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fixedRate")
        @RuneAttribute(value="fixedRate")
        public PrepaidRateBuilder setFixedRate(BigDecimal _fixedRate) {
            this.fixedRate = _fixedRate == null ? null : _fixedRate;
            return this;
        }

        @Override
        @RosettaAttribute(value="floatingRateIndexModel")
        @RuneAttribute(value="floatingRateIndexModel")
        public PrepaidRateBuilder setFloatingRateIndexModel(FloatingRateIndexModel _floatingRateIndexModel) {
            this.floatingRateIndexModel = _floatingRateIndexModel == null ? null : _floatingRateIndexModel.toBuilder();
            return this;
        }

        @Override
        public PrepaidRate build() {
            return new PrepaidRateImpl(this);
        }

        @Override
        public PrepaidRateBuilder toBuilder() {
            return this;
        }

        @Override
        public PrepaidRateBuilder prune() {
            if (this.floatingRateIndexModel != null && !this.floatingRateIndexModel.prune().hasData()) {
                this.floatingRateIndexModel = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getFixedRate() != null) {
                return true;
            }
            return this.getFloatingRateIndexModel() != null && this.getFloatingRateIndexModel().hasData();
        }

        public PrepaidRateBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            PrepaidRateBuilder o = (PrepaidRateBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFloatingRateIndexModel(), (RosettaModelObjectBuilder)o.getFloatingRateIndexModel(), this::setFloatingRateIndexModel);
            merger.mergeBasic((Object)this.getFixedRate(), (Object)o.getFixedRate(), this::setFixedRate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PrepaidRate _that = this.getType().cast(o);
            if (!Objects.equals(this.fixedRate, _that.getFixedRate())) {
                return false;
            }
            return Objects.equals(this.floatingRateIndexModel, _that.getFloatingRateIndexModel());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.fixedRate != null ? this.fixedRate.hashCode() : 0);
            _result = 31 * _result + (this.floatingRateIndexModel != null ? this.floatingRateIndexModel.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PrepaidRateBuilder {fixedRate=" + this.fixedRate + ", floatingRateIndexModel=" + this.floatingRateIndexModel + '}';
        }
    }

    public static interface PrepaidRateBuilder
    extends PrepaidRate,
    RosettaModelObjectBuilder {
        public FloatingRateIndexModel.FloatingRateIndexModelBuilder getOrCreateFloatingRateIndexModel();

        @Override
        public FloatingRateIndexModel.FloatingRateIndexModelBuilder getFloatingRateIndexModel();

        public PrepaidRateBuilder setFixedRate(BigDecimal var1);

        public PrepaidRateBuilder setFloatingRateIndexModel(FloatingRateIndexModel var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("fixedRate"), BigDecimal.class, (Object)this.getFixedRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("floatingRateIndexModel"), processor, FloatingRateIndexModel.FloatingRateIndexModelBuilder.class, this.getFloatingRateIndexModel(), new AttributeMeta[0]);
        }

        public PrepaidRateBuilder prune();
    }

    public static class PrepaidRateImpl
    implements PrepaidRate {
        private final BigDecimal fixedRate;
        private final FloatingRateIndexModel floatingRateIndexModel;

        protected PrepaidRateImpl(PrepaidRateBuilder builder) {
            this.fixedRate = builder.getFixedRate();
            this.floatingRateIndexModel = Optional.ofNullable(builder.getFloatingRateIndexModel()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="fixedRate")
        @RuneAttribute(value="fixedRate")
        public BigDecimal getFixedRate() {
            return this.fixedRate;
        }

        @Override
        @RosettaAttribute(value="floatingRateIndexModel")
        @RuneAttribute(value="floatingRateIndexModel")
        public FloatingRateIndexModel getFloatingRateIndexModel() {
            return this.floatingRateIndexModel;
        }

        @Override
        public PrepaidRate build() {
            return this;
        }

        @Override
        public PrepaidRateBuilder toBuilder() {
            PrepaidRateBuilder builder = PrepaidRate.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PrepaidRateBuilder builder) {
            Optional.ofNullable(this.getFixedRate()).ifPresent(builder::setFixedRate);
            Optional.ofNullable(this.getFloatingRateIndexModel()).ifPresent(builder::setFloatingRateIndexModel);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PrepaidRate _that = this.getType().cast(o);
            if (!Objects.equals(this.fixedRate, _that.getFixedRate())) {
                return false;
            }
            return Objects.equals(this.floatingRateIndexModel, _that.getFloatingRateIndexModel());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.fixedRate != null ? this.fixedRate.hashCode() : 0);
            _result = 31 * _result + (this.floatingRateIndexModel != null ? this.floatingRateIndexModel.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PrepaidRate {fixedRate=" + this.fixedRate + ", floatingRateIndexModel=" + this.floatingRateIndexModel + '}';
        }
    }
}

