/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.Money;
import fpml.confirmation.PremiumTypeEnum;
import fpml.confirmation.meta.PremiumModelMeta;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="PremiumModel", builder=PremiumModelBuilderImpl.class, version="0.17.2")
@RuneDataType(value="PremiumModel", model="fpml", builder=PremiumModelBuilderImpl.class, version="0.17.2")
public interface PremiumModel
extends RosettaModelObject {
    public static final PremiumModelMeta metaData = new PremiumModelMeta();

    public PremiumTypeEnum getPremiumType();

    public Money getPricePerOption();

    public BigDecimal getPercentageOfNotional();

    public PremiumModel build();

    public PremiumModelBuilder toBuilder();

    public static PremiumModelBuilder builder() {
        return new PremiumModelBuilderImpl();
    }

    default public RosettaMetaData<? extends PremiumModel> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends PremiumModel> getType() {
        return PremiumModel.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("premiumType"), PremiumTypeEnum.class, (Object)this.getPremiumType(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("pricePerOption"), processor, Money.class, this.getPricePerOption(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("percentageOfNotional"), BigDecimal.class, (Object)this.getPercentageOfNotional(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class PremiumModelBuilderImpl
    implements PremiumModelBuilder {
        protected PremiumTypeEnum premiumType;
        protected Money.MoneyBuilder pricePerOption;
        protected BigDecimal percentageOfNotional;

        @Override
        @RosettaAttribute(value="premiumType")
        @RuneAttribute(value="premiumType")
        public PremiumTypeEnum getPremiumType() {
            return this.premiumType;
        }

        @Override
        @RosettaAttribute(value="pricePerOption")
        @RuneAttribute(value="pricePerOption")
        public Money.MoneyBuilder getPricePerOption() {
            return this.pricePerOption;
        }

        @Override
        public Money.MoneyBuilder getOrCreatePricePerOption() {
            Money.MoneyBuilder result = this.pricePerOption != null ? this.pricePerOption : (this.pricePerOption = Money.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="percentageOfNotional")
        @RuneAttribute(value="percentageOfNotional")
        public BigDecimal getPercentageOfNotional() {
            return this.percentageOfNotional;
        }

        @Override
        @RosettaAttribute(value="premiumType")
        @RuneAttribute(value="premiumType")
        public PremiumModelBuilder setPremiumType(PremiumTypeEnum _premiumType) {
            this.premiumType = _premiumType == null ? null : _premiumType;
            return this;
        }

        @Override
        @RosettaAttribute(value="pricePerOption")
        @RuneAttribute(value="pricePerOption")
        public PremiumModelBuilder setPricePerOption(Money _pricePerOption) {
            this.pricePerOption = _pricePerOption == null ? null : _pricePerOption.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="percentageOfNotional")
        @RuneAttribute(value="percentageOfNotional")
        public PremiumModelBuilder setPercentageOfNotional(BigDecimal _percentageOfNotional) {
            this.percentageOfNotional = _percentageOfNotional == null ? null : _percentageOfNotional;
            return this;
        }

        @Override
        public PremiumModel build() {
            return new PremiumModelImpl(this);
        }

        @Override
        public PremiumModelBuilder toBuilder() {
            return this;
        }

        @Override
        public PremiumModelBuilder prune() {
            if (this.pricePerOption != null && !this.pricePerOption.prune().hasData()) {
                this.pricePerOption = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getPremiumType() != null) {
                return true;
            }
            if (this.getPricePerOption() != null && this.getPricePerOption().hasData()) {
                return true;
            }
            return this.getPercentageOfNotional() != null;
        }

        public PremiumModelBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            PremiumModelBuilder o = (PremiumModelBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPricePerOption(), (RosettaModelObjectBuilder)o.getPricePerOption(), this::setPricePerOption);
            merger.mergeBasic((Object)this.getPremiumType(), (Object)o.getPremiumType(), this::setPremiumType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPercentageOfNotional(), (Object)o.getPercentageOfNotional(), this::setPercentageOfNotional, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PremiumModel _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.premiumType, (Object)_that.getPremiumType())) {
                return false;
            }
            if (!Objects.equals(this.pricePerOption, _that.getPricePerOption())) {
                return false;
            }
            return Objects.equals(this.percentageOfNotional, _that.getPercentageOfNotional());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.premiumType != null ? ((Object)((Object)this.premiumType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.pricePerOption != null ? this.pricePerOption.hashCode() : 0);
            _result = 31 * _result + (this.percentageOfNotional != null ? this.percentageOfNotional.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PremiumModelBuilder {premiumType=" + (Object)((Object)this.premiumType) + ", pricePerOption=" + this.pricePerOption + ", percentageOfNotional=" + this.percentageOfNotional + '}';
        }
    }

    public static interface PremiumModelBuilder
    extends PremiumModel,
    RosettaModelObjectBuilder {
        public Money.MoneyBuilder getOrCreatePricePerOption();

        @Override
        public Money.MoneyBuilder getPricePerOption();

        public PremiumModelBuilder setPremiumType(PremiumTypeEnum var1);

        public PremiumModelBuilder setPricePerOption(Money var1);

        public PremiumModelBuilder setPercentageOfNotional(BigDecimal var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("premiumType"), PremiumTypeEnum.class, (Object)this.getPremiumType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("pricePerOption"), processor, Money.MoneyBuilder.class, this.getPricePerOption(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("percentageOfNotional"), BigDecimal.class, (Object)this.getPercentageOfNotional(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public PremiumModelBuilder prune();
    }

    public static class PremiumModelImpl
    implements PremiumModel {
        private final PremiumTypeEnum premiumType;
        private final Money pricePerOption;
        private final BigDecimal percentageOfNotional;

        protected PremiumModelImpl(PremiumModelBuilder builder) {
            this.premiumType = builder.getPremiumType();
            this.pricePerOption = Optional.ofNullable(builder.getPricePerOption()).map(f -> f.build()).orElse(null);
            this.percentageOfNotional = builder.getPercentageOfNotional();
        }

        @Override
        @RosettaAttribute(value="premiumType")
        @RuneAttribute(value="premiumType")
        public PremiumTypeEnum getPremiumType() {
            return this.premiumType;
        }

        @Override
        @RosettaAttribute(value="pricePerOption")
        @RuneAttribute(value="pricePerOption")
        public Money getPricePerOption() {
            return this.pricePerOption;
        }

        @Override
        @RosettaAttribute(value="percentageOfNotional")
        @RuneAttribute(value="percentageOfNotional")
        public BigDecimal getPercentageOfNotional() {
            return this.percentageOfNotional;
        }

        @Override
        public PremiumModel build() {
            return this;
        }

        @Override
        public PremiumModelBuilder toBuilder() {
            PremiumModelBuilder builder = PremiumModel.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PremiumModelBuilder builder) {
            Optional.ofNullable(this.getPremiumType()).ifPresent(builder::setPremiumType);
            Optional.ofNullable(this.getPricePerOption()).ifPresent(builder::setPricePerOption);
            Optional.ofNullable(this.getPercentageOfNotional()).ifPresent(builder::setPercentageOfNotional);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PremiumModel _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.premiumType, (Object)_that.getPremiumType())) {
                return false;
            }
            if (!Objects.equals(this.pricePerOption, _that.getPricePerOption())) {
                return false;
            }
            return Objects.equals(this.percentageOfNotional, _that.getPercentageOfNotional());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.premiumType != null ? ((Object)((Object)this.premiumType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.pricePerOption != null ? this.pricePerOption.hashCode() : 0);
            _result = 31 * _result + (this.percentageOfNotional != null ? this.percentageOfNotional.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PremiumModel {premiumType=" + (Object)((Object)this.premiumType) + ", pricePerOption=" + this.pricePerOption + ", percentageOfNotional=" + this.percentageOfNotional + '}';
        }
    }
}

