/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.MoneyWithParticipantShare;
import fpml.confirmation.meta.PaymentProjectionMeta;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="PaymentProjection", builder=PaymentProjectionBuilderImpl.class, version="0.17.2")
@RuneDataType(value="PaymentProjection", model="fpml", builder=PaymentProjectionBuilderImpl.class, version="0.17.2")
public interface PaymentProjection
extends RosettaModelObject {
    public static final PaymentProjectionMeta metaData = new PaymentProjectionMeta();

    public ZonedDateTime getNextPaymentDate();

    public MoneyWithParticipantShare getProjectedAmount();

    public PaymentProjection build();

    public PaymentProjectionBuilder toBuilder();

    public static PaymentProjectionBuilder builder() {
        return new PaymentProjectionBuilderImpl();
    }

    default public RosettaMetaData<? extends PaymentProjection> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends PaymentProjection> getType() {
        return PaymentProjection.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("nextPaymentDate"), ZonedDateTime.class, (Object)this.getNextPaymentDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("projectedAmount"), processor, MoneyWithParticipantShare.class, this.getProjectedAmount(), new AttributeMeta[0]);
    }

    public static class PaymentProjectionBuilderImpl
    implements PaymentProjectionBuilder {
        protected ZonedDateTime nextPaymentDate;
        protected MoneyWithParticipantShare.MoneyWithParticipantShareBuilder projectedAmount;

        @Override
        @RosettaAttribute(value="nextPaymentDate", isRequired=true)
        @RuneAttribute(value="nextPaymentDate", isRequired=true)
        public ZonedDateTime getNextPaymentDate() {
            return this.nextPaymentDate;
        }

        @Override
        @RosettaAttribute(value="projectedAmount")
        @RuneAttribute(value="projectedAmount")
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getProjectedAmount() {
            return this.projectedAmount;
        }

        @Override
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getOrCreateProjectedAmount() {
            MoneyWithParticipantShare.MoneyWithParticipantShareBuilder result = this.projectedAmount != null ? this.projectedAmount : (this.projectedAmount = MoneyWithParticipantShare.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="nextPaymentDate", isRequired=true)
        @RuneAttribute(value="nextPaymentDate", isRequired=true)
        public PaymentProjectionBuilder setNextPaymentDate(ZonedDateTime _nextPaymentDate) {
            this.nextPaymentDate = _nextPaymentDate == null ? null : _nextPaymentDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="projectedAmount")
        @RuneAttribute(value="projectedAmount")
        public PaymentProjectionBuilder setProjectedAmount(MoneyWithParticipantShare _projectedAmount) {
            this.projectedAmount = _projectedAmount == null ? null : _projectedAmount.toBuilder();
            return this;
        }

        @Override
        public PaymentProjection build() {
            return new PaymentProjectionImpl(this);
        }

        @Override
        public PaymentProjectionBuilder toBuilder() {
            return this;
        }

        @Override
        public PaymentProjectionBuilder prune() {
            if (this.projectedAmount != null && !this.projectedAmount.prune().hasData()) {
                this.projectedAmount = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getNextPaymentDate() != null) {
                return true;
            }
            return this.getProjectedAmount() != null && this.getProjectedAmount().hasData();
        }

        public PaymentProjectionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            PaymentProjectionBuilder o = (PaymentProjectionBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getProjectedAmount(), (RosettaModelObjectBuilder)o.getProjectedAmount(), this::setProjectedAmount);
            merger.mergeBasic((Object)this.getNextPaymentDate(), (Object)o.getNextPaymentDate(), this::setNextPaymentDate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PaymentProjection _that = this.getType().cast(o);
            if (!Objects.equals(this.nextPaymentDate, _that.getNextPaymentDate())) {
                return false;
            }
            return Objects.equals(this.projectedAmount, _that.getProjectedAmount());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.nextPaymentDate != null ? this.nextPaymentDate.hashCode() : 0);
            _result = 31 * _result + (this.projectedAmount != null ? this.projectedAmount.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PaymentProjectionBuilder {nextPaymentDate=" + this.nextPaymentDate + ", projectedAmount=" + this.projectedAmount + '}';
        }
    }

    public static interface PaymentProjectionBuilder
    extends PaymentProjection,
    RosettaModelObjectBuilder {
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getOrCreateProjectedAmount();

        @Override
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getProjectedAmount();

        public PaymentProjectionBuilder setNextPaymentDate(ZonedDateTime var1);

        public PaymentProjectionBuilder setProjectedAmount(MoneyWithParticipantShare var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("nextPaymentDate"), ZonedDateTime.class, (Object)this.getNextPaymentDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("projectedAmount"), processor, MoneyWithParticipantShare.MoneyWithParticipantShareBuilder.class, this.getProjectedAmount(), new AttributeMeta[0]);
        }

        public PaymentProjectionBuilder prune();
    }

    public static class PaymentProjectionImpl
    implements PaymentProjection {
        private final ZonedDateTime nextPaymentDate;
        private final MoneyWithParticipantShare projectedAmount;

        protected PaymentProjectionImpl(PaymentProjectionBuilder builder) {
            this.nextPaymentDate = builder.getNextPaymentDate();
            this.projectedAmount = Optional.ofNullable(builder.getProjectedAmount()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="nextPaymentDate", isRequired=true)
        @RuneAttribute(value="nextPaymentDate", isRequired=true)
        public ZonedDateTime getNextPaymentDate() {
            return this.nextPaymentDate;
        }

        @Override
        @RosettaAttribute(value="projectedAmount")
        @RuneAttribute(value="projectedAmount")
        public MoneyWithParticipantShare getProjectedAmount() {
            return this.projectedAmount;
        }

        @Override
        public PaymentProjection build() {
            return this;
        }

        @Override
        public PaymentProjectionBuilder toBuilder() {
            PaymentProjectionBuilder builder = PaymentProjection.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PaymentProjectionBuilder builder) {
            Optional.ofNullable(this.getNextPaymentDate()).ifPresent(builder::setNextPaymentDate);
            Optional.ofNullable(this.getProjectedAmount()).ifPresent(builder::setProjectedAmount);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PaymentProjection _that = this.getType().cast(o);
            if (!Objects.equals(this.nextPaymentDate, _that.getNextPaymentDate())) {
                return false;
            }
            return Objects.equals(this.projectedAmount, _that.getProjectedAmount());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.nextPaymentDate != null ? this.nextPaymentDate.hashCode() : 0);
            _result = 31 * _result + (this.projectedAmount != null ? this.projectedAmount.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PaymentProjection {nextPaymentDate=" + this.nextPaymentDate + ", projectedAmount=" + this.projectedAmount + '}';
        }
    }
}

