/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.confirmation.PartyGroupType;
import fpml.confirmation.PartyReference;
import fpml.confirmation.meta.PartySequenceMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="PartySequence", builder=PartySequenceBuilderImpl.class, version="0.17.2")
@RuneDataType(value="PartySequence", model="fpml", builder=PartySequenceBuilderImpl.class, version="0.17.2")
public interface PartySequence
extends RosettaModelObject {
    public static final PartySequenceMeta metaData = new PartySequenceMeta();

    public PartyGroupType getGroupType();

    public List<? extends PartyReference> getPartyReference();

    public PartySequence build();

    public PartySequenceBuilder toBuilder();

    public static PartySequenceBuilder builder() {
        return new PartySequenceBuilderImpl();
    }

    default public RosettaMetaData<? extends PartySequence> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends PartySequence> getType() {
        return PartySequence.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("groupType"), processor, PartyGroupType.class, this.getGroupType(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partyReference"), processor, PartyReference.class, this.getPartyReference(), new AttributeMeta[0]);
    }

    public static class PartySequenceBuilderImpl
    implements PartySequenceBuilder {
        protected PartyGroupType.PartyGroupTypeBuilder groupType;
        protected List<PartyReference.PartyReferenceBuilder> partyReference = new ArrayList<PartyReference.PartyReferenceBuilder>();

        @Override
        @RosettaAttribute(value="groupType", isRequired=true)
        @RuneAttribute(value="groupType", isRequired=true)
        public PartyGroupType.PartyGroupTypeBuilder getGroupType() {
            return this.groupType;
        }

        @Override
        public PartyGroupType.PartyGroupTypeBuilder getOrCreateGroupType() {
            PartyGroupType.PartyGroupTypeBuilder result = this.groupType != null ? this.groupType : (this.groupType = PartyGroupType.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="partyReference", isRequired=true)
        @RuneAttribute(value="partyReference", isRequired=true)
        public List<? extends PartyReference.PartyReferenceBuilder> getPartyReference() {
            return this.partyReference;
        }

        @Override
        public PartyReference.PartyReferenceBuilder getOrCreatePartyReference(int index) {
            if (this.partyReference == null) {
                this.partyReference = new ArrayList<PartyReference.PartyReferenceBuilder>();
            }
            return (PartyReference.PartyReferenceBuilder)this.getIndex(this.partyReference, index, () -> {
                PartyReference.PartyReferenceBuilder newPartyReference = PartyReference.builder();
                return newPartyReference;
            });
        }

        @Override
        @RosettaAttribute(value="groupType", isRequired=true)
        @RuneAttribute(value="groupType", isRequired=true)
        public PartySequenceBuilder setGroupType(PartyGroupType _groupType) {
            this.groupType = _groupType == null ? null : _groupType.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="partyReference", isRequired=true)
        @RuneAttribute(value="partyReference", isRequired=true)
        public PartySequenceBuilder addPartyReference(PartyReference _partyReference) {
            if (_partyReference != null) {
                this.partyReference.add(_partyReference.toBuilder());
            }
            return this;
        }

        @Override
        public PartySequenceBuilder addPartyReference(PartyReference _partyReference, int idx) {
            this.getIndex(this.partyReference, idx, () -> _partyReference.toBuilder());
            return this;
        }

        @Override
        public PartySequenceBuilder addPartyReference(List<? extends PartyReference> partyReferences) {
            if (partyReferences != null) {
                for (PartyReference partyReference : partyReferences) {
                    this.partyReference.add(partyReference.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="partyReference")
        public PartySequenceBuilder setPartyReference(List<? extends PartyReference> partyReferences) {
            this.partyReference = partyReferences == null ? new ArrayList<PartyReference.PartyReferenceBuilder>() : (List)partyReferences.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public PartySequence build() {
            return new PartySequenceImpl(this);
        }

        @Override
        public PartySequenceBuilder toBuilder() {
            return this;
        }

        @Override
        public PartySequenceBuilder prune() {
            if (this.groupType != null && !this.groupType.prune().hasData()) {
                this.groupType = null;
            }
            this.partyReference = this.partyReference.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getGroupType() != null && this.getGroupType().hasData()) {
                return true;
            }
            return this.getPartyReference() != null && this.getPartyReference().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public PartySequenceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            PartySequenceBuilder o = (PartySequenceBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getGroupType(), (RosettaModelObjectBuilder)o.getGroupType(), this::setGroupType);
            merger.mergeRosetta(this.getPartyReference(), o.getPartyReference(), this::getOrCreatePartyReference);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PartySequence _that = this.getType().cast(o);
            if (!Objects.equals(this.groupType, _that.getGroupType())) {
                return false;
            }
            return ListEquals.listEquals(this.partyReference, _that.getPartyReference());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.groupType != null ? this.groupType.hashCode() : 0);
            _result = 31 * _result + (this.partyReference != null ? this.partyReference.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PartySequenceBuilder {groupType=" + this.groupType + ", partyReference=" + this.partyReference + '}';
        }
    }

    public static interface PartySequenceBuilder
    extends PartySequence,
    RosettaModelObjectBuilder {
        public PartyGroupType.PartyGroupTypeBuilder getOrCreateGroupType();

        @Override
        public PartyGroupType.PartyGroupTypeBuilder getGroupType();

        public PartyReference.PartyReferenceBuilder getOrCreatePartyReference(int var1);

        public List<? extends PartyReference.PartyReferenceBuilder> getPartyReference();

        public PartySequenceBuilder setGroupType(PartyGroupType var1);

        public PartySequenceBuilder addPartyReference(PartyReference var1);

        public PartySequenceBuilder addPartyReference(PartyReference var1, int var2);

        public PartySequenceBuilder addPartyReference(List<? extends PartyReference> var1);

        public PartySequenceBuilder setPartyReference(List<? extends PartyReference> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("groupType"), processor, PartyGroupType.PartyGroupTypeBuilder.class, this.getGroupType(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partyReference"), processor, PartyReference.PartyReferenceBuilder.class, this.getPartyReference(), new AttributeMeta[0]);
        }

        public PartySequenceBuilder prune();
    }

    public static class PartySequenceImpl
    implements PartySequence {
        private final PartyGroupType groupType;
        private final List<? extends PartyReference> partyReference;

        protected PartySequenceImpl(PartySequenceBuilder builder) {
            this.groupType = Optional.ofNullable(builder.getGroupType()).map(f -> f.build()).orElse(null);
            this.partyReference = Optional.ofNullable(builder.getPartyReference()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="groupType", isRequired=true)
        @RuneAttribute(value="groupType", isRequired=true)
        public PartyGroupType getGroupType() {
            return this.groupType;
        }

        @Override
        @RosettaAttribute(value="partyReference", isRequired=true)
        @RuneAttribute(value="partyReference", isRequired=true)
        public List<? extends PartyReference> getPartyReference() {
            return this.partyReference;
        }

        @Override
        public PartySequence build() {
            return this;
        }

        @Override
        public PartySequenceBuilder toBuilder() {
            PartySequenceBuilder builder = PartySequence.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PartySequenceBuilder builder) {
            Optional.ofNullable(this.getGroupType()).ifPresent(builder::setGroupType);
            Optional.ofNullable(this.getPartyReference()).ifPresent(builder::setPartyReference);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PartySequence _that = this.getType().cast(o);
            if (!Objects.equals(this.groupType, _that.getGroupType())) {
                return false;
            }
            return ListEquals.listEquals(this.partyReference, _that.getPartyReference());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.groupType != null ? this.groupType.hashCode() : 0);
            _result = 31 * _result + (this.partyReference != null ? this.partyReference.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PartySequence {groupType=" + this.groupType + ", partyReference=" + this.partyReference + '}';
        }
    }
}

