/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.confirmation.AbstractEvent;
import fpml.confirmation.BusinessEventIdentifier;
import fpml.confirmation.KnockOutRateObservation;
import fpml.confirmation.NoTouchRateObservation;
import fpml.confirmation.PartyTradeIdentifier;
import fpml.confirmation.TouchRateObservation;
import fpml.confirmation.Trade;
import fpml.confirmation.TriggerRateObservation;
import fpml.confirmation.meta.OptionEventMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="OptionEvent", builder=OptionEventBuilderImpl.class, version="0.17.2")
@RuneDataType(value="OptionEvent", model="fpml", builder=OptionEventBuilderImpl.class, version="0.17.2")
public interface OptionEvent
extends AbstractEvent {
    public static final OptionEventMeta metaData = new OptionEventMeta();

    public Trade getOriginalTrade();

    public List<? extends PartyTradeIdentifier> getTradeIdentifier();

    public TriggerRateObservation getKnockIn();

    public KnockOutRateObservation getKnockOut();

    public List<? extends TouchRateObservation> getTouch();

    public NoTouchRateObservation getNoTouch();

    @Override
    public OptionEvent build();

    @Override
    public OptionEventBuilder toBuilder();

    public static OptionEventBuilder builder() {
        return new OptionEventBuilderImpl();
    }

    default public RosettaMetaData<? extends OptionEvent> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends OptionEvent> getType() {
        return OptionEvent.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.class, this.getEventIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("originalTrade"), processor, Trade.class, this.getOriginalTrade(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tradeIdentifier"), processor, PartyTradeIdentifier.class, this.getTradeIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("knockIn"), processor, TriggerRateObservation.class, this.getKnockIn(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("knockOut"), processor, KnockOutRateObservation.class, this.getKnockOut(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("touch"), processor, TouchRateObservation.class, this.getTouch(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("noTouch"), processor, NoTouchRateObservation.class, this.getNoTouch(), new AttributeMeta[0]);
    }

    public static class OptionEventBuilderImpl
    extends AbstractEvent.AbstractEventBuilderImpl
    implements OptionEventBuilder {
        protected Trade.TradeBuilder originalTrade;
        protected List<PartyTradeIdentifier.PartyTradeIdentifierBuilder> tradeIdentifier = new ArrayList<PartyTradeIdentifier.PartyTradeIdentifierBuilder>();
        protected TriggerRateObservation.TriggerRateObservationBuilder knockIn;
        protected KnockOutRateObservation.KnockOutRateObservationBuilder knockOut;
        protected List<TouchRateObservation.TouchRateObservationBuilder> touch = new ArrayList<TouchRateObservation.TouchRateObservationBuilder>();
        protected NoTouchRateObservation.NoTouchRateObservationBuilder noTouch;

        @Override
        @RosettaAttribute(value="originalTrade")
        @RuneAttribute(value="originalTrade")
        public Trade.TradeBuilder getOriginalTrade() {
            return this.originalTrade;
        }

        @Override
        public Trade.TradeBuilder getOrCreateOriginalTrade() {
            Trade.TradeBuilder result = this.originalTrade != null ? this.originalTrade : (this.originalTrade = Trade.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="tradeIdentifier")
        @RuneAttribute(value="tradeIdentifier")
        public List<? extends PartyTradeIdentifier.PartyTradeIdentifierBuilder> getTradeIdentifier() {
            return this.tradeIdentifier;
        }

        @Override
        public PartyTradeIdentifier.PartyTradeIdentifierBuilder getOrCreateTradeIdentifier(int index) {
            if (this.tradeIdentifier == null) {
                this.tradeIdentifier = new ArrayList<PartyTradeIdentifier.PartyTradeIdentifierBuilder>();
            }
            return (PartyTradeIdentifier.PartyTradeIdentifierBuilder)this.getIndex(this.tradeIdentifier, index, () -> {
                PartyTradeIdentifier.PartyTradeIdentifierBuilder newTradeIdentifier = PartyTradeIdentifier.builder();
                return newTradeIdentifier;
            });
        }

        @Override
        @RosettaAttribute(value="knockIn")
        @RuneAttribute(value="knockIn")
        public TriggerRateObservation.TriggerRateObservationBuilder getKnockIn() {
            return this.knockIn;
        }

        @Override
        public TriggerRateObservation.TriggerRateObservationBuilder getOrCreateKnockIn() {
            TriggerRateObservation.TriggerRateObservationBuilder result = this.knockIn != null ? this.knockIn : (this.knockIn = TriggerRateObservation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="knockOut")
        @RuneAttribute(value="knockOut")
        public KnockOutRateObservation.KnockOutRateObservationBuilder getKnockOut() {
            return this.knockOut;
        }

        @Override
        public KnockOutRateObservation.KnockOutRateObservationBuilder getOrCreateKnockOut() {
            KnockOutRateObservation.KnockOutRateObservationBuilder result = this.knockOut != null ? this.knockOut : (this.knockOut = KnockOutRateObservation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="touch")
        @RuneAttribute(value="touch")
        public List<? extends TouchRateObservation.TouchRateObservationBuilder> getTouch() {
            return this.touch;
        }

        @Override
        public TouchRateObservation.TouchRateObservationBuilder getOrCreateTouch(int index) {
            if (this.touch == null) {
                this.touch = new ArrayList<TouchRateObservation.TouchRateObservationBuilder>();
            }
            return (TouchRateObservation.TouchRateObservationBuilder)this.getIndex(this.touch, index, () -> {
                TouchRateObservation.TouchRateObservationBuilder newTouch = TouchRateObservation.builder();
                return newTouch;
            });
        }

        @Override
        @RosettaAttribute(value="noTouch")
        @RuneAttribute(value="noTouch")
        public NoTouchRateObservation.NoTouchRateObservationBuilder getNoTouch() {
            return this.noTouch;
        }

        @Override
        public NoTouchRateObservation.NoTouchRateObservationBuilder getOrCreateNoTouch() {
            NoTouchRateObservation.NoTouchRateObservationBuilder result = this.noTouch != null ? this.noTouch : (this.noTouch = NoTouchRateObservation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="eventIdentifier")
        @RuneAttribute(value="eventIdentifier")
        public OptionEventBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier) {
            if (_eventIdentifier != null) {
                this.eventIdentifier.add(_eventIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public OptionEventBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier, int idx) {
            this.getIndex(this.eventIdentifier, idx, () -> _eventIdentifier.toBuilder());
            return this;
        }

        @Override
        public OptionEventBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            if (eventIdentifiers != null) {
                for (BusinessEventIdentifier businessEventIdentifier : eventIdentifiers) {
                    this.eventIdentifier.add(businessEventIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="eventIdentifier")
        public OptionEventBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            this.eventIdentifier = eventIdentifiers == null ? new ArrayList() : (List)eventIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="originalTrade")
        @RuneAttribute(value="originalTrade")
        public OptionEventBuilder setOriginalTrade(Trade _originalTrade) {
            this.originalTrade = _originalTrade == null ? null : _originalTrade.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeIdentifier")
        @RuneAttribute(value="tradeIdentifier")
        public OptionEventBuilder addTradeIdentifier(PartyTradeIdentifier _tradeIdentifier) {
            if (_tradeIdentifier != null) {
                this.tradeIdentifier.add(_tradeIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public OptionEventBuilder addTradeIdentifier(PartyTradeIdentifier _tradeIdentifier, int idx) {
            this.getIndex(this.tradeIdentifier, idx, () -> _tradeIdentifier.toBuilder());
            return this;
        }

        @Override
        public OptionEventBuilder addTradeIdentifier(List<? extends PartyTradeIdentifier> tradeIdentifiers) {
            if (tradeIdentifiers != null) {
                for (PartyTradeIdentifier partyTradeIdentifier : tradeIdentifiers) {
                    this.tradeIdentifier.add(partyTradeIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="tradeIdentifier")
        public OptionEventBuilder setTradeIdentifier(List<? extends PartyTradeIdentifier> tradeIdentifiers) {
            this.tradeIdentifier = tradeIdentifiers == null ? new ArrayList<PartyTradeIdentifier.PartyTradeIdentifierBuilder>() : (List)tradeIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="knockIn")
        @RuneAttribute(value="knockIn")
        public OptionEventBuilder setKnockIn(TriggerRateObservation _knockIn) {
            this.knockIn = _knockIn == null ? null : _knockIn.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="knockOut")
        @RuneAttribute(value="knockOut")
        public OptionEventBuilder setKnockOut(KnockOutRateObservation _knockOut) {
            this.knockOut = _knockOut == null ? null : _knockOut.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="touch")
        @RuneAttribute(value="touch")
        public OptionEventBuilder addTouch(TouchRateObservation _touch) {
            if (_touch != null) {
                this.touch.add(_touch.toBuilder());
            }
            return this;
        }

        @Override
        public OptionEventBuilder addTouch(TouchRateObservation _touch, int idx) {
            this.getIndex(this.touch, idx, () -> _touch.toBuilder());
            return this;
        }

        @Override
        public OptionEventBuilder addTouch(List<? extends TouchRateObservation> touchs) {
            if (touchs != null) {
                for (TouchRateObservation touchRateObservation : touchs) {
                    this.touch.add(touchRateObservation.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="touch")
        public OptionEventBuilder setTouch(List<? extends TouchRateObservation> touchs) {
            this.touch = touchs == null ? new ArrayList<TouchRateObservation.TouchRateObservationBuilder>() : (List)touchs.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="noTouch")
        @RuneAttribute(value="noTouch")
        public OptionEventBuilder setNoTouch(NoTouchRateObservation _noTouch) {
            this.noTouch = _noTouch == null ? null : _noTouch.toBuilder();
            return this;
        }

        @Override
        public OptionEvent build() {
            return new OptionEventImpl(this);
        }

        @Override
        public OptionEventBuilder toBuilder() {
            return this;
        }

        @Override
        public OptionEventBuilder prune() {
            super.prune();
            if (this.originalTrade != null && !this.originalTrade.prune().hasData()) {
                this.originalTrade = null;
            }
            this.tradeIdentifier = this.tradeIdentifier.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.knockIn != null && !this.knockIn.prune().hasData()) {
                this.knockIn = null;
            }
            if (this.knockOut != null && !this.knockOut.prune().hasData()) {
                this.knockOut = null;
            }
            this.touch = this.touch.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.noTouch != null && !this.noTouch.prune().hasData()) {
                this.noTouch = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getOriginalTrade() != null && this.getOriginalTrade().hasData()) {
                return true;
            }
            if (this.getTradeIdentifier() != null && this.getTradeIdentifier().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getKnockIn() != null && this.getKnockIn().hasData()) {
                return true;
            }
            if (this.getKnockOut() != null && this.getKnockOut().hasData()) {
                return true;
            }
            if (this.getTouch() != null && this.getTouch().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getNoTouch() != null && this.getNoTouch().hasData();
        }

        @Override
        public OptionEventBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            OptionEventBuilder o = (OptionEventBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getOriginalTrade(), (RosettaModelObjectBuilder)o.getOriginalTrade(), this::setOriginalTrade);
            merger.mergeRosetta(this.getTradeIdentifier(), o.getTradeIdentifier(), this::getOrCreateTradeIdentifier);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getKnockIn(), (RosettaModelObjectBuilder)o.getKnockIn(), this::setKnockIn);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getKnockOut(), (RosettaModelObjectBuilder)o.getKnockOut(), this::setKnockOut);
            merger.mergeRosetta(this.getTouch(), o.getTouch(), this::getOrCreateTouch);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getNoTouch(), (RosettaModelObjectBuilder)o.getNoTouch(), this::setNoTouch);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            OptionEvent _that = (OptionEvent)this.getType().cast(o);
            if (!Objects.equals(this.originalTrade, _that.getOriginalTrade())) {
                return false;
            }
            if (!ListEquals.listEquals(this.tradeIdentifier, _that.getTradeIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.knockIn, _that.getKnockIn())) {
                return false;
            }
            if (!Objects.equals(this.knockOut, _that.getKnockOut())) {
                return false;
            }
            if (!ListEquals.listEquals(this.touch, _that.getTouch())) {
                return false;
            }
            return Objects.equals(this.noTouch, _that.getNoTouch());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.originalTrade != null ? this.originalTrade.hashCode() : 0);
            _result = 31 * _result + (this.tradeIdentifier != null ? this.tradeIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.knockIn != null ? this.knockIn.hashCode() : 0);
            _result = 31 * _result + (this.knockOut != null ? this.knockOut.hashCode() : 0);
            _result = 31 * _result + (this.touch != null ? this.touch.hashCode() : 0);
            _result = 31 * _result + (this.noTouch != null ? this.noTouch.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "OptionEventBuilder {originalTrade=" + this.originalTrade + ", tradeIdentifier=" + this.tradeIdentifier + ", knockIn=" + this.knockIn + ", knockOut=" + this.knockOut + ", touch=" + this.touch + ", noTouch=" + this.noTouch + '}' + " " + super.toString();
        }
    }

    public static interface OptionEventBuilder
    extends OptionEvent,
    AbstractEvent.AbstractEventBuilder {
        public Trade.TradeBuilder getOrCreateOriginalTrade();

        @Override
        public Trade.TradeBuilder getOriginalTrade();

        public PartyTradeIdentifier.PartyTradeIdentifierBuilder getOrCreateTradeIdentifier(int var1);

        public List<? extends PartyTradeIdentifier.PartyTradeIdentifierBuilder> getTradeIdentifier();

        public TriggerRateObservation.TriggerRateObservationBuilder getOrCreateKnockIn();

        @Override
        public TriggerRateObservation.TriggerRateObservationBuilder getKnockIn();

        public KnockOutRateObservation.KnockOutRateObservationBuilder getOrCreateKnockOut();

        @Override
        public KnockOutRateObservation.KnockOutRateObservationBuilder getKnockOut();

        public TouchRateObservation.TouchRateObservationBuilder getOrCreateTouch(int var1);

        public List<? extends TouchRateObservation.TouchRateObservationBuilder> getTouch();

        public NoTouchRateObservation.NoTouchRateObservationBuilder getOrCreateNoTouch();

        @Override
        public NoTouchRateObservation.NoTouchRateObservationBuilder getNoTouch();

        @Override
        public OptionEventBuilder addEventIdentifier(BusinessEventIdentifier var1);

        @Override
        public OptionEventBuilder addEventIdentifier(BusinessEventIdentifier var1, int var2);

        @Override
        public OptionEventBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public OptionEventBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        public OptionEventBuilder setOriginalTrade(Trade var1);

        public OptionEventBuilder addTradeIdentifier(PartyTradeIdentifier var1);

        public OptionEventBuilder addTradeIdentifier(PartyTradeIdentifier var1, int var2);

        public OptionEventBuilder addTradeIdentifier(List<? extends PartyTradeIdentifier> var1);

        public OptionEventBuilder setTradeIdentifier(List<? extends PartyTradeIdentifier> var1);

        public OptionEventBuilder setKnockIn(TriggerRateObservation var1);

        public OptionEventBuilder setKnockOut(KnockOutRateObservation var1);

        public OptionEventBuilder addTouch(TouchRateObservation var1);

        public OptionEventBuilder addTouch(TouchRateObservation var1, int var2);

        public OptionEventBuilder addTouch(List<? extends TouchRateObservation> var1);

        public OptionEventBuilder setTouch(List<? extends TouchRateObservation> var1);

        public OptionEventBuilder setNoTouch(NoTouchRateObservation var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.BusinessEventIdentifierBuilder.class, this.getEventIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("originalTrade"), processor, Trade.TradeBuilder.class, this.getOriginalTrade(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tradeIdentifier"), processor, PartyTradeIdentifier.PartyTradeIdentifierBuilder.class, this.getTradeIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("knockIn"), processor, TriggerRateObservation.TriggerRateObservationBuilder.class, this.getKnockIn(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("knockOut"), processor, KnockOutRateObservation.KnockOutRateObservationBuilder.class, this.getKnockOut(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("touch"), processor, TouchRateObservation.TouchRateObservationBuilder.class, this.getTouch(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("noTouch"), processor, NoTouchRateObservation.NoTouchRateObservationBuilder.class, this.getNoTouch(), new AttributeMeta[0]);
        }

        @Override
        public OptionEventBuilder prune();
    }

    public static class OptionEventImpl
    extends AbstractEvent.AbstractEventImpl
    implements OptionEvent {
        private final Trade originalTrade;
        private final List<? extends PartyTradeIdentifier> tradeIdentifier;
        private final TriggerRateObservation knockIn;
        private final KnockOutRateObservation knockOut;
        private final List<? extends TouchRateObservation> touch;
        private final NoTouchRateObservation noTouch;

        protected OptionEventImpl(OptionEventBuilder builder) {
            super(builder);
            this.originalTrade = Optional.ofNullable(builder.getOriginalTrade()).map(f -> f.build()).orElse(null);
            this.tradeIdentifier = Optional.ofNullable(builder.getTradeIdentifier()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.knockIn = Optional.ofNullable(builder.getKnockIn()).map(f -> f.build()).orElse(null);
            this.knockOut = Optional.ofNullable(builder.getKnockOut()).map(f -> f.build()).orElse(null);
            this.touch = Optional.ofNullable(builder.getTouch()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.noTouch = Optional.ofNullable(builder.getNoTouch()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="originalTrade")
        @RuneAttribute(value="originalTrade")
        public Trade getOriginalTrade() {
            return this.originalTrade;
        }

        @Override
        @RosettaAttribute(value="tradeIdentifier")
        @RuneAttribute(value="tradeIdentifier")
        public List<? extends PartyTradeIdentifier> getTradeIdentifier() {
            return this.tradeIdentifier;
        }

        @Override
        @RosettaAttribute(value="knockIn")
        @RuneAttribute(value="knockIn")
        public TriggerRateObservation getKnockIn() {
            return this.knockIn;
        }

        @Override
        @RosettaAttribute(value="knockOut")
        @RuneAttribute(value="knockOut")
        public KnockOutRateObservation getKnockOut() {
            return this.knockOut;
        }

        @Override
        @RosettaAttribute(value="touch")
        @RuneAttribute(value="touch")
        public List<? extends TouchRateObservation> getTouch() {
            return this.touch;
        }

        @Override
        @RosettaAttribute(value="noTouch")
        @RuneAttribute(value="noTouch")
        public NoTouchRateObservation getNoTouch() {
            return this.noTouch;
        }

        @Override
        public OptionEvent build() {
            return this;
        }

        @Override
        public OptionEventBuilder toBuilder() {
            OptionEventBuilder builder = OptionEvent.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(OptionEventBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getOriginalTrade()).ifPresent(builder::setOriginalTrade);
            Optional.ofNullable(this.getTradeIdentifier()).ifPresent(builder::setTradeIdentifier);
            Optional.ofNullable(this.getKnockIn()).ifPresent(builder::setKnockIn);
            Optional.ofNullable(this.getKnockOut()).ifPresent(builder::setKnockOut);
            Optional.ofNullable(this.getTouch()).ifPresent(builder::setTouch);
            Optional.ofNullable(this.getNoTouch()).ifPresent(builder::setNoTouch);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            OptionEvent _that = (OptionEvent)this.getType().cast(o);
            if (!Objects.equals(this.originalTrade, _that.getOriginalTrade())) {
                return false;
            }
            if (!ListEquals.listEquals(this.tradeIdentifier, _that.getTradeIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.knockIn, _that.getKnockIn())) {
                return false;
            }
            if (!Objects.equals(this.knockOut, _that.getKnockOut())) {
                return false;
            }
            if (!ListEquals.listEquals(this.touch, _that.getTouch())) {
                return false;
            }
            return Objects.equals(this.noTouch, _that.getNoTouch());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.originalTrade != null ? this.originalTrade.hashCode() : 0);
            _result = 31 * _result + (this.tradeIdentifier != null ? this.tradeIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.knockIn != null ? this.knockIn.hashCode() : 0);
            _result = 31 * _result + (this.knockOut != null ? this.knockOut.hashCode() : 0);
            _result = 31 * _result + (this.touch != null ? this.touch.hashCode() : 0);
            _result = 31 * _result + (this.noTouch != null ? this.noTouch.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "OptionEvent {originalTrade=" + this.originalTrade + ", tradeIdentifier=" + this.tradeIdentifier + ", knockIn=" + this.knockIn + ", knockOut=" + this.knockOut + ", touch=" + this.touch + ", noTouch=" + this.noTouch + '}' + " " + super.toString();
        }
    }
}

