/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.confirmation.CommodityMetalBrand;
import fpml.confirmation.CommodityMetalGrade;
import fpml.confirmation.CommodityMetalShape;
import fpml.confirmation.Material;
import fpml.confirmation.meta.MetalMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Metal", builder=MetalBuilderImpl.class, version="0.17.2")
@RuneDataType(value="Metal", model="fpml", builder=MetalBuilderImpl.class, version="0.17.2")
public interface Metal
extends RosettaModelObject {
    public static final MetalMeta metaData = new MetalMeta();

    public Material getMaterial();

    public List<? extends CommodityMetalShape> getShape();

    public List<? extends CommodityMetalBrand> getBrand();

    public List<? extends CommodityMetalGrade> getGrade();

    public Metal build();

    public MetalBuilder toBuilder();

    public static MetalBuilder builder() {
        return new MetalBuilderImpl();
    }

    default public RosettaMetaData<? extends Metal> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Metal> getType() {
        return Metal.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("material"), processor, Material.class, this.getMaterial(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("shape"), processor, CommodityMetalShape.class, this.getShape(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("brand"), processor, CommodityMetalBrand.class, this.getBrand(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("grade"), processor, CommodityMetalGrade.class, this.getGrade(), new AttributeMeta[0]);
    }

    public static class MetalBuilderImpl
    implements MetalBuilder {
        protected Material.MaterialBuilder material;
        protected List<CommodityMetalShape.CommodityMetalShapeBuilder> shape = new ArrayList<CommodityMetalShape.CommodityMetalShapeBuilder>();
        protected List<CommodityMetalBrand.CommodityMetalBrandBuilder> brand = new ArrayList<CommodityMetalBrand.CommodityMetalBrandBuilder>();
        protected List<CommodityMetalGrade.CommodityMetalGradeBuilder> grade = new ArrayList<CommodityMetalGrade.CommodityMetalGradeBuilder>();

        @Override
        @RosettaAttribute(value="material", isRequired=true)
        @RuneAttribute(value="material", isRequired=true)
        public Material.MaterialBuilder getMaterial() {
            return this.material;
        }

        @Override
        public Material.MaterialBuilder getOrCreateMaterial() {
            Material.MaterialBuilder result = this.material != null ? this.material : (this.material = Material.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="shape", isRequired=true)
        @RuneAttribute(value="shape", isRequired=true)
        public List<? extends CommodityMetalShape.CommodityMetalShapeBuilder> getShape() {
            return this.shape;
        }

        @Override
        public CommodityMetalShape.CommodityMetalShapeBuilder getOrCreateShape(int index) {
            if (this.shape == null) {
                this.shape = new ArrayList<CommodityMetalShape.CommodityMetalShapeBuilder>();
            }
            return (CommodityMetalShape.CommodityMetalShapeBuilder)this.getIndex(this.shape, index, () -> {
                CommodityMetalShape.CommodityMetalShapeBuilder newShape = CommodityMetalShape.builder();
                return newShape;
            });
        }

        @Override
        @RosettaAttribute(value="brand")
        @RuneAttribute(value="brand")
        public List<? extends CommodityMetalBrand.CommodityMetalBrandBuilder> getBrand() {
            return this.brand;
        }

        @Override
        public CommodityMetalBrand.CommodityMetalBrandBuilder getOrCreateBrand(int index) {
            if (this.brand == null) {
                this.brand = new ArrayList<CommodityMetalBrand.CommodityMetalBrandBuilder>();
            }
            return (CommodityMetalBrand.CommodityMetalBrandBuilder)this.getIndex(this.brand, index, () -> {
                CommodityMetalBrand.CommodityMetalBrandBuilder newBrand = CommodityMetalBrand.builder();
                return newBrand;
            });
        }

        @Override
        @RosettaAttribute(value="grade", isRequired=true)
        @RuneAttribute(value="grade", isRequired=true)
        public List<? extends CommodityMetalGrade.CommodityMetalGradeBuilder> getGrade() {
            return this.grade;
        }

        @Override
        public CommodityMetalGrade.CommodityMetalGradeBuilder getOrCreateGrade(int index) {
            if (this.grade == null) {
                this.grade = new ArrayList<CommodityMetalGrade.CommodityMetalGradeBuilder>();
            }
            return (CommodityMetalGrade.CommodityMetalGradeBuilder)this.getIndex(this.grade, index, () -> {
                CommodityMetalGrade.CommodityMetalGradeBuilder newGrade = CommodityMetalGrade.builder();
                return newGrade;
            });
        }

        @Override
        @RosettaAttribute(value="material", isRequired=true)
        @RuneAttribute(value="material", isRequired=true)
        public MetalBuilder setMaterial(Material _material) {
            this.material = _material == null ? null : _material.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="shape", isRequired=true)
        @RuneAttribute(value="shape", isRequired=true)
        public MetalBuilder addShape(CommodityMetalShape _shape) {
            if (_shape != null) {
                this.shape.add(_shape.toBuilder());
            }
            return this;
        }

        @Override
        public MetalBuilder addShape(CommodityMetalShape _shape, int idx) {
            this.getIndex(this.shape, idx, () -> _shape.toBuilder());
            return this;
        }

        @Override
        public MetalBuilder addShape(List<? extends CommodityMetalShape> shapes) {
            if (shapes != null) {
                for (CommodityMetalShape commodityMetalShape : shapes) {
                    this.shape.add(commodityMetalShape.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="shape")
        public MetalBuilder setShape(List<? extends CommodityMetalShape> shapes) {
            this.shape = shapes == null ? new ArrayList<CommodityMetalShape.CommodityMetalShapeBuilder>() : (List)shapes.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="brand")
        @RuneAttribute(value="brand")
        public MetalBuilder addBrand(CommodityMetalBrand _brand) {
            if (_brand != null) {
                this.brand.add(_brand.toBuilder());
            }
            return this;
        }

        @Override
        public MetalBuilder addBrand(CommodityMetalBrand _brand, int idx) {
            this.getIndex(this.brand, idx, () -> _brand.toBuilder());
            return this;
        }

        @Override
        public MetalBuilder addBrand(List<? extends CommodityMetalBrand> brands) {
            if (brands != null) {
                for (CommodityMetalBrand commodityMetalBrand : brands) {
                    this.brand.add(commodityMetalBrand.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="brand")
        public MetalBuilder setBrand(List<? extends CommodityMetalBrand> brands) {
            this.brand = brands == null ? new ArrayList<CommodityMetalBrand.CommodityMetalBrandBuilder>() : (List)brands.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="grade", isRequired=true)
        @RuneAttribute(value="grade", isRequired=true)
        public MetalBuilder addGrade(CommodityMetalGrade _grade) {
            if (_grade != null) {
                this.grade.add(_grade.toBuilder());
            }
            return this;
        }

        @Override
        public MetalBuilder addGrade(CommodityMetalGrade _grade, int idx) {
            this.getIndex(this.grade, idx, () -> _grade.toBuilder());
            return this;
        }

        @Override
        public MetalBuilder addGrade(List<? extends CommodityMetalGrade> grades) {
            if (grades != null) {
                for (CommodityMetalGrade commodityMetalGrade : grades) {
                    this.grade.add(commodityMetalGrade.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="grade")
        public MetalBuilder setGrade(List<? extends CommodityMetalGrade> grades) {
            this.grade = grades == null ? new ArrayList<CommodityMetalGrade.CommodityMetalGradeBuilder>() : (List)grades.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public Metal build() {
            return new MetalImpl(this);
        }

        @Override
        public MetalBuilder toBuilder() {
            return this;
        }

        @Override
        public MetalBuilder prune() {
            if (this.material != null && !this.material.prune().hasData()) {
                this.material = null;
            }
            this.shape = this.shape.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.brand = this.brand.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.grade = this.grade.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getMaterial() != null && this.getMaterial().hasData()) {
                return true;
            }
            if (this.getShape() != null && this.getShape().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getBrand() != null && this.getBrand().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getGrade() != null && this.getGrade().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public MetalBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            MetalBuilder o = (MetalBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMaterial(), (RosettaModelObjectBuilder)o.getMaterial(), this::setMaterial);
            merger.mergeRosetta(this.getShape(), o.getShape(), this::getOrCreateShape);
            merger.mergeRosetta(this.getBrand(), o.getBrand(), this::getOrCreateBrand);
            merger.mergeRosetta(this.getGrade(), o.getGrade(), this::getOrCreateGrade);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Metal _that = this.getType().cast(o);
            if (!Objects.equals(this.material, _that.getMaterial())) {
                return false;
            }
            if (!ListEquals.listEquals(this.shape, _that.getShape())) {
                return false;
            }
            if (!ListEquals.listEquals(this.brand, _that.getBrand())) {
                return false;
            }
            return ListEquals.listEquals(this.grade, _that.getGrade());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.material != null ? this.material.hashCode() : 0);
            _result = 31 * _result + (this.shape != null ? this.shape.hashCode() : 0);
            _result = 31 * _result + (this.brand != null ? this.brand.hashCode() : 0);
            _result = 31 * _result + (this.grade != null ? this.grade.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "MetalBuilder {material=" + this.material + ", shape=" + this.shape + ", brand=" + this.brand + ", grade=" + this.grade + '}';
        }
    }

    public static interface MetalBuilder
    extends Metal,
    RosettaModelObjectBuilder {
        public Material.MaterialBuilder getOrCreateMaterial();

        @Override
        public Material.MaterialBuilder getMaterial();

        public CommodityMetalShape.CommodityMetalShapeBuilder getOrCreateShape(int var1);

        public List<? extends CommodityMetalShape.CommodityMetalShapeBuilder> getShape();

        public CommodityMetalBrand.CommodityMetalBrandBuilder getOrCreateBrand(int var1);

        public List<? extends CommodityMetalBrand.CommodityMetalBrandBuilder> getBrand();

        public CommodityMetalGrade.CommodityMetalGradeBuilder getOrCreateGrade(int var1);

        public List<? extends CommodityMetalGrade.CommodityMetalGradeBuilder> getGrade();

        public MetalBuilder setMaterial(Material var1);

        public MetalBuilder addShape(CommodityMetalShape var1);

        public MetalBuilder addShape(CommodityMetalShape var1, int var2);

        public MetalBuilder addShape(List<? extends CommodityMetalShape> var1);

        public MetalBuilder setShape(List<? extends CommodityMetalShape> var1);

        public MetalBuilder addBrand(CommodityMetalBrand var1);

        public MetalBuilder addBrand(CommodityMetalBrand var1, int var2);

        public MetalBuilder addBrand(List<? extends CommodityMetalBrand> var1);

        public MetalBuilder setBrand(List<? extends CommodityMetalBrand> var1);

        public MetalBuilder addGrade(CommodityMetalGrade var1);

        public MetalBuilder addGrade(CommodityMetalGrade var1, int var2);

        public MetalBuilder addGrade(List<? extends CommodityMetalGrade> var1);

        public MetalBuilder setGrade(List<? extends CommodityMetalGrade> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("material"), processor, Material.MaterialBuilder.class, this.getMaterial(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("shape"), processor, CommodityMetalShape.CommodityMetalShapeBuilder.class, this.getShape(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("brand"), processor, CommodityMetalBrand.CommodityMetalBrandBuilder.class, this.getBrand(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("grade"), processor, CommodityMetalGrade.CommodityMetalGradeBuilder.class, this.getGrade(), new AttributeMeta[0]);
        }

        public MetalBuilder prune();
    }

    public static class MetalImpl
    implements Metal {
        private final Material material;
        private final List<? extends CommodityMetalShape> shape;
        private final List<? extends CommodityMetalBrand> brand;
        private final List<? extends CommodityMetalGrade> grade;

        protected MetalImpl(MetalBuilder builder) {
            this.material = Optional.ofNullable(builder.getMaterial()).map(f -> f.build()).orElse(null);
            this.shape = Optional.ofNullable(builder.getShape()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.brand = Optional.ofNullable(builder.getBrand()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.grade = Optional.ofNullable(builder.getGrade()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="material", isRequired=true)
        @RuneAttribute(value="material", isRequired=true)
        public Material getMaterial() {
            return this.material;
        }

        @Override
        @RosettaAttribute(value="shape", isRequired=true)
        @RuneAttribute(value="shape", isRequired=true)
        public List<? extends CommodityMetalShape> getShape() {
            return this.shape;
        }

        @Override
        @RosettaAttribute(value="brand")
        @RuneAttribute(value="brand")
        public List<? extends CommodityMetalBrand> getBrand() {
            return this.brand;
        }

        @Override
        @RosettaAttribute(value="grade", isRequired=true)
        @RuneAttribute(value="grade", isRequired=true)
        public List<? extends CommodityMetalGrade> getGrade() {
            return this.grade;
        }

        @Override
        public Metal build() {
            return this;
        }

        @Override
        public MetalBuilder toBuilder() {
            MetalBuilder builder = Metal.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(MetalBuilder builder) {
            Optional.ofNullable(this.getMaterial()).ifPresent(builder::setMaterial);
            Optional.ofNullable(this.getShape()).ifPresent(builder::setShape);
            Optional.ofNullable(this.getBrand()).ifPresent(builder::setBrand);
            Optional.ofNullable(this.getGrade()).ifPresent(builder::setGrade);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Metal _that = this.getType().cast(o);
            if (!Objects.equals(this.material, _that.getMaterial())) {
                return false;
            }
            if (!ListEquals.listEquals(this.shape, _that.getShape())) {
                return false;
            }
            if (!ListEquals.listEquals(this.brand, _that.getBrand())) {
                return false;
            }
            return ListEquals.listEquals(this.grade, _that.getGrade());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.material != null ? this.material.hashCode() : 0);
            _result = 31 * _result + (this.shape != null ? this.shape.hashCode() : 0);
            _result = 31 * _result + (this.brand != null ? this.brand.hashCode() : 0);
            _result = 31 * _result + (this.grade != null ? this.grade.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Metal {material=" + this.material + ", shape=" + this.shape + ", brand=" + this.brand + ", grade=" + this.grade + '}';
        }
    }
}

