/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.CorrectableRequestMessage;
import fpml.confirmation.CorrelationAndSequenceModel;
import fpml.confirmation.OnBehalfOfModel;
import fpml.confirmation.OptionExpiryBase;
import fpml.confirmation.PartiesAndAccountsModel;
import fpml.confirmation.RequestMessageHeader;
import fpml.confirmation.TradeMaturity;
import fpml.confirmation.ValidationModel;
import fpml.confirmation.meta.MaturityNotificationMeta;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="MaturityNotification", builder=MaturityNotificationBuilderImpl.class, version="0.17.2")
@RuneDataType(value="MaturityNotification", model="fpml", builder=MaturityNotificationBuilderImpl.class, version="0.17.2")
public interface MaturityNotification
extends CorrectableRequestMessage {
    public static final MaturityNotificationMeta metaData = new MaturityNotificationMeta();

    public OptionExpiryBase getOptionExpiry();

    public TradeMaturity getTradeMaturity();

    public PartiesAndAccountsModel getPartiesAndAccountsModel();

    @Override
    public MaturityNotification build();

    @Override
    public MaturityNotificationBuilder toBuilder();

    public static MaturityNotificationBuilder builder() {
        return new MaturityNotificationBuilderImpl();
    }

    default public RosettaMetaData<? extends MaturityNotification> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends MaturityNotification> getType() {
        return MaturityNotification.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.class, this.getHeader(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.class, this.getValidationModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("isCorrection"), Boolean.class, (Object)this.getIsCorrection(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("correlationAndSequenceModel"), processor, CorrelationAndSequenceModel.class, this.getCorrelationAndSequenceModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.class, this.getOnBehalfOfModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("optionExpiry"), processor, OptionExpiryBase.class, this.getOptionExpiry(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tradeMaturity"), processor, TradeMaturity.class, this.getTradeMaturity(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partiesAndAccountsModel"), processor, PartiesAndAccountsModel.class, this.getPartiesAndAccountsModel(), new AttributeMeta[0]);
    }

    public static class MaturityNotificationBuilderImpl
    extends CorrectableRequestMessage.CorrectableRequestMessageBuilderImpl
    implements MaturityNotificationBuilder {
        protected OptionExpiryBase.OptionExpiryBaseBuilder optionExpiry;
        protected TradeMaturity.TradeMaturityBuilder tradeMaturity;
        protected PartiesAndAccountsModel.PartiesAndAccountsModelBuilder partiesAndAccountsModel;

        @Override
        @RosettaAttribute(value="optionExpiry")
        @RuneAttribute(value="optionExpiry")
        public OptionExpiryBase.OptionExpiryBaseBuilder getOptionExpiry() {
            return this.optionExpiry;
        }

        @Override
        public OptionExpiryBase.OptionExpiryBaseBuilder getOrCreateOptionExpiry() {
            OptionExpiryBase.OptionExpiryBaseBuilder result = this.optionExpiry != null ? this.optionExpiry : (this.optionExpiry = OptionExpiryBase.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="tradeMaturity")
        @RuneAttribute(value="tradeMaturity")
        public TradeMaturity.TradeMaturityBuilder getTradeMaturity() {
            return this.tradeMaturity;
        }

        @Override
        public TradeMaturity.TradeMaturityBuilder getOrCreateTradeMaturity() {
            TradeMaturity.TradeMaturityBuilder result = this.tradeMaturity != null ? this.tradeMaturity : (this.tradeMaturity = TradeMaturity.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel", isRequired=true)
        @RuneAttribute(value="partiesAndAccountsModel", isRequired=true)
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getPartiesAndAccountsModel() {
            return this.partiesAndAccountsModel;
        }

        @Override
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getOrCreatePartiesAndAccountsModel() {
            PartiesAndAccountsModel.PartiesAndAccountsModelBuilder result = this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel : (this.partiesAndAccountsModel = PartiesAndAccountsModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fpmlVersion", isRequired=true)
        @RuneAttribute(value="fpmlVersion", isRequired=true)
        public MaturityNotificationBuilder setFpmlVersion(String _fpmlVersion) {
            this.fpmlVersion = _fpmlVersion == null ? null : _fpmlVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="expectedBuild")
        @RuneAttribute(value="expectedBuild")
        public MaturityNotificationBuilder setExpectedBuild(Integer _expectedBuild) {
            this.expectedBuild = _expectedBuild == null ? null : _expectedBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="actualBuild")
        @RuneAttribute(value="actualBuild")
        public MaturityNotificationBuilder setActualBuild(Integer _actualBuild) {
            this.actualBuild = _actualBuild == null ? null : _actualBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="header", isRequired=true)
        @RuneAttribute(value="header", isRequired=true)
        public MaturityNotificationBuilder setHeader(RequestMessageHeader _header) {
            this.header = _header == null ? null : _header.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="validationModel", isRequired=true)
        @RuneAttribute(value="validationModel", isRequired=true)
        public MaturityNotificationBuilder setValidationModel(ValidationModel _validationModel) {
            this.validationModel = _validationModel == null ? null : _validationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="isCorrection", isRequired=true)
        @RuneAttribute(value="isCorrection", isRequired=true)
        public MaturityNotificationBuilder setIsCorrection(Boolean _isCorrection) {
            this.isCorrection = _isCorrection == null ? null : _isCorrection;
            return this;
        }

        @Override
        @RosettaAttribute(value="correlationAndSequenceModel")
        @RuneAttribute(value="correlationAndSequenceModel")
        public MaturityNotificationBuilder setCorrelationAndSequenceModel(CorrelationAndSequenceModel _correlationAndSequenceModel) {
            this.correlationAndSequenceModel = _correlationAndSequenceModel == null ? null : _correlationAndSequenceModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="onBehalfOfModel")
        @RuneAttribute(value="onBehalfOfModel")
        public MaturityNotificationBuilder setOnBehalfOfModel(OnBehalfOfModel _onBehalfOfModel) {
            this.onBehalfOfModel = _onBehalfOfModel == null ? null : _onBehalfOfModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="optionExpiry")
        @RuneAttribute(value="optionExpiry")
        public MaturityNotificationBuilder setOptionExpiry(OptionExpiryBase _optionExpiry) {
            this.optionExpiry = _optionExpiry == null ? null : _optionExpiry.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeMaturity")
        @RuneAttribute(value="tradeMaturity")
        public MaturityNotificationBuilder setTradeMaturity(TradeMaturity _tradeMaturity) {
            this.tradeMaturity = _tradeMaturity == null ? null : _tradeMaturity.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel", isRequired=true)
        @RuneAttribute(value="partiesAndAccountsModel", isRequired=true)
        public MaturityNotificationBuilder setPartiesAndAccountsModel(PartiesAndAccountsModel _partiesAndAccountsModel) {
            this.partiesAndAccountsModel = _partiesAndAccountsModel == null ? null : _partiesAndAccountsModel.toBuilder();
            return this;
        }

        @Override
        public MaturityNotification build() {
            return new MaturityNotificationImpl(this);
        }

        @Override
        public MaturityNotificationBuilder toBuilder() {
            return this;
        }

        @Override
        public MaturityNotificationBuilder prune() {
            super.prune();
            if (this.optionExpiry != null && !this.optionExpiry.prune().hasData()) {
                this.optionExpiry = null;
            }
            if (this.tradeMaturity != null && !this.tradeMaturity.prune().hasData()) {
                this.tradeMaturity = null;
            }
            if (this.partiesAndAccountsModel != null && !this.partiesAndAccountsModel.prune().hasData()) {
                this.partiesAndAccountsModel = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getOptionExpiry() != null && this.getOptionExpiry().hasData()) {
                return true;
            }
            if (this.getTradeMaturity() != null && this.getTradeMaturity().hasData()) {
                return true;
            }
            return this.getPartiesAndAccountsModel() != null && this.getPartiesAndAccountsModel().hasData();
        }

        @Override
        public MaturityNotificationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            MaturityNotificationBuilder o = (MaturityNotificationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getOptionExpiry(), (RosettaModelObjectBuilder)o.getOptionExpiry(), this::setOptionExpiry);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTradeMaturity(), (RosettaModelObjectBuilder)o.getTradeMaturity(), this::setTradeMaturity);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPartiesAndAccountsModel(), (RosettaModelObjectBuilder)o.getPartiesAndAccountsModel(), this::setPartiesAndAccountsModel);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            MaturityNotification _that = (MaturityNotification)this.getType().cast(o);
            if (!Objects.equals(this.optionExpiry, _that.getOptionExpiry())) {
                return false;
            }
            if (!Objects.equals(this.tradeMaturity, _that.getTradeMaturity())) {
                return false;
            }
            return Objects.equals(this.partiesAndAccountsModel, _that.getPartiesAndAccountsModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.optionExpiry != null ? this.optionExpiry.hashCode() : 0);
            _result = 31 * _result + (this.tradeMaturity != null ? this.tradeMaturity.hashCode() : 0);
            _result = 31 * _result + (this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "MaturityNotificationBuilder {optionExpiry=" + this.optionExpiry + ", tradeMaturity=" + this.tradeMaturity + ", partiesAndAccountsModel=" + this.partiesAndAccountsModel + '}' + " " + super.toString();
        }
    }

    public static interface MaturityNotificationBuilder
    extends MaturityNotification,
    CorrectableRequestMessage.CorrectableRequestMessageBuilder {
        public OptionExpiryBase.OptionExpiryBaseBuilder getOrCreateOptionExpiry();

        @Override
        public OptionExpiryBase.OptionExpiryBaseBuilder getOptionExpiry();

        public TradeMaturity.TradeMaturityBuilder getOrCreateTradeMaturity();

        @Override
        public TradeMaturity.TradeMaturityBuilder getTradeMaturity();

        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getOrCreatePartiesAndAccountsModel();

        @Override
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getPartiesAndAccountsModel();

        @Override
        public MaturityNotificationBuilder setFpmlVersion(String var1);

        @Override
        public MaturityNotificationBuilder setExpectedBuild(Integer var1);

        @Override
        public MaturityNotificationBuilder setActualBuild(Integer var1);

        @Override
        public MaturityNotificationBuilder setHeader(RequestMessageHeader var1);

        @Override
        public MaturityNotificationBuilder setValidationModel(ValidationModel var1);

        @Override
        public MaturityNotificationBuilder setIsCorrection(Boolean var1);

        @Override
        public MaturityNotificationBuilder setCorrelationAndSequenceModel(CorrelationAndSequenceModel var1);

        @Override
        public MaturityNotificationBuilder setOnBehalfOfModel(OnBehalfOfModel var1);

        public MaturityNotificationBuilder setOptionExpiry(OptionExpiryBase var1);

        public MaturityNotificationBuilder setTradeMaturity(TradeMaturity var1);

        public MaturityNotificationBuilder setPartiesAndAccountsModel(PartiesAndAccountsModel var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.RequestMessageHeaderBuilder.class, (RosettaModelObjectBuilder)this.getHeader(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.ValidationModelBuilder.class, (RosettaModelObjectBuilder)this.getValidationModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("isCorrection"), Boolean.class, (Object)this.getIsCorrection(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("correlationAndSequenceModel"), processor, CorrelationAndSequenceModel.CorrelationAndSequenceModelBuilder.class, (RosettaModelObjectBuilder)this.getCorrelationAndSequenceModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.OnBehalfOfModelBuilder.class, (RosettaModelObjectBuilder)this.getOnBehalfOfModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("optionExpiry"), processor, OptionExpiryBase.OptionExpiryBaseBuilder.class, this.getOptionExpiry(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tradeMaturity"), processor, TradeMaturity.TradeMaturityBuilder.class, this.getTradeMaturity(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partiesAndAccountsModel"), processor, PartiesAndAccountsModel.PartiesAndAccountsModelBuilder.class, this.getPartiesAndAccountsModel(), new AttributeMeta[0]);
        }

        @Override
        public MaturityNotificationBuilder prune();
    }

    public static class MaturityNotificationImpl
    extends CorrectableRequestMessage.CorrectableRequestMessageImpl
    implements MaturityNotification {
        private final OptionExpiryBase optionExpiry;
        private final TradeMaturity tradeMaturity;
        private final PartiesAndAccountsModel partiesAndAccountsModel;

        protected MaturityNotificationImpl(MaturityNotificationBuilder builder) {
            super(builder);
            this.optionExpiry = Optional.ofNullable(builder.getOptionExpiry()).map(f -> f.build()).orElse(null);
            this.tradeMaturity = Optional.ofNullable(builder.getTradeMaturity()).map(f -> f.build()).orElse(null);
            this.partiesAndAccountsModel = Optional.ofNullable(builder.getPartiesAndAccountsModel()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="optionExpiry")
        @RuneAttribute(value="optionExpiry")
        public OptionExpiryBase getOptionExpiry() {
            return this.optionExpiry;
        }

        @Override
        @RosettaAttribute(value="tradeMaturity")
        @RuneAttribute(value="tradeMaturity")
        public TradeMaturity getTradeMaturity() {
            return this.tradeMaturity;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel", isRequired=true)
        @RuneAttribute(value="partiesAndAccountsModel", isRequired=true)
        public PartiesAndAccountsModel getPartiesAndAccountsModel() {
            return this.partiesAndAccountsModel;
        }

        @Override
        public MaturityNotification build() {
            return this;
        }

        @Override
        public MaturityNotificationBuilder toBuilder() {
            MaturityNotificationBuilder builder = MaturityNotification.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(MaturityNotificationBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getOptionExpiry()).ifPresent(builder::setOptionExpiry);
            Optional.ofNullable(this.getTradeMaturity()).ifPresent(builder::setTradeMaturity);
            Optional.ofNullable(this.getPartiesAndAccountsModel()).ifPresent(builder::setPartiesAndAccountsModel);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            MaturityNotification _that = (MaturityNotification)this.getType().cast(o);
            if (!Objects.equals(this.optionExpiry, _that.getOptionExpiry())) {
                return false;
            }
            if (!Objects.equals(this.tradeMaturity, _that.getTradeMaturity())) {
                return false;
            }
            return Objects.equals(this.partiesAndAccountsModel, _that.getPartiesAndAccountsModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.optionExpiry != null ? this.optionExpiry.hashCode() : 0);
            _result = 31 * _result + (this.tradeMaturity != null ? this.tradeMaturity.hashCode() : 0);
            _result = 31 * _result + (this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "MaturityNotification {optionExpiry=" + this.optionExpiry + ", tradeMaturity=" + this.tradeMaturity + ", partiesAndAccountsModel=" + this.partiesAndAccountsModel + '}' + " " + super.toString();
        }
    }
}

