/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.AbstractLoanEventSequence;
import fpml.confirmation.BusinessEventIdentifier;
import fpml.confirmation.BusinessEventPartiesModel;
import fpml.confirmation.LenderAndCashDetailsModel;
import fpml.confirmation.LoanContractMaturityChange;
import fpml.confirmation.LoanContractReference;
import fpml.confirmation.LoanLegalActionReference;
import fpml.confirmation.meta.MaturityChangeMeta;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@RosettaDataType(value="MaturityChange", builder=MaturityChangeBuilderImpl.class, version="0.17.2")
@RuneDataType(value="MaturityChange", model="fpml", builder=MaturityChangeBuilderImpl.class, version="0.17.2")
public interface MaturityChange
extends LoanContractMaturityChange {
    public static final MaturityChangeMeta metaData = new MaturityChangeMeta();

    @Override
    public MaturityChange build();

    @Override
    public MaturityChangeBuilder toBuilder();

    public static MaturityChangeBuilder builder() {
        return new MaturityChangeBuilderImpl();
    }

    default public RosettaMetaData<? extends MaturityChange> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends MaturityChange> getType() {
        return MaturityChange.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.class, this.getEventIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("abstractLoanEventSequence"), processor, AbstractLoanEventSequence.class, this.getAbstractLoanEventSequence(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("lenderAndCashDetailsModel"), processor, LenderAndCashDetailsModel.class, this.getLenderAndCashDetailsModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("businessEventPartiesModel"), processor, BusinessEventPartiesModel.class, this.getBusinessEventPartiesModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("legalActionReference"), processor, LoanLegalActionReference.class, this.getLegalActionReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("loanContractReference"), processor, LoanContractReference.class, this.getLoanContractReference(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("currentMaturityDate"), ZonedDateTime.class, (Object)this.getCurrentMaturityDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priorMaturityDate"), ZonedDateTime.class, (Object)this.getPriorMaturityDate(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class MaturityChangeBuilderImpl
    extends LoanContractMaturityChange.LoanContractMaturityChangeBuilderImpl
    implements MaturityChangeBuilder {
        @Override
        @RosettaAttribute(value="eventIdentifier", isRequired=true)
        @RuneAttribute(value="eventIdentifier", isRequired=true)
        public MaturityChangeBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier) {
            if (_eventIdentifier != null) {
                this.eventIdentifier.add(_eventIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public MaturityChangeBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier, int idx) {
            this.getIndex(this.eventIdentifier, idx, () -> _eventIdentifier.toBuilder());
            return this;
        }

        @Override
        public MaturityChangeBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            if (eventIdentifiers != null) {
                for (BusinessEventIdentifier businessEventIdentifier : eventIdentifiers) {
                    this.eventIdentifier.add(businessEventIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="eventIdentifier")
        public MaturityChangeBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            this.eventIdentifier = eventIdentifiers == null ? new ArrayList() : (List)eventIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="abstractLoanEventSequence")
        @RuneAttribute(value="abstractLoanEventSequence")
        public MaturityChangeBuilder setAbstractLoanEventSequence(AbstractLoanEventSequence _abstractLoanEventSequence) {
            this.abstractLoanEventSequence = _abstractLoanEventSequence == null ? null : _abstractLoanEventSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="lenderAndCashDetailsModel")
        @RuneAttribute(value="lenderAndCashDetailsModel")
        public MaturityChangeBuilder setLenderAndCashDetailsModel(LenderAndCashDetailsModel _lenderAndCashDetailsModel) {
            this.lenderAndCashDetailsModel = _lenderAndCashDetailsModel == null ? null : _lenderAndCashDetailsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="comment")
        @RuneAttribute(value="comment")
        public MaturityChangeBuilder setComment(String _comment) {
            this.comment = _comment == null ? null : _comment;
            return this;
        }

        @Override
        @RosettaAttribute(value="businessEventPartiesModel", isRequired=true)
        @RuneAttribute(value="businessEventPartiesModel", isRequired=true)
        public MaturityChangeBuilder setBusinessEventPartiesModel(BusinessEventPartiesModel _businessEventPartiesModel) {
            this.businessEventPartiesModel = _businessEventPartiesModel == null ? null : _businessEventPartiesModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="effectiveDate", isRequired=true)
        @RuneAttribute(value="effectiveDate", isRequired=true)
        public MaturityChangeBuilder setEffectiveDate(ZonedDateTime _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="legalActionReference")
        @RuneAttribute(value="legalActionReference")
        public MaturityChangeBuilder setLegalActionReference(LoanLegalActionReference _legalActionReference) {
            this.legalActionReference = _legalActionReference == null ? null : _legalActionReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="loanContractReference", isRequired=true)
        @RuneAttribute(value="loanContractReference", isRequired=true)
        public MaturityChangeBuilder setLoanContractReference(LoanContractReference _loanContractReference) {
            this.loanContractReference = _loanContractReference == null ? null : _loanContractReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="currentMaturityDate", isRequired=true)
        @RuneAttribute(value="currentMaturityDate", isRequired=true)
        public MaturityChangeBuilder setCurrentMaturityDate(ZonedDateTime _currentMaturityDate) {
            this.currentMaturityDate = _currentMaturityDate == null ? null : _currentMaturityDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="priorMaturityDate")
        @RuneAttribute(value="priorMaturityDate")
        public MaturityChangeBuilder setPriorMaturityDate(ZonedDateTime _priorMaturityDate) {
            this.priorMaturityDate = _priorMaturityDate == null ? null : _priorMaturityDate;
            return this;
        }

        @Override
        public MaturityChange build() {
            return new MaturityChangeImpl(this);
        }

        @Override
        public MaturityChangeBuilder toBuilder() {
            return this;
        }

        @Override
        public MaturityChangeBuilder prune() {
            super.prune();
            return this;
        }

        @Override
        public boolean hasData() {
            return super.hasData();
        }

        @Override
        public MaturityChangeBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            MaturityChangeBuilder o = (MaturityChangeBuilder)other;
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            return _result;
        }

        @Override
        public String toString() {
            return "MaturityChangeBuilder {} " + super.toString();
        }
    }

    public static interface MaturityChangeBuilder
    extends MaturityChange,
    LoanContractMaturityChange.LoanContractMaturityChangeBuilder {
        @Override
        public MaturityChangeBuilder addEventIdentifier(BusinessEventIdentifier var1);

        @Override
        public MaturityChangeBuilder addEventIdentifier(BusinessEventIdentifier var1, int var2);

        @Override
        public MaturityChangeBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public MaturityChangeBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public MaturityChangeBuilder setAbstractLoanEventSequence(AbstractLoanEventSequence var1);

        @Override
        public MaturityChangeBuilder setLenderAndCashDetailsModel(LenderAndCashDetailsModel var1);

        @Override
        public MaturityChangeBuilder setComment(String var1);

        @Override
        public MaturityChangeBuilder setBusinessEventPartiesModel(BusinessEventPartiesModel var1);

        @Override
        public MaturityChangeBuilder setEffectiveDate(ZonedDateTime var1);

        @Override
        public MaturityChangeBuilder setLegalActionReference(LoanLegalActionReference var1);

        @Override
        public MaturityChangeBuilder setLoanContractReference(LoanContractReference var1);

        @Override
        public MaturityChangeBuilder setCurrentMaturityDate(ZonedDateTime var1);

        @Override
        public MaturityChangeBuilder setPriorMaturityDate(ZonedDateTime var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.BusinessEventIdentifierBuilder.class, this.getEventIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("abstractLoanEventSequence"), processor, AbstractLoanEventSequence.AbstractLoanEventSequenceBuilder.class, (RosettaModelObjectBuilder)this.getAbstractLoanEventSequence(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("lenderAndCashDetailsModel"), processor, LenderAndCashDetailsModel.LenderAndCashDetailsModelBuilder.class, (RosettaModelObjectBuilder)this.getLenderAndCashDetailsModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("businessEventPartiesModel"), processor, BusinessEventPartiesModel.BusinessEventPartiesModelBuilder.class, (RosettaModelObjectBuilder)this.getBusinessEventPartiesModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("legalActionReference"), processor, LoanLegalActionReference.LoanLegalActionReferenceBuilder.class, (RosettaModelObjectBuilder)this.getLegalActionReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("loanContractReference"), processor, LoanContractReference.LoanContractReferenceBuilder.class, (RosettaModelObjectBuilder)this.getLoanContractReference(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("currentMaturityDate"), ZonedDateTime.class, (Object)this.getCurrentMaturityDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priorMaturityDate"), ZonedDateTime.class, (Object)this.getPriorMaturityDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public MaturityChangeBuilder prune();
    }

    public static class MaturityChangeImpl
    extends LoanContractMaturityChange.LoanContractMaturityChangeImpl
    implements MaturityChange {
        protected MaturityChangeImpl(MaturityChangeBuilder builder) {
            super(builder);
        }

        @Override
        public MaturityChange build() {
            return this;
        }

        @Override
        public MaturityChangeBuilder toBuilder() {
            MaturityChangeBuilder builder = MaturityChange.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(MaturityChangeBuilder builder) {
            super.setBuilderFields(builder);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            return _result;
        }

        @Override
        public String toString() {
            return "MaturityChange {} " + super.toString();
        }
    }
}

