/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.AbstractTradingAccrual;
import fpml.confirmation.AccrualPeriod;
import fpml.confirmation.AccrualTypeId;
import fpml.confirmation.FacilityReference;
import fpml.confirmation.LoanTradingAccruingFeeTypeEnum;
import fpml.confirmation.Money;
import fpml.confirmation.meta.LoanTradingFacilityFeeAccrualMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="LoanTradingFacilityFeeAccrual", builder=LoanTradingFacilityFeeAccrualBuilderImpl.class, version="0.17.2")
@RuneDataType(value="LoanTradingFacilityFeeAccrual", model="fpml", builder=LoanTradingFacilityFeeAccrualBuilderImpl.class, version="0.17.2")
public interface LoanTradingFacilityFeeAccrual
extends AbstractTradingAccrual {
    public static final LoanTradingFacilityFeeAccrualMeta metaData = new LoanTradingFacilityFeeAccrualMeta();

    public AccrualTypeId getAccruingFeeTypeId();

    public LoanTradingAccruingFeeTypeEnum getAccruingFeeType();

    public FacilityReference getFacilityReference();

    @Override
    public LoanTradingFacilityFeeAccrual build();

    @Override
    public LoanTradingFacilityFeeAccrualBuilder toBuilder();

    public static LoanTradingFacilityFeeAccrualBuilder builder() {
        return new LoanTradingFacilityFeeAccrualBuilderImpl();
    }

    default public RosettaMetaData<? extends LoanTradingFacilityFeeAccrual> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends LoanTradingFacilityFeeAccrual> getType() {
        return LoanTradingFacilityFeeAccrual.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("amount"), processor, Money.class, this.getAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("accrualPeriod"), processor, AccrualPeriod.class, this.getAccrualPeriod(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("accruingFeeTypeId"), processor, AccrualTypeId.class, this.getAccruingFeeTypeId(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("accruingFeeType"), LoanTradingAccruingFeeTypeEnum.class, (Object)this.getAccruingFeeType(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("facilityReference"), processor, FacilityReference.class, this.getFacilityReference(), new AttributeMeta[0]);
    }

    public static class LoanTradingFacilityFeeAccrualBuilderImpl
    extends AbstractTradingAccrual.AbstractTradingAccrualBuilderImpl
    implements LoanTradingFacilityFeeAccrualBuilder {
        protected AccrualTypeId.AccrualTypeIdBuilder accruingFeeTypeId;
        protected LoanTradingAccruingFeeTypeEnum accruingFeeType;
        protected FacilityReference.FacilityReferenceBuilder facilityReference;

        @Override
        @RosettaAttribute(value="accruingFeeTypeId", isRequired=true)
        @RuneAttribute(value="accruingFeeTypeId", isRequired=true)
        public AccrualTypeId.AccrualTypeIdBuilder getAccruingFeeTypeId() {
            return this.accruingFeeTypeId;
        }

        @Override
        public AccrualTypeId.AccrualTypeIdBuilder getOrCreateAccruingFeeTypeId() {
            AccrualTypeId.AccrualTypeIdBuilder result = this.accruingFeeTypeId != null ? this.accruingFeeTypeId : (this.accruingFeeTypeId = AccrualTypeId.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="accruingFeeType")
        @RuneAttribute(value="accruingFeeType")
        public LoanTradingAccruingFeeTypeEnum getAccruingFeeType() {
            return this.accruingFeeType;
        }

        @Override
        @RosettaAttribute(value="facilityReference", isRequired=true)
        @RuneAttribute(value="facilityReference", isRequired=true)
        public FacilityReference.FacilityReferenceBuilder getFacilityReference() {
            return this.facilityReference;
        }

        @Override
        public FacilityReference.FacilityReferenceBuilder getOrCreateFacilityReference() {
            FacilityReference.FacilityReferenceBuilder result = this.facilityReference != null ? this.facilityReference : (this.facilityReference = FacilityReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public LoanTradingFacilityFeeAccrualBuilder setAmount(Money _amount) {
            this.amount = _amount == null ? null : _amount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="accrualPeriod")
        @RuneAttribute(value="accrualPeriod")
        public LoanTradingFacilityFeeAccrualBuilder addAccrualPeriod(AccrualPeriod _accrualPeriod) {
            if (_accrualPeriod != null) {
                this.accrualPeriod.add(_accrualPeriod.toBuilder());
            }
            return this;
        }

        @Override
        public LoanTradingFacilityFeeAccrualBuilder addAccrualPeriod(AccrualPeriod _accrualPeriod, int idx) {
            this.getIndex(this.accrualPeriod, idx, () -> _accrualPeriod.toBuilder());
            return this;
        }

        @Override
        public LoanTradingFacilityFeeAccrualBuilder addAccrualPeriod(List<? extends AccrualPeriod> accrualPeriods) {
            if (accrualPeriods != null) {
                for (AccrualPeriod accrualPeriod : accrualPeriods) {
                    this.accrualPeriod.add(accrualPeriod.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="accrualPeriod")
        public LoanTradingFacilityFeeAccrualBuilder setAccrualPeriod(List<? extends AccrualPeriod> accrualPeriods) {
            this.accrualPeriod = accrualPeriods == null ? new ArrayList() : (List)accrualPeriods.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="accruingFeeTypeId", isRequired=true)
        @RuneAttribute(value="accruingFeeTypeId", isRequired=true)
        public LoanTradingFacilityFeeAccrualBuilder setAccruingFeeTypeId(AccrualTypeId _accruingFeeTypeId) {
            this.accruingFeeTypeId = _accruingFeeTypeId == null ? null : _accruingFeeTypeId.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="accruingFeeType")
        @RuneAttribute(value="accruingFeeType")
        public LoanTradingFacilityFeeAccrualBuilder setAccruingFeeType(LoanTradingAccruingFeeTypeEnum _accruingFeeType) {
            this.accruingFeeType = _accruingFeeType == null ? null : _accruingFeeType;
            return this;
        }

        @Override
        @RosettaAttribute(value="facilityReference", isRequired=true)
        @RuneAttribute(value="facilityReference", isRequired=true)
        public LoanTradingFacilityFeeAccrualBuilder setFacilityReference(FacilityReference _facilityReference) {
            this.facilityReference = _facilityReference == null ? null : _facilityReference.toBuilder();
            return this;
        }

        @Override
        public LoanTradingFacilityFeeAccrual build() {
            return new LoanTradingFacilityFeeAccrualImpl(this);
        }

        @Override
        public LoanTradingFacilityFeeAccrualBuilder toBuilder() {
            return this;
        }

        @Override
        public LoanTradingFacilityFeeAccrualBuilder prune() {
            super.prune();
            if (this.accruingFeeTypeId != null && !this.accruingFeeTypeId.prune().hasData()) {
                this.accruingFeeTypeId = null;
            }
            if (this.facilityReference != null && !this.facilityReference.prune().hasData()) {
                this.facilityReference = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getAccruingFeeTypeId() != null && this.getAccruingFeeTypeId().hasData()) {
                return true;
            }
            if (this.getAccruingFeeType() != null) {
                return true;
            }
            return this.getFacilityReference() != null && this.getFacilityReference().hasData();
        }

        @Override
        public LoanTradingFacilityFeeAccrualBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            LoanTradingFacilityFeeAccrualBuilder o = (LoanTradingFacilityFeeAccrualBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAccruingFeeTypeId(), (RosettaModelObjectBuilder)o.getAccruingFeeTypeId(), this::setAccruingFeeTypeId);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFacilityReference(), (RosettaModelObjectBuilder)o.getFacilityReference(), this::setFacilityReference);
            merger.mergeBasic((Object)this.getAccruingFeeType(), (Object)o.getAccruingFeeType(), this::setAccruingFeeType, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LoanTradingFacilityFeeAccrual _that = (LoanTradingFacilityFeeAccrual)this.getType().cast(o);
            if (!Objects.equals(this.accruingFeeTypeId, _that.getAccruingFeeTypeId())) {
                return false;
            }
            if (!Objects.equals((Object)this.accruingFeeType, (Object)_that.getAccruingFeeType())) {
                return false;
            }
            return Objects.equals(this.facilityReference, _that.getFacilityReference());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.accruingFeeTypeId != null ? this.accruingFeeTypeId.hashCode() : 0);
            _result = 31 * _result + (this.accruingFeeType != null ? ((Object)((Object)this.accruingFeeType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.facilityReference != null ? this.facilityReference.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LoanTradingFacilityFeeAccrualBuilder {accruingFeeTypeId=" + this.accruingFeeTypeId + ", accruingFeeType=" + (Object)((Object)this.accruingFeeType) + ", facilityReference=" + this.facilityReference + '}' + " " + super.toString();
        }
    }

    public static interface LoanTradingFacilityFeeAccrualBuilder
    extends LoanTradingFacilityFeeAccrual,
    AbstractTradingAccrual.AbstractTradingAccrualBuilder {
        public AccrualTypeId.AccrualTypeIdBuilder getOrCreateAccruingFeeTypeId();

        @Override
        public AccrualTypeId.AccrualTypeIdBuilder getAccruingFeeTypeId();

        public FacilityReference.FacilityReferenceBuilder getOrCreateFacilityReference();

        @Override
        public FacilityReference.FacilityReferenceBuilder getFacilityReference();

        @Override
        public LoanTradingFacilityFeeAccrualBuilder setAmount(Money var1);

        @Override
        public LoanTradingFacilityFeeAccrualBuilder addAccrualPeriod(AccrualPeriod var1);

        @Override
        public LoanTradingFacilityFeeAccrualBuilder addAccrualPeriod(AccrualPeriod var1, int var2);

        @Override
        public LoanTradingFacilityFeeAccrualBuilder addAccrualPeriod(List<? extends AccrualPeriod> var1);

        @Override
        public LoanTradingFacilityFeeAccrualBuilder setAccrualPeriod(List<? extends AccrualPeriod> var1);

        public LoanTradingFacilityFeeAccrualBuilder setAccruingFeeTypeId(AccrualTypeId var1);

        public LoanTradingFacilityFeeAccrualBuilder setAccruingFeeType(LoanTradingAccruingFeeTypeEnum var1);

        public LoanTradingFacilityFeeAccrualBuilder setFacilityReference(FacilityReference var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("amount"), processor, Money.MoneyBuilder.class, (RosettaModelObjectBuilder)this.getAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("accrualPeriod"), processor, AccrualPeriod.AccrualPeriodBuilder.class, this.getAccrualPeriod(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("accruingFeeTypeId"), processor, AccrualTypeId.AccrualTypeIdBuilder.class, this.getAccruingFeeTypeId(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("accruingFeeType"), LoanTradingAccruingFeeTypeEnum.class, (Object)this.getAccruingFeeType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("facilityReference"), processor, FacilityReference.FacilityReferenceBuilder.class, this.getFacilityReference(), new AttributeMeta[0]);
        }

        @Override
        public LoanTradingFacilityFeeAccrualBuilder prune();
    }

    public static class LoanTradingFacilityFeeAccrualImpl
    extends AbstractTradingAccrual.AbstractTradingAccrualImpl
    implements LoanTradingFacilityFeeAccrual {
        private final AccrualTypeId accruingFeeTypeId;
        private final LoanTradingAccruingFeeTypeEnum accruingFeeType;
        private final FacilityReference facilityReference;

        protected LoanTradingFacilityFeeAccrualImpl(LoanTradingFacilityFeeAccrualBuilder builder) {
            super(builder);
            this.accruingFeeTypeId = Optional.ofNullable(builder.getAccruingFeeTypeId()).map(f -> f.build()).orElse(null);
            this.accruingFeeType = builder.getAccruingFeeType();
            this.facilityReference = Optional.ofNullable(builder.getFacilityReference()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="accruingFeeTypeId", isRequired=true)
        @RuneAttribute(value="accruingFeeTypeId", isRequired=true)
        public AccrualTypeId getAccruingFeeTypeId() {
            return this.accruingFeeTypeId;
        }

        @Override
        @RosettaAttribute(value="accruingFeeType")
        @RuneAttribute(value="accruingFeeType")
        public LoanTradingAccruingFeeTypeEnum getAccruingFeeType() {
            return this.accruingFeeType;
        }

        @Override
        @RosettaAttribute(value="facilityReference", isRequired=true)
        @RuneAttribute(value="facilityReference", isRequired=true)
        public FacilityReference getFacilityReference() {
            return this.facilityReference;
        }

        @Override
        public LoanTradingFacilityFeeAccrual build() {
            return this;
        }

        @Override
        public LoanTradingFacilityFeeAccrualBuilder toBuilder() {
            LoanTradingFacilityFeeAccrualBuilder builder = LoanTradingFacilityFeeAccrual.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LoanTradingFacilityFeeAccrualBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getAccruingFeeTypeId()).ifPresent(builder::setAccruingFeeTypeId);
            Optional.ofNullable(this.getAccruingFeeType()).ifPresent(builder::setAccruingFeeType);
            Optional.ofNullable(this.getFacilityReference()).ifPresent(builder::setFacilityReference);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LoanTradingFacilityFeeAccrual _that = (LoanTradingFacilityFeeAccrual)this.getType().cast(o);
            if (!Objects.equals(this.accruingFeeTypeId, _that.getAccruingFeeTypeId())) {
                return false;
            }
            if (!Objects.equals((Object)this.accruingFeeType, (Object)_that.getAccruingFeeType())) {
                return false;
            }
            return Objects.equals(this.facilityReference, _that.getFacilityReference());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.accruingFeeTypeId != null ? this.accruingFeeTypeId.hashCode() : 0);
            _result = 31 * _result + (this.accruingFeeType != null ? ((Object)((Object)this.accruingFeeType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.facilityReference != null ? this.facilityReference.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LoanTradingFacilityFeeAccrual {accruingFeeTypeId=" + this.accruingFeeTypeId + ", accruingFeeType=" + (Object)((Object)this.accruingFeeType) + ", facilityReference=" + this.facilityReference + '}' + " " + super.toString();
        }
    }
}

