/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.confirmation.LoanTradingNonAccruingFee;
import fpml.confirmation.LoanTradingSettlementAccrualsModel;
import fpml.confirmation.NonNegativeMoney;
import fpml.confirmation.SimplePayerReceiverModel;
import fpml.confirmation.meta.LoanTradingDelayedCompensationMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="LoanTradingDelayedCompensation", builder=LoanTradingDelayedCompensationBuilderImpl.class, version="0.17.2")
@RuneDataType(value="LoanTradingDelayedCompensation", model="fpml", builder=LoanTradingDelayedCompensationBuilderImpl.class, version="0.17.2")
public interface LoanTradingDelayedCompensation
extends RosettaModelObject {
    public static final LoanTradingDelayedCompensationMeta metaData = new LoanTradingDelayedCompensationMeta();

    public NonNegativeMoney getAmount();

    public SimplePayerReceiverModel getSimplePayerReceiverModel();

    public LoanTradingSettlementAccrualsModel getLoanTradingSettlementAccrualsModel();

    public List<? extends LoanTradingNonAccruingFee> getNonAccruingFee();

    public LoanTradingDelayedCompensation build();

    public LoanTradingDelayedCompensationBuilder toBuilder();

    public static LoanTradingDelayedCompensationBuilder builder() {
        return new LoanTradingDelayedCompensationBuilderImpl();
    }

    default public RosettaMetaData<? extends LoanTradingDelayedCompensation> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends LoanTradingDelayedCompensation> getType() {
        return LoanTradingDelayedCompensation.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("amount"), processor, NonNegativeMoney.class, this.getAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("simplePayerReceiverModel"), processor, SimplePayerReceiverModel.class, this.getSimplePayerReceiverModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("loanTradingSettlementAccrualsModel"), processor, LoanTradingSettlementAccrualsModel.class, this.getLoanTradingSettlementAccrualsModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("nonAccruingFee"), processor, LoanTradingNonAccruingFee.class, this.getNonAccruingFee(), new AttributeMeta[0]);
    }

    public static class LoanTradingDelayedCompensationBuilderImpl
    implements LoanTradingDelayedCompensationBuilder {
        protected NonNegativeMoney.NonNegativeMoneyBuilder amount;
        protected SimplePayerReceiverModel.SimplePayerReceiverModelBuilder simplePayerReceiverModel;
        protected LoanTradingSettlementAccrualsModel.LoanTradingSettlementAccrualsModelBuilder loanTradingSettlementAccrualsModel;
        protected List<LoanTradingNonAccruingFee.LoanTradingNonAccruingFeeBuilder> nonAccruingFee = new ArrayList<LoanTradingNonAccruingFee.LoanTradingNonAccruingFeeBuilder>();

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public NonNegativeMoney.NonNegativeMoneyBuilder getAmount() {
            return this.amount;
        }

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateAmount() {
            NonNegativeMoney.NonNegativeMoneyBuilder result = this.amount != null ? this.amount : (this.amount = NonNegativeMoney.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="simplePayerReceiverModel")
        @RuneAttribute(value="simplePayerReceiverModel")
        public SimplePayerReceiverModel.SimplePayerReceiverModelBuilder getSimplePayerReceiverModel() {
            return this.simplePayerReceiverModel;
        }

        @Override
        public SimplePayerReceiverModel.SimplePayerReceiverModelBuilder getOrCreateSimplePayerReceiverModel() {
            SimplePayerReceiverModel.SimplePayerReceiverModelBuilder result = this.simplePayerReceiverModel != null ? this.simplePayerReceiverModel : (this.simplePayerReceiverModel = SimplePayerReceiverModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="loanTradingSettlementAccrualsModel", isRequired=true)
        @RuneAttribute(value="loanTradingSettlementAccrualsModel", isRequired=true)
        public LoanTradingSettlementAccrualsModel.LoanTradingSettlementAccrualsModelBuilder getLoanTradingSettlementAccrualsModel() {
            return this.loanTradingSettlementAccrualsModel;
        }

        @Override
        public LoanTradingSettlementAccrualsModel.LoanTradingSettlementAccrualsModelBuilder getOrCreateLoanTradingSettlementAccrualsModel() {
            LoanTradingSettlementAccrualsModel.LoanTradingSettlementAccrualsModelBuilder result = this.loanTradingSettlementAccrualsModel != null ? this.loanTradingSettlementAccrualsModel : (this.loanTradingSettlementAccrualsModel = LoanTradingSettlementAccrualsModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="nonAccruingFee")
        @RuneAttribute(value="nonAccruingFee")
        public List<? extends LoanTradingNonAccruingFee.LoanTradingNonAccruingFeeBuilder> getNonAccruingFee() {
            return this.nonAccruingFee;
        }

        @Override
        public LoanTradingNonAccruingFee.LoanTradingNonAccruingFeeBuilder getOrCreateNonAccruingFee(int index) {
            if (this.nonAccruingFee == null) {
                this.nonAccruingFee = new ArrayList<LoanTradingNonAccruingFee.LoanTradingNonAccruingFeeBuilder>();
            }
            return (LoanTradingNonAccruingFee.LoanTradingNonAccruingFeeBuilder)this.getIndex(this.nonAccruingFee, index, () -> {
                LoanTradingNonAccruingFee.LoanTradingNonAccruingFeeBuilder newNonAccruingFee = LoanTradingNonAccruingFee.builder();
                return newNonAccruingFee;
            });
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public LoanTradingDelayedCompensationBuilder setAmount(NonNegativeMoney _amount) {
            this.amount = _amount == null ? null : _amount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="simplePayerReceiverModel")
        @RuneAttribute(value="simplePayerReceiverModel")
        public LoanTradingDelayedCompensationBuilder setSimplePayerReceiverModel(SimplePayerReceiverModel _simplePayerReceiverModel) {
            this.simplePayerReceiverModel = _simplePayerReceiverModel == null ? null : _simplePayerReceiverModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="loanTradingSettlementAccrualsModel", isRequired=true)
        @RuneAttribute(value="loanTradingSettlementAccrualsModel", isRequired=true)
        public LoanTradingDelayedCompensationBuilder setLoanTradingSettlementAccrualsModel(LoanTradingSettlementAccrualsModel _loanTradingSettlementAccrualsModel) {
            this.loanTradingSettlementAccrualsModel = _loanTradingSettlementAccrualsModel == null ? null : _loanTradingSettlementAccrualsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="nonAccruingFee")
        @RuneAttribute(value="nonAccruingFee")
        public LoanTradingDelayedCompensationBuilder addNonAccruingFee(LoanTradingNonAccruingFee _nonAccruingFee) {
            if (_nonAccruingFee != null) {
                this.nonAccruingFee.add(_nonAccruingFee.toBuilder());
            }
            return this;
        }

        @Override
        public LoanTradingDelayedCompensationBuilder addNonAccruingFee(LoanTradingNonAccruingFee _nonAccruingFee, int idx) {
            this.getIndex(this.nonAccruingFee, idx, () -> _nonAccruingFee.toBuilder());
            return this;
        }

        @Override
        public LoanTradingDelayedCompensationBuilder addNonAccruingFee(List<? extends LoanTradingNonAccruingFee> nonAccruingFees) {
            if (nonAccruingFees != null) {
                for (LoanTradingNonAccruingFee loanTradingNonAccruingFee : nonAccruingFees) {
                    this.nonAccruingFee.add(loanTradingNonAccruingFee.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="nonAccruingFee")
        public LoanTradingDelayedCompensationBuilder setNonAccruingFee(List<? extends LoanTradingNonAccruingFee> nonAccruingFees) {
            this.nonAccruingFee = nonAccruingFees == null ? new ArrayList<LoanTradingNonAccruingFee.LoanTradingNonAccruingFeeBuilder>() : (List)nonAccruingFees.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public LoanTradingDelayedCompensation build() {
            return new LoanTradingDelayedCompensationImpl(this);
        }

        @Override
        public LoanTradingDelayedCompensationBuilder toBuilder() {
            return this;
        }

        @Override
        public LoanTradingDelayedCompensationBuilder prune() {
            if (this.amount != null && !this.amount.prune().hasData()) {
                this.amount = null;
            }
            if (this.simplePayerReceiverModel != null && !this.simplePayerReceiverModel.prune().hasData()) {
                this.simplePayerReceiverModel = null;
            }
            if (this.loanTradingSettlementAccrualsModel != null && !this.loanTradingSettlementAccrualsModel.prune().hasData()) {
                this.loanTradingSettlementAccrualsModel = null;
            }
            this.nonAccruingFee = this.nonAccruingFee.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getAmount() != null && this.getAmount().hasData()) {
                return true;
            }
            if (this.getSimplePayerReceiverModel() != null && this.getSimplePayerReceiverModel().hasData()) {
                return true;
            }
            if (this.getLoanTradingSettlementAccrualsModel() != null && this.getLoanTradingSettlementAccrualsModel().hasData()) {
                return true;
            }
            return this.getNonAccruingFee() != null && this.getNonAccruingFee().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public LoanTradingDelayedCompensationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            LoanTradingDelayedCompensationBuilder o = (LoanTradingDelayedCompensationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAmount(), (RosettaModelObjectBuilder)o.getAmount(), this::setAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSimplePayerReceiverModel(), (RosettaModelObjectBuilder)o.getSimplePayerReceiverModel(), this::setSimplePayerReceiverModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLoanTradingSettlementAccrualsModel(), (RosettaModelObjectBuilder)o.getLoanTradingSettlementAccrualsModel(), this::setLoanTradingSettlementAccrualsModel);
            merger.mergeRosetta(this.getNonAccruingFee(), o.getNonAccruingFee(), this::getOrCreateNonAccruingFee);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            LoanTradingDelayedCompensation _that = this.getType().cast(o);
            if (!Objects.equals(this.amount, _that.getAmount())) {
                return false;
            }
            if (!Objects.equals(this.simplePayerReceiverModel, _that.getSimplePayerReceiverModel())) {
                return false;
            }
            if (!Objects.equals(this.loanTradingSettlementAccrualsModel, _that.getLoanTradingSettlementAccrualsModel())) {
                return false;
            }
            return ListEquals.listEquals(this.nonAccruingFee, _that.getNonAccruingFee());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            _result = 31 * _result + (this.simplePayerReceiverModel != null ? this.simplePayerReceiverModel.hashCode() : 0);
            _result = 31 * _result + (this.loanTradingSettlementAccrualsModel != null ? this.loanTradingSettlementAccrualsModel.hashCode() : 0);
            _result = 31 * _result + (this.nonAccruingFee != null ? this.nonAccruingFee.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "LoanTradingDelayedCompensationBuilder {amount=" + this.amount + ", simplePayerReceiverModel=" + this.simplePayerReceiverModel + ", loanTradingSettlementAccrualsModel=" + this.loanTradingSettlementAccrualsModel + ", nonAccruingFee=" + this.nonAccruingFee + '}';
        }
    }

    public static interface LoanTradingDelayedCompensationBuilder
    extends LoanTradingDelayedCompensation,
    RosettaModelObjectBuilder {
        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateAmount();

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getAmount();

        public SimplePayerReceiverModel.SimplePayerReceiverModelBuilder getOrCreateSimplePayerReceiverModel();

        @Override
        public SimplePayerReceiverModel.SimplePayerReceiverModelBuilder getSimplePayerReceiverModel();

        public LoanTradingSettlementAccrualsModel.LoanTradingSettlementAccrualsModelBuilder getOrCreateLoanTradingSettlementAccrualsModel();

        @Override
        public LoanTradingSettlementAccrualsModel.LoanTradingSettlementAccrualsModelBuilder getLoanTradingSettlementAccrualsModel();

        public LoanTradingNonAccruingFee.LoanTradingNonAccruingFeeBuilder getOrCreateNonAccruingFee(int var1);

        public List<? extends LoanTradingNonAccruingFee.LoanTradingNonAccruingFeeBuilder> getNonAccruingFee();

        public LoanTradingDelayedCompensationBuilder setAmount(NonNegativeMoney var1);

        public LoanTradingDelayedCompensationBuilder setSimplePayerReceiverModel(SimplePayerReceiverModel var1);

        public LoanTradingDelayedCompensationBuilder setLoanTradingSettlementAccrualsModel(LoanTradingSettlementAccrualsModel var1);

        public LoanTradingDelayedCompensationBuilder addNonAccruingFee(LoanTradingNonAccruingFee var1);

        public LoanTradingDelayedCompensationBuilder addNonAccruingFee(LoanTradingNonAccruingFee var1, int var2);

        public LoanTradingDelayedCompensationBuilder addNonAccruingFee(List<? extends LoanTradingNonAccruingFee> var1);

        public LoanTradingDelayedCompensationBuilder setNonAccruingFee(List<? extends LoanTradingNonAccruingFee> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("amount"), processor, NonNegativeMoney.NonNegativeMoneyBuilder.class, this.getAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("simplePayerReceiverModel"), processor, SimplePayerReceiverModel.SimplePayerReceiverModelBuilder.class, this.getSimplePayerReceiverModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("loanTradingSettlementAccrualsModel"), processor, LoanTradingSettlementAccrualsModel.LoanTradingSettlementAccrualsModelBuilder.class, this.getLoanTradingSettlementAccrualsModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("nonAccruingFee"), processor, LoanTradingNonAccruingFee.LoanTradingNonAccruingFeeBuilder.class, this.getNonAccruingFee(), new AttributeMeta[0]);
        }

        public LoanTradingDelayedCompensationBuilder prune();
    }

    public static class LoanTradingDelayedCompensationImpl
    implements LoanTradingDelayedCompensation {
        private final NonNegativeMoney amount;
        private final SimplePayerReceiverModel simplePayerReceiverModel;
        private final LoanTradingSettlementAccrualsModel loanTradingSettlementAccrualsModel;
        private final List<? extends LoanTradingNonAccruingFee> nonAccruingFee;

        protected LoanTradingDelayedCompensationImpl(LoanTradingDelayedCompensationBuilder builder) {
            this.amount = Optional.ofNullable(builder.getAmount()).map(f -> f.build()).orElse(null);
            this.simplePayerReceiverModel = Optional.ofNullable(builder.getSimplePayerReceiverModel()).map(f -> f.build()).orElse(null);
            this.loanTradingSettlementAccrualsModel = Optional.ofNullable(builder.getLoanTradingSettlementAccrualsModel()).map(f -> f.build()).orElse(null);
            this.nonAccruingFee = Optional.ofNullable(builder.getNonAccruingFee()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public NonNegativeMoney getAmount() {
            return this.amount;
        }

        @Override
        @RosettaAttribute(value="simplePayerReceiverModel")
        @RuneAttribute(value="simplePayerReceiverModel")
        public SimplePayerReceiverModel getSimplePayerReceiverModel() {
            return this.simplePayerReceiverModel;
        }

        @Override
        @RosettaAttribute(value="loanTradingSettlementAccrualsModel", isRequired=true)
        @RuneAttribute(value="loanTradingSettlementAccrualsModel", isRequired=true)
        public LoanTradingSettlementAccrualsModel getLoanTradingSettlementAccrualsModel() {
            return this.loanTradingSettlementAccrualsModel;
        }

        @Override
        @RosettaAttribute(value="nonAccruingFee")
        @RuneAttribute(value="nonAccruingFee")
        public List<? extends LoanTradingNonAccruingFee> getNonAccruingFee() {
            return this.nonAccruingFee;
        }

        @Override
        public LoanTradingDelayedCompensation build() {
            return this;
        }

        @Override
        public LoanTradingDelayedCompensationBuilder toBuilder() {
            LoanTradingDelayedCompensationBuilder builder = LoanTradingDelayedCompensation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LoanTradingDelayedCompensationBuilder builder) {
            Optional.ofNullable(this.getAmount()).ifPresent(builder::setAmount);
            Optional.ofNullable(this.getSimplePayerReceiverModel()).ifPresent(builder::setSimplePayerReceiverModel);
            Optional.ofNullable(this.getLoanTradingSettlementAccrualsModel()).ifPresent(builder::setLoanTradingSettlementAccrualsModel);
            Optional.ofNullable(this.getNonAccruingFee()).ifPresent(builder::setNonAccruingFee);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            LoanTradingDelayedCompensation _that = this.getType().cast(o);
            if (!Objects.equals(this.amount, _that.getAmount())) {
                return false;
            }
            if (!Objects.equals(this.simplePayerReceiverModel, _that.getSimplePayerReceiverModel())) {
                return false;
            }
            if (!Objects.equals(this.loanTradingSettlementAccrualsModel, _that.getLoanTradingSettlementAccrualsModel())) {
                return false;
            }
            return ListEquals.listEquals(this.nonAccruingFee, _that.getNonAccruingFee());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            _result = 31 * _result + (this.simplePayerReceiverModel != null ? this.simplePayerReceiverModel.hashCode() : 0);
            _result = 31 * _result + (this.loanTradingSettlementAccrualsModel != null ? this.loanTradingSettlementAccrualsModel.hashCode() : 0);
            _result = 31 * _result + (this.nonAccruingFee != null ? this.nonAccruingFee.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "LoanTradingDelayedCompensation {amount=" + this.amount + ", simplePayerReceiverModel=" + this.simplePayerReceiverModel + ", loanTradingSettlementAccrualsModel=" + this.loanTradingSettlementAccrualsModel + ", nonAccruingFee=" + this.nonAccruingFee + '}';
        }
    }
}

