/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.LoanTradingCounterpartyCashSettlementRulesModel;
import fpml.confirmation.LoanTradingParticipationSettlementTermsModel;
import fpml.confirmation.LoanTransferFee;
import fpml.confirmation.meta.LoanTradeSequenceMeta;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="LoanTradeSequence", builder=LoanTradeSequenceBuilderImpl.class, version="0.17.2")
@RuneDataType(value="LoanTradeSequence", model="fpml", builder=LoanTradeSequenceBuilderImpl.class, version="0.17.2")
public interface LoanTradeSequence
extends RosettaModelObject {
    public static final LoanTradeSequenceMeta metaData = new LoanTradeSequenceMeta();

    public BigDecimal getPrice();

    public LoanTransferFee getTransferFee();

    public LoanTradingCounterpartyCashSettlementRulesModel getLoanTradingCounterpartyCashSettlementRulesModel();

    public LoanTradingParticipationSettlementTermsModel getLoanTradingParticipationSettlementTermsModel();

    public LoanTradeSequence build();

    public LoanTradeSequenceBuilder toBuilder();

    public static LoanTradeSequenceBuilder builder() {
        return new LoanTradeSequenceBuilderImpl();
    }

    default public RosettaMetaData<? extends LoanTradeSequence> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends LoanTradeSequence> getType() {
        return LoanTradeSequence.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("price"), BigDecimal.class, (Object)this.getPrice(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("transferFee"), processor, LoanTransferFee.class, this.getTransferFee(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("loanTradingCounterpartyCashSettlementRulesModel"), processor, LoanTradingCounterpartyCashSettlementRulesModel.class, this.getLoanTradingCounterpartyCashSettlementRulesModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("loanTradingParticipationSettlementTermsModel"), processor, LoanTradingParticipationSettlementTermsModel.class, this.getLoanTradingParticipationSettlementTermsModel(), new AttributeMeta[0]);
    }

    public static class LoanTradeSequenceBuilderImpl
    implements LoanTradeSequenceBuilder {
        protected BigDecimal price;
        protected LoanTransferFee.LoanTransferFeeBuilder transferFee;
        protected LoanTradingCounterpartyCashSettlementRulesModel.LoanTradingCounterpartyCashSettlementRulesModelBuilder loanTradingCounterpartyCashSettlementRulesModel;
        protected LoanTradingParticipationSettlementTermsModel.LoanTradingParticipationSettlementTermsModelBuilder loanTradingParticipationSettlementTermsModel;

        @Override
        @RosettaAttribute(value="price", isRequired=true)
        @RuneAttribute(value="price", isRequired=true)
        public BigDecimal getPrice() {
            return this.price;
        }

        @Override
        @RosettaAttribute(value="transferFee", isRequired=true)
        @RuneAttribute(value="transferFee", isRequired=true)
        public LoanTransferFee.LoanTransferFeeBuilder getTransferFee() {
            return this.transferFee;
        }

        @Override
        public LoanTransferFee.LoanTransferFeeBuilder getOrCreateTransferFee() {
            LoanTransferFee.LoanTransferFeeBuilder result = this.transferFee != null ? this.transferFee : (this.transferFee = LoanTransferFee.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="loanTradingCounterpartyCashSettlementRulesModel", isRequired=true)
        @RuneAttribute(value="loanTradingCounterpartyCashSettlementRulesModel", isRequired=true)
        public LoanTradingCounterpartyCashSettlementRulesModel.LoanTradingCounterpartyCashSettlementRulesModelBuilder getLoanTradingCounterpartyCashSettlementRulesModel() {
            return this.loanTradingCounterpartyCashSettlementRulesModel;
        }

        @Override
        public LoanTradingCounterpartyCashSettlementRulesModel.LoanTradingCounterpartyCashSettlementRulesModelBuilder getOrCreateLoanTradingCounterpartyCashSettlementRulesModel() {
            LoanTradingCounterpartyCashSettlementRulesModel.LoanTradingCounterpartyCashSettlementRulesModelBuilder result = this.loanTradingCounterpartyCashSettlementRulesModel != null ? this.loanTradingCounterpartyCashSettlementRulesModel : (this.loanTradingCounterpartyCashSettlementRulesModel = LoanTradingCounterpartyCashSettlementRulesModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="loanTradingParticipationSettlementTermsModel")
        @RuneAttribute(value="loanTradingParticipationSettlementTermsModel")
        public LoanTradingParticipationSettlementTermsModel.LoanTradingParticipationSettlementTermsModelBuilder getLoanTradingParticipationSettlementTermsModel() {
            return this.loanTradingParticipationSettlementTermsModel;
        }

        @Override
        public LoanTradingParticipationSettlementTermsModel.LoanTradingParticipationSettlementTermsModelBuilder getOrCreateLoanTradingParticipationSettlementTermsModel() {
            LoanTradingParticipationSettlementTermsModel.LoanTradingParticipationSettlementTermsModelBuilder result = this.loanTradingParticipationSettlementTermsModel != null ? this.loanTradingParticipationSettlementTermsModel : (this.loanTradingParticipationSettlementTermsModel = LoanTradingParticipationSettlementTermsModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="price", isRequired=true)
        @RuneAttribute(value="price", isRequired=true)
        public LoanTradeSequenceBuilder setPrice(BigDecimal _price) {
            this.price = _price == null ? null : _price;
            return this;
        }

        @Override
        @RosettaAttribute(value="transferFee", isRequired=true)
        @RuneAttribute(value="transferFee", isRequired=true)
        public LoanTradeSequenceBuilder setTransferFee(LoanTransferFee _transferFee) {
            this.transferFee = _transferFee == null ? null : _transferFee.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="loanTradingCounterpartyCashSettlementRulesModel", isRequired=true)
        @RuneAttribute(value="loanTradingCounterpartyCashSettlementRulesModel", isRequired=true)
        public LoanTradeSequenceBuilder setLoanTradingCounterpartyCashSettlementRulesModel(LoanTradingCounterpartyCashSettlementRulesModel _loanTradingCounterpartyCashSettlementRulesModel) {
            this.loanTradingCounterpartyCashSettlementRulesModel = _loanTradingCounterpartyCashSettlementRulesModel == null ? null : _loanTradingCounterpartyCashSettlementRulesModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="loanTradingParticipationSettlementTermsModel")
        @RuneAttribute(value="loanTradingParticipationSettlementTermsModel")
        public LoanTradeSequenceBuilder setLoanTradingParticipationSettlementTermsModel(LoanTradingParticipationSettlementTermsModel _loanTradingParticipationSettlementTermsModel) {
            this.loanTradingParticipationSettlementTermsModel = _loanTradingParticipationSettlementTermsModel == null ? null : _loanTradingParticipationSettlementTermsModel.toBuilder();
            return this;
        }

        @Override
        public LoanTradeSequence build() {
            return new LoanTradeSequenceImpl(this);
        }

        @Override
        public LoanTradeSequenceBuilder toBuilder() {
            return this;
        }

        @Override
        public LoanTradeSequenceBuilder prune() {
            if (this.transferFee != null && !this.transferFee.prune().hasData()) {
                this.transferFee = null;
            }
            if (this.loanTradingCounterpartyCashSettlementRulesModel != null && !this.loanTradingCounterpartyCashSettlementRulesModel.prune().hasData()) {
                this.loanTradingCounterpartyCashSettlementRulesModel = null;
            }
            if (this.loanTradingParticipationSettlementTermsModel != null && !this.loanTradingParticipationSettlementTermsModel.prune().hasData()) {
                this.loanTradingParticipationSettlementTermsModel = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getPrice() != null) {
                return true;
            }
            if (this.getTransferFee() != null && this.getTransferFee().hasData()) {
                return true;
            }
            if (this.getLoanTradingCounterpartyCashSettlementRulesModel() != null && this.getLoanTradingCounterpartyCashSettlementRulesModel().hasData()) {
                return true;
            }
            return this.getLoanTradingParticipationSettlementTermsModel() != null && this.getLoanTradingParticipationSettlementTermsModel().hasData();
        }

        public LoanTradeSequenceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            LoanTradeSequenceBuilder o = (LoanTradeSequenceBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTransferFee(), (RosettaModelObjectBuilder)o.getTransferFee(), this::setTransferFee);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLoanTradingCounterpartyCashSettlementRulesModel(), (RosettaModelObjectBuilder)o.getLoanTradingCounterpartyCashSettlementRulesModel(), this::setLoanTradingCounterpartyCashSettlementRulesModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLoanTradingParticipationSettlementTermsModel(), (RosettaModelObjectBuilder)o.getLoanTradingParticipationSettlementTermsModel(), this::setLoanTradingParticipationSettlementTermsModel);
            merger.mergeBasic((Object)this.getPrice(), (Object)o.getPrice(), this::setPrice, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            LoanTradeSequence _that = this.getType().cast(o);
            if (!Objects.equals(this.price, _that.getPrice())) {
                return false;
            }
            if (!Objects.equals(this.transferFee, _that.getTransferFee())) {
                return false;
            }
            if (!Objects.equals(this.loanTradingCounterpartyCashSettlementRulesModel, _that.getLoanTradingCounterpartyCashSettlementRulesModel())) {
                return false;
            }
            return Objects.equals(this.loanTradingParticipationSettlementTermsModel, _that.getLoanTradingParticipationSettlementTermsModel());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.price != null ? this.price.hashCode() : 0);
            _result = 31 * _result + (this.transferFee != null ? this.transferFee.hashCode() : 0);
            _result = 31 * _result + (this.loanTradingCounterpartyCashSettlementRulesModel != null ? this.loanTradingCounterpartyCashSettlementRulesModel.hashCode() : 0);
            _result = 31 * _result + (this.loanTradingParticipationSettlementTermsModel != null ? this.loanTradingParticipationSettlementTermsModel.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "LoanTradeSequenceBuilder {price=" + this.price + ", transferFee=" + this.transferFee + ", loanTradingCounterpartyCashSettlementRulesModel=" + this.loanTradingCounterpartyCashSettlementRulesModel + ", loanTradingParticipationSettlementTermsModel=" + this.loanTradingParticipationSettlementTermsModel + '}';
        }
    }

    public static interface LoanTradeSequenceBuilder
    extends LoanTradeSequence,
    RosettaModelObjectBuilder {
        public LoanTransferFee.LoanTransferFeeBuilder getOrCreateTransferFee();

        @Override
        public LoanTransferFee.LoanTransferFeeBuilder getTransferFee();

        public LoanTradingCounterpartyCashSettlementRulesModel.LoanTradingCounterpartyCashSettlementRulesModelBuilder getOrCreateLoanTradingCounterpartyCashSettlementRulesModel();

        @Override
        public LoanTradingCounterpartyCashSettlementRulesModel.LoanTradingCounterpartyCashSettlementRulesModelBuilder getLoanTradingCounterpartyCashSettlementRulesModel();

        public LoanTradingParticipationSettlementTermsModel.LoanTradingParticipationSettlementTermsModelBuilder getOrCreateLoanTradingParticipationSettlementTermsModel();

        @Override
        public LoanTradingParticipationSettlementTermsModel.LoanTradingParticipationSettlementTermsModelBuilder getLoanTradingParticipationSettlementTermsModel();

        public LoanTradeSequenceBuilder setPrice(BigDecimal var1);

        public LoanTradeSequenceBuilder setTransferFee(LoanTransferFee var1);

        public LoanTradeSequenceBuilder setLoanTradingCounterpartyCashSettlementRulesModel(LoanTradingCounterpartyCashSettlementRulesModel var1);

        public LoanTradeSequenceBuilder setLoanTradingParticipationSettlementTermsModel(LoanTradingParticipationSettlementTermsModel var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("price"), BigDecimal.class, (Object)this.getPrice(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("transferFee"), processor, LoanTransferFee.LoanTransferFeeBuilder.class, this.getTransferFee(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("loanTradingCounterpartyCashSettlementRulesModel"), processor, LoanTradingCounterpartyCashSettlementRulesModel.LoanTradingCounterpartyCashSettlementRulesModelBuilder.class, this.getLoanTradingCounterpartyCashSettlementRulesModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("loanTradingParticipationSettlementTermsModel"), processor, LoanTradingParticipationSettlementTermsModel.LoanTradingParticipationSettlementTermsModelBuilder.class, this.getLoanTradingParticipationSettlementTermsModel(), new AttributeMeta[0]);
        }

        public LoanTradeSequenceBuilder prune();
    }

    public static class LoanTradeSequenceImpl
    implements LoanTradeSequence {
        private final BigDecimal price;
        private final LoanTransferFee transferFee;
        private final LoanTradingCounterpartyCashSettlementRulesModel loanTradingCounterpartyCashSettlementRulesModel;
        private final LoanTradingParticipationSettlementTermsModel loanTradingParticipationSettlementTermsModel;

        protected LoanTradeSequenceImpl(LoanTradeSequenceBuilder builder) {
            this.price = builder.getPrice();
            this.transferFee = Optional.ofNullable(builder.getTransferFee()).map(f -> f.build()).orElse(null);
            this.loanTradingCounterpartyCashSettlementRulesModel = Optional.ofNullable(builder.getLoanTradingCounterpartyCashSettlementRulesModel()).map(f -> f.build()).orElse(null);
            this.loanTradingParticipationSettlementTermsModel = Optional.ofNullable(builder.getLoanTradingParticipationSettlementTermsModel()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="price", isRequired=true)
        @RuneAttribute(value="price", isRequired=true)
        public BigDecimal getPrice() {
            return this.price;
        }

        @Override
        @RosettaAttribute(value="transferFee", isRequired=true)
        @RuneAttribute(value="transferFee", isRequired=true)
        public LoanTransferFee getTransferFee() {
            return this.transferFee;
        }

        @Override
        @RosettaAttribute(value="loanTradingCounterpartyCashSettlementRulesModel", isRequired=true)
        @RuneAttribute(value="loanTradingCounterpartyCashSettlementRulesModel", isRequired=true)
        public LoanTradingCounterpartyCashSettlementRulesModel getLoanTradingCounterpartyCashSettlementRulesModel() {
            return this.loanTradingCounterpartyCashSettlementRulesModel;
        }

        @Override
        @RosettaAttribute(value="loanTradingParticipationSettlementTermsModel")
        @RuneAttribute(value="loanTradingParticipationSettlementTermsModel")
        public LoanTradingParticipationSettlementTermsModel getLoanTradingParticipationSettlementTermsModel() {
            return this.loanTradingParticipationSettlementTermsModel;
        }

        @Override
        public LoanTradeSequence build() {
            return this;
        }

        @Override
        public LoanTradeSequenceBuilder toBuilder() {
            LoanTradeSequenceBuilder builder = LoanTradeSequence.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LoanTradeSequenceBuilder builder) {
            Optional.ofNullable(this.getPrice()).ifPresent(builder::setPrice);
            Optional.ofNullable(this.getTransferFee()).ifPresent(builder::setTransferFee);
            Optional.ofNullable(this.getLoanTradingCounterpartyCashSettlementRulesModel()).ifPresent(builder::setLoanTradingCounterpartyCashSettlementRulesModel);
            Optional.ofNullable(this.getLoanTradingParticipationSettlementTermsModel()).ifPresent(builder::setLoanTradingParticipationSettlementTermsModel);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            LoanTradeSequence _that = this.getType().cast(o);
            if (!Objects.equals(this.price, _that.getPrice())) {
                return false;
            }
            if (!Objects.equals(this.transferFee, _that.getTransferFee())) {
                return false;
            }
            if (!Objects.equals(this.loanTradingCounterpartyCashSettlementRulesModel, _that.getLoanTradingCounterpartyCashSettlementRulesModel())) {
                return false;
            }
            return Objects.equals(this.loanTradingParticipationSettlementTermsModel, _that.getLoanTradingParticipationSettlementTermsModel());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.price != null ? this.price.hashCode() : 0);
            _result = 31 * _result + (this.transferFee != null ? this.transferFee.hashCode() : 0);
            _result = 31 * _result + (this.loanTradingCounterpartyCashSettlementRulesModel != null ? this.loanTradingCounterpartyCashSettlementRulesModel.hashCode() : 0);
            _result = 31 * _result + (this.loanTradingParticipationSettlementTermsModel != null ? this.loanTradingParticipationSettlementTermsModel.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "LoanTradeSequence {price=" + this.price + ", transferFee=" + this.transferFee + ", loanTradingCounterpartyCashSettlementRulesModel=" + this.loanTradingCounterpartyCashSettlementRulesModel + ", loanTradingParticipationSettlementTermsModel=" + this.loanTradingParticipationSettlementTermsModel + '}';
        }
    }
}

