/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.AdjustableOrRelativeDate;
import fpml.confirmation.DirectionalLeg;
import fpml.confirmation.InterestCalculation;
import fpml.confirmation.InterestLegCalculationPeriodDates;
import fpml.confirmation.LegAmount;
import fpml.confirmation.LegIdentifier;
import fpml.confirmation.PayerReceiverModel;
import fpml.confirmation.ReturnSwapNotional;
import fpml.confirmation.StubCalculationPeriod;
import fpml.confirmation.meta.InterestLegMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="InterestLeg", builder=InterestLegBuilderImpl.class, version="0.17.2")
@RuneDataType(value="InterestLeg", model="fpml", builder=InterestLegBuilderImpl.class, version="0.17.2")
public interface InterestLeg
extends DirectionalLeg {
    public static final InterestLegMeta metaData = new InterestLegMeta();

    public InterestLegCalculationPeriodDates getInterestLegCalculationPeriodDates();

    public ReturnSwapNotional getNotional();

    public LegAmount getInterestAmount();

    public InterestCalculation getInterestCalculation();

    public StubCalculationPeriod getStubCalculationPeriod();

    @Override
    public InterestLeg build();

    @Override
    public InterestLegBuilder toBuilder();

    public static InterestLegBuilder builder() {
        return new InterestLegBuilderImpl();
    }

    default public RosettaMetaData<? extends InterestLeg> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends InterestLeg> getType() {
        return InterestLeg.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("legIdentifier"), processor, LegIdentifier.class, this.getLegIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("payerReceiverModel"), processor, PayerReceiverModel.class, this.getPayerReceiverModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("effectiveDate"), processor, AdjustableOrRelativeDate.class, this.getEffectiveDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("terminationDate"), processor, AdjustableOrRelativeDate.class, this.getTerminationDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("interestLegCalculationPeriodDates"), processor, InterestLegCalculationPeriodDates.class, this.getInterestLegCalculationPeriodDates(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("notional"), processor, ReturnSwapNotional.class, this.getNotional(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("interestAmount"), processor, LegAmount.class, this.getInterestAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("interestCalculation"), processor, InterestCalculation.class, this.getInterestCalculation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("stubCalculationPeriod"), processor, StubCalculationPeriod.class, this.getStubCalculationPeriod(), new AttributeMeta[0]);
    }

    public static class InterestLegBuilderImpl
    extends DirectionalLeg.DirectionalLegBuilderImpl
    implements InterestLegBuilder {
        protected InterestLegCalculationPeriodDates.InterestLegCalculationPeriodDatesBuilder interestLegCalculationPeriodDates;
        protected ReturnSwapNotional.ReturnSwapNotionalBuilder notional;
        protected LegAmount.LegAmountBuilder interestAmount;
        protected InterestCalculation.InterestCalculationBuilder interestCalculation;
        protected StubCalculationPeriod.StubCalculationPeriodBuilder stubCalculationPeriod;

        @Override
        @RosettaAttribute(value="interestLegCalculationPeriodDates", isRequired=true)
        @RuneAttribute(value="interestLegCalculationPeriodDates", isRequired=true)
        public InterestLegCalculationPeriodDates.InterestLegCalculationPeriodDatesBuilder getInterestLegCalculationPeriodDates() {
            return this.interestLegCalculationPeriodDates;
        }

        @Override
        public InterestLegCalculationPeriodDates.InterestLegCalculationPeriodDatesBuilder getOrCreateInterestLegCalculationPeriodDates() {
            InterestLegCalculationPeriodDates.InterestLegCalculationPeriodDatesBuilder result = this.interestLegCalculationPeriodDates != null ? this.interestLegCalculationPeriodDates : (this.interestLegCalculationPeriodDates = InterestLegCalculationPeriodDates.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="notional", isRequired=true)
        @RuneAttribute(value="notional", isRequired=true)
        public ReturnSwapNotional.ReturnSwapNotionalBuilder getNotional() {
            return this.notional;
        }

        @Override
        public ReturnSwapNotional.ReturnSwapNotionalBuilder getOrCreateNotional() {
            ReturnSwapNotional.ReturnSwapNotionalBuilder result = this.notional != null ? this.notional : (this.notional = ReturnSwapNotional.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="interestAmount", isRequired=true)
        @RuneAttribute(value="interestAmount", isRequired=true)
        public LegAmount.LegAmountBuilder getInterestAmount() {
            return this.interestAmount;
        }

        @Override
        public LegAmount.LegAmountBuilder getOrCreateInterestAmount() {
            LegAmount.LegAmountBuilder result = this.interestAmount != null ? this.interestAmount : (this.interestAmount = LegAmount.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="interestCalculation", isRequired=true)
        @RuneAttribute(value="interestCalculation", isRequired=true)
        public InterestCalculation.InterestCalculationBuilder getInterestCalculation() {
            return this.interestCalculation;
        }

        @Override
        public InterestCalculation.InterestCalculationBuilder getOrCreateInterestCalculation() {
            InterestCalculation.InterestCalculationBuilder result = this.interestCalculation != null ? this.interestCalculation : (this.interestCalculation = InterestCalculation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="stubCalculationPeriod")
        @RuneAttribute(value="stubCalculationPeriod")
        public StubCalculationPeriod.StubCalculationPeriodBuilder getStubCalculationPeriod() {
            return this.stubCalculationPeriod;
        }

        @Override
        public StubCalculationPeriod.StubCalculationPeriodBuilder getOrCreateStubCalculationPeriod() {
            StubCalculationPeriod.StubCalculationPeriodBuilder result = this.stubCalculationPeriod != null ? this.stubCalculationPeriod : (this.stubCalculationPeriod = StubCalculationPeriod.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public InterestLegBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="legIdentifier")
        @RuneAttribute(value="legIdentifier")
        public InterestLegBuilder addLegIdentifier(LegIdentifier _legIdentifier) {
            if (_legIdentifier != null) {
                this.legIdentifier.add(_legIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public InterestLegBuilder addLegIdentifier(LegIdentifier _legIdentifier, int idx) {
            this.getIndex(this.legIdentifier, idx, () -> _legIdentifier.toBuilder());
            return this;
        }

        @Override
        public InterestLegBuilder addLegIdentifier(List<? extends LegIdentifier> legIdentifiers) {
            if (legIdentifiers != null) {
                for (LegIdentifier legIdentifier : legIdentifiers) {
                    this.legIdentifier.add(legIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="legIdentifier")
        public InterestLegBuilder setLegIdentifier(List<? extends LegIdentifier> legIdentifiers) {
            this.legIdentifier = legIdentifiers == null ? new ArrayList() : (List)legIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="payerReceiverModel", isRequired=true)
        @RuneAttribute(value="payerReceiverModel", isRequired=true)
        public InterestLegBuilder setPayerReceiverModel(PayerReceiverModel _payerReceiverModel) {
            this.payerReceiverModel = _payerReceiverModel == null ? null : _payerReceiverModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public InterestLegBuilder setEffectiveDate(AdjustableOrRelativeDate _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="terminationDate")
        @RuneAttribute(value="terminationDate")
        public InterestLegBuilder setTerminationDate(AdjustableOrRelativeDate _terminationDate) {
            this.terminationDate = _terminationDate == null ? null : _terminationDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="interestLegCalculationPeriodDates", isRequired=true)
        @RuneAttribute(value="interestLegCalculationPeriodDates", isRequired=true)
        public InterestLegBuilder setInterestLegCalculationPeriodDates(InterestLegCalculationPeriodDates _interestLegCalculationPeriodDates) {
            this.interestLegCalculationPeriodDates = _interestLegCalculationPeriodDates == null ? null : _interestLegCalculationPeriodDates.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="notional", isRequired=true)
        @RuneAttribute(value="notional", isRequired=true)
        public InterestLegBuilder setNotional(ReturnSwapNotional _notional) {
            this.notional = _notional == null ? null : _notional.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="interestAmount", isRequired=true)
        @RuneAttribute(value="interestAmount", isRequired=true)
        public InterestLegBuilder setInterestAmount(LegAmount _interestAmount) {
            this.interestAmount = _interestAmount == null ? null : _interestAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="interestCalculation", isRequired=true)
        @RuneAttribute(value="interestCalculation", isRequired=true)
        public InterestLegBuilder setInterestCalculation(InterestCalculation _interestCalculation) {
            this.interestCalculation = _interestCalculation == null ? null : _interestCalculation.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="stubCalculationPeriod")
        @RuneAttribute(value="stubCalculationPeriod")
        public InterestLegBuilder setStubCalculationPeriod(StubCalculationPeriod _stubCalculationPeriod) {
            this.stubCalculationPeriod = _stubCalculationPeriod == null ? null : _stubCalculationPeriod.toBuilder();
            return this;
        }

        @Override
        public InterestLeg build() {
            return new InterestLegImpl(this);
        }

        @Override
        public InterestLegBuilder toBuilder() {
            return this;
        }

        @Override
        public InterestLegBuilder prune() {
            super.prune();
            if (this.interestLegCalculationPeriodDates != null && !this.interestLegCalculationPeriodDates.prune().hasData()) {
                this.interestLegCalculationPeriodDates = null;
            }
            if (this.notional != null && !this.notional.prune().hasData()) {
                this.notional = null;
            }
            if (this.interestAmount != null && !this.interestAmount.prune().hasData()) {
                this.interestAmount = null;
            }
            if (this.interestCalculation != null && !this.interestCalculation.prune().hasData()) {
                this.interestCalculation = null;
            }
            if (this.stubCalculationPeriod != null && !this.stubCalculationPeriod.prune().hasData()) {
                this.stubCalculationPeriod = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getInterestLegCalculationPeriodDates() != null && this.getInterestLegCalculationPeriodDates().hasData()) {
                return true;
            }
            if (this.getNotional() != null && this.getNotional().hasData()) {
                return true;
            }
            if (this.getInterestAmount() != null && this.getInterestAmount().hasData()) {
                return true;
            }
            if (this.getInterestCalculation() != null && this.getInterestCalculation().hasData()) {
                return true;
            }
            return this.getStubCalculationPeriod() != null && this.getStubCalculationPeriod().hasData();
        }

        @Override
        public InterestLegBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            InterestLegBuilder o = (InterestLegBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getInterestLegCalculationPeriodDates(), (RosettaModelObjectBuilder)o.getInterestLegCalculationPeriodDates(), this::setInterestLegCalculationPeriodDates);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getNotional(), (RosettaModelObjectBuilder)o.getNotional(), this::setNotional);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getInterestAmount(), (RosettaModelObjectBuilder)o.getInterestAmount(), this::setInterestAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getInterestCalculation(), (RosettaModelObjectBuilder)o.getInterestCalculation(), this::setInterestCalculation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getStubCalculationPeriod(), (RosettaModelObjectBuilder)o.getStubCalculationPeriod(), this::setStubCalculationPeriod);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            InterestLeg _that = (InterestLeg)this.getType().cast(o);
            if (!Objects.equals(this.interestLegCalculationPeriodDates, _that.getInterestLegCalculationPeriodDates())) {
                return false;
            }
            if (!Objects.equals(this.notional, _that.getNotional())) {
                return false;
            }
            if (!Objects.equals(this.interestAmount, _that.getInterestAmount())) {
                return false;
            }
            if (!Objects.equals(this.interestCalculation, _that.getInterestCalculation())) {
                return false;
            }
            return Objects.equals(this.stubCalculationPeriod, _that.getStubCalculationPeriod());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.interestLegCalculationPeriodDates != null ? this.interestLegCalculationPeriodDates.hashCode() : 0);
            _result = 31 * _result + (this.notional != null ? this.notional.hashCode() : 0);
            _result = 31 * _result + (this.interestAmount != null ? this.interestAmount.hashCode() : 0);
            _result = 31 * _result + (this.interestCalculation != null ? this.interestCalculation.hashCode() : 0);
            _result = 31 * _result + (this.stubCalculationPeriod != null ? this.stubCalculationPeriod.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "InterestLegBuilder {interestLegCalculationPeriodDates=" + this.interestLegCalculationPeriodDates + ", notional=" + this.notional + ", interestAmount=" + this.interestAmount + ", interestCalculation=" + this.interestCalculation + ", stubCalculationPeriod=" + this.stubCalculationPeriod + '}' + " " + super.toString();
        }
    }

    public static interface InterestLegBuilder
    extends InterestLeg,
    DirectionalLeg.DirectionalLegBuilder {
        public InterestLegCalculationPeriodDates.InterestLegCalculationPeriodDatesBuilder getOrCreateInterestLegCalculationPeriodDates();

        @Override
        public InterestLegCalculationPeriodDates.InterestLegCalculationPeriodDatesBuilder getInterestLegCalculationPeriodDates();

        public ReturnSwapNotional.ReturnSwapNotionalBuilder getOrCreateNotional();

        @Override
        public ReturnSwapNotional.ReturnSwapNotionalBuilder getNotional();

        public LegAmount.LegAmountBuilder getOrCreateInterestAmount();

        @Override
        public LegAmount.LegAmountBuilder getInterestAmount();

        public InterestCalculation.InterestCalculationBuilder getOrCreateInterestCalculation();

        @Override
        public InterestCalculation.InterestCalculationBuilder getInterestCalculation();

        public StubCalculationPeriod.StubCalculationPeriodBuilder getOrCreateStubCalculationPeriod();

        @Override
        public StubCalculationPeriod.StubCalculationPeriodBuilder getStubCalculationPeriod();

        @Override
        public InterestLegBuilder setId(String var1);

        @Override
        public InterestLegBuilder addLegIdentifier(LegIdentifier var1);

        @Override
        public InterestLegBuilder addLegIdentifier(LegIdentifier var1, int var2);

        @Override
        public InterestLegBuilder addLegIdentifier(List<? extends LegIdentifier> var1);

        @Override
        public InterestLegBuilder setLegIdentifier(List<? extends LegIdentifier> var1);

        @Override
        public InterestLegBuilder setPayerReceiverModel(PayerReceiverModel var1);

        @Override
        public InterestLegBuilder setEffectiveDate(AdjustableOrRelativeDate var1);

        @Override
        public InterestLegBuilder setTerminationDate(AdjustableOrRelativeDate var1);

        public InterestLegBuilder setInterestLegCalculationPeriodDates(InterestLegCalculationPeriodDates var1);

        public InterestLegBuilder setNotional(ReturnSwapNotional var1);

        public InterestLegBuilder setInterestAmount(LegAmount var1);

        public InterestLegBuilder setInterestCalculation(InterestCalculation var1);

        public InterestLegBuilder setStubCalculationPeriod(StubCalculationPeriod var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("legIdentifier"), processor, LegIdentifier.LegIdentifierBuilder.class, this.getLegIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("payerReceiverModel"), processor, PayerReceiverModel.PayerReceiverModelBuilder.class, (RosettaModelObjectBuilder)this.getPayerReceiverModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("effectiveDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, (RosettaModelObjectBuilder)this.getEffectiveDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("terminationDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, (RosettaModelObjectBuilder)this.getTerminationDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("interestLegCalculationPeriodDates"), processor, InterestLegCalculationPeriodDates.InterestLegCalculationPeriodDatesBuilder.class, this.getInterestLegCalculationPeriodDates(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("notional"), processor, ReturnSwapNotional.ReturnSwapNotionalBuilder.class, this.getNotional(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("interestAmount"), processor, LegAmount.LegAmountBuilder.class, this.getInterestAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("interestCalculation"), processor, InterestCalculation.InterestCalculationBuilder.class, this.getInterestCalculation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("stubCalculationPeriod"), processor, StubCalculationPeriod.StubCalculationPeriodBuilder.class, this.getStubCalculationPeriod(), new AttributeMeta[0]);
        }

        @Override
        public InterestLegBuilder prune();
    }

    public static class InterestLegImpl
    extends DirectionalLeg.DirectionalLegImpl
    implements InterestLeg {
        private final InterestLegCalculationPeriodDates interestLegCalculationPeriodDates;
        private final ReturnSwapNotional notional;
        private final LegAmount interestAmount;
        private final InterestCalculation interestCalculation;
        private final StubCalculationPeriod stubCalculationPeriod;

        protected InterestLegImpl(InterestLegBuilder builder) {
            super(builder);
            this.interestLegCalculationPeriodDates = Optional.ofNullable(builder.getInterestLegCalculationPeriodDates()).map(f -> f.build()).orElse(null);
            this.notional = Optional.ofNullable(builder.getNotional()).map(f -> f.build()).orElse(null);
            this.interestAmount = Optional.ofNullable(builder.getInterestAmount()).map(f -> f.build()).orElse(null);
            this.interestCalculation = Optional.ofNullable(builder.getInterestCalculation()).map(f -> f.build()).orElse(null);
            this.stubCalculationPeriod = Optional.ofNullable(builder.getStubCalculationPeriod()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="interestLegCalculationPeriodDates", isRequired=true)
        @RuneAttribute(value="interestLegCalculationPeriodDates", isRequired=true)
        public InterestLegCalculationPeriodDates getInterestLegCalculationPeriodDates() {
            return this.interestLegCalculationPeriodDates;
        }

        @Override
        @RosettaAttribute(value="notional", isRequired=true)
        @RuneAttribute(value="notional", isRequired=true)
        public ReturnSwapNotional getNotional() {
            return this.notional;
        }

        @Override
        @RosettaAttribute(value="interestAmount", isRequired=true)
        @RuneAttribute(value="interestAmount", isRequired=true)
        public LegAmount getInterestAmount() {
            return this.interestAmount;
        }

        @Override
        @RosettaAttribute(value="interestCalculation", isRequired=true)
        @RuneAttribute(value="interestCalculation", isRequired=true)
        public InterestCalculation getInterestCalculation() {
            return this.interestCalculation;
        }

        @Override
        @RosettaAttribute(value="stubCalculationPeriod")
        @RuneAttribute(value="stubCalculationPeriod")
        public StubCalculationPeriod getStubCalculationPeriod() {
            return this.stubCalculationPeriod;
        }

        @Override
        public InterestLeg build() {
            return this;
        }

        @Override
        public InterestLegBuilder toBuilder() {
            InterestLegBuilder builder = InterestLeg.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(InterestLegBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getInterestLegCalculationPeriodDates()).ifPresent(builder::setInterestLegCalculationPeriodDates);
            Optional.ofNullable(this.getNotional()).ifPresent(builder::setNotional);
            Optional.ofNullable(this.getInterestAmount()).ifPresent(builder::setInterestAmount);
            Optional.ofNullable(this.getInterestCalculation()).ifPresent(builder::setInterestCalculation);
            Optional.ofNullable(this.getStubCalculationPeriod()).ifPresent(builder::setStubCalculationPeriod);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            InterestLeg _that = (InterestLeg)this.getType().cast(o);
            if (!Objects.equals(this.interestLegCalculationPeriodDates, _that.getInterestLegCalculationPeriodDates())) {
                return false;
            }
            if (!Objects.equals(this.notional, _that.getNotional())) {
                return false;
            }
            if (!Objects.equals(this.interestAmount, _that.getInterestAmount())) {
                return false;
            }
            if (!Objects.equals(this.interestCalculation, _that.getInterestCalculation())) {
                return false;
            }
            return Objects.equals(this.stubCalculationPeriod, _that.getStubCalculationPeriod());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.interestLegCalculationPeriodDates != null ? this.interestLegCalculationPeriodDates.hashCode() : 0);
            _result = 31 * _result + (this.notional != null ? this.notional.hashCode() : 0);
            _result = 31 * _result + (this.interestAmount != null ? this.interestAmount.hashCode() : 0);
            _result = 31 * _result + (this.interestCalculation != null ? this.interestCalculation.hashCode() : 0);
            _result = 31 * _result + (this.stubCalculationPeriod != null ? this.stubCalculationPeriod.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "InterestLeg {interestLegCalculationPeriodDates=" + this.interestLegCalculationPeriodDates + ", notional=" + this.notional + ", interestAmount=" + this.interestAmount + ", interestCalculation=" + this.interestCalculation + ", stubCalculationPeriod=" + this.stubCalculationPeriod + '}' + " " + super.toString();
        }
    }
}

