/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.confirmation.AdjustableDate2;
import fpml.confirmation.GenericExerciseStyle;
import fpml.confirmation.GenericOptionStrike;
import fpml.confirmation.GenericProductFeature;
import fpml.confirmation.OptionType;
import fpml.confirmation.meta.GenericOptionAttributesModelMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="GenericOptionAttributesModel", builder=GenericOptionAttributesModelBuilderImpl.class, version="0.17.2")
@RuneDataType(value="GenericOptionAttributesModel", model="fpml", builder=GenericOptionAttributesModelBuilderImpl.class, version="0.17.2")
public interface GenericOptionAttributesModel
extends RosettaModelObject {
    public static final GenericOptionAttributesModelMeta metaData = new GenericOptionAttributesModelMeta();

    public OptionType getOptionType();

    public AdjustableDate2 getCommencementDate();

    public GenericExerciseStyle getExerciseStyle();

    public List<? extends GenericOptionStrike> getStrike();

    public List<? extends GenericProductFeature> getFeature();

    public GenericOptionAttributesModel build();

    public GenericOptionAttributesModelBuilder toBuilder();

    public static GenericOptionAttributesModelBuilder builder() {
        return new GenericOptionAttributesModelBuilderImpl();
    }

    default public RosettaMetaData<? extends GenericOptionAttributesModel> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends GenericOptionAttributesModel> getType() {
        return GenericOptionAttributesModel.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("optionType"), processor, OptionType.class, this.getOptionType(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("commencementDate"), processor, AdjustableDate2.class, this.getCommencementDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exerciseStyle"), processor, GenericExerciseStyle.class, this.getExerciseStyle(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("strike"), processor, GenericOptionStrike.class, this.getStrike(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("feature"), processor, GenericProductFeature.class, this.getFeature(), new AttributeMeta[0]);
    }

    public static class GenericOptionAttributesModelBuilderImpl
    implements GenericOptionAttributesModelBuilder {
        protected OptionType.OptionTypeBuilder optionType;
        protected AdjustableDate2.AdjustableDate2Builder commencementDate;
        protected GenericExerciseStyle.GenericExerciseStyleBuilder exerciseStyle;
        protected List<GenericOptionStrike.GenericOptionStrikeBuilder> strike = new ArrayList<GenericOptionStrike.GenericOptionStrikeBuilder>();
        protected List<GenericProductFeature.GenericProductFeatureBuilder> feature = new ArrayList<GenericProductFeature.GenericProductFeatureBuilder>();

        @Override
        @RosettaAttribute(value="optionType")
        @RuneAttribute(value="optionType")
        public OptionType.OptionTypeBuilder getOptionType() {
            return this.optionType;
        }

        @Override
        public OptionType.OptionTypeBuilder getOrCreateOptionType() {
            OptionType.OptionTypeBuilder result = this.optionType != null ? this.optionType : (this.optionType = OptionType.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="commencementDate")
        @RuneAttribute(value="commencementDate")
        public AdjustableDate2.AdjustableDate2Builder getCommencementDate() {
            return this.commencementDate;
        }

        @Override
        public AdjustableDate2.AdjustableDate2Builder getOrCreateCommencementDate() {
            AdjustableDate2.AdjustableDate2Builder result = this.commencementDate != null ? this.commencementDate : (this.commencementDate = AdjustableDate2.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="exerciseStyle")
        @RuneAttribute(value="exerciseStyle")
        public GenericExerciseStyle.GenericExerciseStyleBuilder getExerciseStyle() {
            return this.exerciseStyle;
        }

        @Override
        public GenericExerciseStyle.GenericExerciseStyleBuilder getOrCreateExerciseStyle() {
            GenericExerciseStyle.GenericExerciseStyleBuilder result = this.exerciseStyle != null ? this.exerciseStyle : (this.exerciseStyle = GenericExerciseStyle.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="strike")
        @RuneAttribute(value="strike")
        public List<? extends GenericOptionStrike.GenericOptionStrikeBuilder> getStrike() {
            return this.strike;
        }

        @Override
        public GenericOptionStrike.GenericOptionStrikeBuilder getOrCreateStrike(int index) {
            if (this.strike == null) {
                this.strike = new ArrayList<GenericOptionStrike.GenericOptionStrikeBuilder>();
            }
            return (GenericOptionStrike.GenericOptionStrikeBuilder)this.getIndex(this.strike, index, () -> {
                GenericOptionStrike.GenericOptionStrikeBuilder newStrike = GenericOptionStrike.builder();
                return newStrike;
            });
        }

        @Override
        @RosettaAttribute(value="feature")
        @RuneAttribute(value="feature")
        public List<? extends GenericProductFeature.GenericProductFeatureBuilder> getFeature() {
            return this.feature;
        }

        @Override
        public GenericProductFeature.GenericProductFeatureBuilder getOrCreateFeature(int index) {
            if (this.feature == null) {
                this.feature = new ArrayList<GenericProductFeature.GenericProductFeatureBuilder>();
            }
            return (GenericProductFeature.GenericProductFeatureBuilder)this.getIndex(this.feature, index, () -> {
                GenericProductFeature.GenericProductFeatureBuilder newFeature = GenericProductFeature.builder();
                return newFeature;
            });
        }

        @Override
        @RosettaAttribute(value="optionType")
        @RuneAttribute(value="optionType")
        public GenericOptionAttributesModelBuilder setOptionType(OptionType _optionType) {
            this.optionType = _optionType == null ? null : _optionType.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="commencementDate")
        @RuneAttribute(value="commencementDate")
        public GenericOptionAttributesModelBuilder setCommencementDate(AdjustableDate2 _commencementDate) {
            this.commencementDate = _commencementDate == null ? null : _commencementDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exerciseStyle")
        @RuneAttribute(value="exerciseStyle")
        public GenericOptionAttributesModelBuilder setExerciseStyle(GenericExerciseStyle _exerciseStyle) {
            this.exerciseStyle = _exerciseStyle == null ? null : _exerciseStyle.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="strike")
        @RuneAttribute(value="strike")
        public GenericOptionAttributesModelBuilder addStrike(GenericOptionStrike _strike) {
            if (_strike != null) {
                this.strike.add(_strike.toBuilder());
            }
            return this;
        }

        @Override
        public GenericOptionAttributesModelBuilder addStrike(GenericOptionStrike _strike, int idx) {
            this.getIndex(this.strike, idx, () -> _strike.toBuilder());
            return this;
        }

        @Override
        public GenericOptionAttributesModelBuilder addStrike(List<? extends GenericOptionStrike> strikes) {
            if (strikes != null) {
                for (GenericOptionStrike genericOptionStrike : strikes) {
                    this.strike.add(genericOptionStrike.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="strike")
        public GenericOptionAttributesModelBuilder setStrike(List<? extends GenericOptionStrike> strikes) {
            this.strike = strikes == null ? new ArrayList<GenericOptionStrike.GenericOptionStrikeBuilder>() : (List)strikes.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="feature")
        @RuneAttribute(value="feature")
        public GenericOptionAttributesModelBuilder addFeature(GenericProductFeature _feature) {
            if (_feature != null) {
                this.feature.add(_feature.toBuilder());
            }
            return this;
        }

        @Override
        public GenericOptionAttributesModelBuilder addFeature(GenericProductFeature _feature, int idx) {
            this.getIndex(this.feature, idx, () -> _feature.toBuilder());
            return this;
        }

        @Override
        public GenericOptionAttributesModelBuilder addFeature(List<? extends GenericProductFeature> features) {
            if (features != null) {
                for (GenericProductFeature genericProductFeature : features) {
                    this.feature.add(genericProductFeature.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="feature")
        public GenericOptionAttributesModelBuilder setFeature(List<? extends GenericProductFeature> features) {
            this.feature = features == null ? new ArrayList<GenericProductFeature.GenericProductFeatureBuilder>() : (List)features.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public GenericOptionAttributesModel build() {
            return new GenericOptionAttributesModelImpl(this);
        }

        @Override
        public GenericOptionAttributesModelBuilder toBuilder() {
            return this;
        }

        @Override
        public GenericOptionAttributesModelBuilder prune() {
            if (this.optionType != null && !this.optionType.prune().hasData()) {
                this.optionType = null;
            }
            if (this.commencementDate != null && !this.commencementDate.prune().hasData()) {
                this.commencementDate = null;
            }
            if (this.exerciseStyle != null && !this.exerciseStyle.prune().hasData()) {
                this.exerciseStyle = null;
            }
            this.strike = this.strike.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.feature = this.feature.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getOptionType() != null && this.getOptionType().hasData()) {
                return true;
            }
            if (this.getCommencementDate() != null && this.getCommencementDate().hasData()) {
                return true;
            }
            if (this.getExerciseStyle() != null && this.getExerciseStyle().hasData()) {
                return true;
            }
            if (this.getStrike() != null && this.getStrike().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getFeature() != null && this.getFeature().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public GenericOptionAttributesModelBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            GenericOptionAttributesModelBuilder o = (GenericOptionAttributesModelBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getOptionType(), (RosettaModelObjectBuilder)o.getOptionType(), this::setOptionType);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCommencementDate(), (RosettaModelObjectBuilder)o.getCommencementDate(), this::setCommencementDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExerciseStyle(), (RosettaModelObjectBuilder)o.getExerciseStyle(), this::setExerciseStyle);
            merger.mergeRosetta(this.getStrike(), o.getStrike(), this::getOrCreateStrike);
            merger.mergeRosetta(this.getFeature(), o.getFeature(), this::getOrCreateFeature);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            GenericOptionAttributesModel _that = this.getType().cast(o);
            if (!Objects.equals(this.optionType, _that.getOptionType())) {
                return false;
            }
            if (!Objects.equals(this.commencementDate, _that.getCommencementDate())) {
                return false;
            }
            if (!Objects.equals(this.exerciseStyle, _that.getExerciseStyle())) {
                return false;
            }
            if (!ListEquals.listEquals(this.strike, _that.getStrike())) {
                return false;
            }
            return ListEquals.listEquals(this.feature, _that.getFeature());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.optionType != null ? this.optionType.hashCode() : 0);
            _result = 31 * _result + (this.commencementDate != null ? this.commencementDate.hashCode() : 0);
            _result = 31 * _result + (this.exerciseStyle != null ? this.exerciseStyle.hashCode() : 0);
            _result = 31 * _result + (this.strike != null ? this.strike.hashCode() : 0);
            _result = 31 * _result + (this.feature != null ? this.feature.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "GenericOptionAttributesModelBuilder {optionType=" + this.optionType + ", commencementDate=" + this.commencementDate + ", exerciseStyle=" + this.exerciseStyle + ", strike=" + this.strike + ", feature=" + this.feature + '}';
        }
    }

    public static interface GenericOptionAttributesModelBuilder
    extends GenericOptionAttributesModel,
    RosettaModelObjectBuilder {
        public OptionType.OptionTypeBuilder getOrCreateOptionType();

        @Override
        public OptionType.OptionTypeBuilder getOptionType();

        public AdjustableDate2.AdjustableDate2Builder getOrCreateCommencementDate();

        @Override
        public AdjustableDate2.AdjustableDate2Builder getCommencementDate();

        public GenericExerciseStyle.GenericExerciseStyleBuilder getOrCreateExerciseStyle();

        @Override
        public GenericExerciseStyle.GenericExerciseStyleBuilder getExerciseStyle();

        public GenericOptionStrike.GenericOptionStrikeBuilder getOrCreateStrike(int var1);

        public List<? extends GenericOptionStrike.GenericOptionStrikeBuilder> getStrike();

        public GenericProductFeature.GenericProductFeatureBuilder getOrCreateFeature(int var1);

        public List<? extends GenericProductFeature.GenericProductFeatureBuilder> getFeature();

        public GenericOptionAttributesModelBuilder setOptionType(OptionType var1);

        public GenericOptionAttributesModelBuilder setCommencementDate(AdjustableDate2 var1);

        public GenericOptionAttributesModelBuilder setExerciseStyle(GenericExerciseStyle var1);

        public GenericOptionAttributesModelBuilder addStrike(GenericOptionStrike var1);

        public GenericOptionAttributesModelBuilder addStrike(GenericOptionStrike var1, int var2);

        public GenericOptionAttributesModelBuilder addStrike(List<? extends GenericOptionStrike> var1);

        public GenericOptionAttributesModelBuilder setStrike(List<? extends GenericOptionStrike> var1);

        public GenericOptionAttributesModelBuilder addFeature(GenericProductFeature var1);

        public GenericOptionAttributesModelBuilder addFeature(GenericProductFeature var1, int var2);

        public GenericOptionAttributesModelBuilder addFeature(List<? extends GenericProductFeature> var1);

        public GenericOptionAttributesModelBuilder setFeature(List<? extends GenericProductFeature> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("optionType"), processor, OptionType.OptionTypeBuilder.class, this.getOptionType(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("commencementDate"), processor, AdjustableDate2.AdjustableDate2Builder.class, this.getCommencementDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exerciseStyle"), processor, GenericExerciseStyle.GenericExerciseStyleBuilder.class, this.getExerciseStyle(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("strike"), processor, GenericOptionStrike.GenericOptionStrikeBuilder.class, this.getStrike(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("feature"), processor, GenericProductFeature.GenericProductFeatureBuilder.class, this.getFeature(), new AttributeMeta[0]);
        }

        public GenericOptionAttributesModelBuilder prune();
    }

    public static class GenericOptionAttributesModelImpl
    implements GenericOptionAttributesModel {
        private final OptionType optionType;
        private final AdjustableDate2 commencementDate;
        private final GenericExerciseStyle exerciseStyle;
        private final List<? extends GenericOptionStrike> strike;
        private final List<? extends GenericProductFeature> feature;

        protected GenericOptionAttributesModelImpl(GenericOptionAttributesModelBuilder builder) {
            this.optionType = Optional.ofNullable(builder.getOptionType()).map(f -> f.build()).orElse(null);
            this.commencementDate = Optional.ofNullable(builder.getCommencementDate()).map(f -> f.build()).orElse(null);
            this.exerciseStyle = Optional.ofNullable(builder.getExerciseStyle()).map(f -> f.build()).orElse(null);
            this.strike = Optional.ofNullable(builder.getStrike()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.feature = Optional.ofNullable(builder.getFeature()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="optionType")
        @RuneAttribute(value="optionType")
        public OptionType getOptionType() {
            return this.optionType;
        }

        @Override
        @RosettaAttribute(value="commencementDate")
        @RuneAttribute(value="commencementDate")
        public AdjustableDate2 getCommencementDate() {
            return this.commencementDate;
        }

        @Override
        @RosettaAttribute(value="exerciseStyle")
        @RuneAttribute(value="exerciseStyle")
        public GenericExerciseStyle getExerciseStyle() {
            return this.exerciseStyle;
        }

        @Override
        @RosettaAttribute(value="strike")
        @RuneAttribute(value="strike")
        public List<? extends GenericOptionStrike> getStrike() {
            return this.strike;
        }

        @Override
        @RosettaAttribute(value="feature")
        @RuneAttribute(value="feature")
        public List<? extends GenericProductFeature> getFeature() {
            return this.feature;
        }

        @Override
        public GenericOptionAttributesModel build() {
            return this;
        }

        @Override
        public GenericOptionAttributesModelBuilder toBuilder() {
            GenericOptionAttributesModelBuilder builder = GenericOptionAttributesModel.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(GenericOptionAttributesModelBuilder builder) {
            Optional.ofNullable(this.getOptionType()).ifPresent(builder::setOptionType);
            Optional.ofNullable(this.getCommencementDate()).ifPresent(builder::setCommencementDate);
            Optional.ofNullable(this.getExerciseStyle()).ifPresent(builder::setExerciseStyle);
            Optional.ofNullable(this.getStrike()).ifPresent(builder::setStrike);
            Optional.ofNullable(this.getFeature()).ifPresent(builder::setFeature);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            GenericOptionAttributesModel _that = this.getType().cast(o);
            if (!Objects.equals(this.optionType, _that.getOptionType())) {
                return false;
            }
            if (!Objects.equals(this.commencementDate, _that.getCommencementDate())) {
                return false;
            }
            if (!Objects.equals(this.exerciseStyle, _that.getExerciseStyle())) {
                return false;
            }
            if (!ListEquals.listEquals(this.strike, _that.getStrike())) {
                return false;
            }
            return ListEquals.listEquals(this.feature, _that.getFeature());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.optionType != null ? this.optionType.hashCode() : 0);
            _result = 31 * _result + (this.commencementDate != null ? this.commencementDate.hashCode() : 0);
            _result = 31 * _result + (this.exerciseStyle != null ? this.exerciseStyle.hashCode() : 0);
            _result = 31 * _result + (this.strike != null ? this.strike.hashCode() : 0);
            _result = 31 * _result + (this.feature != null ? this.feature.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "GenericOptionAttributesModel {optionType=" + this.optionType + ", commencementDate=" + this.commencementDate + ", exerciseStyle=" + this.exerciseStyle + ", strike=" + this.strike + ", feature=" + this.feature + '}';
        }
    }
}

