/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.confirmation.FxTriggerBase;
import fpml.confirmation.InformationSource;
import fpml.confirmation.QuotedCurrencyPair;
import fpml.confirmation.TriggerConditionEnum;
import fpml.confirmation.meta.FxTriggerMeta;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="FxTrigger", builder=FxTriggerBuilderImpl.class, version="0.17.2")
@RuneDataType(value="FxTrigger", model="fpml", builder=FxTriggerBuilderImpl.class, version="0.17.2")
public interface FxTrigger
extends FxTriggerBase {
    public static final FxTriggerMeta metaData = new FxTriggerMeta();

    public List<? extends InformationSource> getInformationSource();

    @Override
    public FxTrigger build();

    @Override
    public FxTriggerBuilder toBuilder();

    public static FxTriggerBuilder builder() {
        return new FxTriggerBuilderImpl();
    }

    default public RosettaMetaData<? extends FxTrigger> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FxTrigger> getType() {
        return FxTrigger.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("triggerCondition"), TriggerConditionEnum.class, (Object)this.getTriggerCondition(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("quotedCurrencyPair"), processor, QuotedCurrencyPair.class, this.getQuotedCurrencyPair(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("triggerRate"), BigDecimal.class, (Object)this.getTriggerRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("spotRate"), BigDecimal.class, (Object)this.getSpotRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("informationSource"), processor, InformationSource.class, this.getInformationSource(), new AttributeMeta[0]);
    }

    public static class FxTriggerBuilderImpl
    extends FxTriggerBase.FxTriggerBaseBuilderImpl
    implements FxTriggerBuilder {
        protected List<InformationSource.InformationSourceBuilder> informationSource = new ArrayList<InformationSource.InformationSourceBuilder>();

        @Override
        @RosettaAttribute(value="informationSource", isRequired=true)
        @RuneAttribute(value="informationSource", isRequired=true)
        public List<? extends InformationSource.InformationSourceBuilder> getInformationSource() {
            return this.informationSource;
        }

        @Override
        public InformationSource.InformationSourceBuilder getOrCreateInformationSource(int index) {
            if (this.informationSource == null) {
                this.informationSource = new ArrayList<InformationSource.InformationSourceBuilder>();
            }
            return (InformationSource.InformationSourceBuilder)this.getIndex(this.informationSource, index, () -> {
                InformationSource.InformationSourceBuilder newInformationSource = InformationSource.builder();
                return newInformationSource;
            });
        }

        @Override
        @RosettaAttribute(value="triggerCondition", isRequired=true)
        @RuneAttribute(value="triggerCondition", isRequired=true)
        public FxTriggerBuilder setTriggerCondition(TriggerConditionEnum _triggerCondition) {
            this.triggerCondition = _triggerCondition == null ? null : _triggerCondition;
            return this;
        }

        @Override
        @RosettaAttribute(value="quotedCurrencyPair", isRequired=true)
        @RuneAttribute(value="quotedCurrencyPair", isRequired=true)
        public FxTriggerBuilder setQuotedCurrencyPair(QuotedCurrencyPair _quotedCurrencyPair) {
            this.quotedCurrencyPair = _quotedCurrencyPair == null ? null : _quotedCurrencyPair.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="triggerRate", isRequired=true)
        @RuneAttribute(value="triggerRate", isRequired=true)
        public FxTriggerBuilder setTriggerRate(BigDecimal _triggerRate) {
            this.triggerRate = _triggerRate == null ? null : _triggerRate;
            return this;
        }

        @Override
        @RosettaAttribute(value="spotRate")
        @RuneAttribute(value="spotRate")
        public FxTriggerBuilder setSpotRate(BigDecimal _spotRate) {
            this.spotRate = _spotRate == null ? null : _spotRate;
            return this;
        }

        @Override
        @RosettaAttribute(value="informationSource", isRequired=true)
        @RuneAttribute(value="informationSource", isRequired=true)
        public FxTriggerBuilder addInformationSource(InformationSource _informationSource) {
            if (_informationSource != null) {
                this.informationSource.add(_informationSource.toBuilder());
            }
            return this;
        }

        @Override
        public FxTriggerBuilder addInformationSource(InformationSource _informationSource, int idx) {
            this.getIndex(this.informationSource, idx, () -> _informationSource.toBuilder());
            return this;
        }

        @Override
        public FxTriggerBuilder addInformationSource(List<? extends InformationSource> informationSources) {
            if (informationSources != null) {
                for (InformationSource informationSource : informationSources) {
                    this.informationSource.add(informationSource.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="informationSource")
        public FxTriggerBuilder setInformationSource(List<? extends InformationSource> informationSources) {
            this.informationSource = informationSources == null ? new ArrayList<InformationSource.InformationSourceBuilder>() : (List)informationSources.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public FxTrigger build() {
            return new FxTriggerImpl(this);
        }

        @Override
        public FxTriggerBuilder toBuilder() {
            return this;
        }

        @Override
        public FxTriggerBuilder prune() {
            super.prune();
            this.informationSource = this.informationSource.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            return this.getInformationSource() != null && this.getInformationSource().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public FxTriggerBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            FxTriggerBuilder o = (FxTriggerBuilder)other;
            merger.mergeRosetta(this.getInformationSource(), o.getInformationSource(), this::getOrCreateInformationSource);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FxTrigger _that = (FxTrigger)this.getType().cast(o);
            return ListEquals.listEquals(this.informationSource, _that.getInformationSource());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.informationSource != null ? this.informationSource.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FxTriggerBuilder {informationSource=" + this.informationSource + '}' + " " + super.toString();
        }
    }

    public static interface FxTriggerBuilder
    extends FxTrigger,
    FxTriggerBase.FxTriggerBaseBuilder {
        public InformationSource.InformationSourceBuilder getOrCreateInformationSource(int var1);

        public List<? extends InformationSource.InformationSourceBuilder> getInformationSource();

        @Override
        public FxTriggerBuilder setTriggerCondition(TriggerConditionEnum var1);

        @Override
        public FxTriggerBuilder setQuotedCurrencyPair(QuotedCurrencyPair var1);

        @Override
        public FxTriggerBuilder setTriggerRate(BigDecimal var1);

        @Override
        public FxTriggerBuilder setSpotRate(BigDecimal var1);

        public FxTriggerBuilder addInformationSource(InformationSource var1);

        public FxTriggerBuilder addInformationSource(InformationSource var1, int var2);

        public FxTriggerBuilder addInformationSource(List<? extends InformationSource> var1);

        public FxTriggerBuilder setInformationSource(List<? extends InformationSource> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("triggerCondition"), TriggerConditionEnum.class, (Object)this.getTriggerCondition(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("quotedCurrencyPair"), processor, QuotedCurrencyPair.QuotedCurrencyPairBuilder.class, (RosettaModelObjectBuilder)this.getQuotedCurrencyPair(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("triggerRate"), BigDecimal.class, (Object)this.getTriggerRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("spotRate"), BigDecimal.class, (Object)this.getSpotRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("informationSource"), processor, InformationSource.InformationSourceBuilder.class, this.getInformationSource(), new AttributeMeta[0]);
        }

        @Override
        public FxTriggerBuilder prune();
    }

    public static class FxTriggerImpl
    extends FxTriggerBase.FxTriggerBaseImpl
    implements FxTrigger {
        private final List<? extends InformationSource> informationSource;

        protected FxTriggerImpl(FxTriggerBuilder builder) {
            super(builder);
            this.informationSource = Optional.ofNullable(builder.getInformationSource()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="informationSource", isRequired=true)
        @RuneAttribute(value="informationSource", isRequired=true)
        public List<? extends InformationSource> getInformationSource() {
            return this.informationSource;
        }

        @Override
        public FxTrigger build() {
            return this;
        }

        @Override
        public FxTriggerBuilder toBuilder() {
            FxTriggerBuilder builder = FxTrigger.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FxTriggerBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getInformationSource()).ifPresent(builder::setInformationSource);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FxTrigger _that = (FxTrigger)this.getType().cast(o);
            return ListEquals.listEquals(this.informationSource, _that.getInformationSource());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.informationSource != null ? this.informationSource.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FxTrigger {informationSource=" + this.informationSource + '}' + " " + super.toString();
        }
    }
}

