/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.FxOutstandingGain;
import fpml.confirmation.SimplePayment;
import fpml.confirmation.meta.FxTargetRebateMeta;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="FxTargetRebate", builder=FxTargetRebateBuilderImpl.class, version="0.17.2")
@RuneDataType(value="FxTargetRebate", model="fpml", builder=FxTargetRebateBuilderImpl.class, version="0.17.2")
public interface FxTargetRebate
extends RosettaModelObject {
    public static final FxTargetRebateMeta metaData = new FxTargetRebateMeta();

    public SimplePayment getPayment();

    public FxOutstandingGain getOutstandingGain();

    public FxTargetRebate build();

    public FxTargetRebateBuilder toBuilder();

    public static FxTargetRebateBuilder builder() {
        return new FxTargetRebateBuilderImpl();
    }

    default public RosettaMetaData<? extends FxTargetRebate> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FxTargetRebate> getType() {
        return FxTargetRebate.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("payment"), processor, SimplePayment.class, this.getPayment(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("outstandingGain"), processor, FxOutstandingGain.class, this.getOutstandingGain(), new AttributeMeta[0]);
    }

    public static class FxTargetRebateBuilderImpl
    implements FxTargetRebateBuilder {
        protected SimplePayment.SimplePaymentBuilder payment;
        protected FxOutstandingGain.FxOutstandingGainBuilder outstandingGain;

        @Override
        @RosettaAttribute(value="payment")
        @RuneAttribute(value="payment")
        public SimplePayment.SimplePaymentBuilder getPayment() {
            return this.payment;
        }

        @Override
        public SimplePayment.SimplePaymentBuilder getOrCreatePayment() {
            SimplePayment.SimplePaymentBuilder result = this.payment != null ? this.payment : (this.payment = SimplePayment.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="outstandingGain")
        @RuneAttribute(value="outstandingGain")
        public FxOutstandingGain.FxOutstandingGainBuilder getOutstandingGain() {
            return this.outstandingGain;
        }

        @Override
        public FxOutstandingGain.FxOutstandingGainBuilder getOrCreateOutstandingGain() {
            FxOutstandingGain.FxOutstandingGainBuilder result = this.outstandingGain != null ? this.outstandingGain : (this.outstandingGain = FxOutstandingGain.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="payment")
        @RuneAttribute(value="payment")
        public FxTargetRebateBuilder setPayment(SimplePayment _payment) {
            this.payment = _payment == null ? null : _payment.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="outstandingGain")
        @RuneAttribute(value="outstandingGain")
        public FxTargetRebateBuilder setOutstandingGain(FxOutstandingGain _outstandingGain) {
            this.outstandingGain = _outstandingGain == null ? null : _outstandingGain.toBuilder();
            return this;
        }

        @Override
        public FxTargetRebate build() {
            return new FxTargetRebateImpl(this);
        }

        @Override
        public FxTargetRebateBuilder toBuilder() {
            return this;
        }

        @Override
        public FxTargetRebateBuilder prune() {
            if (this.payment != null && !this.payment.prune().hasData()) {
                this.payment = null;
            }
            if (this.outstandingGain != null && !this.outstandingGain.prune().hasData()) {
                this.outstandingGain = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getPayment() != null && this.getPayment().hasData()) {
                return true;
            }
            return this.getOutstandingGain() != null && this.getOutstandingGain().hasData();
        }

        public FxTargetRebateBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            FxTargetRebateBuilder o = (FxTargetRebateBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPayment(), (RosettaModelObjectBuilder)o.getPayment(), this::setPayment);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getOutstandingGain(), (RosettaModelObjectBuilder)o.getOutstandingGain(), this::setOutstandingGain);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FxTargetRebate _that = this.getType().cast(o);
            if (!Objects.equals(this.payment, _that.getPayment())) {
                return false;
            }
            return Objects.equals(this.outstandingGain, _that.getOutstandingGain());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.payment != null ? this.payment.hashCode() : 0);
            _result = 31 * _result + (this.outstandingGain != null ? this.outstandingGain.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FxTargetRebateBuilder {payment=" + this.payment + ", outstandingGain=" + this.outstandingGain + '}';
        }
    }

    public static interface FxTargetRebateBuilder
    extends FxTargetRebate,
    RosettaModelObjectBuilder {
        public SimplePayment.SimplePaymentBuilder getOrCreatePayment();

        @Override
        public SimplePayment.SimplePaymentBuilder getPayment();

        public FxOutstandingGain.FxOutstandingGainBuilder getOrCreateOutstandingGain();

        @Override
        public FxOutstandingGain.FxOutstandingGainBuilder getOutstandingGain();

        public FxTargetRebateBuilder setPayment(SimplePayment var1);

        public FxTargetRebateBuilder setOutstandingGain(FxOutstandingGain var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("payment"), processor, SimplePayment.SimplePaymentBuilder.class, this.getPayment(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("outstandingGain"), processor, FxOutstandingGain.FxOutstandingGainBuilder.class, this.getOutstandingGain(), new AttributeMeta[0]);
        }

        public FxTargetRebateBuilder prune();
    }

    public static class FxTargetRebateImpl
    implements FxTargetRebate {
        private final SimplePayment payment;
        private final FxOutstandingGain outstandingGain;

        protected FxTargetRebateImpl(FxTargetRebateBuilder builder) {
            this.payment = Optional.ofNullable(builder.getPayment()).map(f -> f.build()).orElse(null);
            this.outstandingGain = Optional.ofNullable(builder.getOutstandingGain()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="payment")
        @RuneAttribute(value="payment")
        public SimplePayment getPayment() {
            return this.payment;
        }

        @Override
        @RosettaAttribute(value="outstandingGain")
        @RuneAttribute(value="outstandingGain")
        public FxOutstandingGain getOutstandingGain() {
            return this.outstandingGain;
        }

        @Override
        public FxTargetRebate build() {
            return this;
        }

        @Override
        public FxTargetRebateBuilder toBuilder() {
            FxTargetRebateBuilder builder = FxTargetRebate.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FxTargetRebateBuilder builder) {
            Optional.ofNullable(this.getPayment()).ifPresent(builder::setPayment);
            Optional.ofNullable(this.getOutstandingGain()).ifPresent(builder::setOutstandingGain);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FxTargetRebate _that = this.getType().cast(o);
            if (!Objects.equals(this.payment, _that.getPayment())) {
                return false;
            }
            return Objects.equals(this.outstandingGain, _that.getOutstandingGain());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.payment != null ? this.payment.hashCode() : 0);
            _result = 31 * _result + (this.outstandingGain != null ? this.outstandingGain.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FxTargetRebate {payment=" + this.payment + ", outstandingGain=" + this.outstandingGain + '}';
        }
    }
}

