/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.confirmation.AdjustableOrAdjustedDate;
import fpml.confirmation.FxCashSettlementSimple;
import fpml.confirmation.FxFixingScheduleSimple;
import fpml.confirmation.FxPerformanceFixedLeg;
import fpml.confirmation.FxPerformanceFloatingLeg;
import fpml.confirmation.FxSpotRateSource;
import fpml.confirmation.FxValuationDateOffset;
import fpml.confirmation.NonNegativeMoney;
import fpml.confirmation.Payment;
import fpml.confirmation.Product;
import fpml.confirmation.ProductModel;
import fpml.confirmation.QuotedCurrencyPair;
import fpml.confirmation.meta.FxPerformanceSwapMeta;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="FxPerformanceSwap", builder=FxPerformanceSwapBuilderImpl.class, version="0.17.2")
@RuneDataType(value="FxPerformanceSwap", model="fpml", builder=FxPerformanceSwapBuilderImpl.class, version="0.17.2")
public interface FxPerformanceSwap
extends Product {
    public static final FxPerformanceSwapMeta metaData = new FxPerformanceSwapMeta();

    public QuotedCurrencyPair getQuotedCurrencyPair();

    public NonNegativeMoney getVegaNotional();

    public NonNegativeMoney getNotional();

    public FxPerformanceFixedLeg getFixedLeg();

    public FxPerformanceFloatingLeg getFloatingLeg();

    public FxSpotRateSource getFixingInformationSource();

    public FxFixingScheduleSimple getFixingSchedule();

    public ZonedDateTime getValuationDate();

    public FxValuationDateOffset getValuationDateOffset();

    public AdjustableOrAdjustedDate getSettlementDate();

    public BigDecimal getAnnualizationFactor();

    public Boolean getMeanAdjustment();

    public Integer getNumberOfReturns();

    public List<? extends Payment> getAdditionalPayment();

    public FxCashSettlementSimple getCashSettlement();

    @Override
    public FxPerformanceSwap build();

    @Override
    public FxPerformanceSwapBuilder toBuilder();

    public static FxPerformanceSwapBuilder builder() {
        return new FxPerformanceSwapBuilderImpl();
    }

    default public RosettaMetaData<? extends FxPerformanceSwap> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FxPerformanceSwap> getType() {
        return FxPerformanceSwap.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.class, this.getProductModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("quotedCurrencyPair"), processor, QuotedCurrencyPair.class, this.getQuotedCurrencyPair(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("vegaNotional"), processor, NonNegativeMoney.class, this.getVegaNotional(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("notional"), processor, NonNegativeMoney.class, this.getNotional(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fixedLeg"), processor, FxPerformanceFixedLeg.class, this.getFixedLeg(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("floatingLeg"), processor, FxPerformanceFloatingLeg.class, this.getFloatingLeg(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fixingInformationSource"), processor, FxSpotRateSource.class, this.getFixingInformationSource(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fixingSchedule"), processor, FxFixingScheduleSimple.class, this.getFixingSchedule(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationDate"), ZonedDateTime.class, (Object)this.getValuationDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("valuationDateOffset"), processor, FxValuationDateOffset.class, this.getValuationDateOffset(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("settlementDate"), processor, AdjustableOrAdjustedDate.class, this.getSettlementDate(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("annualizationFactor"), BigDecimal.class, (Object)this.getAnnualizationFactor(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("meanAdjustment"), Boolean.class, (Object)this.getMeanAdjustment(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("numberOfReturns"), Integer.class, (Object)this.getNumberOfReturns(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("additionalPayment"), processor, Payment.class, this.getAdditionalPayment(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("cashSettlement"), processor, FxCashSettlementSimple.class, this.getCashSettlement(), new AttributeMeta[0]);
    }

    public static class FxPerformanceSwapBuilderImpl
    extends Product.ProductBuilderImpl
    implements FxPerformanceSwapBuilder {
        protected QuotedCurrencyPair.QuotedCurrencyPairBuilder quotedCurrencyPair;
        protected NonNegativeMoney.NonNegativeMoneyBuilder vegaNotional;
        protected NonNegativeMoney.NonNegativeMoneyBuilder notional;
        protected FxPerformanceFixedLeg.FxPerformanceFixedLegBuilder fixedLeg;
        protected FxPerformanceFloatingLeg.FxPerformanceFloatingLegBuilder floatingLeg;
        protected FxSpotRateSource.FxSpotRateSourceBuilder fixingInformationSource;
        protected FxFixingScheduleSimple.FxFixingScheduleSimpleBuilder fixingSchedule;
        protected ZonedDateTime valuationDate;
        protected FxValuationDateOffset.FxValuationDateOffsetBuilder valuationDateOffset;
        protected AdjustableOrAdjustedDate.AdjustableOrAdjustedDateBuilder settlementDate;
        protected BigDecimal annualizationFactor;
        protected Boolean meanAdjustment;
        protected Integer numberOfReturns;
        protected List<Payment.PaymentBuilder> additionalPayment = new ArrayList<Payment.PaymentBuilder>();
        protected FxCashSettlementSimple.FxCashSettlementSimpleBuilder cashSettlement;

        @Override
        @RosettaAttribute(value="quotedCurrencyPair", isRequired=true)
        @RuneAttribute(value="quotedCurrencyPair", isRequired=true)
        public QuotedCurrencyPair.QuotedCurrencyPairBuilder getQuotedCurrencyPair() {
            return this.quotedCurrencyPair;
        }

        @Override
        public QuotedCurrencyPair.QuotedCurrencyPairBuilder getOrCreateQuotedCurrencyPair() {
            QuotedCurrencyPair.QuotedCurrencyPairBuilder result = this.quotedCurrencyPair != null ? this.quotedCurrencyPair : (this.quotedCurrencyPair = QuotedCurrencyPair.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="vegaNotional", isRequired=true)
        @RuneAttribute(value="vegaNotional", isRequired=true)
        public NonNegativeMoney.NonNegativeMoneyBuilder getVegaNotional() {
            return this.vegaNotional;
        }

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateVegaNotional() {
            NonNegativeMoney.NonNegativeMoneyBuilder result = this.vegaNotional != null ? this.vegaNotional : (this.vegaNotional = NonNegativeMoney.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="notional")
        @RuneAttribute(value="notional")
        public NonNegativeMoney.NonNegativeMoneyBuilder getNotional() {
            return this.notional;
        }

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateNotional() {
            NonNegativeMoney.NonNegativeMoneyBuilder result = this.notional != null ? this.notional : (this.notional = NonNegativeMoney.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fixedLeg", isRequired=true)
        @RuneAttribute(value="fixedLeg", isRequired=true)
        public FxPerformanceFixedLeg.FxPerformanceFixedLegBuilder getFixedLeg() {
            return this.fixedLeg;
        }

        @Override
        public FxPerformanceFixedLeg.FxPerformanceFixedLegBuilder getOrCreateFixedLeg() {
            FxPerformanceFixedLeg.FxPerformanceFixedLegBuilder result = this.fixedLeg != null ? this.fixedLeg : (this.fixedLeg = FxPerformanceFixedLeg.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="floatingLeg", isRequired=true)
        @RuneAttribute(value="floatingLeg", isRequired=true)
        public FxPerformanceFloatingLeg.FxPerformanceFloatingLegBuilder getFloatingLeg() {
            return this.floatingLeg;
        }

        @Override
        public FxPerformanceFloatingLeg.FxPerformanceFloatingLegBuilder getOrCreateFloatingLeg() {
            FxPerformanceFloatingLeg.FxPerformanceFloatingLegBuilder result = this.floatingLeg != null ? this.floatingLeg : (this.floatingLeg = FxPerformanceFloatingLeg.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fixingInformationSource", isRequired=true)
        @RuneAttribute(value="fixingInformationSource", isRequired=true)
        public FxSpotRateSource.FxSpotRateSourceBuilder getFixingInformationSource() {
            return this.fixingInformationSource;
        }

        @Override
        public FxSpotRateSource.FxSpotRateSourceBuilder getOrCreateFixingInformationSource() {
            FxSpotRateSource.FxSpotRateSourceBuilder result = this.fixingInformationSource != null ? this.fixingInformationSource : (this.fixingInformationSource = FxSpotRateSource.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fixingSchedule", isRequired=true)
        @RuneAttribute(value="fixingSchedule", isRequired=true)
        public FxFixingScheduleSimple.FxFixingScheduleSimpleBuilder getFixingSchedule() {
            return this.fixingSchedule;
        }

        @Override
        public FxFixingScheduleSimple.FxFixingScheduleSimpleBuilder getOrCreateFixingSchedule() {
            FxFixingScheduleSimple.FxFixingScheduleSimpleBuilder result = this.fixingSchedule != null ? this.fixingSchedule : (this.fixingSchedule = FxFixingScheduleSimple.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="valuationDate")
        @RuneAttribute(value="valuationDate")
        public ZonedDateTime getValuationDate() {
            return this.valuationDate;
        }

        @Override
        @RosettaAttribute(value="valuationDateOffset")
        @RuneAttribute(value="valuationDateOffset")
        public FxValuationDateOffset.FxValuationDateOffsetBuilder getValuationDateOffset() {
            return this.valuationDateOffset;
        }

        @Override
        public FxValuationDateOffset.FxValuationDateOffsetBuilder getOrCreateValuationDateOffset() {
            FxValuationDateOffset.FxValuationDateOffsetBuilder result = this.valuationDateOffset != null ? this.valuationDateOffset : (this.valuationDateOffset = FxValuationDateOffset.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="settlementDate", isRequired=true)
        @RuneAttribute(value="settlementDate", isRequired=true)
        public AdjustableOrAdjustedDate.AdjustableOrAdjustedDateBuilder getSettlementDate() {
            return this.settlementDate;
        }

        @Override
        public AdjustableOrAdjustedDate.AdjustableOrAdjustedDateBuilder getOrCreateSettlementDate() {
            AdjustableOrAdjustedDate.AdjustableOrAdjustedDateBuilder result = this.settlementDate != null ? this.settlementDate : (this.settlementDate = AdjustableOrAdjustedDate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="annualizationFactor", isRequired=true)
        @RuneAttribute(value="annualizationFactor", isRequired=true)
        public BigDecimal getAnnualizationFactor() {
            return this.annualizationFactor;
        }

        @Override
        @RosettaAttribute(value="meanAdjustment", isRequired=true)
        @RuneAttribute(value="meanAdjustment", isRequired=true)
        public Boolean getMeanAdjustment() {
            return this.meanAdjustment;
        }

        @Override
        @RosettaAttribute(value="numberOfReturns")
        @RuneAttribute(value="numberOfReturns")
        public Integer getNumberOfReturns() {
            return this.numberOfReturns;
        }

        @Override
        @RosettaAttribute(value="additionalPayment")
        @RuneAttribute(value="additionalPayment")
        public List<? extends Payment.PaymentBuilder> getAdditionalPayment() {
            return this.additionalPayment;
        }

        @Override
        public Payment.PaymentBuilder getOrCreateAdditionalPayment(int index) {
            if (this.additionalPayment == null) {
                this.additionalPayment = new ArrayList<Payment.PaymentBuilder>();
            }
            return (Payment.PaymentBuilder)this.getIndex(this.additionalPayment, index, () -> {
                Payment.PaymentBuilder newAdditionalPayment = Payment.builder();
                return newAdditionalPayment;
            });
        }

        @Override
        @RosettaAttribute(value="cashSettlement")
        @RuneAttribute(value="cashSettlement")
        public FxCashSettlementSimple.FxCashSettlementSimpleBuilder getCashSettlement() {
            return this.cashSettlement;
        }

        @Override
        public FxCashSettlementSimple.FxCashSettlementSimpleBuilder getOrCreateCashSettlement() {
            FxCashSettlementSimple.FxCashSettlementSimpleBuilder result = this.cashSettlement != null ? this.cashSettlement : (this.cashSettlement = FxCashSettlementSimple.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="productModel")
        @RuneAttribute(value="productModel")
        public FxPerformanceSwapBuilder setProductModel(ProductModel _productModel) {
            this.productModel = _productModel == null ? null : _productModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public FxPerformanceSwapBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="quotedCurrencyPair", isRequired=true)
        @RuneAttribute(value="quotedCurrencyPair", isRequired=true)
        public FxPerformanceSwapBuilder setQuotedCurrencyPair(QuotedCurrencyPair _quotedCurrencyPair) {
            this.quotedCurrencyPair = _quotedCurrencyPair == null ? null : _quotedCurrencyPair.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="vegaNotional", isRequired=true)
        @RuneAttribute(value="vegaNotional", isRequired=true)
        public FxPerformanceSwapBuilder setVegaNotional(NonNegativeMoney _vegaNotional) {
            this.vegaNotional = _vegaNotional == null ? null : _vegaNotional.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="notional")
        @RuneAttribute(value="notional")
        public FxPerformanceSwapBuilder setNotional(NonNegativeMoney _notional) {
            this.notional = _notional == null ? null : _notional.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fixedLeg", isRequired=true)
        @RuneAttribute(value="fixedLeg", isRequired=true)
        public FxPerformanceSwapBuilder setFixedLeg(FxPerformanceFixedLeg _fixedLeg) {
            this.fixedLeg = _fixedLeg == null ? null : _fixedLeg.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="floatingLeg", isRequired=true)
        @RuneAttribute(value="floatingLeg", isRequired=true)
        public FxPerformanceSwapBuilder setFloatingLeg(FxPerformanceFloatingLeg _floatingLeg) {
            this.floatingLeg = _floatingLeg == null ? null : _floatingLeg.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fixingInformationSource", isRequired=true)
        @RuneAttribute(value="fixingInformationSource", isRequired=true)
        public FxPerformanceSwapBuilder setFixingInformationSource(FxSpotRateSource _fixingInformationSource) {
            this.fixingInformationSource = _fixingInformationSource == null ? null : _fixingInformationSource.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fixingSchedule", isRequired=true)
        @RuneAttribute(value="fixingSchedule", isRequired=true)
        public FxPerformanceSwapBuilder setFixingSchedule(FxFixingScheduleSimple _fixingSchedule) {
            this.fixingSchedule = _fixingSchedule == null ? null : _fixingSchedule.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationDate")
        @RuneAttribute(value="valuationDate")
        public FxPerformanceSwapBuilder setValuationDate(ZonedDateTime _valuationDate) {
            this.valuationDate = _valuationDate == null ? null : _valuationDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationDateOffset")
        @RuneAttribute(value="valuationDateOffset")
        public FxPerformanceSwapBuilder setValuationDateOffset(FxValuationDateOffset _valuationDateOffset) {
            this.valuationDateOffset = _valuationDateOffset == null ? null : _valuationDateOffset.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementDate", isRequired=true)
        @RuneAttribute(value="settlementDate", isRequired=true)
        public FxPerformanceSwapBuilder setSettlementDate(AdjustableOrAdjustedDate _settlementDate) {
            this.settlementDate = _settlementDate == null ? null : _settlementDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="annualizationFactor", isRequired=true)
        @RuneAttribute(value="annualizationFactor", isRequired=true)
        public FxPerformanceSwapBuilder setAnnualizationFactor(BigDecimal _annualizationFactor) {
            this.annualizationFactor = _annualizationFactor == null ? null : _annualizationFactor;
            return this;
        }

        @Override
        @RosettaAttribute(value="meanAdjustment", isRequired=true)
        @RuneAttribute(value="meanAdjustment", isRequired=true)
        public FxPerformanceSwapBuilder setMeanAdjustment(Boolean _meanAdjustment) {
            this.meanAdjustment = _meanAdjustment == null ? null : _meanAdjustment;
            return this;
        }

        @Override
        @RosettaAttribute(value="numberOfReturns")
        @RuneAttribute(value="numberOfReturns")
        public FxPerformanceSwapBuilder setNumberOfReturns(Integer _numberOfReturns) {
            this.numberOfReturns = _numberOfReturns == null ? null : _numberOfReturns;
            return this;
        }

        @Override
        @RosettaAttribute(value="additionalPayment")
        @RuneAttribute(value="additionalPayment")
        public FxPerformanceSwapBuilder addAdditionalPayment(Payment _additionalPayment) {
            if (_additionalPayment != null) {
                this.additionalPayment.add(_additionalPayment.toBuilder());
            }
            return this;
        }

        @Override
        public FxPerformanceSwapBuilder addAdditionalPayment(Payment _additionalPayment, int idx) {
            this.getIndex(this.additionalPayment, idx, () -> _additionalPayment.toBuilder());
            return this;
        }

        @Override
        public FxPerformanceSwapBuilder addAdditionalPayment(List<? extends Payment> additionalPayments) {
            if (additionalPayments != null) {
                for (Payment payment : additionalPayments) {
                    this.additionalPayment.add(payment.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="additionalPayment")
        public FxPerformanceSwapBuilder setAdditionalPayment(List<? extends Payment> additionalPayments) {
            this.additionalPayment = additionalPayments == null ? new ArrayList<Payment.PaymentBuilder>() : (List)additionalPayments.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="cashSettlement")
        @RuneAttribute(value="cashSettlement")
        public FxPerformanceSwapBuilder setCashSettlement(FxCashSettlementSimple _cashSettlement) {
            this.cashSettlement = _cashSettlement == null ? null : _cashSettlement.toBuilder();
            return this;
        }

        @Override
        public FxPerformanceSwap build() {
            return new FxPerformanceSwapImpl(this);
        }

        @Override
        public FxPerformanceSwapBuilder toBuilder() {
            return this;
        }

        @Override
        public FxPerformanceSwapBuilder prune() {
            super.prune();
            if (this.quotedCurrencyPair != null && !this.quotedCurrencyPair.prune().hasData()) {
                this.quotedCurrencyPair = null;
            }
            if (this.vegaNotional != null && !this.vegaNotional.prune().hasData()) {
                this.vegaNotional = null;
            }
            if (this.notional != null && !this.notional.prune().hasData()) {
                this.notional = null;
            }
            if (this.fixedLeg != null && !this.fixedLeg.prune().hasData()) {
                this.fixedLeg = null;
            }
            if (this.floatingLeg != null && !this.floatingLeg.prune().hasData()) {
                this.floatingLeg = null;
            }
            if (this.fixingInformationSource != null && !this.fixingInformationSource.prune().hasData()) {
                this.fixingInformationSource = null;
            }
            if (this.fixingSchedule != null && !this.fixingSchedule.prune().hasData()) {
                this.fixingSchedule = null;
            }
            if (this.valuationDateOffset != null && !this.valuationDateOffset.prune().hasData()) {
                this.valuationDateOffset = null;
            }
            if (this.settlementDate != null && !this.settlementDate.prune().hasData()) {
                this.settlementDate = null;
            }
            this.additionalPayment = this.additionalPayment.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.cashSettlement != null && !this.cashSettlement.prune().hasData()) {
                this.cashSettlement = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getQuotedCurrencyPair() != null && this.getQuotedCurrencyPair().hasData()) {
                return true;
            }
            if (this.getVegaNotional() != null && this.getVegaNotional().hasData()) {
                return true;
            }
            if (this.getNotional() != null && this.getNotional().hasData()) {
                return true;
            }
            if (this.getFixedLeg() != null && this.getFixedLeg().hasData()) {
                return true;
            }
            if (this.getFloatingLeg() != null && this.getFloatingLeg().hasData()) {
                return true;
            }
            if (this.getFixingInformationSource() != null && this.getFixingInformationSource().hasData()) {
                return true;
            }
            if (this.getFixingSchedule() != null && this.getFixingSchedule().hasData()) {
                return true;
            }
            if (this.getValuationDate() != null) {
                return true;
            }
            if (this.getValuationDateOffset() != null && this.getValuationDateOffset().hasData()) {
                return true;
            }
            if (this.getSettlementDate() != null && this.getSettlementDate().hasData()) {
                return true;
            }
            if (this.getAnnualizationFactor() != null) {
                return true;
            }
            if (this.getMeanAdjustment() != null) {
                return true;
            }
            if (this.getNumberOfReturns() != null) {
                return true;
            }
            if (this.getAdditionalPayment() != null && this.getAdditionalPayment().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getCashSettlement() != null && this.getCashSettlement().hasData();
        }

        @Override
        public FxPerformanceSwapBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            FxPerformanceSwapBuilder o = (FxPerformanceSwapBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getQuotedCurrencyPair(), (RosettaModelObjectBuilder)o.getQuotedCurrencyPair(), this::setQuotedCurrencyPair);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getVegaNotional(), (RosettaModelObjectBuilder)o.getVegaNotional(), this::setVegaNotional);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getNotional(), (RosettaModelObjectBuilder)o.getNotional(), this::setNotional);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFixedLeg(), (RosettaModelObjectBuilder)o.getFixedLeg(), this::setFixedLeg);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFloatingLeg(), (RosettaModelObjectBuilder)o.getFloatingLeg(), this::setFloatingLeg);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFixingInformationSource(), (RosettaModelObjectBuilder)o.getFixingInformationSource(), this::setFixingInformationSource);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFixingSchedule(), (RosettaModelObjectBuilder)o.getFixingSchedule(), this::setFixingSchedule);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getValuationDateOffset(), (RosettaModelObjectBuilder)o.getValuationDateOffset(), this::setValuationDateOffset);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSettlementDate(), (RosettaModelObjectBuilder)o.getSettlementDate(), this::setSettlementDate);
            merger.mergeRosetta(this.getAdditionalPayment(), o.getAdditionalPayment(), this::getOrCreateAdditionalPayment);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCashSettlement(), (RosettaModelObjectBuilder)o.getCashSettlement(), this::setCashSettlement);
            merger.mergeBasic((Object)this.getValuationDate(), (Object)o.getValuationDate(), this::setValuationDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getAnnualizationFactor(), (Object)o.getAnnualizationFactor(), this::setAnnualizationFactor, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getMeanAdjustment(), (Object)o.getMeanAdjustment(), this::setMeanAdjustment, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNumberOfReturns(), (Object)o.getNumberOfReturns(), this::setNumberOfReturns, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FxPerformanceSwap _that = (FxPerformanceSwap)this.getType().cast(o);
            if (!Objects.equals(this.quotedCurrencyPair, _that.getQuotedCurrencyPair())) {
                return false;
            }
            if (!Objects.equals(this.vegaNotional, _that.getVegaNotional())) {
                return false;
            }
            if (!Objects.equals(this.notional, _that.getNotional())) {
                return false;
            }
            if (!Objects.equals(this.fixedLeg, _that.getFixedLeg())) {
                return false;
            }
            if (!Objects.equals(this.floatingLeg, _that.getFloatingLeg())) {
                return false;
            }
            if (!Objects.equals(this.fixingInformationSource, _that.getFixingInformationSource())) {
                return false;
            }
            if (!Objects.equals(this.fixingSchedule, _that.getFixingSchedule())) {
                return false;
            }
            if (!Objects.equals(this.valuationDate, _that.getValuationDate())) {
                return false;
            }
            if (!Objects.equals(this.valuationDateOffset, _that.getValuationDateOffset())) {
                return false;
            }
            if (!Objects.equals(this.settlementDate, _that.getSettlementDate())) {
                return false;
            }
            if (!Objects.equals(this.annualizationFactor, _that.getAnnualizationFactor())) {
                return false;
            }
            if (!Objects.equals(this.meanAdjustment, _that.getMeanAdjustment())) {
                return false;
            }
            if (!Objects.equals(this.numberOfReturns, _that.getNumberOfReturns())) {
                return false;
            }
            if (!ListEquals.listEquals(this.additionalPayment, _that.getAdditionalPayment())) {
                return false;
            }
            return Objects.equals(this.cashSettlement, _that.getCashSettlement());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.quotedCurrencyPair != null ? this.quotedCurrencyPair.hashCode() : 0);
            _result = 31 * _result + (this.vegaNotional != null ? this.vegaNotional.hashCode() : 0);
            _result = 31 * _result + (this.notional != null ? this.notional.hashCode() : 0);
            _result = 31 * _result + (this.fixedLeg != null ? this.fixedLeg.hashCode() : 0);
            _result = 31 * _result + (this.floatingLeg != null ? this.floatingLeg.hashCode() : 0);
            _result = 31 * _result + (this.fixingInformationSource != null ? this.fixingInformationSource.hashCode() : 0);
            _result = 31 * _result + (this.fixingSchedule != null ? this.fixingSchedule.hashCode() : 0);
            _result = 31 * _result + (this.valuationDate != null ? this.valuationDate.hashCode() : 0);
            _result = 31 * _result + (this.valuationDateOffset != null ? this.valuationDateOffset.hashCode() : 0);
            _result = 31 * _result + (this.settlementDate != null ? this.settlementDate.hashCode() : 0);
            _result = 31 * _result + (this.annualizationFactor != null ? this.annualizationFactor.hashCode() : 0);
            _result = 31 * _result + (this.meanAdjustment != null ? this.meanAdjustment.hashCode() : 0);
            _result = 31 * _result + (this.numberOfReturns != null ? this.numberOfReturns.hashCode() : 0);
            _result = 31 * _result + (this.additionalPayment != null ? this.additionalPayment.hashCode() : 0);
            _result = 31 * _result + (this.cashSettlement != null ? this.cashSettlement.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FxPerformanceSwapBuilder {quotedCurrencyPair=" + this.quotedCurrencyPair + ", vegaNotional=" + this.vegaNotional + ", notional=" + this.notional + ", fixedLeg=" + this.fixedLeg + ", floatingLeg=" + this.floatingLeg + ", fixingInformationSource=" + this.fixingInformationSource + ", fixingSchedule=" + this.fixingSchedule + ", valuationDate=" + this.valuationDate + ", valuationDateOffset=" + this.valuationDateOffset + ", settlementDate=" + this.settlementDate + ", annualizationFactor=" + this.annualizationFactor + ", meanAdjustment=" + this.meanAdjustment + ", numberOfReturns=" + this.numberOfReturns + ", additionalPayment=" + this.additionalPayment + ", cashSettlement=" + this.cashSettlement + '}' + " " + super.toString();
        }
    }

    public static interface FxPerformanceSwapBuilder
    extends FxPerformanceSwap,
    Product.ProductBuilder {
        public QuotedCurrencyPair.QuotedCurrencyPairBuilder getOrCreateQuotedCurrencyPair();

        @Override
        public QuotedCurrencyPair.QuotedCurrencyPairBuilder getQuotedCurrencyPair();

        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateVegaNotional();

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getVegaNotional();

        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateNotional();

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getNotional();

        public FxPerformanceFixedLeg.FxPerformanceFixedLegBuilder getOrCreateFixedLeg();

        @Override
        public FxPerformanceFixedLeg.FxPerformanceFixedLegBuilder getFixedLeg();

        public FxPerformanceFloatingLeg.FxPerformanceFloatingLegBuilder getOrCreateFloatingLeg();

        @Override
        public FxPerformanceFloatingLeg.FxPerformanceFloatingLegBuilder getFloatingLeg();

        public FxSpotRateSource.FxSpotRateSourceBuilder getOrCreateFixingInformationSource();

        @Override
        public FxSpotRateSource.FxSpotRateSourceBuilder getFixingInformationSource();

        public FxFixingScheduleSimple.FxFixingScheduleSimpleBuilder getOrCreateFixingSchedule();

        @Override
        public FxFixingScheduleSimple.FxFixingScheduleSimpleBuilder getFixingSchedule();

        public FxValuationDateOffset.FxValuationDateOffsetBuilder getOrCreateValuationDateOffset();

        @Override
        public FxValuationDateOffset.FxValuationDateOffsetBuilder getValuationDateOffset();

        public AdjustableOrAdjustedDate.AdjustableOrAdjustedDateBuilder getOrCreateSettlementDate();

        @Override
        public AdjustableOrAdjustedDate.AdjustableOrAdjustedDateBuilder getSettlementDate();

        public Payment.PaymentBuilder getOrCreateAdditionalPayment(int var1);

        public List<? extends Payment.PaymentBuilder> getAdditionalPayment();

        public FxCashSettlementSimple.FxCashSettlementSimpleBuilder getOrCreateCashSettlement();

        @Override
        public FxCashSettlementSimple.FxCashSettlementSimpleBuilder getCashSettlement();

        @Override
        public FxPerformanceSwapBuilder setProductModel(ProductModel var1);

        @Override
        public FxPerformanceSwapBuilder setId(String var1);

        public FxPerformanceSwapBuilder setQuotedCurrencyPair(QuotedCurrencyPair var1);

        public FxPerformanceSwapBuilder setVegaNotional(NonNegativeMoney var1);

        public FxPerformanceSwapBuilder setNotional(NonNegativeMoney var1);

        public FxPerformanceSwapBuilder setFixedLeg(FxPerformanceFixedLeg var1);

        public FxPerformanceSwapBuilder setFloatingLeg(FxPerformanceFloatingLeg var1);

        public FxPerformanceSwapBuilder setFixingInformationSource(FxSpotRateSource var1);

        public FxPerformanceSwapBuilder setFixingSchedule(FxFixingScheduleSimple var1);

        public FxPerformanceSwapBuilder setValuationDate(ZonedDateTime var1);

        public FxPerformanceSwapBuilder setValuationDateOffset(FxValuationDateOffset var1);

        public FxPerformanceSwapBuilder setSettlementDate(AdjustableOrAdjustedDate var1);

        public FxPerformanceSwapBuilder setAnnualizationFactor(BigDecimal var1);

        public FxPerformanceSwapBuilder setMeanAdjustment(Boolean var1);

        public FxPerformanceSwapBuilder setNumberOfReturns(Integer var1);

        public FxPerformanceSwapBuilder addAdditionalPayment(Payment var1);

        public FxPerformanceSwapBuilder addAdditionalPayment(Payment var1, int var2);

        public FxPerformanceSwapBuilder addAdditionalPayment(List<? extends Payment> var1);

        public FxPerformanceSwapBuilder setAdditionalPayment(List<? extends Payment> var1);

        public FxPerformanceSwapBuilder setCashSettlement(FxCashSettlementSimple var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.ProductModelBuilder.class, (RosettaModelObjectBuilder)this.getProductModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("quotedCurrencyPair"), processor, QuotedCurrencyPair.QuotedCurrencyPairBuilder.class, this.getQuotedCurrencyPair(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("vegaNotional"), processor, NonNegativeMoney.NonNegativeMoneyBuilder.class, this.getVegaNotional(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("notional"), processor, NonNegativeMoney.NonNegativeMoneyBuilder.class, this.getNotional(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fixedLeg"), processor, FxPerformanceFixedLeg.FxPerformanceFixedLegBuilder.class, this.getFixedLeg(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("floatingLeg"), processor, FxPerformanceFloatingLeg.FxPerformanceFloatingLegBuilder.class, this.getFloatingLeg(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fixingInformationSource"), processor, FxSpotRateSource.FxSpotRateSourceBuilder.class, this.getFixingInformationSource(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fixingSchedule"), processor, FxFixingScheduleSimple.FxFixingScheduleSimpleBuilder.class, this.getFixingSchedule(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationDate"), ZonedDateTime.class, (Object)this.getValuationDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("valuationDateOffset"), processor, FxValuationDateOffset.FxValuationDateOffsetBuilder.class, this.getValuationDateOffset(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("settlementDate"), processor, AdjustableOrAdjustedDate.AdjustableOrAdjustedDateBuilder.class, this.getSettlementDate(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("annualizationFactor"), BigDecimal.class, (Object)this.getAnnualizationFactor(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("meanAdjustment"), Boolean.class, (Object)this.getMeanAdjustment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("numberOfReturns"), Integer.class, (Object)this.getNumberOfReturns(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("additionalPayment"), processor, Payment.PaymentBuilder.class, this.getAdditionalPayment(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("cashSettlement"), processor, FxCashSettlementSimple.FxCashSettlementSimpleBuilder.class, this.getCashSettlement(), new AttributeMeta[0]);
        }

        @Override
        public FxPerformanceSwapBuilder prune();
    }

    public static class FxPerformanceSwapImpl
    extends Product.ProductImpl
    implements FxPerformanceSwap {
        private final QuotedCurrencyPair quotedCurrencyPair;
        private final NonNegativeMoney vegaNotional;
        private final NonNegativeMoney notional;
        private final FxPerformanceFixedLeg fixedLeg;
        private final FxPerformanceFloatingLeg floatingLeg;
        private final FxSpotRateSource fixingInformationSource;
        private final FxFixingScheduleSimple fixingSchedule;
        private final ZonedDateTime valuationDate;
        private final FxValuationDateOffset valuationDateOffset;
        private final AdjustableOrAdjustedDate settlementDate;
        private final BigDecimal annualizationFactor;
        private final Boolean meanAdjustment;
        private final Integer numberOfReturns;
        private final List<? extends Payment> additionalPayment;
        private final FxCashSettlementSimple cashSettlement;

        protected FxPerformanceSwapImpl(FxPerformanceSwapBuilder builder) {
            super(builder);
            this.quotedCurrencyPair = Optional.ofNullable(builder.getQuotedCurrencyPair()).map(f -> f.build()).orElse(null);
            this.vegaNotional = Optional.ofNullable(builder.getVegaNotional()).map(f -> f.build()).orElse(null);
            this.notional = Optional.ofNullable(builder.getNotional()).map(f -> f.build()).orElse(null);
            this.fixedLeg = Optional.ofNullable(builder.getFixedLeg()).map(f -> f.build()).orElse(null);
            this.floatingLeg = Optional.ofNullable(builder.getFloatingLeg()).map(f -> f.build()).orElse(null);
            this.fixingInformationSource = Optional.ofNullable(builder.getFixingInformationSource()).map(f -> f.build()).orElse(null);
            this.fixingSchedule = Optional.ofNullable(builder.getFixingSchedule()).map(f -> f.build()).orElse(null);
            this.valuationDate = builder.getValuationDate();
            this.valuationDateOffset = Optional.ofNullable(builder.getValuationDateOffset()).map(f -> f.build()).orElse(null);
            this.settlementDate = Optional.ofNullable(builder.getSettlementDate()).map(f -> f.build()).orElse(null);
            this.annualizationFactor = builder.getAnnualizationFactor();
            this.meanAdjustment = builder.getMeanAdjustment();
            this.numberOfReturns = builder.getNumberOfReturns();
            this.additionalPayment = Optional.ofNullable(builder.getAdditionalPayment()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.cashSettlement = Optional.ofNullable(builder.getCashSettlement()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="quotedCurrencyPair", isRequired=true)
        @RuneAttribute(value="quotedCurrencyPair", isRequired=true)
        public QuotedCurrencyPair getQuotedCurrencyPair() {
            return this.quotedCurrencyPair;
        }

        @Override
        @RosettaAttribute(value="vegaNotional", isRequired=true)
        @RuneAttribute(value="vegaNotional", isRequired=true)
        public NonNegativeMoney getVegaNotional() {
            return this.vegaNotional;
        }

        @Override
        @RosettaAttribute(value="notional")
        @RuneAttribute(value="notional")
        public NonNegativeMoney getNotional() {
            return this.notional;
        }

        @Override
        @RosettaAttribute(value="fixedLeg", isRequired=true)
        @RuneAttribute(value="fixedLeg", isRequired=true)
        public FxPerformanceFixedLeg getFixedLeg() {
            return this.fixedLeg;
        }

        @Override
        @RosettaAttribute(value="floatingLeg", isRequired=true)
        @RuneAttribute(value="floatingLeg", isRequired=true)
        public FxPerformanceFloatingLeg getFloatingLeg() {
            return this.floatingLeg;
        }

        @Override
        @RosettaAttribute(value="fixingInformationSource", isRequired=true)
        @RuneAttribute(value="fixingInformationSource", isRequired=true)
        public FxSpotRateSource getFixingInformationSource() {
            return this.fixingInformationSource;
        }

        @Override
        @RosettaAttribute(value="fixingSchedule", isRequired=true)
        @RuneAttribute(value="fixingSchedule", isRequired=true)
        public FxFixingScheduleSimple getFixingSchedule() {
            return this.fixingSchedule;
        }

        @Override
        @RosettaAttribute(value="valuationDate")
        @RuneAttribute(value="valuationDate")
        public ZonedDateTime getValuationDate() {
            return this.valuationDate;
        }

        @Override
        @RosettaAttribute(value="valuationDateOffset")
        @RuneAttribute(value="valuationDateOffset")
        public FxValuationDateOffset getValuationDateOffset() {
            return this.valuationDateOffset;
        }

        @Override
        @RosettaAttribute(value="settlementDate", isRequired=true)
        @RuneAttribute(value="settlementDate", isRequired=true)
        public AdjustableOrAdjustedDate getSettlementDate() {
            return this.settlementDate;
        }

        @Override
        @RosettaAttribute(value="annualizationFactor", isRequired=true)
        @RuneAttribute(value="annualizationFactor", isRequired=true)
        public BigDecimal getAnnualizationFactor() {
            return this.annualizationFactor;
        }

        @Override
        @RosettaAttribute(value="meanAdjustment", isRequired=true)
        @RuneAttribute(value="meanAdjustment", isRequired=true)
        public Boolean getMeanAdjustment() {
            return this.meanAdjustment;
        }

        @Override
        @RosettaAttribute(value="numberOfReturns")
        @RuneAttribute(value="numberOfReturns")
        public Integer getNumberOfReturns() {
            return this.numberOfReturns;
        }

        @Override
        @RosettaAttribute(value="additionalPayment")
        @RuneAttribute(value="additionalPayment")
        public List<? extends Payment> getAdditionalPayment() {
            return this.additionalPayment;
        }

        @Override
        @RosettaAttribute(value="cashSettlement")
        @RuneAttribute(value="cashSettlement")
        public FxCashSettlementSimple getCashSettlement() {
            return this.cashSettlement;
        }

        @Override
        public FxPerformanceSwap build() {
            return this;
        }

        @Override
        public FxPerformanceSwapBuilder toBuilder() {
            FxPerformanceSwapBuilder builder = FxPerformanceSwap.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FxPerformanceSwapBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getQuotedCurrencyPair()).ifPresent(builder::setQuotedCurrencyPair);
            Optional.ofNullable(this.getVegaNotional()).ifPresent(builder::setVegaNotional);
            Optional.ofNullable(this.getNotional()).ifPresent(builder::setNotional);
            Optional.ofNullable(this.getFixedLeg()).ifPresent(builder::setFixedLeg);
            Optional.ofNullable(this.getFloatingLeg()).ifPresent(builder::setFloatingLeg);
            Optional.ofNullable(this.getFixingInformationSource()).ifPresent(builder::setFixingInformationSource);
            Optional.ofNullable(this.getFixingSchedule()).ifPresent(builder::setFixingSchedule);
            Optional.ofNullable(this.getValuationDate()).ifPresent(builder::setValuationDate);
            Optional.ofNullable(this.getValuationDateOffset()).ifPresent(builder::setValuationDateOffset);
            Optional.ofNullable(this.getSettlementDate()).ifPresent(builder::setSettlementDate);
            Optional.ofNullable(this.getAnnualizationFactor()).ifPresent(builder::setAnnualizationFactor);
            Optional.ofNullable(this.getMeanAdjustment()).ifPresent(builder::setMeanAdjustment);
            Optional.ofNullable(this.getNumberOfReturns()).ifPresent(builder::setNumberOfReturns);
            Optional.ofNullable(this.getAdditionalPayment()).ifPresent(builder::setAdditionalPayment);
            Optional.ofNullable(this.getCashSettlement()).ifPresent(builder::setCashSettlement);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FxPerformanceSwap _that = (FxPerformanceSwap)this.getType().cast(o);
            if (!Objects.equals(this.quotedCurrencyPair, _that.getQuotedCurrencyPair())) {
                return false;
            }
            if (!Objects.equals(this.vegaNotional, _that.getVegaNotional())) {
                return false;
            }
            if (!Objects.equals(this.notional, _that.getNotional())) {
                return false;
            }
            if (!Objects.equals(this.fixedLeg, _that.getFixedLeg())) {
                return false;
            }
            if (!Objects.equals(this.floatingLeg, _that.getFloatingLeg())) {
                return false;
            }
            if (!Objects.equals(this.fixingInformationSource, _that.getFixingInformationSource())) {
                return false;
            }
            if (!Objects.equals(this.fixingSchedule, _that.getFixingSchedule())) {
                return false;
            }
            if (!Objects.equals(this.valuationDate, _that.getValuationDate())) {
                return false;
            }
            if (!Objects.equals(this.valuationDateOffset, _that.getValuationDateOffset())) {
                return false;
            }
            if (!Objects.equals(this.settlementDate, _that.getSettlementDate())) {
                return false;
            }
            if (!Objects.equals(this.annualizationFactor, _that.getAnnualizationFactor())) {
                return false;
            }
            if (!Objects.equals(this.meanAdjustment, _that.getMeanAdjustment())) {
                return false;
            }
            if (!Objects.equals(this.numberOfReturns, _that.getNumberOfReturns())) {
                return false;
            }
            if (!ListEquals.listEquals(this.additionalPayment, _that.getAdditionalPayment())) {
                return false;
            }
            return Objects.equals(this.cashSettlement, _that.getCashSettlement());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.quotedCurrencyPair != null ? this.quotedCurrencyPair.hashCode() : 0);
            _result = 31 * _result + (this.vegaNotional != null ? this.vegaNotional.hashCode() : 0);
            _result = 31 * _result + (this.notional != null ? this.notional.hashCode() : 0);
            _result = 31 * _result + (this.fixedLeg != null ? this.fixedLeg.hashCode() : 0);
            _result = 31 * _result + (this.floatingLeg != null ? this.floatingLeg.hashCode() : 0);
            _result = 31 * _result + (this.fixingInformationSource != null ? this.fixingInformationSource.hashCode() : 0);
            _result = 31 * _result + (this.fixingSchedule != null ? this.fixingSchedule.hashCode() : 0);
            _result = 31 * _result + (this.valuationDate != null ? this.valuationDate.hashCode() : 0);
            _result = 31 * _result + (this.valuationDateOffset != null ? this.valuationDateOffset.hashCode() : 0);
            _result = 31 * _result + (this.settlementDate != null ? this.settlementDate.hashCode() : 0);
            _result = 31 * _result + (this.annualizationFactor != null ? this.annualizationFactor.hashCode() : 0);
            _result = 31 * _result + (this.meanAdjustment != null ? this.meanAdjustment.hashCode() : 0);
            _result = 31 * _result + (this.numberOfReturns != null ? this.numberOfReturns.hashCode() : 0);
            _result = 31 * _result + (this.additionalPayment != null ? this.additionalPayment.hashCode() : 0);
            _result = 31 * _result + (this.cashSettlement != null ? this.cashSettlement.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FxPerformanceSwap {quotedCurrencyPair=" + this.quotedCurrencyPair + ", vegaNotional=" + this.vegaNotional + ", notional=" + this.notional + ", fixedLeg=" + this.fixedLeg + ", floatingLeg=" + this.floatingLeg + ", fixingInformationSource=" + this.fixingInformationSource + ", fixingSchedule=" + this.fixingSchedule + ", valuationDate=" + this.valuationDate + ", valuationDateOffset=" + this.valuationDateOffset + ", settlementDate=" + this.settlementDate + ", annualizationFactor=" + this.annualizationFactor + ", meanAdjustment=" + this.meanAdjustment + ", numberOfReturns=" + this.numberOfReturns + ", additionalPayment=" + this.additionalPayment + ", cashSettlement=" + this.cashSettlement + '}' + " " + super.toString();
        }
    }
}

