/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.confirmation.ParametricScheduleModel;
import fpml.confirmation.meta.FxFixingScheduleSequence1Meta;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="FxFixingScheduleSequence1", builder=FxFixingScheduleSequence1BuilderImpl.class, version="0.17.2")
@RuneDataType(value="FxFixingScheduleSequence1", model="fpml", builder=FxFixingScheduleSequence1BuilderImpl.class, version="0.17.2")
public interface FxFixingScheduleSequence1
extends RosettaModelObject {
    public static final FxFixingScheduleSequence1Meta metaData = new FxFixingScheduleSequence1Meta();

    public ParametricScheduleModel getParametricScheduleModel();

    public Integer getNumberOfFixings();

    public List<ZonedDateTime> getFixingDate();

    public FxFixingScheduleSequence1 build();

    public FxFixingScheduleSequence1Builder toBuilder();

    public static FxFixingScheduleSequence1Builder builder() {
        return new FxFixingScheduleSequence1BuilderImpl();
    }

    default public RosettaMetaData<? extends FxFixingScheduleSequence1> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FxFixingScheduleSequence1> getType() {
        return FxFixingScheduleSequence1.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("parametricScheduleModel"), processor, ParametricScheduleModel.class, this.getParametricScheduleModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("numberOfFixings"), Integer.class, (Object)this.getNumberOfFixings(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fixingDate"), ZonedDateTime.class, this.getFixingDate(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class FxFixingScheduleSequence1BuilderImpl
    implements FxFixingScheduleSequence1Builder {
        protected ParametricScheduleModel.ParametricScheduleModelBuilder parametricScheduleModel;
        protected Integer numberOfFixings;
        protected List<ZonedDateTime> fixingDate = new ArrayList<ZonedDateTime>();

        @Override
        @RosettaAttribute(value="parametricScheduleModel", isRequired=true)
        @RuneAttribute(value="parametricScheduleModel", isRequired=true)
        public ParametricScheduleModel.ParametricScheduleModelBuilder getParametricScheduleModel() {
            return this.parametricScheduleModel;
        }

        @Override
        public ParametricScheduleModel.ParametricScheduleModelBuilder getOrCreateParametricScheduleModel() {
            ParametricScheduleModel.ParametricScheduleModelBuilder result = this.parametricScheduleModel != null ? this.parametricScheduleModel : (this.parametricScheduleModel = ParametricScheduleModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="numberOfFixings")
        @RuneAttribute(value="numberOfFixings")
        public Integer getNumberOfFixings() {
            return this.numberOfFixings;
        }

        @Override
        @RosettaAttribute(value="fixingDate")
        @RuneAttribute(value="fixingDate")
        public List<ZonedDateTime> getFixingDate() {
            return this.fixingDate;
        }

        @Override
        @RosettaAttribute(value="parametricScheduleModel", isRequired=true)
        @RuneAttribute(value="parametricScheduleModel", isRequired=true)
        public FxFixingScheduleSequence1Builder setParametricScheduleModel(ParametricScheduleModel _parametricScheduleModel) {
            this.parametricScheduleModel = _parametricScheduleModel == null ? null : _parametricScheduleModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="numberOfFixings")
        @RuneAttribute(value="numberOfFixings")
        public FxFixingScheduleSequence1Builder setNumberOfFixings(Integer _numberOfFixings) {
            this.numberOfFixings = _numberOfFixings == null ? null : _numberOfFixings;
            return this;
        }

        @Override
        @RosettaAttribute(value="fixingDate")
        @RuneAttribute(value="fixingDate")
        public FxFixingScheduleSequence1Builder addFixingDate(ZonedDateTime _fixingDate) {
            if (_fixingDate != null) {
                this.fixingDate.add(_fixingDate);
            }
            return this;
        }

        @Override
        public FxFixingScheduleSequence1Builder addFixingDate(ZonedDateTime _fixingDate, int idx) {
            this.getIndex(this.fixingDate, idx, () -> _fixingDate);
            return this;
        }

        @Override
        public FxFixingScheduleSequence1Builder addFixingDate(List<ZonedDateTime> fixingDates) {
            if (fixingDates != null) {
                for (ZonedDateTime toAdd : fixingDates) {
                    this.fixingDate.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="fixingDate")
        public FxFixingScheduleSequence1Builder setFixingDate(List<ZonedDateTime> fixingDates) {
            this.fixingDate = fixingDates == null ? new ArrayList<ZonedDateTime>() : (List)fixingDates.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public FxFixingScheduleSequence1 build() {
            return new FxFixingScheduleSequence1Impl(this);
        }

        @Override
        public FxFixingScheduleSequence1Builder toBuilder() {
            return this;
        }

        @Override
        public FxFixingScheduleSequence1Builder prune() {
            if (this.parametricScheduleModel != null && !this.parametricScheduleModel.prune().hasData()) {
                this.parametricScheduleModel = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getParametricScheduleModel() != null && this.getParametricScheduleModel().hasData()) {
                return true;
            }
            if (this.getNumberOfFixings() != null) {
                return true;
            }
            return this.getFixingDate() != null && !this.getFixingDate().isEmpty();
        }

        public FxFixingScheduleSequence1Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            FxFixingScheduleSequence1Builder o = (FxFixingScheduleSequence1Builder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getParametricScheduleModel(), (RosettaModelObjectBuilder)o.getParametricScheduleModel(), this::setParametricScheduleModel);
            merger.mergeBasic((Object)this.getNumberOfFixings(), (Object)o.getNumberOfFixings(), this::setNumberOfFixings, new AttributeMeta[0]);
            merger.mergeBasic(this.getFixingDate(), o.getFixingDate(), this::addFixingDate);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FxFixingScheduleSequence1 _that = this.getType().cast(o);
            if (!Objects.equals(this.parametricScheduleModel, _that.getParametricScheduleModel())) {
                return false;
            }
            if (!Objects.equals(this.numberOfFixings, _that.getNumberOfFixings())) {
                return false;
            }
            return ListEquals.listEquals(this.fixingDate, _that.getFixingDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.parametricScheduleModel != null ? this.parametricScheduleModel.hashCode() : 0);
            _result = 31 * _result + (this.numberOfFixings != null ? this.numberOfFixings.hashCode() : 0);
            _result = 31 * _result + (this.fixingDate != null ? this.fixingDate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FxFixingScheduleSequence1Builder {parametricScheduleModel=" + this.parametricScheduleModel + ", numberOfFixings=" + this.numberOfFixings + ", fixingDate=" + this.fixingDate + '}';
        }
    }

    public static interface FxFixingScheduleSequence1Builder
    extends FxFixingScheduleSequence1,
    RosettaModelObjectBuilder {
        public ParametricScheduleModel.ParametricScheduleModelBuilder getOrCreateParametricScheduleModel();

        @Override
        public ParametricScheduleModel.ParametricScheduleModelBuilder getParametricScheduleModel();

        public FxFixingScheduleSequence1Builder setParametricScheduleModel(ParametricScheduleModel var1);

        public FxFixingScheduleSequence1Builder setNumberOfFixings(Integer var1);

        public FxFixingScheduleSequence1Builder addFixingDate(ZonedDateTime var1);

        public FxFixingScheduleSequence1Builder addFixingDate(ZonedDateTime var1, int var2);

        public FxFixingScheduleSequence1Builder addFixingDate(List<ZonedDateTime> var1);

        public FxFixingScheduleSequence1Builder setFixingDate(List<ZonedDateTime> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("parametricScheduleModel"), processor, ParametricScheduleModel.ParametricScheduleModelBuilder.class, this.getParametricScheduleModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("numberOfFixings"), Integer.class, (Object)this.getNumberOfFixings(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fixingDate"), ZonedDateTime.class, this.getFixingDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public FxFixingScheduleSequence1Builder prune();
    }

    public static class FxFixingScheduleSequence1Impl
    implements FxFixingScheduleSequence1 {
        private final ParametricScheduleModel parametricScheduleModel;
        private final Integer numberOfFixings;
        private final List<ZonedDateTime> fixingDate;

        protected FxFixingScheduleSequence1Impl(FxFixingScheduleSequence1Builder builder) {
            this.parametricScheduleModel = Optional.ofNullable(builder.getParametricScheduleModel()).map(f -> f.build()).orElse(null);
            this.numberOfFixings = builder.getNumberOfFixings();
            this.fixingDate = Optional.ofNullable(builder.getFixingDate()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
        }

        @Override
        @RosettaAttribute(value="parametricScheduleModel", isRequired=true)
        @RuneAttribute(value="parametricScheduleModel", isRequired=true)
        public ParametricScheduleModel getParametricScheduleModel() {
            return this.parametricScheduleModel;
        }

        @Override
        @RosettaAttribute(value="numberOfFixings")
        @RuneAttribute(value="numberOfFixings")
        public Integer getNumberOfFixings() {
            return this.numberOfFixings;
        }

        @Override
        @RosettaAttribute(value="fixingDate")
        @RuneAttribute(value="fixingDate")
        public List<ZonedDateTime> getFixingDate() {
            return this.fixingDate;
        }

        @Override
        public FxFixingScheduleSequence1 build() {
            return this;
        }

        @Override
        public FxFixingScheduleSequence1Builder toBuilder() {
            FxFixingScheduleSequence1Builder builder = FxFixingScheduleSequence1.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FxFixingScheduleSequence1Builder builder) {
            Optional.ofNullable(this.getParametricScheduleModel()).ifPresent(builder::setParametricScheduleModel);
            Optional.ofNullable(this.getNumberOfFixings()).ifPresent(builder::setNumberOfFixings);
            Optional.ofNullable(this.getFixingDate()).ifPresent(builder::setFixingDate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FxFixingScheduleSequence1 _that = this.getType().cast(o);
            if (!Objects.equals(this.parametricScheduleModel, _that.getParametricScheduleModel())) {
                return false;
            }
            if (!Objects.equals(this.numberOfFixings, _that.getNumberOfFixings())) {
                return false;
            }
            return ListEquals.listEquals(this.fixingDate, _that.getFixingDate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.parametricScheduleModel != null ? this.parametricScheduleModel.hashCode() : 0);
            _result = 31 * _result + (this.numberOfFixings != null ? this.numberOfFixings.hashCode() : 0);
            _result = 31 * _result + (this.fixingDate != null ? this.fixingDate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FxFixingScheduleSequence1 {parametricScheduleModel=" + this.parametricScheduleModel + ", numberOfFixings=" + this.numberOfFixings + ", fixingDate=" + this.fixingDate + '}';
        }
    }
}

