/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.confirmation.Currency;
import fpml.confirmation.FxFixing;
import fpml.confirmation.FxRateSourceFixing;
import fpml.confirmation.meta.FxCashSettlementSimpleMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="FxCashSettlementSimple", builder=FxCashSettlementSimpleBuilderImpl.class, version="0.17.2")
@RuneDataType(value="FxCashSettlementSimple", model="fpml", builder=FxCashSettlementSimpleBuilderImpl.class, version="0.17.2")
public interface FxCashSettlementSimple
extends RosettaModelObject {
    public static final FxCashSettlementSimpleMeta metaData = new FxCashSettlementSimpleMeta();

    public Currency getSettlementCurrency();

    public Currency getReferenceCurrency();

    public List<? extends FxFixing> getFixing();

    public List<? extends FxRateSourceFixing> getRateSourceFixing();

    public FxCashSettlementSimple build();

    public FxCashSettlementSimpleBuilder toBuilder();

    public static FxCashSettlementSimpleBuilder builder() {
        return new FxCashSettlementSimpleBuilderImpl();
    }

    default public RosettaMetaData<? extends FxCashSettlementSimple> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FxCashSettlementSimple> getType() {
        return FxCashSettlementSimple.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("settlementCurrency"), processor, Currency.class, this.getSettlementCurrency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("referenceCurrency"), processor, Currency.class, this.getReferenceCurrency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fixing"), processor, FxFixing.class, this.getFixing(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("rateSourceFixing"), processor, FxRateSourceFixing.class, this.getRateSourceFixing(), new AttributeMeta[0]);
    }

    public static class FxCashSettlementSimpleBuilderImpl
    implements FxCashSettlementSimpleBuilder {
        protected Currency.CurrencyBuilder settlementCurrency;
        protected Currency.CurrencyBuilder referenceCurrency;
        protected List<FxFixing.FxFixingBuilder> fixing = new ArrayList<FxFixing.FxFixingBuilder>();
        protected List<FxRateSourceFixing.FxRateSourceFixingBuilder> rateSourceFixing = new ArrayList<FxRateSourceFixing.FxRateSourceFixingBuilder>();

        @Override
        @RosettaAttribute(value="settlementCurrency", isRequired=true)
        @RuneAttribute(value="settlementCurrency", isRequired=true)
        public Currency.CurrencyBuilder getSettlementCurrency() {
            return this.settlementCurrency;
        }

        @Override
        public Currency.CurrencyBuilder getOrCreateSettlementCurrency() {
            Currency.CurrencyBuilder result = this.settlementCurrency != null ? this.settlementCurrency : (this.settlementCurrency = Currency.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="referenceCurrency")
        @RuneAttribute(value="referenceCurrency")
        public Currency.CurrencyBuilder getReferenceCurrency() {
            return this.referenceCurrency;
        }

        @Override
        public Currency.CurrencyBuilder getOrCreateReferenceCurrency() {
            Currency.CurrencyBuilder result = this.referenceCurrency != null ? this.referenceCurrency : (this.referenceCurrency = Currency.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fixing")
        @RuneAttribute(value="fixing")
        public List<? extends FxFixing.FxFixingBuilder> getFixing() {
            return this.fixing;
        }

        @Override
        public FxFixing.FxFixingBuilder getOrCreateFixing(int index) {
            if (this.fixing == null) {
                this.fixing = new ArrayList<FxFixing.FxFixingBuilder>();
            }
            return (FxFixing.FxFixingBuilder)this.getIndex(this.fixing, index, () -> {
                FxFixing.FxFixingBuilder newFixing = FxFixing.builder();
                return newFixing;
            });
        }

        @Override
        @RosettaAttribute(value="rateSourceFixing")
        @RuneAttribute(value="rateSourceFixing")
        public List<? extends FxRateSourceFixing.FxRateSourceFixingBuilder> getRateSourceFixing() {
            return this.rateSourceFixing;
        }

        @Override
        public FxRateSourceFixing.FxRateSourceFixingBuilder getOrCreateRateSourceFixing(int index) {
            if (this.rateSourceFixing == null) {
                this.rateSourceFixing = new ArrayList<FxRateSourceFixing.FxRateSourceFixingBuilder>();
            }
            return (FxRateSourceFixing.FxRateSourceFixingBuilder)this.getIndex(this.rateSourceFixing, index, () -> {
                FxRateSourceFixing.FxRateSourceFixingBuilder newRateSourceFixing = FxRateSourceFixing.builder();
                return newRateSourceFixing;
            });
        }

        @Override
        @RosettaAttribute(value="settlementCurrency", isRequired=true)
        @RuneAttribute(value="settlementCurrency", isRequired=true)
        public FxCashSettlementSimpleBuilder setSettlementCurrency(Currency _settlementCurrency) {
            this.settlementCurrency = _settlementCurrency == null ? null : _settlementCurrency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="referenceCurrency")
        @RuneAttribute(value="referenceCurrency")
        public FxCashSettlementSimpleBuilder setReferenceCurrency(Currency _referenceCurrency) {
            this.referenceCurrency = _referenceCurrency == null ? null : _referenceCurrency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fixing")
        @RuneAttribute(value="fixing")
        public FxCashSettlementSimpleBuilder addFixing(FxFixing _fixing) {
            if (_fixing != null) {
                this.fixing.add(_fixing.toBuilder());
            }
            return this;
        }

        @Override
        public FxCashSettlementSimpleBuilder addFixing(FxFixing _fixing, int idx) {
            this.getIndex(this.fixing, idx, () -> _fixing.toBuilder());
            return this;
        }

        @Override
        public FxCashSettlementSimpleBuilder addFixing(List<? extends FxFixing> fixings) {
            if (fixings != null) {
                for (FxFixing fxFixing : fixings) {
                    this.fixing.add(fxFixing.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="fixing")
        public FxCashSettlementSimpleBuilder setFixing(List<? extends FxFixing> fixings) {
            this.fixing = fixings == null ? new ArrayList<FxFixing.FxFixingBuilder>() : (List)fixings.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="rateSourceFixing")
        @RuneAttribute(value="rateSourceFixing")
        public FxCashSettlementSimpleBuilder addRateSourceFixing(FxRateSourceFixing _rateSourceFixing) {
            if (_rateSourceFixing != null) {
                this.rateSourceFixing.add(_rateSourceFixing.toBuilder());
            }
            return this;
        }

        @Override
        public FxCashSettlementSimpleBuilder addRateSourceFixing(FxRateSourceFixing _rateSourceFixing, int idx) {
            this.getIndex(this.rateSourceFixing, idx, () -> _rateSourceFixing.toBuilder());
            return this;
        }

        @Override
        public FxCashSettlementSimpleBuilder addRateSourceFixing(List<? extends FxRateSourceFixing> rateSourceFixings) {
            if (rateSourceFixings != null) {
                for (FxRateSourceFixing fxRateSourceFixing : rateSourceFixings) {
                    this.rateSourceFixing.add(fxRateSourceFixing.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="rateSourceFixing")
        public FxCashSettlementSimpleBuilder setRateSourceFixing(List<? extends FxRateSourceFixing> rateSourceFixings) {
            this.rateSourceFixing = rateSourceFixings == null ? new ArrayList<FxRateSourceFixing.FxRateSourceFixingBuilder>() : (List)rateSourceFixings.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public FxCashSettlementSimple build() {
            return new FxCashSettlementSimpleImpl(this);
        }

        @Override
        public FxCashSettlementSimpleBuilder toBuilder() {
            return this;
        }

        @Override
        public FxCashSettlementSimpleBuilder prune() {
            if (this.settlementCurrency != null && !this.settlementCurrency.prune().hasData()) {
                this.settlementCurrency = null;
            }
            if (this.referenceCurrency != null && !this.referenceCurrency.prune().hasData()) {
                this.referenceCurrency = null;
            }
            this.fixing = this.fixing.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.rateSourceFixing = this.rateSourceFixing.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getSettlementCurrency() != null && this.getSettlementCurrency().hasData()) {
                return true;
            }
            if (this.getReferenceCurrency() != null && this.getReferenceCurrency().hasData()) {
                return true;
            }
            if (this.getFixing() != null && this.getFixing().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getRateSourceFixing() != null && this.getRateSourceFixing().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public FxCashSettlementSimpleBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            FxCashSettlementSimpleBuilder o = (FxCashSettlementSimpleBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSettlementCurrency(), (RosettaModelObjectBuilder)o.getSettlementCurrency(), this::setSettlementCurrency);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getReferenceCurrency(), (RosettaModelObjectBuilder)o.getReferenceCurrency(), this::setReferenceCurrency);
            merger.mergeRosetta(this.getFixing(), o.getFixing(), this::getOrCreateFixing);
            merger.mergeRosetta(this.getRateSourceFixing(), o.getRateSourceFixing(), this::getOrCreateRateSourceFixing);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FxCashSettlementSimple _that = this.getType().cast(o);
            if (!Objects.equals(this.settlementCurrency, _that.getSettlementCurrency())) {
                return false;
            }
            if (!Objects.equals(this.referenceCurrency, _that.getReferenceCurrency())) {
                return false;
            }
            if (!ListEquals.listEquals(this.fixing, _that.getFixing())) {
                return false;
            }
            return ListEquals.listEquals(this.rateSourceFixing, _that.getRateSourceFixing());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.settlementCurrency != null ? this.settlementCurrency.hashCode() : 0);
            _result = 31 * _result + (this.referenceCurrency != null ? this.referenceCurrency.hashCode() : 0);
            _result = 31 * _result + (this.fixing != null ? this.fixing.hashCode() : 0);
            _result = 31 * _result + (this.rateSourceFixing != null ? this.rateSourceFixing.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FxCashSettlementSimpleBuilder {settlementCurrency=" + this.settlementCurrency + ", referenceCurrency=" + this.referenceCurrency + ", fixing=" + this.fixing + ", rateSourceFixing=" + this.rateSourceFixing + '}';
        }
    }

    public static interface FxCashSettlementSimpleBuilder
    extends FxCashSettlementSimple,
    RosettaModelObjectBuilder {
        public Currency.CurrencyBuilder getOrCreateSettlementCurrency();

        @Override
        public Currency.CurrencyBuilder getSettlementCurrency();

        public Currency.CurrencyBuilder getOrCreateReferenceCurrency();

        @Override
        public Currency.CurrencyBuilder getReferenceCurrency();

        public FxFixing.FxFixingBuilder getOrCreateFixing(int var1);

        public List<? extends FxFixing.FxFixingBuilder> getFixing();

        public FxRateSourceFixing.FxRateSourceFixingBuilder getOrCreateRateSourceFixing(int var1);

        public List<? extends FxRateSourceFixing.FxRateSourceFixingBuilder> getRateSourceFixing();

        public FxCashSettlementSimpleBuilder setSettlementCurrency(Currency var1);

        public FxCashSettlementSimpleBuilder setReferenceCurrency(Currency var1);

        public FxCashSettlementSimpleBuilder addFixing(FxFixing var1);

        public FxCashSettlementSimpleBuilder addFixing(FxFixing var1, int var2);

        public FxCashSettlementSimpleBuilder addFixing(List<? extends FxFixing> var1);

        public FxCashSettlementSimpleBuilder setFixing(List<? extends FxFixing> var1);

        public FxCashSettlementSimpleBuilder addRateSourceFixing(FxRateSourceFixing var1);

        public FxCashSettlementSimpleBuilder addRateSourceFixing(FxRateSourceFixing var1, int var2);

        public FxCashSettlementSimpleBuilder addRateSourceFixing(List<? extends FxRateSourceFixing> var1);

        public FxCashSettlementSimpleBuilder setRateSourceFixing(List<? extends FxRateSourceFixing> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("settlementCurrency"), processor, Currency.CurrencyBuilder.class, this.getSettlementCurrency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("referenceCurrency"), processor, Currency.CurrencyBuilder.class, this.getReferenceCurrency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fixing"), processor, FxFixing.FxFixingBuilder.class, this.getFixing(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("rateSourceFixing"), processor, FxRateSourceFixing.FxRateSourceFixingBuilder.class, this.getRateSourceFixing(), new AttributeMeta[0]);
        }

        public FxCashSettlementSimpleBuilder prune();
    }

    public static class FxCashSettlementSimpleImpl
    implements FxCashSettlementSimple {
        private final Currency settlementCurrency;
        private final Currency referenceCurrency;
        private final List<? extends FxFixing> fixing;
        private final List<? extends FxRateSourceFixing> rateSourceFixing;

        protected FxCashSettlementSimpleImpl(FxCashSettlementSimpleBuilder builder) {
            this.settlementCurrency = Optional.ofNullable(builder.getSettlementCurrency()).map(f -> f.build()).orElse(null);
            this.referenceCurrency = Optional.ofNullable(builder.getReferenceCurrency()).map(f -> f.build()).orElse(null);
            this.fixing = Optional.ofNullable(builder.getFixing()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.rateSourceFixing = Optional.ofNullable(builder.getRateSourceFixing()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="settlementCurrency", isRequired=true)
        @RuneAttribute(value="settlementCurrency", isRequired=true)
        public Currency getSettlementCurrency() {
            return this.settlementCurrency;
        }

        @Override
        @RosettaAttribute(value="referenceCurrency")
        @RuneAttribute(value="referenceCurrency")
        public Currency getReferenceCurrency() {
            return this.referenceCurrency;
        }

        @Override
        @RosettaAttribute(value="fixing")
        @RuneAttribute(value="fixing")
        public List<? extends FxFixing> getFixing() {
            return this.fixing;
        }

        @Override
        @RosettaAttribute(value="rateSourceFixing")
        @RuneAttribute(value="rateSourceFixing")
        public List<? extends FxRateSourceFixing> getRateSourceFixing() {
            return this.rateSourceFixing;
        }

        @Override
        public FxCashSettlementSimple build() {
            return this;
        }

        @Override
        public FxCashSettlementSimpleBuilder toBuilder() {
            FxCashSettlementSimpleBuilder builder = FxCashSettlementSimple.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FxCashSettlementSimpleBuilder builder) {
            Optional.ofNullable(this.getSettlementCurrency()).ifPresent(builder::setSettlementCurrency);
            Optional.ofNullable(this.getReferenceCurrency()).ifPresent(builder::setReferenceCurrency);
            Optional.ofNullable(this.getFixing()).ifPresent(builder::setFixing);
            Optional.ofNullable(this.getRateSourceFixing()).ifPresent(builder::setRateSourceFixing);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FxCashSettlementSimple _that = this.getType().cast(o);
            if (!Objects.equals(this.settlementCurrency, _that.getSettlementCurrency())) {
                return false;
            }
            if (!Objects.equals(this.referenceCurrency, _that.getReferenceCurrency())) {
                return false;
            }
            if (!ListEquals.listEquals(this.fixing, _that.getFixing())) {
                return false;
            }
            return ListEquals.listEquals(this.rateSourceFixing, _that.getRateSourceFixing());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.settlementCurrency != null ? this.settlementCurrency.hashCode() : 0);
            _result = 31 * _result + (this.referenceCurrency != null ? this.referenceCurrency.hashCode() : 0);
            _result = 31 * _result + (this.fixing != null ? this.fixing.hashCode() : 0);
            _result = 31 * _result + (this.rateSourceFixing != null ? this.rateSourceFixing.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FxCashSettlementSimple {settlementCurrency=" + this.settlementCurrency + ", referenceCurrency=" + this.referenceCurrency + ", fixing=" + this.fixing + ", rateSourceFixing=" + this.rateSourceFixing + '}';
        }
    }
}

