/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.FxOptionStrikePrice;
import fpml.confirmation.NonNegativeAmountSchedule;
import fpml.confirmation.meta.FxAccrualOptionSequenceMeta;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="FxAccrualOptionSequence", builder=FxAccrualOptionSequenceBuilderImpl.class, version="0.17.2")
@RuneDataType(value="FxAccrualOptionSequence", model="fpml", builder=FxAccrualOptionSequenceBuilderImpl.class, version="0.17.2")
public interface FxAccrualOptionSequence
extends RosettaModelObject {
    public static final FxAccrualOptionSequenceMeta metaData = new FxAccrualOptionSequenceMeta();

    public FxOptionStrikePrice getStrike();

    public NonNegativeAmountSchedule getCounterCurrencyAmount();

    public FxAccrualOptionSequence build();

    public FxAccrualOptionSequenceBuilder toBuilder();

    public static FxAccrualOptionSequenceBuilder builder() {
        return new FxAccrualOptionSequenceBuilderImpl();
    }

    default public RosettaMetaData<? extends FxAccrualOptionSequence> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FxAccrualOptionSequence> getType() {
        return FxAccrualOptionSequence.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("strike"), processor, FxOptionStrikePrice.class, this.getStrike(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("counterCurrencyAmount"), processor, NonNegativeAmountSchedule.class, this.getCounterCurrencyAmount(), new AttributeMeta[0]);
    }

    public static class FxAccrualOptionSequenceBuilderImpl
    implements FxAccrualOptionSequenceBuilder {
        protected FxOptionStrikePrice.FxOptionStrikePriceBuilder strike;
        protected NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder counterCurrencyAmount;

        @Override
        @RosettaAttribute(value="strike", isRequired=true)
        @RuneAttribute(value="strike", isRequired=true)
        public FxOptionStrikePrice.FxOptionStrikePriceBuilder getStrike() {
            return this.strike;
        }

        @Override
        public FxOptionStrikePrice.FxOptionStrikePriceBuilder getOrCreateStrike() {
            FxOptionStrikePrice.FxOptionStrikePriceBuilder result = this.strike != null ? this.strike : (this.strike = FxOptionStrikePrice.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="counterCurrencyAmount")
        @RuneAttribute(value="counterCurrencyAmount")
        public NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder getCounterCurrencyAmount() {
            return this.counterCurrencyAmount;
        }

        @Override
        public NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder getOrCreateCounterCurrencyAmount() {
            NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder result = this.counterCurrencyAmount != null ? this.counterCurrencyAmount : (this.counterCurrencyAmount = NonNegativeAmountSchedule.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="strike", isRequired=true)
        @RuneAttribute(value="strike", isRequired=true)
        public FxAccrualOptionSequenceBuilder setStrike(FxOptionStrikePrice _strike) {
            this.strike = _strike == null ? null : _strike.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="counterCurrencyAmount")
        @RuneAttribute(value="counterCurrencyAmount")
        public FxAccrualOptionSequenceBuilder setCounterCurrencyAmount(NonNegativeAmountSchedule _counterCurrencyAmount) {
            this.counterCurrencyAmount = _counterCurrencyAmount == null ? null : _counterCurrencyAmount.toBuilder();
            return this;
        }

        @Override
        public FxAccrualOptionSequence build() {
            return new FxAccrualOptionSequenceImpl(this);
        }

        @Override
        public FxAccrualOptionSequenceBuilder toBuilder() {
            return this;
        }

        @Override
        public FxAccrualOptionSequenceBuilder prune() {
            if (this.strike != null && !this.strike.prune().hasData()) {
                this.strike = null;
            }
            if (this.counterCurrencyAmount != null && !this.counterCurrencyAmount.prune().hasData()) {
                this.counterCurrencyAmount = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getStrike() != null && this.getStrike().hasData()) {
                return true;
            }
            return this.getCounterCurrencyAmount() != null && this.getCounterCurrencyAmount().hasData();
        }

        public FxAccrualOptionSequenceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            FxAccrualOptionSequenceBuilder o = (FxAccrualOptionSequenceBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getStrike(), (RosettaModelObjectBuilder)o.getStrike(), this::setStrike);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCounterCurrencyAmount(), (RosettaModelObjectBuilder)o.getCounterCurrencyAmount(), this::setCounterCurrencyAmount);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FxAccrualOptionSequence _that = this.getType().cast(o);
            if (!Objects.equals(this.strike, _that.getStrike())) {
                return false;
            }
            return Objects.equals(this.counterCurrencyAmount, _that.getCounterCurrencyAmount());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.strike != null ? this.strike.hashCode() : 0);
            _result = 31 * _result + (this.counterCurrencyAmount != null ? this.counterCurrencyAmount.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FxAccrualOptionSequenceBuilder {strike=" + this.strike + ", counterCurrencyAmount=" + this.counterCurrencyAmount + '}';
        }
    }

    public static interface FxAccrualOptionSequenceBuilder
    extends FxAccrualOptionSequence,
    RosettaModelObjectBuilder {
        public FxOptionStrikePrice.FxOptionStrikePriceBuilder getOrCreateStrike();

        @Override
        public FxOptionStrikePrice.FxOptionStrikePriceBuilder getStrike();

        public NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder getOrCreateCounterCurrencyAmount();

        @Override
        public NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder getCounterCurrencyAmount();

        public FxAccrualOptionSequenceBuilder setStrike(FxOptionStrikePrice var1);

        public FxAccrualOptionSequenceBuilder setCounterCurrencyAmount(NonNegativeAmountSchedule var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("strike"), processor, FxOptionStrikePrice.FxOptionStrikePriceBuilder.class, this.getStrike(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("counterCurrencyAmount"), processor, NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder.class, this.getCounterCurrencyAmount(), new AttributeMeta[0]);
        }

        public FxAccrualOptionSequenceBuilder prune();
    }

    public static class FxAccrualOptionSequenceImpl
    implements FxAccrualOptionSequence {
        private final FxOptionStrikePrice strike;
        private final NonNegativeAmountSchedule counterCurrencyAmount;

        protected FxAccrualOptionSequenceImpl(FxAccrualOptionSequenceBuilder builder) {
            this.strike = Optional.ofNullable(builder.getStrike()).map(f -> f.build()).orElse(null);
            this.counterCurrencyAmount = Optional.ofNullable(builder.getCounterCurrencyAmount()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="strike", isRequired=true)
        @RuneAttribute(value="strike", isRequired=true)
        public FxOptionStrikePrice getStrike() {
            return this.strike;
        }

        @Override
        @RosettaAttribute(value="counterCurrencyAmount")
        @RuneAttribute(value="counterCurrencyAmount")
        public NonNegativeAmountSchedule getCounterCurrencyAmount() {
            return this.counterCurrencyAmount;
        }

        @Override
        public FxAccrualOptionSequence build() {
            return this;
        }

        @Override
        public FxAccrualOptionSequenceBuilder toBuilder() {
            FxAccrualOptionSequenceBuilder builder = FxAccrualOptionSequence.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FxAccrualOptionSequenceBuilder builder) {
            Optional.ofNullable(this.getStrike()).ifPresent(builder::setStrike);
            Optional.ofNullable(this.getCounterCurrencyAmount()).ifPresent(builder::setCounterCurrencyAmount);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FxAccrualOptionSequence _that = this.getType().cast(o);
            if (!Objects.equals(this.strike, _that.getStrike())) {
                return false;
            }
            return Objects.equals(this.counterCurrencyAmount, _that.getCounterCurrencyAmount());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.strike != null ? this.strike.hashCode() : 0);
            _result = 31 * _result + (this.counterCurrencyAmount != null ? this.counterCurrencyAmount.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FxAccrualOptionSequence {strike=" + this.strike + ", counterCurrencyAmount=" + this.counterCurrencyAmount + '}';
        }
    }
}

