/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.confirmation.AbstractFacilityEvent;
import fpml.confirmation.AbstractFacilityNotification;
import fpml.confirmation.CorrelationAndSequenceModel;
import fpml.confirmation.DealDetailsModel;
import fpml.confirmation.EventPayment;
import fpml.confirmation.FacilityDetailsModel;
import fpml.confirmation.FacilityPosition;
import fpml.confirmation.LetterOfCreditDetailsModel;
import fpml.confirmation.LoanContractDetailsModel;
import fpml.confirmation.OnBehalfOfModel;
import fpml.confirmation.Party;
import fpml.confirmation.RequestMessageHeader;
import fpml.confirmation.ValidationModel;
import fpml.confirmation.meta.FacilityNotificationMeta;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="FacilityNotification", builder=FacilityNotificationBuilderImpl.class, version="0.17.2")
@RuneDataType(value="FacilityNotification", model="fpml", builder=FacilityNotificationBuilderImpl.class, version="0.17.2")
public interface FacilityNotification
extends AbstractFacilityNotification {
    public static final FacilityNotificationMeta metaData = new FacilityNotificationMeta();

    public AbstractFacilityEvent getFacilityEventGroup();

    public DealDetailsModel getDealDetailsModel();

    public FacilityDetailsModel getFacilityDetailsModel();

    public List<? extends LoanContractDetailsModel> getLoanContractDetailsModel();

    public List<? extends LetterOfCreditDetailsModel> getLetterOfCreditDetailsModel();

    public List<? extends Party> getParty();

    @Override
    public FacilityNotification build();

    @Override
    public FacilityNotificationBuilder toBuilder();

    public static FacilityNotificationBuilder builder() {
        return new FacilityNotificationBuilderImpl();
    }

    default public RosettaMetaData<? extends FacilityNotification> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FacilityNotification> getType() {
        return FacilityNotification.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.class, this.getHeader(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.class, this.getValidationModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("isCorrection"), Boolean.class, (Object)this.getIsCorrection(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("correlationAndSequenceModel"), processor, CorrelationAndSequenceModel.class, this.getCorrelationAndSequenceModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.class, this.getOnBehalfOfModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("noticeDate"), ZonedDateTime.class, (Object)this.getNoticeDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("isGlobalOnly"), Boolean.class, (Object)this.getIsGlobalOnly(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("eventPayment"), processor, EventPayment.class, this.getEventPayment(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("facilityPosition"), processor, FacilityPosition.class, this.getFacilityPosition(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("facilityEventGroup"), processor, AbstractFacilityEvent.class, this.getFacilityEventGroup(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dealDetailsModel"), processor, DealDetailsModel.class, this.getDealDetailsModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("facilityDetailsModel"), processor, FacilityDetailsModel.class, this.getFacilityDetailsModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("loanContractDetailsModel"), processor, LoanContractDetailsModel.class, this.getLoanContractDetailsModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("letterOfCreditDetailsModel"), processor, LetterOfCreditDetailsModel.class, this.getLetterOfCreditDetailsModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("party"), processor, Party.class, this.getParty(), new AttributeMeta[0]);
    }

    public static class FacilityNotificationBuilderImpl
    extends AbstractFacilityNotification.AbstractFacilityNotificationBuilderImpl
    implements FacilityNotificationBuilder {
        protected AbstractFacilityEvent.AbstractFacilityEventBuilder facilityEventGroup;
        protected DealDetailsModel.DealDetailsModelBuilder dealDetailsModel;
        protected FacilityDetailsModel.FacilityDetailsModelBuilder facilityDetailsModel;
        protected List<LoanContractDetailsModel.LoanContractDetailsModelBuilder> loanContractDetailsModel = new ArrayList<LoanContractDetailsModel.LoanContractDetailsModelBuilder>();
        protected List<LetterOfCreditDetailsModel.LetterOfCreditDetailsModelBuilder> letterOfCreditDetailsModel = new ArrayList<LetterOfCreditDetailsModel.LetterOfCreditDetailsModelBuilder>();
        protected List<Party.PartyBuilder> party = new ArrayList<Party.PartyBuilder>();

        @Override
        @RosettaAttribute(value="facilityEventGroup", isRequired=true)
        @RuneAttribute(value="facilityEventGroup", isRequired=true)
        public AbstractFacilityEvent.AbstractFacilityEventBuilder getFacilityEventGroup() {
            return this.facilityEventGroup;
        }

        @Override
        public AbstractFacilityEvent.AbstractFacilityEventBuilder getOrCreateFacilityEventGroup() {
            AbstractFacilityEvent.AbstractFacilityEventBuilder result = this.facilityEventGroup != null ? this.facilityEventGroup : (this.facilityEventGroup = AbstractFacilityEvent.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="dealDetailsModel")
        @RuneAttribute(value="dealDetailsModel")
        public DealDetailsModel.DealDetailsModelBuilder getDealDetailsModel() {
            return this.dealDetailsModel;
        }

        @Override
        public DealDetailsModel.DealDetailsModelBuilder getOrCreateDealDetailsModel() {
            DealDetailsModel.DealDetailsModelBuilder result = this.dealDetailsModel != null ? this.dealDetailsModel : (this.dealDetailsModel = DealDetailsModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="facilityDetailsModel", isRequired=true)
        @RuneAttribute(value="facilityDetailsModel", isRequired=true)
        public FacilityDetailsModel.FacilityDetailsModelBuilder getFacilityDetailsModel() {
            return this.facilityDetailsModel;
        }

        @Override
        public FacilityDetailsModel.FacilityDetailsModelBuilder getOrCreateFacilityDetailsModel() {
            FacilityDetailsModel.FacilityDetailsModelBuilder result = this.facilityDetailsModel != null ? this.facilityDetailsModel : (this.facilityDetailsModel = FacilityDetailsModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="loanContractDetailsModel")
        @RuneAttribute(value="loanContractDetailsModel")
        public List<? extends LoanContractDetailsModel.LoanContractDetailsModelBuilder> getLoanContractDetailsModel() {
            return this.loanContractDetailsModel;
        }

        @Override
        public LoanContractDetailsModel.LoanContractDetailsModelBuilder getOrCreateLoanContractDetailsModel(int index) {
            if (this.loanContractDetailsModel == null) {
                this.loanContractDetailsModel = new ArrayList<LoanContractDetailsModel.LoanContractDetailsModelBuilder>();
            }
            return (LoanContractDetailsModel.LoanContractDetailsModelBuilder)this.getIndex(this.loanContractDetailsModel, index, () -> {
                LoanContractDetailsModel.LoanContractDetailsModelBuilder newLoanContractDetailsModel = LoanContractDetailsModel.builder();
                return newLoanContractDetailsModel;
            });
        }

        @Override
        @RosettaAttribute(value="letterOfCreditDetailsModel")
        @RuneAttribute(value="letterOfCreditDetailsModel")
        public List<? extends LetterOfCreditDetailsModel.LetterOfCreditDetailsModelBuilder> getLetterOfCreditDetailsModel() {
            return this.letterOfCreditDetailsModel;
        }

        @Override
        public LetterOfCreditDetailsModel.LetterOfCreditDetailsModelBuilder getOrCreateLetterOfCreditDetailsModel(int index) {
            if (this.letterOfCreditDetailsModel == null) {
                this.letterOfCreditDetailsModel = new ArrayList<LetterOfCreditDetailsModel.LetterOfCreditDetailsModelBuilder>();
            }
            return (LetterOfCreditDetailsModel.LetterOfCreditDetailsModelBuilder)this.getIndex(this.letterOfCreditDetailsModel, index, () -> {
                LetterOfCreditDetailsModel.LetterOfCreditDetailsModelBuilder newLetterOfCreditDetailsModel = LetterOfCreditDetailsModel.builder();
                return newLetterOfCreditDetailsModel;
            });
        }

        @Override
        @RosettaAttribute(value="party", isRequired=true)
        @RuneAttribute(value="party", isRequired=true)
        public List<? extends Party.PartyBuilder> getParty() {
            return this.party;
        }

        @Override
        public Party.PartyBuilder getOrCreateParty(int index) {
            if (this.party == null) {
                this.party = new ArrayList<Party.PartyBuilder>();
            }
            return (Party.PartyBuilder)this.getIndex(this.party, index, () -> {
                Party.PartyBuilder newParty = Party.builder();
                return newParty;
            });
        }

        @Override
        @RosettaAttribute(value="fpmlVersion", isRequired=true)
        @RuneAttribute(value="fpmlVersion", isRequired=true)
        public FacilityNotificationBuilder setFpmlVersion(String _fpmlVersion) {
            this.fpmlVersion = _fpmlVersion == null ? null : _fpmlVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="expectedBuild")
        @RuneAttribute(value="expectedBuild")
        public FacilityNotificationBuilder setExpectedBuild(Integer _expectedBuild) {
            this.expectedBuild = _expectedBuild == null ? null : _expectedBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="actualBuild")
        @RuneAttribute(value="actualBuild")
        public FacilityNotificationBuilder setActualBuild(Integer _actualBuild) {
            this.actualBuild = _actualBuild == null ? null : _actualBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="header", isRequired=true)
        @RuneAttribute(value="header", isRequired=true)
        public FacilityNotificationBuilder setHeader(RequestMessageHeader _header) {
            this.header = _header == null ? null : _header.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="validationModel", isRequired=true)
        @RuneAttribute(value="validationModel", isRequired=true)
        public FacilityNotificationBuilder setValidationModel(ValidationModel _validationModel) {
            this.validationModel = _validationModel == null ? null : _validationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="isCorrection", isRequired=true)
        @RuneAttribute(value="isCorrection", isRequired=true)
        public FacilityNotificationBuilder setIsCorrection(Boolean _isCorrection) {
            this.isCorrection = _isCorrection == null ? null : _isCorrection;
            return this;
        }

        @Override
        @RosettaAttribute(value="correlationAndSequenceModel")
        @RuneAttribute(value="correlationAndSequenceModel")
        public FacilityNotificationBuilder setCorrelationAndSequenceModel(CorrelationAndSequenceModel _correlationAndSequenceModel) {
            this.correlationAndSequenceModel = _correlationAndSequenceModel == null ? null : _correlationAndSequenceModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="onBehalfOfModel")
        @RuneAttribute(value="onBehalfOfModel")
        public FacilityNotificationBuilder setOnBehalfOfModel(OnBehalfOfModel _onBehalfOfModel) {
            this.onBehalfOfModel = _onBehalfOfModel == null ? null : _onBehalfOfModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="noticeDate", isRequired=true)
        @RuneAttribute(value="noticeDate", isRequired=true)
        public FacilityNotificationBuilder setNoticeDate(ZonedDateTime _noticeDate) {
            this.noticeDate = _noticeDate == null ? null : _noticeDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="isGlobalOnly", isRequired=true)
        @RuneAttribute(value="isGlobalOnly", isRequired=true)
        public FacilityNotificationBuilder setIsGlobalOnly(Boolean _isGlobalOnly) {
            this.isGlobalOnly = _isGlobalOnly == null ? null : _isGlobalOnly;
            return this;
        }

        @Override
        @RosettaAttribute(value="eventPayment")
        @RuneAttribute(value="eventPayment")
        public FacilityNotificationBuilder addEventPayment(EventPayment _eventPayment) {
            if (_eventPayment != null) {
                this.eventPayment.add(_eventPayment.toBuilder());
            }
            return this;
        }

        @Override
        public FacilityNotificationBuilder addEventPayment(EventPayment _eventPayment, int idx) {
            this.getIndex(this.eventPayment, idx, () -> _eventPayment.toBuilder());
            return this;
        }

        @Override
        public FacilityNotificationBuilder addEventPayment(List<? extends EventPayment> eventPayments) {
            if (eventPayments != null) {
                for (EventPayment eventPayment : eventPayments) {
                    this.eventPayment.add(eventPayment.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="eventPayment")
        public FacilityNotificationBuilder setEventPayment(List<? extends EventPayment> eventPayments) {
            this.eventPayment = eventPayments == null ? new ArrayList() : (List)eventPayments.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="facilityPosition")
        @RuneAttribute(value="facilityPosition")
        public FacilityNotificationBuilder setFacilityPosition(FacilityPosition _facilityPosition) {
            this.facilityPosition = _facilityPosition == null ? null : _facilityPosition.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="facilityEventGroup", isRequired=true)
        @RuneAttribute(value="facilityEventGroup", isRequired=true)
        public FacilityNotificationBuilder setFacilityEventGroup(AbstractFacilityEvent _facilityEventGroup) {
            this.facilityEventGroup = _facilityEventGroup == null ? null : _facilityEventGroup.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dealDetailsModel")
        @RuneAttribute(value="dealDetailsModel")
        public FacilityNotificationBuilder setDealDetailsModel(DealDetailsModel _dealDetailsModel) {
            this.dealDetailsModel = _dealDetailsModel == null ? null : _dealDetailsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="facilityDetailsModel", isRequired=true)
        @RuneAttribute(value="facilityDetailsModel", isRequired=true)
        public FacilityNotificationBuilder setFacilityDetailsModel(FacilityDetailsModel _facilityDetailsModel) {
            this.facilityDetailsModel = _facilityDetailsModel == null ? null : _facilityDetailsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="loanContractDetailsModel")
        @RuneAttribute(value="loanContractDetailsModel")
        public FacilityNotificationBuilder addLoanContractDetailsModel(LoanContractDetailsModel _loanContractDetailsModel) {
            if (_loanContractDetailsModel != null) {
                this.loanContractDetailsModel.add(_loanContractDetailsModel.toBuilder());
            }
            return this;
        }

        @Override
        public FacilityNotificationBuilder addLoanContractDetailsModel(LoanContractDetailsModel _loanContractDetailsModel, int idx) {
            this.getIndex(this.loanContractDetailsModel, idx, () -> _loanContractDetailsModel.toBuilder());
            return this;
        }

        @Override
        public FacilityNotificationBuilder addLoanContractDetailsModel(List<? extends LoanContractDetailsModel> loanContractDetailsModels) {
            if (loanContractDetailsModels != null) {
                for (LoanContractDetailsModel loanContractDetailsModel : loanContractDetailsModels) {
                    this.loanContractDetailsModel.add(loanContractDetailsModel.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="loanContractDetailsModel")
        public FacilityNotificationBuilder setLoanContractDetailsModel(List<? extends LoanContractDetailsModel> loanContractDetailsModels) {
            this.loanContractDetailsModel = loanContractDetailsModels == null ? new ArrayList<LoanContractDetailsModel.LoanContractDetailsModelBuilder>() : (List)loanContractDetailsModels.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="letterOfCreditDetailsModel")
        @RuneAttribute(value="letterOfCreditDetailsModel")
        public FacilityNotificationBuilder addLetterOfCreditDetailsModel(LetterOfCreditDetailsModel _letterOfCreditDetailsModel) {
            if (_letterOfCreditDetailsModel != null) {
                this.letterOfCreditDetailsModel.add(_letterOfCreditDetailsModel.toBuilder());
            }
            return this;
        }

        @Override
        public FacilityNotificationBuilder addLetterOfCreditDetailsModel(LetterOfCreditDetailsModel _letterOfCreditDetailsModel, int idx) {
            this.getIndex(this.letterOfCreditDetailsModel, idx, () -> _letterOfCreditDetailsModel.toBuilder());
            return this;
        }

        @Override
        public FacilityNotificationBuilder addLetterOfCreditDetailsModel(List<? extends LetterOfCreditDetailsModel> letterOfCreditDetailsModels) {
            if (letterOfCreditDetailsModels != null) {
                for (LetterOfCreditDetailsModel letterOfCreditDetailsModel : letterOfCreditDetailsModels) {
                    this.letterOfCreditDetailsModel.add(letterOfCreditDetailsModel.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="letterOfCreditDetailsModel")
        public FacilityNotificationBuilder setLetterOfCreditDetailsModel(List<? extends LetterOfCreditDetailsModel> letterOfCreditDetailsModels) {
            this.letterOfCreditDetailsModel = letterOfCreditDetailsModels == null ? new ArrayList<LetterOfCreditDetailsModel.LetterOfCreditDetailsModelBuilder>() : (List)letterOfCreditDetailsModels.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="party", isRequired=true)
        @RuneAttribute(value="party", isRequired=true)
        public FacilityNotificationBuilder addParty(Party _party) {
            if (_party != null) {
                this.party.add(_party.toBuilder());
            }
            return this;
        }

        @Override
        public FacilityNotificationBuilder addParty(Party _party, int idx) {
            this.getIndex(this.party, idx, () -> _party.toBuilder());
            return this;
        }

        @Override
        public FacilityNotificationBuilder addParty(List<? extends Party> partys) {
            if (partys != null) {
                for (Party party : partys) {
                    this.party.add(party.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="party")
        public FacilityNotificationBuilder setParty(List<? extends Party> partys) {
            this.party = partys == null ? new ArrayList<Party.PartyBuilder>() : (List)partys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public FacilityNotification build() {
            return new FacilityNotificationImpl(this);
        }

        @Override
        public FacilityNotificationBuilder toBuilder() {
            return this;
        }

        @Override
        public FacilityNotificationBuilder prune() {
            super.prune();
            if (this.facilityEventGroup != null && !this.facilityEventGroup.prune().hasData()) {
                this.facilityEventGroup = null;
            }
            if (this.dealDetailsModel != null && !this.dealDetailsModel.prune().hasData()) {
                this.dealDetailsModel = null;
            }
            if (this.facilityDetailsModel != null && !this.facilityDetailsModel.prune().hasData()) {
                this.facilityDetailsModel = null;
            }
            this.loanContractDetailsModel = this.loanContractDetailsModel.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.letterOfCreditDetailsModel = this.letterOfCreditDetailsModel.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.party = this.party.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getFacilityEventGroup() != null && this.getFacilityEventGroup().hasData()) {
                return true;
            }
            if (this.getDealDetailsModel() != null && this.getDealDetailsModel().hasData()) {
                return true;
            }
            if (this.getFacilityDetailsModel() != null && this.getFacilityDetailsModel().hasData()) {
                return true;
            }
            if (this.getLoanContractDetailsModel() != null && this.getLoanContractDetailsModel().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getLetterOfCreditDetailsModel() != null && this.getLetterOfCreditDetailsModel().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getParty() != null && this.getParty().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public FacilityNotificationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            FacilityNotificationBuilder o = (FacilityNotificationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFacilityEventGroup(), (RosettaModelObjectBuilder)o.getFacilityEventGroup(), this::setFacilityEventGroup);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDealDetailsModel(), (RosettaModelObjectBuilder)o.getDealDetailsModel(), this::setDealDetailsModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFacilityDetailsModel(), (RosettaModelObjectBuilder)o.getFacilityDetailsModel(), this::setFacilityDetailsModel);
            merger.mergeRosetta(this.getLoanContractDetailsModel(), o.getLoanContractDetailsModel(), this::getOrCreateLoanContractDetailsModel);
            merger.mergeRosetta(this.getLetterOfCreditDetailsModel(), o.getLetterOfCreditDetailsModel(), this::getOrCreateLetterOfCreditDetailsModel);
            merger.mergeRosetta(this.getParty(), o.getParty(), this::getOrCreateParty);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FacilityNotification _that = (FacilityNotification)this.getType().cast(o);
            if (!Objects.equals(this.facilityEventGroup, _that.getFacilityEventGroup())) {
                return false;
            }
            if (!Objects.equals(this.dealDetailsModel, _that.getDealDetailsModel())) {
                return false;
            }
            if (!Objects.equals(this.facilityDetailsModel, _that.getFacilityDetailsModel())) {
                return false;
            }
            if (!ListEquals.listEquals(this.loanContractDetailsModel, _that.getLoanContractDetailsModel())) {
                return false;
            }
            if (!ListEquals.listEquals(this.letterOfCreditDetailsModel, _that.getLetterOfCreditDetailsModel())) {
                return false;
            }
            return ListEquals.listEquals(this.party, _that.getParty());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.facilityEventGroup != null ? this.facilityEventGroup.hashCode() : 0);
            _result = 31 * _result + (this.dealDetailsModel != null ? this.dealDetailsModel.hashCode() : 0);
            _result = 31 * _result + (this.facilityDetailsModel != null ? this.facilityDetailsModel.hashCode() : 0);
            _result = 31 * _result + (this.loanContractDetailsModel != null ? this.loanContractDetailsModel.hashCode() : 0);
            _result = 31 * _result + (this.letterOfCreditDetailsModel != null ? this.letterOfCreditDetailsModel.hashCode() : 0);
            _result = 31 * _result + (this.party != null ? this.party.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FacilityNotificationBuilder {facilityEventGroup=" + this.facilityEventGroup + ", dealDetailsModel=" + this.dealDetailsModel + ", facilityDetailsModel=" + this.facilityDetailsModel + ", loanContractDetailsModel=" + this.loanContractDetailsModel + ", letterOfCreditDetailsModel=" + this.letterOfCreditDetailsModel + ", party=" + this.party + '}' + " " + super.toString();
        }
    }

    public static interface FacilityNotificationBuilder
    extends FacilityNotification,
    AbstractFacilityNotification.AbstractFacilityNotificationBuilder {
        public AbstractFacilityEvent.AbstractFacilityEventBuilder getOrCreateFacilityEventGroup();

        @Override
        public AbstractFacilityEvent.AbstractFacilityEventBuilder getFacilityEventGroup();

        public DealDetailsModel.DealDetailsModelBuilder getOrCreateDealDetailsModel();

        @Override
        public DealDetailsModel.DealDetailsModelBuilder getDealDetailsModel();

        public FacilityDetailsModel.FacilityDetailsModelBuilder getOrCreateFacilityDetailsModel();

        @Override
        public FacilityDetailsModel.FacilityDetailsModelBuilder getFacilityDetailsModel();

        public LoanContractDetailsModel.LoanContractDetailsModelBuilder getOrCreateLoanContractDetailsModel(int var1);

        public List<? extends LoanContractDetailsModel.LoanContractDetailsModelBuilder> getLoanContractDetailsModel();

        public LetterOfCreditDetailsModel.LetterOfCreditDetailsModelBuilder getOrCreateLetterOfCreditDetailsModel(int var1);

        public List<? extends LetterOfCreditDetailsModel.LetterOfCreditDetailsModelBuilder> getLetterOfCreditDetailsModel();

        public Party.PartyBuilder getOrCreateParty(int var1);

        public List<? extends Party.PartyBuilder> getParty();

        @Override
        public FacilityNotificationBuilder setFpmlVersion(String var1);

        @Override
        public FacilityNotificationBuilder setExpectedBuild(Integer var1);

        @Override
        public FacilityNotificationBuilder setActualBuild(Integer var1);

        @Override
        public FacilityNotificationBuilder setHeader(RequestMessageHeader var1);

        @Override
        public FacilityNotificationBuilder setValidationModel(ValidationModel var1);

        @Override
        public FacilityNotificationBuilder setIsCorrection(Boolean var1);

        @Override
        public FacilityNotificationBuilder setCorrelationAndSequenceModel(CorrelationAndSequenceModel var1);

        @Override
        public FacilityNotificationBuilder setOnBehalfOfModel(OnBehalfOfModel var1);

        @Override
        public FacilityNotificationBuilder setNoticeDate(ZonedDateTime var1);

        @Override
        public FacilityNotificationBuilder setIsGlobalOnly(Boolean var1);

        @Override
        public FacilityNotificationBuilder addEventPayment(EventPayment var1);

        @Override
        public FacilityNotificationBuilder addEventPayment(EventPayment var1, int var2);

        @Override
        public FacilityNotificationBuilder addEventPayment(List<? extends EventPayment> var1);

        @Override
        public FacilityNotificationBuilder setEventPayment(List<? extends EventPayment> var1);

        @Override
        public FacilityNotificationBuilder setFacilityPosition(FacilityPosition var1);

        public FacilityNotificationBuilder setFacilityEventGroup(AbstractFacilityEvent var1);

        public FacilityNotificationBuilder setDealDetailsModel(DealDetailsModel var1);

        public FacilityNotificationBuilder setFacilityDetailsModel(FacilityDetailsModel var1);

        public FacilityNotificationBuilder addLoanContractDetailsModel(LoanContractDetailsModel var1);

        public FacilityNotificationBuilder addLoanContractDetailsModel(LoanContractDetailsModel var1, int var2);

        public FacilityNotificationBuilder addLoanContractDetailsModel(List<? extends LoanContractDetailsModel> var1);

        public FacilityNotificationBuilder setLoanContractDetailsModel(List<? extends LoanContractDetailsModel> var1);

        public FacilityNotificationBuilder addLetterOfCreditDetailsModel(LetterOfCreditDetailsModel var1);

        public FacilityNotificationBuilder addLetterOfCreditDetailsModel(LetterOfCreditDetailsModel var1, int var2);

        public FacilityNotificationBuilder addLetterOfCreditDetailsModel(List<? extends LetterOfCreditDetailsModel> var1);

        public FacilityNotificationBuilder setLetterOfCreditDetailsModel(List<? extends LetterOfCreditDetailsModel> var1);

        public FacilityNotificationBuilder addParty(Party var1);

        public FacilityNotificationBuilder addParty(Party var1, int var2);

        public FacilityNotificationBuilder addParty(List<? extends Party> var1);

        public FacilityNotificationBuilder setParty(List<? extends Party> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.RequestMessageHeaderBuilder.class, (RosettaModelObjectBuilder)this.getHeader(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.ValidationModelBuilder.class, (RosettaModelObjectBuilder)this.getValidationModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("isCorrection"), Boolean.class, (Object)this.getIsCorrection(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("correlationAndSequenceModel"), processor, CorrelationAndSequenceModel.CorrelationAndSequenceModelBuilder.class, (RosettaModelObjectBuilder)this.getCorrelationAndSequenceModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.OnBehalfOfModelBuilder.class, (RosettaModelObjectBuilder)this.getOnBehalfOfModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("noticeDate"), ZonedDateTime.class, (Object)this.getNoticeDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("isGlobalOnly"), Boolean.class, (Object)this.getIsGlobalOnly(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("eventPayment"), processor, EventPayment.EventPaymentBuilder.class, this.getEventPayment(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("facilityPosition"), processor, FacilityPosition.FacilityPositionBuilder.class, (RosettaModelObjectBuilder)this.getFacilityPosition(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("facilityEventGroup"), processor, AbstractFacilityEvent.AbstractFacilityEventBuilder.class, this.getFacilityEventGroup(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dealDetailsModel"), processor, DealDetailsModel.DealDetailsModelBuilder.class, this.getDealDetailsModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("facilityDetailsModel"), processor, FacilityDetailsModel.FacilityDetailsModelBuilder.class, this.getFacilityDetailsModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("loanContractDetailsModel"), processor, LoanContractDetailsModel.LoanContractDetailsModelBuilder.class, this.getLoanContractDetailsModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("letterOfCreditDetailsModel"), processor, LetterOfCreditDetailsModel.LetterOfCreditDetailsModelBuilder.class, this.getLetterOfCreditDetailsModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("party"), processor, Party.PartyBuilder.class, this.getParty(), new AttributeMeta[0]);
        }

        @Override
        public FacilityNotificationBuilder prune();
    }

    public static class FacilityNotificationImpl
    extends AbstractFacilityNotification.AbstractFacilityNotificationImpl
    implements FacilityNotification {
        private final AbstractFacilityEvent facilityEventGroup;
        private final DealDetailsModel dealDetailsModel;
        private final FacilityDetailsModel facilityDetailsModel;
        private final List<? extends LoanContractDetailsModel> loanContractDetailsModel;
        private final List<? extends LetterOfCreditDetailsModel> letterOfCreditDetailsModel;
        private final List<? extends Party> party;

        protected FacilityNotificationImpl(FacilityNotificationBuilder builder) {
            super(builder);
            this.facilityEventGroup = Optional.ofNullable(builder.getFacilityEventGroup()).map(f -> f.build()).orElse(null);
            this.dealDetailsModel = Optional.ofNullable(builder.getDealDetailsModel()).map(f -> f.build()).orElse(null);
            this.facilityDetailsModel = Optional.ofNullable(builder.getFacilityDetailsModel()).map(f -> f.build()).orElse(null);
            this.loanContractDetailsModel = Optional.ofNullable(builder.getLoanContractDetailsModel()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.letterOfCreditDetailsModel = Optional.ofNullable(builder.getLetterOfCreditDetailsModel()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.party = Optional.ofNullable(builder.getParty()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="facilityEventGroup", isRequired=true)
        @RuneAttribute(value="facilityEventGroup", isRequired=true)
        public AbstractFacilityEvent getFacilityEventGroup() {
            return this.facilityEventGroup;
        }

        @Override
        @RosettaAttribute(value="dealDetailsModel")
        @RuneAttribute(value="dealDetailsModel")
        public DealDetailsModel getDealDetailsModel() {
            return this.dealDetailsModel;
        }

        @Override
        @RosettaAttribute(value="facilityDetailsModel", isRequired=true)
        @RuneAttribute(value="facilityDetailsModel", isRequired=true)
        public FacilityDetailsModel getFacilityDetailsModel() {
            return this.facilityDetailsModel;
        }

        @Override
        @RosettaAttribute(value="loanContractDetailsModel")
        @RuneAttribute(value="loanContractDetailsModel")
        public List<? extends LoanContractDetailsModel> getLoanContractDetailsModel() {
            return this.loanContractDetailsModel;
        }

        @Override
        @RosettaAttribute(value="letterOfCreditDetailsModel")
        @RuneAttribute(value="letterOfCreditDetailsModel")
        public List<? extends LetterOfCreditDetailsModel> getLetterOfCreditDetailsModel() {
            return this.letterOfCreditDetailsModel;
        }

        @Override
        @RosettaAttribute(value="party", isRequired=true)
        @RuneAttribute(value="party", isRequired=true)
        public List<? extends Party> getParty() {
            return this.party;
        }

        @Override
        public FacilityNotification build() {
            return this;
        }

        @Override
        public FacilityNotificationBuilder toBuilder() {
            FacilityNotificationBuilder builder = FacilityNotification.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FacilityNotificationBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getFacilityEventGroup()).ifPresent(builder::setFacilityEventGroup);
            Optional.ofNullable(this.getDealDetailsModel()).ifPresent(builder::setDealDetailsModel);
            Optional.ofNullable(this.getFacilityDetailsModel()).ifPresent(builder::setFacilityDetailsModel);
            Optional.ofNullable(this.getLoanContractDetailsModel()).ifPresent(builder::setLoanContractDetailsModel);
            Optional.ofNullable(this.getLetterOfCreditDetailsModel()).ifPresent(builder::setLetterOfCreditDetailsModel);
            Optional.ofNullable(this.getParty()).ifPresent(builder::setParty);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FacilityNotification _that = (FacilityNotification)this.getType().cast(o);
            if (!Objects.equals(this.facilityEventGroup, _that.getFacilityEventGroup())) {
                return false;
            }
            if (!Objects.equals(this.dealDetailsModel, _that.getDealDetailsModel())) {
                return false;
            }
            if (!Objects.equals(this.facilityDetailsModel, _that.getFacilityDetailsModel())) {
                return false;
            }
            if (!ListEquals.listEquals(this.loanContractDetailsModel, _that.getLoanContractDetailsModel())) {
                return false;
            }
            if (!ListEquals.listEquals(this.letterOfCreditDetailsModel, _that.getLetterOfCreditDetailsModel())) {
                return false;
            }
            return ListEquals.listEquals(this.party, _that.getParty());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.facilityEventGroup != null ? this.facilityEventGroup.hashCode() : 0);
            _result = 31 * _result + (this.dealDetailsModel != null ? this.dealDetailsModel.hashCode() : 0);
            _result = 31 * _result + (this.facilityDetailsModel != null ? this.facilityDetailsModel.hashCode() : 0);
            _result = 31 * _result + (this.loanContractDetailsModel != null ? this.loanContractDetailsModel.hashCode() : 0);
            _result = 31 * _result + (this.letterOfCreditDetailsModel != null ? this.letterOfCreditDetailsModel.hashCode() : 0);
            _result = 31 * _result + (this.party != null ? this.party.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FacilityNotification {facilityEventGroup=" + this.facilityEventGroup + ", dealDetailsModel=" + this.dealDetailsModel + ", facilityDetailsModel=" + this.facilityDetailsModel + ", loanContractDetailsModel=" + this.loanContractDetailsModel + ", letterOfCreditDetailsModel=" + this.letterOfCreditDetailsModel + ", party=" + this.party + '}' + " " + super.toString();
        }
    }
}

