/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.confirmation.CommodityClassification;
import fpml.confirmation.CommodityDeliveryPeriods;
import fpml.confirmation.ElectricityDelivery;
import fpml.confirmation.ElectricityPhysicalQuantity;
import fpml.confirmation.ElectricityProduct;
import fpml.confirmation.LoadTypeEnum;
import fpml.confirmation.PayerReceiverModel;
import fpml.confirmation.PhysicalSwapLeg;
import fpml.confirmation.SettlementPeriods;
import fpml.confirmation.SettlementPeriodsSchedule;
import fpml.confirmation.meta.ElectricityPhysicalLegMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ElectricityPhysicalLeg", builder=ElectricityPhysicalLegBuilderImpl.class, version="0.17.2")
@RuneDataType(value="ElectricityPhysicalLeg", model="fpml", builder=ElectricityPhysicalLegBuilderImpl.class, version="0.17.2")
public interface ElectricityPhysicalLeg
extends PhysicalSwapLeg {
    public static final ElectricityPhysicalLegMeta metaData = new ElectricityPhysicalLegMeta();

    public CommodityDeliveryPeriods getDeliveryPeriods();

    public List<? extends SettlementPeriods> getSettlementPeriods();

    public SettlementPeriodsSchedule getSettlementPeriodsSchedule();

    public LoadTypeEnum getLoadType();

    public ElectricityProduct getElectricity();

    public ElectricityDelivery getDeliveryConditions();

    public ElectricityPhysicalQuantity getDeliveryQuantity();

    @Override
    public ElectricityPhysicalLeg build();

    @Override
    public ElectricityPhysicalLegBuilder toBuilder();

    public static ElectricityPhysicalLegBuilder builder() {
        return new ElectricityPhysicalLegBuilderImpl();
    }

    default public RosettaMetaData<? extends ElectricityPhysicalLeg> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ElectricityPhysicalLeg> getType() {
        return ElectricityPhysicalLeg.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("commodityClassification"), processor, CommodityClassification.class, this.getCommodityClassification(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("payerReceiverModel"), processor, PayerReceiverModel.class, this.getPayerReceiverModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("deliveryPeriods"), processor, CommodityDeliveryPeriods.class, this.getDeliveryPeriods(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("settlementPeriods"), processor, SettlementPeriods.class, this.getSettlementPeriods(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("settlementPeriodsSchedule"), processor, SettlementPeriodsSchedule.class, this.getSettlementPeriodsSchedule(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("loadType"), LoadTypeEnum.class, (Object)this.getLoadType(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("electricity"), processor, ElectricityProduct.class, this.getElectricity(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("deliveryConditions"), processor, ElectricityDelivery.class, this.getDeliveryConditions(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("deliveryQuantity"), processor, ElectricityPhysicalQuantity.class, this.getDeliveryQuantity(), new AttributeMeta[0]);
    }

    public static class ElectricityPhysicalLegBuilderImpl
    extends PhysicalSwapLeg.PhysicalSwapLegBuilderImpl
    implements ElectricityPhysicalLegBuilder {
        protected CommodityDeliveryPeriods.CommodityDeliveryPeriodsBuilder deliveryPeriods;
        protected List<SettlementPeriods.SettlementPeriodsBuilder> settlementPeriods = new ArrayList<SettlementPeriods.SettlementPeriodsBuilder>();
        protected SettlementPeriodsSchedule.SettlementPeriodsScheduleBuilder settlementPeriodsSchedule;
        protected LoadTypeEnum loadType;
        protected ElectricityProduct.ElectricityProductBuilder electricity;
        protected ElectricityDelivery.ElectricityDeliveryBuilder deliveryConditions;
        protected ElectricityPhysicalQuantity.ElectricityPhysicalQuantityBuilder deliveryQuantity;

        @Override
        @RosettaAttribute(value="deliveryPeriods", isRequired=true)
        @RuneAttribute(value="deliveryPeriods", isRequired=true)
        public CommodityDeliveryPeriods.CommodityDeliveryPeriodsBuilder getDeliveryPeriods() {
            return this.deliveryPeriods;
        }

        @Override
        public CommodityDeliveryPeriods.CommodityDeliveryPeriodsBuilder getOrCreateDeliveryPeriods() {
            CommodityDeliveryPeriods.CommodityDeliveryPeriodsBuilder result = this.deliveryPeriods != null ? this.deliveryPeriods : (this.deliveryPeriods = CommodityDeliveryPeriods.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="settlementPeriods", isRequired=true)
        @RuneAttribute(value="settlementPeriods", isRequired=true)
        public List<? extends SettlementPeriods.SettlementPeriodsBuilder> getSettlementPeriods() {
            return this.settlementPeriods;
        }

        @Override
        public SettlementPeriods.SettlementPeriodsBuilder getOrCreateSettlementPeriods(int index) {
            if (this.settlementPeriods == null) {
                this.settlementPeriods = new ArrayList<SettlementPeriods.SettlementPeriodsBuilder>();
            }
            return (SettlementPeriods.SettlementPeriodsBuilder)this.getIndex(this.settlementPeriods, index, () -> {
                SettlementPeriods.SettlementPeriodsBuilder newSettlementPeriods = SettlementPeriods.builder();
                return newSettlementPeriods;
            });
        }

        @Override
        @RosettaAttribute(value="settlementPeriodsSchedule")
        @RuneAttribute(value="settlementPeriodsSchedule")
        public SettlementPeriodsSchedule.SettlementPeriodsScheduleBuilder getSettlementPeriodsSchedule() {
            return this.settlementPeriodsSchedule;
        }

        @Override
        public SettlementPeriodsSchedule.SettlementPeriodsScheduleBuilder getOrCreateSettlementPeriodsSchedule() {
            SettlementPeriodsSchedule.SettlementPeriodsScheduleBuilder result = this.settlementPeriodsSchedule != null ? this.settlementPeriodsSchedule : (this.settlementPeriodsSchedule = SettlementPeriodsSchedule.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="loadType")
        @RuneAttribute(value="loadType")
        public LoadTypeEnum getLoadType() {
            return this.loadType;
        }

        @Override
        @RosettaAttribute(value="electricity", isRequired=true)
        @RuneAttribute(value="electricity", isRequired=true)
        public ElectricityProduct.ElectricityProductBuilder getElectricity() {
            return this.electricity;
        }

        @Override
        public ElectricityProduct.ElectricityProductBuilder getOrCreateElectricity() {
            ElectricityProduct.ElectricityProductBuilder result = this.electricity != null ? this.electricity : (this.electricity = ElectricityProduct.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="deliveryConditions", isRequired=true)
        @RuneAttribute(value="deliveryConditions", isRequired=true)
        public ElectricityDelivery.ElectricityDeliveryBuilder getDeliveryConditions() {
            return this.deliveryConditions;
        }

        @Override
        public ElectricityDelivery.ElectricityDeliveryBuilder getOrCreateDeliveryConditions() {
            ElectricityDelivery.ElectricityDeliveryBuilder result = this.deliveryConditions != null ? this.deliveryConditions : (this.deliveryConditions = ElectricityDelivery.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="deliveryQuantity", isRequired=true)
        @RuneAttribute(value="deliveryQuantity", isRequired=true)
        public ElectricityPhysicalQuantity.ElectricityPhysicalQuantityBuilder getDeliveryQuantity() {
            return this.deliveryQuantity;
        }

        @Override
        public ElectricityPhysicalQuantity.ElectricityPhysicalQuantityBuilder getOrCreateDeliveryQuantity() {
            ElectricityPhysicalQuantity.ElectricityPhysicalQuantityBuilder result = this.deliveryQuantity != null ? this.deliveryQuantity : (this.deliveryQuantity = ElectricityPhysicalQuantity.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public ElectricityPhysicalLegBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="commodityClassification")
        @RuneAttribute(value="commodityClassification")
        public ElectricityPhysicalLegBuilder addCommodityClassification(CommodityClassification _commodityClassification) {
            if (_commodityClassification != null) {
                this.commodityClassification.add(_commodityClassification.toBuilder());
            }
            return this;
        }

        @Override
        public ElectricityPhysicalLegBuilder addCommodityClassification(CommodityClassification _commodityClassification, int idx) {
            this.getIndex(this.commodityClassification, idx, () -> _commodityClassification.toBuilder());
            return this;
        }

        @Override
        public ElectricityPhysicalLegBuilder addCommodityClassification(List<? extends CommodityClassification> commodityClassifications) {
            if (commodityClassifications != null) {
                for (CommodityClassification commodityClassification : commodityClassifications) {
                    this.commodityClassification.add(commodityClassification.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="commodityClassification")
        public ElectricityPhysicalLegBuilder setCommodityClassification(List<? extends CommodityClassification> commodityClassifications) {
            this.commodityClassification = commodityClassifications == null ? new ArrayList() : (List)commodityClassifications.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="payerReceiverModel", isRequired=true)
        @RuneAttribute(value="payerReceiverModel", isRequired=true)
        public ElectricityPhysicalLegBuilder setPayerReceiverModel(PayerReceiverModel _payerReceiverModel) {
            this.payerReceiverModel = _payerReceiverModel == null ? null : _payerReceiverModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="deliveryPeriods", isRequired=true)
        @RuneAttribute(value="deliveryPeriods", isRequired=true)
        public ElectricityPhysicalLegBuilder setDeliveryPeriods(CommodityDeliveryPeriods _deliveryPeriods) {
            this.deliveryPeriods = _deliveryPeriods == null ? null : _deliveryPeriods.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementPeriods", isRequired=true)
        @RuneAttribute(value="settlementPeriods", isRequired=true)
        public ElectricityPhysicalLegBuilder addSettlementPeriods(SettlementPeriods _settlementPeriods) {
            if (_settlementPeriods != null) {
                this.settlementPeriods.add(_settlementPeriods.toBuilder());
            }
            return this;
        }

        @Override
        public ElectricityPhysicalLegBuilder addSettlementPeriods(SettlementPeriods _settlementPeriods, int idx) {
            this.getIndex(this.settlementPeriods, idx, () -> _settlementPeriods.toBuilder());
            return this;
        }

        @Override
        public ElectricityPhysicalLegBuilder addSettlementPeriods(List<? extends SettlementPeriods> settlementPeriodss) {
            if (settlementPeriodss != null) {
                for (SettlementPeriods settlementPeriods : settlementPeriodss) {
                    this.settlementPeriods.add(settlementPeriods.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="settlementPeriods")
        public ElectricityPhysicalLegBuilder setSettlementPeriods(List<? extends SettlementPeriods> settlementPeriodss) {
            this.settlementPeriods = settlementPeriodss == null ? new ArrayList<SettlementPeriods.SettlementPeriodsBuilder>() : (List)settlementPeriodss.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementPeriodsSchedule")
        @RuneAttribute(value="settlementPeriodsSchedule")
        public ElectricityPhysicalLegBuilder setSettlementPeriodsSchedule(SettlementPeriodsSchedule _settlementPeriodsSchedule) {
            this.settlementPeriodsSchedule = _settlementPeriodsSchedule == null ? null : _settlementPeriodsSchedule.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="loadType")
        @RuneAttribute(value="loadType")
        public ElectricityPhysicalLegBuilder setLoadType(LoadTypeEnum _loadType) {
            this.loadType = _loadType == null ? null : _loadType;
            return this;
        }

        @Override
        @RosettaAttribute(value="electricity", isRequired=true)
        @RuneAttribute(value="electricity", isRequired=true)
        public ElectricityPhysicalLegBuilder setElectricity(ElectricityProduct _electricity) {
            this.electricity = _electricity == null ? null : _electricity.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="deliveryConditions", isRequired=true)
        @RuneAttribute(value="deliveryConditions", isRequired=true)
        public ElectricityPhysicalLegBuilder setDeliveryConditions(ElectricityDelivery _deliveryConditions) {
            this.deliveryConditions = _deliveryConditions == null ? null : _deliveryConditions.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="deliveryQuantity", isRequired=true)
        @RuneAttribute(value="deliveryQuantity", isRequired=true)
        public ElectricityPhysicalLegBuilder setDeliveryQuantity(ElectricityPhysicalQuantity _deliveryQuantity) {
            this.deliveryQuantity = _deliveryQuantity == null ? null : _deliveryQuantity.toBuilder();
            return this;
        }

        @Override
        public ElectricityPhysicalLeg build() {
            return new ElectricityPhysicalLegImpl(this);
        }

        @Override
        public ElectricityPhysicalLegBuilder toBuilder() {
            return this;
        }

        @Override
        public ElectricityPhysicalLegBuilder prune() {
            super.prune();
            if (this.deliveryPeriods != null && !this.deliveryPeriods.prune().hasData()) {
                this.deliveryPeriods = null;
            }
            this.settlementPeriods = this.settlementPeriods.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.settlementPeriodsSchedule != null && !this.settlementPeriodsSchedule.prune().hasData()) {
                this.settlementPeriodsSchedule = null;
            }
            if (this.electricity != null && !this.electricity.prune().hasData()) {
                this.electricity = null;
            }
            if (this.deliveryConditions != null && !this.deliveryConditions.prune().hasData()) {
                this.deliveryConditions = null;
            }
            if (this.deliveryQuantity != null && !this.deliveryQuantity.prune().hasData()) {
                this.deliveryQuantity = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getDeliveryPeriods() != null && this.getDeliveryPeriods().hasData()) {
                return true;
            }
            if (this.getSettlementPeriods() != null && this.getSettlementPeriods().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getSettlementPeriodsSchedule() != null && this.getSettlementPeriodsSchedule().hasData()) {
                return true;
            }
            if (this.getLoadType() != null) {
                return true;
            }
            if (this.getElectricity() != null && this.getElectricity().hasData()) {
                return true;
            }
            if (this.getDeliveryConditions() != null && this.getDeliveryConditions().hasData()) {
                return true;
            }
            return this.getDeliveryQuantity() != null && this.getDeliveryQuantity().hasData();
        }

        @Override
        public ElectricityPhysicalLegBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            ElectricityPhysicalLegBuilder o = (ElectricityPhysicalLegBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDeliveryPeriods(), (RosettaModelObjectBuilder)o.getDeliveryPeriods(), this::setDeliveryPeriods);
            merger.mergeRosetta(this.getSettlementPeriods(), o.getSettlementPeriods(), this::getOrCreateSettlementPeriods);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSettlementPeriodsSchedule(), (RosettaModelObjectBuilder)o.getSettlementPeriodsSchedule(), this::setSettlementPeriodsSchedule);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getElectricity(), (RosettaModelObjectBuilder)o.getElectricity(), this::setElectricity);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDeliveryConditions(), (RosettaModelObjectBuilder)o.getDeliveryConditions(), this::setDeliveryConditions);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDeliveryQuantity(), (RosettaModelObjectBuilder)o.getDeliveryQuantity(), this::setDeliveryQuantity);
            merger.mergeBasic((Object)this.getLoadType(), (Object)o.getLoadType(), this::setLoadType, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ElectricityPhysicalLeg _that = (ElectricityPhysicalLeg)this.getType().cast(o);
            if (!Objects.equals(this.deliveryPeriods, _that.getDeliveryPeriods())) {
                return false;
            }
            if (!ListEquals.listEquals(this.settlementPeriods, _that.getSettlementPeriods())) {
                return false;
            }
            if (!Objects.equals(this.settlementPeriodsSchedule, _that.getSettlementPeriodsSchedule())) {
                return false;
            }
            if (!Objects.equals((Object)this.loadType, (Object)_that.getLoadType())) {
                return false;
            }
            if (!Objects.equals(this.electricity, _that.getElectricity())) {
                return false;
            }
            if (!Objects.equals(this.deliveryConditions, _that.getDeliveryConditions())) {
                return false;
            }
            return Objects.equals(this.deliveryQuantity, _that.getDeliveryQuantity());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.deliveryPeriods != null ? this.deliveryPeriods.hashCode() : 0);
            _result = 31 * _result + (this.settlementPeriods != null ? this.settlementPeriods.hashCode() : 0);
            _result = 31 * _result + (this.settlementPeriodsSchedule != null ? this.settlementPeriodsSchedule.hashCode() : 0);
            _result = 31 * _result + (this.loadType != null ? ((Object)((Object)this.loadType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.electricity != null ? this.electricity.hashCode() : 0);
            _result = 31 * _result + (this.deliveryConditions != null ? this.deliveryConditions.hashCode() : 0);
            _result = 31 * _result + (this.deliveryQuantity != null ? this.deliveryQuantity.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ElectricityPhysicalLegBuilder {deliveryPeriods=" + this.deliveryPeriods + ", settlementPeriods=" + this.settlementPeriods + ", settlementPeriodsSchedule=" + this.settlementPeriodsSchedule + ", loadType=" + (Object)((Object)this.loadType) + ", electricity=" + this.electricity + ", deliveryConditions=" + this.deliveryConditions + ", deliveryQuantity=" + this.deliveryQuantity + '}' + " " + super.toString();
        }
    }

    public static interface ElectricityPhysicalLegBuilder
    extends ElectricityPhysicalLeg,
    PhysicalSwapLeg.PhysicalSwapLegBuilder {
        public CommodityDeliveryPeriods.CommodityDeliveryPeriodsBuilder getOrCreateDeliveryPeriods();

        @Override
        public CommodityDeliveryPeriods.CommodityDeliveryPeriodsBuilder getDeliveryPeriods();

        public SettlementPeriods.SettlementPeriodsBuilder getOrCreateSettlementPeriods(int var1);

        public List<? extends SettlementPeriods.SettlementPeriodsBuilder> getSettlementPeriods();

        public SettlementPeriodsSchedule.SettlementPeriodsScheduleBuilder getOrCreateSettlementPeriodsSchedule();

        @Override
        public SettlementPeriodsSchedule.SettlementPeriodsScheduleBuilder getSettlementPeriodsSchedule();

        public ElectricityProduct.ElectricityProductBuilder getOrCreateElectricity();

        @Override
        public ElectricityProduct.ElectricityProductBuilder getElectricity();

        public ElectricityDelivery.ElectricityDeliveryBuilder getOrCreateDeliveryConditions();

        @Override
        public ElectricityDelivery.ElectricityDeliveryBuilder getDeliveryConditions();

        public ElectricityPhysicalQuantity.ElectricityPhysicalQuantityBuilder getOrCreateDeliveryQuantity();

        @Override
        public ElectricityPhysicalQuantity.ElectricityPhysicalQuantityBuilder getDeliveryQuantity();

        @Override
        public ElectricityPhysicalLegBuilder setId(String var1);

        @Override
        public ElectricityPhysicalLegBuilder addCommodityClassification(CommodityClassification var1);

        @Override
        public ElectricityPhysicalLegBuilder addCommodityClassification(CommodityClassification var1, int var2);

        @Override
        public ElectricityPhysicalLegBuilder addCommodityClassification(List<? extends CommodityClassification> var1);

        @Override
        public ElectricityPhysicalLegBuilder setCommodityClassification(List<? extends CommodityClassification> var1);

        @Override
        public ElectricityPhysicalLegBuilder setPayerReceiverModel(PayerReceiverModel var1);

        public ElectricityPhysicalLegBuilder setDeliveryPeriods(CommodityDeliveryPeriods var1);

        public ElectricityPhysicalLegBuilder addSettlementPeriods(SettlementPeriods var1);

        public ElectricityPhysicalLegBuilder addSettlementPeriods(SettlementPeriods var1, int var2);

        public ElectricityPhysicalLegBuilder addSettlementPeriods(List<? extends SettlementPeriods> var1);

        public ElectricityPhysicalLegBuilder setSettlementPeriods(List<? extends SettlementPeriods> var1);

        public ElectricityPhysicalLegBuilder setSettlementPeriodsSchedule(SettlementPeriodsSchedule var1);

        public ElectricityPhysicalLegBuilder setLoadType(LoadTypeEnum var1);

        public ElectricityPhysicalLegBuilder setElectricity(ElectricityProduct var1);

        public ElectricityPhysicalLegBuilder setDeliveryConditions(ElectricityDelivery var1);

        public ElectricityPhysicalLegBuilder setDeliveryQuantity(ElectricityPhysicalQuantity var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("commodityClassification"), processor, CommodityClassification.CommodityClassificationBuilder.class, this.getCommodityClassification(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("payerReceiverModel"), processor, PayerReceiverModel.PayerReceiverModelBuilder.class, (RosettaModelObjectBuilder)this.getPayerReceiverModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("deliveryPeriods"), processor, CommodityDeliveryPeriods.CommodityDeliveryPeriodsBuilder.class, this.getDeliveryPeriods(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("settlementPeriods"), processor, SettlementPeriods.SettlementPeriodsBuilder.class, this.getSettlementPeriods(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("settlementPeriodsSchedule"), processor, SettlementPeriodsSchedule.SettlementPeriodsScheduleBuilder.class, this.getSettlementPeriodsSchedule(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("loadType"), LoadTypeEnum.class, (Object)this.getLoadType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("electricity"), processor, ElectricityProduct.ElectricityProductBuilder.class, this.getElectricity(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("deliveryConditions"), processor, ElectricityDelivery.ElectricityDeliveryBuilder.class, this.getDeliveryConditions(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("deliveryQuantity"), processor, ElectricityPhysicalQuantity.ElectricityPhysicalQuantityBuilder.class, this.getDeliveryQuantity(), new AttributeMeta[0]);
        }

        @Override
        public ElectricityPhysicalLegBuilder prune();
    }

    public static class ElectricityPhysicalLegImpl
    extends PhysicalSwapLeg.PhysicalSwapLegImpl
    implements ElectricityPhysicalLeg {
        private final CommodityDeliveryPeriods deliveryPeriods;
        private final List<? extends SettlementPeriods> settlementPeriods;
        private final SettlementPeriodsSchedule settlementPeriodsSchedule;
        private final LoadTypeEnum loadType;
        private final ElectricityProduct electricity;
        private final ElectricityDelivery deliveryConditions;
        private final ElectricityPhysicalQuantity deliveryQuantity;

        protected ElectricityPhysicalLegImpl(ElectricityPhysicalLegBuilder builder) {
            super(builder);
            this.deliveryPeriods = Optional.ofNullable(builder.getDeliveryPeriods()).map(f -> f.build()).orElse(null);
            this.settlementPeriods = Optional.ofNullable(builder.getSettlementPeriods()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.settlementPeriodsSchedule = Optional.ofNullable(builder.getSettlementPeriodsSchedule()).map(f -> f.build()).orElse(null);
            this.loadType = builder.getLoadType();
            this.electricity = Optional.ofNullable(builder.getElectricity()).map(f -> f.build()).orElse(null);
            this.deliveryConditions = Optional.ofNullable(builder.getDeliveryConditions()).map(f -> f.build()).orElse(null);
            this.deliveryQuantity = Optional.ofNullable(builder.getDeliveryQuantity()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="deliveryPeriods", isRequired=true)
        @RuneAttribute(value="deliveryPeriods", isRequired=true)
        public CommodityDeliveryPeriods getDeliveryPeriods() {
            return this.deliveryPeriods;
        }

        @Override
        @RosettaAttribute(value="settlementPeriods", isRequired=true)
        @RuneAttribute(value="settlementPeriods", isRequired=true)
        public List<? extends SettlementPeriods> getSettlementPeriods() {
            return this.settlementPeriods;
        }

        @Override
        @RosettaAttribute(value="settlementPeriodsSchedule")
        @RuneAttribute(value="settlementPeriodsSchedule")
        public SettlementPeriodsSchedule getSettlementPeriodsSchedule() {
            return this.settlementPeriodsSchedule;
        }

        @Override
        @RosettaAttribute(value="loadType")
        @RuneAttribute(value="loadType")
        public LoadTypeEnum getLoadType() {
            return this.loadType;
        }

        @Override
        @RosettaAttribute(value="electricity", isRequired=true)
        @RuneAttribute(value="electricity", isRequired=true)
        public ElectricityProduct getElectricity() {
            return this.electricity;
        }

        @Override
        @RosettaAttribute(value="deliveryConditions", isRequired=true)
        @RuneAttribute(value="deliveryConditions", isRequired=true)
        public ElectricityDelivery getDeliveryConditions() {
            return this.deliveryConditions;
        }

        @Override
        @RosettaAttribute(value="deliveryQuantity", isRequired=true)
        @RuneAttribute(value="deliveryQuantity", isRequired=true)
        public ElectricityPhysicalQuantity getDeliveryQuantity() {
            return this.deliveryQuantity;
        }

        @Override
        public ElectricityPhysicalLeg build() {
            return this;
        }

        @Override
        public ElectricityPhysicalLegBuilder toBuilder() {
            ElectricityPhysicalLegBuilder builder = ElectricityPhysicalLeg.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ElectricityPhysicalLegBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getDeliveryPeriods()).ifPresent(builder::setDeliveryPeriods);
            Optional.ofNullable(this.getSettlementPeriods()).ifPresent(builder::setSettlementPeriods);
            Optional.ofNullable(this.getSettlementPeriodsSchedule()).ifPresent(builder::setSettlementPeriodsSchedule);
            Optional.ofNullable(this.getLoadType()).ifPresent(builder::setLoadType);
            Optional.ofNullable(this.getElectricity()).ifPresent(builder::setElectricity);
            Optional.ofNullable(this.getDeliveryConditions()).ifPresent(builder::setDeliveryConditions);
            Optional.ofNullable(this.getDeliveryQuantity()).ifPresent(builder::setDeliveryQuantity);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ElectricityPhysicalLeg _that = (ElectricityPhysicalLeg)this.getType().cast(o);
            if (!Objects.equals(this.deliveryPeriods, _that.getDeliveryPeriods())) {
                return false;
            }
            if (!ListEquals.listEquals(this.settlementPeriods, _that.getSettlementPeriods())) {
                return false;
            }
            if (!Objects.equals(this.settlementPeriodsSchedule, _that.getSettlementPeriodsSchedule())) {
                return false;
            }
            if (!Objects.equals((Object)this.loadType, (Object)_that.getLoadType())) {
                return false;
            }
            if (!Objects.equals(this.electricity, _that.getElectricity())) {
                return false;
            }
            if (!Objects.equals(this.deliveryConditions, _that.getDeliveryConditions())) {
                return false;
            }
            return Objects.equals(this.deliveryQuantity, _that.getDeliveryQuantity());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.deliveryPeriods != null ? this.deliveryPeriods.hashCode() : 0);
            _result = 31 * _result + (this.settlementPeriods != null ? this.settlementPeriods.hashCode() : 0);
            _result = 31 * _result + (this.settlementPeriodsSchedule != null ? this.settlementPeriodsSchedule.hashCode() : 0);
            _result = 31 * _result + (this.loadType != null ? ((Object)((Object)this.loadType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.electricity != null ? this.electricity.hashCode() : 0);
            _result = 31 * _result + (this.deliveryConditions != null ? this.deliveryConditions.hashCode() : 0);
            _result = 31 * _result + (this.deliveryQuantity != null ? this.deliveryQuantity.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ElectricityPhysicalLeg {deliveryPeriods=" + this.deliveryPeriods + ", settlementPeriods=" + this.settlementPeriods + ", settlementPeriodsSchedule=" + this.settlementPeriodsSchedule + ", loadType=" + (Object)((Object)this.loadType) + ", electricity=" + this.electricity + ", deliveryConditions=" + this.deliveryConditions + ", deliveryQuantity=" + this.deliveryQuantity + '}' + " " + super.toString();
        }
    }
}

