/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.confirmation.AdjustableOrRelativeDate;
import fpml.confirmation.DeclaredCashAndCashEquivalentDividendPercentageModel;
import fpml.confirmation.DirectionalLegUnderlyer;
import fpml.confirmation.DividendPeriodPayment;
import fpml.confirmation.FxFeature;
import fpml.confirmation.LegIdentifier;
import fpml.confirmation.OptionSettlementModel;
import fpml.confirmation.PayerReceiverModel;
import fpml.confirmation.Underlyer;
import fpml.confirmation.meta.DividendLegMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="DividendLeg", builder=DividendLegBuilderImpl.class, version="0.17.2")
@RuneDataType(value="DividendLeg", model="fpml", builder=DividendLegBuilderImpl.class, version="0.17.2")
public interface DividendLeg
extends DirectionalLegUnderlyer {
    public static final DividendLegMeta metaData = new DividendLegMeta();

    public DeclaredCashAndCashEquivalentDividendPercentageModel getDeclaredCashAndCashEquivalentDividendPercentageModel();

    public List<? extends DividendPeriodPayment> getDividendPeriod();

    public Boolean getSpecialDividends();

    public Boolean getMaterialDividend();

    @Override
    public DividendLeg build();

    @Override
    public DividendLegBuilder toBuilder();

    public static DividendLegBuilder builder() {
        return new DividendLegBuilderImpl();
    }

    default public RosettaMetaData<? extends DividendLeg> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends DividendLeg> getType() {
        return DividendLeg.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("legIdentifier"), processor, LegIdentifier.class, this.getLegIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("payerReceiverModel"), processor, PayerReceiverModel.class, this.getPayerReceiverModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("effectiveDate"), processor, AdjustableOrRelativeDate.class, this.getEffectiveDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("terminationDate"), processor, AdjustableOrRelativeDate.class, this.getTerminationDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("underlyer"), processor, Underlyer.class, this.getUnderlyer(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("optionSettlementModel"), processor, OptionSettlementModel.class, this.getOptionSettlementModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fxFeature"), processor, FxFeature.class, this.getFxFeature(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("declaredCashAndCashEquivalentDividendPercentageModel"), processor, DeclaredCashAndCashEquivalentDividendPercentageModel.class, this.getDeclaredCashAndCashEquivalentDividendPercentageModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dividendPeriod"), processor, DividendPeriodPayment.class, this.getDividendPeriod(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("specialDividends"), Boolean.class, (Object)this.getSpecialDividends(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("materialDividend"), Boolean.class, (Object)this.getMaterialDividend(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class DividendLegBuilderImpl
    extends DirectionalLegUnderlyer.DirectionalLegUnderlyerBuilderImpl
    implements DividendLegBuilder {
        protected DeclaredCashAndCashEquivalentDividendPercentageModel.DeclaredCashAndCashEquivalentDividendPercentageModelBuilder declaredCashAndCashEquivalentDividendPercentageModel;
        protected List<DividendPeriodPayment.DividendPeriodPaymentBuilder> dividendPeriod = new ArrayList<DividendPeriodPayment.DividendPeriodPaymentBuilder>();
        protected Boolean specialDividends;
        protected Boolean materialDividend;

        @Override
        @RosettaAttribute(value="declaredCashAndCashEquivalentDividendPercentageModel", isRequired=true)
        @RuneAttribute(value="declaredCashAndCashEquivalentDividendPercentageModel", isRequired=true)
        public DeclaredCashAndCashEquivalentDividendPercentageModel.DeclaredCashAndCashEquivalentDividendPercentageModelBuilder getDeclaredCashAndCashEquivalentDividendPercentageModel() {
            return this.declaredCashAndCashEquivalentDividendPercentageModel;
        }

        @Override
        public DeclaredCashAndCashEquivalentDividendPercentageModel.DeclaredCashAndCashEquivalentDividendPercentageModelBuilder getOrCreateDeclaredCashAndCashEquivalentDividendPercentageModel() {
            DeclaredCashAndCashEquivalentDividendPercentageModel.DeclaredCashAndCashEquivalentDividendPercentageModelBuilder result = this.declaredCashAndCashEquivalentDividendPercentageModel != null ? this.declaredCashAndCashEquivalentDividendPercentageModel : (this.declaredCashAndCashEquivalentDividendPercentageModel = DeclaredCashAndCashEquivalentDividendPercentageModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="dividendPeriod", isRequired=true)
        @RuneAttribute(value="dividendPeriod", isRequired=true)
        public List<? extends DividendPeriodPayment.DividendPeriodPaymentBuilder> getDividendPeriod() {
            return this.dividendPeriod;
        }

        @Override
        public DividendPeriodPayment.DividendPeriodPaymentBuilder getOrCreateDividendPeriod(int index) {
            if (this.dividendPeriod == null) {
                this.dividendPeriod = new ArrayList<DividendPeriodPayment.DividendPeriodPaymentBuilder>();
            }
            return (DividendPeriodPayment.DividendPeriodPaymentBuilder)this.getIndex(this.dividendPeriod, index, () -> {
                DividendPeriodPayment.DividendPeriodPaymentBuilder newDividendPeriod = DividendPeriodPayment.builder();
                return newDividendPeriod;
            });
        }

        @Override
        @RosettaAttribute(value="specialDividends")
        @RuneAttribute(value="specialDividends")
        public Boolean getSpecialDividends() {
            return this.specialDividends;
        }

        @Override
        @RosettaAttribute(value="materialDividend")
        @RuneAttribute(value="materialDividend")
        public Boolean getMaterialDividend() {
            return this.materialDividend;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public DividendLegBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="legIdentifier")
        @RuneAttribute(value="legIdentifier")
        public DividendLegBuilder addLegIdentifier(LegIdentifier _legIdentifier) {
            if (_legIdentifier != null) {
                this.legIdentifier.add(_legIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public DividendLegBuilder addLegIdentifier(LegIdentifier _legIdentifier, int idx) {
            this.getIndex(this.legIdentifier, idx, () -> _legIdentifier.toBuilder());
            return this;
        }

        @Override
        public DividendLegBuilder addLegIdentifier(List<? extends LegIdentifier> legIdentifiers) {
            if (legIdentifiers != null) {
                for (LegIdentifier legIdentifier : legIdentifiers) {
                    this.legIdentifier.add(legIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="legIdentifier")
        public DividendLegBuilder setLegIdentifier(List<? extends LegIdentifier> legIdentifiers) {
            this.legIdentifier = legIdentifiers == null ? new ArrayList() : (List)legIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="payerReceiverModel", isRequired=true)
        @RuneAttribute(value="payerReceiverModel", isRequired=true)
        public DividendLegBuilder setPayerReceiverModel(PayerReceiverModel _payerReceiverModel) {
            this.payerReceiverModel = _payerReceiverModel == null ? null : _payerReceiverModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public DividendLegBuilder setEffectiveDate(AdjustableOrRelativeDate _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="terminationDate")
        @RuneAttribute(value="terminationDate")
        public DividendLegBuilder setTerminationDate(AdjustableOrRelativeDate _terminationDate) {
            this.terminationDate = _terminationDate == null ? null : _terminationDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyer", isRequired=true)
        @RuneAttribute(value="underlyer", isRequired=true)
        public DividendLegBuilder setUnderlyer(Underlyer _underlyer) {
            this.underlyer = _underlyer == null ? null : _underlyer.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="optionSettlementModel", isRequired=true)
        @RuneAttribute(value="optionSettlementModel", isRequired=true)
        public DividendLegBuilder setOptionSettlementModel(OptionSettlementModel _optionSettlementModel) {
            this.optionSettlementModel = _optionSettlementModel == null ? null : _optionSettlementModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fxFeature")
        @RuneAttribute(value="fxFeature")
        public DividendLegBuilder setFxFeature(FxFeature _fxFeature) {
            this.fxFeature = _fxFeature == null ? null : _fxFeature.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="declaredCashAndCashEquivalentDividendPercentageModel", isRequired=true)
        @RuneAttribute(value="declaredCashAndCashEquivalentDividendPercentageModel", isRequired=true)
        public DividendLegBuilder setDeclaredCashAndCashEquivalentDividendPercentageModel(DeclaredCashAndCashEquivalentDividendPercentageModel _declaredCashAndCashEquivalentDividendPercentageModel) {
            this.declaredCashAndCashEquivalentDividendPercentageModel = _declaredCashAndCashEquivalentDividendPercentageModel == null ? null : _declaredCashAndCashEquivalentDividendPercentageModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dividendPeriod", isRequired=true)
        @RuneAttribute(value="dividendPeriod", isRequired=true)
        public DividendLegBuilder addDividendPeriod(DividendPeriodPayment _dividendPeriod) {
            if (_dividendPeriod != null) {
                this.dividendPeriod.add(_dividendPeriod.toBuilder());
            }
            return this;
        }

        @Override
        public DividendLegBuilder addDividendPeriod(DividendPeriodPayment _dividendPeriod, int idx) {
            this.getIndex(this.dividendPeriod, idx, () -> _dividendPeriod.toBuilder());
            return this;
        }

        @Override
        public DividendLegBuilder addDividendPeriod(List<? extends DividendPeriodPayment> dividendPeriods) {
            if (dividendPeriods != null) {
                for (DividendPeriodPayment dividendPeriodPayment : dividendPeriods) {
                    this.dividendPeriod.add(dividendPeriodPayment.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="dividendPeriod")
        public DividendLegBuilder setDividendPeriod(List<? extends DividendPeriodPayment> dividendPeriods) {
            this.dividendPeriod = dividendPeriods == null ? new ArrayList<DividendPeriodPayment.DividendPeriodPaymentBuilder>() : (List)dividendPeriods.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="specialDividends")
        @RuneAttribute(value="specialDividends")
        public DividendLegBuilder setSpecialDividends(Boolean _specialDividends) {
            this.specialDividends = _specialDividends == null ? null : _specialDividends;
            return this;
        }

        @Override
        @RosettaAttribute(value="materialDividend")
        @RuneAttribute(value="materialDividend")
        public DividendLegBuilder setMaterialDividend(Boolean _materialDividend) {
            this.materialDividend = _materialDividend == null ? null : _materialDividend;
            return this;
        }

        @Override
        public DividendLeg build() {
            return new DividendLegImpl(this);
        }

        @Override
        public DividendLegBuilder toBuilder() {
            return this;
        }

        @Override
        public DividendLegBuilder prune() {
            super.prune();
            if (this.declaredCashAndCashEquivalentDividendPercentageModel != null && !this.declaredCashAndCashEquivalentDividendPercentageModel.prune().hasData()) {
                this.declaredCashAndCashEquivalentDividendPercentageModel = null;
            }
            this.dividendPeriod = this.dividendPeriod.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getDeclaredCashAndCashEquivalentDividendPercentageModel() != null && this.getDeclaredCashAndCashEquivalentDividendPercentageModel().hasData()) {
                return true;
            }
            if (this.getDividendPeriod() != null && this.getDividendPeriod().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getSpecialDividends() != null) {
                return true;
            }
            return this.getMaterialDividend() != null;
        }

        @Override
        public DividendLegBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            DividendLegBuilder o = (DividendLegBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDeclaredCashAndCashEquivalentDividendPercentageModel(), (RosettaModelObjectBuilder)o.getDeclaredCashAndCashEquivalentDividendPercentageModel(), this::setDeclaredCashAndCashEquivalentDividendPercentageModel);
            merger.mergeRosetta(this.getDividendPeriod(), o.getDividendPeriod(), this::getOrCreateDividendPeriod);
            merger.mergeBasic((Object)this.getSpecialDividends(), (Object)o.getSpecialDividends(), this::setSpecialDividends, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getMaterialDividend(), (Object)o.getMaterialDividend(), this::setMaterialDividend, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            DividendLeg _that = (DividendLeg)this.getType().cast(o);
            if (!Objects.equals(this.declaredCashAndCashEquivalentDividendPercentageModel, _that.getDeclaredCashAndCashEquivalentDividendPercentageModel())) {
                return false;
            }
            if (!ListEquals.listEquals(this.dividendPeriod, _that.getDividendPeriod())) {
                return false;
            }
            if (!Objects.equals(this.specialDividends, _that.getSpecialDividends())) {
                return false;
            }
            return Objects.equals(this.materialDividend, _that.getMaterialDividend());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.declaredCashAndCashEquivalentDividendPercentageModel != null ? this.declaredCashAndCashEquivalentDividendPercentageModel.hashCode() : 0);
            _result = 31 * _result + (this.dividendPeriod != null ? this.dividendPeriod.hashCode() : 0);
            _result = 31 * _result + (this.specialDividends != null ? this.specialDividends.hashCode() : 0);
            _result = 31 * _result + (this.materialDividend != null ? this.materialDividend.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "DividendLegBuilder {declaredCashAndCashEquivalentDividendPercentageModel=" + this.declaredCashAndCashEquivalentDividendPercentageModel + ", dividendPeriod=" + this.dividendPeriod + ", specialDividends=" + this.specialDividends + ", materialDividend=" + this.materialDividend + '}' + " " + super.toString();
        }
    }

    public static interface DividendLegBuilder
    extends DividendLeg,
    DirectionalLegUnderlyer.DirectionalLegUnderlyerBuilder {
        public DeclaredCashAndCashEquivalentDividendPercentageModel.DeclaredCashAndCashEquivalentDividendPercentageModelBuilder getOrCreateDeclaredCashAndCashEquivalentDividendPercentageModel();

        @Override
        public DeclaredCashAndCashEquivalentDividendPercentageModel.DeclaredCashAndCashEquivalentDividendPercentageModelBuilder getDeclaredCashAndCashEquivalentDividendPercentageModel();

        public DividendPeriodPayment.DividendPeriodPaymentBuilder getOrCreateDividendPeriod(int var1);

        public List<? extends DividendPeriodPayment.DividendPeriodPaymentBuilder> getDividendPeriod();

        @Override
        public DividendLegBuilder setId(String var1);

        @Override
        public DividendLegBuilder addLegIdentifier(LegIdentifier var1);

        @Override
        public DividendLegBuilder addLegIdentifier(LegIdentifier var1, int var2);

        @Override
        public DividendLegBuilder addLegIdentifier(List<? extends LegIdentifier> var1);

        @Override
        public DividendLegBuilder setLegIdentifier(List<? extends LegIdentifier> var1);

        @Override
        public DividendLegBuilder setPayerReceiverModel(PayerReceiverModel var1);

        @Override
        public DividendLegBuilder setEffectiveDate(AdjustableOrRelativeDate var1);

        @Override
        public DividendLegBuilder setTerminationDate(AdjustableOrRelativeDate var1);

        @Override
        public DividendLegBuilder setUnderlyer(Underlyer var1);

        @Override
        public DividendLegBuilder setOptionSettlementModel(OptionSettlementModel var1);

        @Override
        public DividendLegBuilder setFxFeature(FxFeature var1);

        public DividendLegBuilder setDeclaredCashAndCashEquivalentDividendPercentageModel(DeclaredCashAndCashEquivalentDividendPercentageModel var1);

        public DividendLegBuilder addDividendPeriod(DividendPeriodPayment var1);

        public DividendLegBuilder addDividendPeriod(DividendPeriodPayment var1, int var2);

        public DividendLegBuilder addDividendPeriod(List<? extends DividendPeriodPayment> var1);

        public DividendLegBuilder setDividendPeriod(List<? extends DividendPeriodPayment> var1);

        public DividendLegBuilder setSpecialDividends(Boolean var1);

        public DividendLegBuilder setMaterialDividend(Boolean var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("legIdentifier"), processor, LegIdentifier.LegIdentifierBuilder.class, this.getLegIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("payerReceiverModel"), processor, PayerReceiverModel.PayerReceiverModelBuilder.class, (RosettaModelObjectBuilder)this.getPayerReceiverModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("effectiveDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, (RosettaModelObjectBuilder)this.getEffectiveDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("terminationDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, (RosettaModelObjectBuilder)this.getTerminationDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("underlyer"), processor, Underlyer.UnderlyerBuilder.class, (RosettaModelObjectBuilder)this.getUnderlyer(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("optionSettlementModel"), processor, OptionSettlementModel.OptionSettlementModelBuilder.class, (RosettaModelObjectBuilder)this.getOptionSettlementModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fxFeature"), processor, FxFeature.FxFeatureBuilder.class, (RosettaModelObjectBuilder)this.getFxFeature(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("declaredCashAndCashEquivalentDividendPercentageModel"), processor, DeclaredCashAndCashEquivalentDividendPercentageModel.DeclaredCashAndCashEquivalentDividendPercentageModelBuilder.class, this.getDeclaredCashAndCashEquivalentDividendPercentageModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dividendPeriod"), processor, DividendPeriodPayment.DividendPeriodPaymentBuilder.class, this.getDividendPeriod(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("specialDividends"), Boolean.class, (Object)this.getSpecialDividends(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("materialDividend"), Boolean.class, (Object)this.getMaterialDividend(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public DividendLegBuilder prune();
    }

    public static class DividendLegImpl
    extends DirectionalLegUnderlyer.DirectionalLegUnderlyerImpl
    implements DividendLeg {
        private final DeclaredCashAndCashEquivalentDividendPercentageModel declaredCashAndCashEquivalentDividendPercentageModel;
        private final List<? extends DividendPeriodPayment> dividendPeriod;
        private final Boolean specialDividends;
        private final Boolean materialDividend;

        protected DividendLegImpl(DividendLegBuilder builder) {
            super(builder);
            this.declaredCashAndCashEquivalentDividendPercentageModel = Optional.ofNullable(builder.getDeclaredCashAndCashEquivalentDividendPercentageModel()).map(f -> f.build()).orElse(null);
            this.dividendPeriod = Optional.ofNullable(builder.getDividendPeriod()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.specialDividends = builder.getSpecialDividends();
            this.materialDividend = builder.getMaterialDividend();
        }

        @Override
        @RosettaAttribute(value="declaredCashAndCashEquivalentDividendPercentageModel", isRequired=true)
        @RuneAttribute(value="declaredCashAndCashEquivalentDividendPercentageModel", isRequired=true)
        public DeclaredCashAndCashEquivalentDividendPercentageModel getDeclaredCashAndCashEquivalentDividendPercentageModel() {
            return this.declaredCashAndCashEquivalentDividendPercentageModel;
        }

        @Override
        @RosettaAttribute(value="dividendPeriod", isRequired=true)
        @RuneAttribute(value="dividendPeriod", isRequired=true)
        public List<? extends DividendPeriodPayment> getDividendPeriod() {
            return this.dividendPeriod;
        }

        @Override
        @RosettaAttribute(value="specialDividends")
        @RuneAttribute(value="specialDividends")
        public Boolean getSpecialDividends() {
            return this.specialDividends;
        }

        @Override
        @RosettaAttribute(value="materialDividend")
        @RuneAttribute(value="materialDividend")
        public Boolean getMaterialDividend() {
            return this.materialDividend;
        }

        @Override
        public DividendLeg build() {
            return this;
        }

        @Override
        public DividendLegBuilder toBuilder() {
            DividendLegBuilder builder = DividendLeg.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(DividendLegBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getDeclaredCashAndCashEquivalentDividendPercentageModel()).ifPresent(builder::setDeclaredCashAndCashEquivalentDividendPercentageModel);
            Optional.ofNullable(this.getDividendPeriod()).ifPresent(builder::setDividendPeriod);
            Optional.ofNullable(this.getSpecialDividends()).ifPresent(builder::setSpecialDividends);
            Optional.ofNullable(this.getMaterialDividend()).ifPresent(builder::setMaterialDividend);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            DividendLeg _that = (DividendLeg)this.getType().cast(o);
            if (!Objects.equals(this.declaredCashAndCashEquivalentDividendPercentageModel, _that.getDeclaredCashAndCashEquivalentDividendPercentageModel())) {
                return false;
            }
            if (!ListEquals.listEquals(this.dividendPeriod, _that.getDividendPeriod())) {
                return false;
            }
            if (!Objects.equals(this.specialDividends, _that.getSpecialDividends())) {
                return false;
            }
            return Objects.equals(this.materialDividend, _that.getMaterialDividend());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.declaredCashAndCashEquivalentDividendPercentageModel != null ? this.declaredCashAndCashEquivalentDividendPercentageModel.hashCode() : 0);
            _result = 31 * _result + (this.dividendPeriod != null ? this.dividendPeriod.hashCode() : 0);
            _result = 31 * _result + (this.specialDividends != null ? this.specialDividends.hashCode() : 0);
            _result = 31 * _result + (this.materialDividend != null ? this.materialDividend.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "DividendLeg {declaredCashAndCashEquivalentDividendPercentageModel=" + this.declaredCashAndCashEquivalentDividendPercentageModel + ", dividendPeriod=" + this.dividendPeriod + ", specialDividends=" + this.specialDividends + ", materialDividend=" + this.materialDividend + '}' + " " + super.toString();
        }
    }
}

