/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.DenominatorTerm;
import fpml.confirmation.FormulaTerm;
import fpml.confirmation.meta.DerivativeFormulaMeta;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="DerivativeFormula", builder=DerivativeFormulaBuilderImpl.class, version="0.17.2")
@RuneDataType(value="DerivativeFormula", model="fpml", builder=DerivativeFormulaBuilderImpl.class, version="0.17.2")
public interface DerivativeFormula
extends RosettaModelObject {
    public static final DerivativeFormulaMeta metaData = new DerivativeFormulaMeta();

    public FormulaTerm getTerm();

    public DenominatorTerm getDenominatorTerm();

    public DerivativeFormula build();

    public DerivativeFormulaBuilder toBuilder();

    public static DerivativeFormulaBuilder builder() {
        return new DerivativeFormulaBuilderImpl();
    }

    default public RosettaMetaData<? extends DerivativeFormula> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends DerivativeFormula> getType() {
        return DerivativeFormula.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("term"), processor, FormulaTerm.class, this.getTerm(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("denominatorTerm"), processor, DenominatorTerm.class, this.getDenominatorTerm(), new AttributeMeta[0]);
    }

    public static class DerivativeFormulaBuilderImpl
    implements DerivativeFormulaBuilder {
        protected FormulaTerm.FormulaTermBuilder term;
        protected DenominatorTerm.DenominatorTermBuilder denominatorTerm;

        @Override
        @RosettaAttribute(value="term", isRequired=true)
        @RuneAttribute(value="term", isRequired=true)
        public FormulaTerm.FormulaTermBuilder getTerm() {
            return this.term;
        }

        @Override
        public FormulaTerm.FormulaTermBuilder getOrCreateTerm() {
            FormulaTerm.FormulaTermBuilder result = this.term != null ? this.term : (this.term = FormulaTerm.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="denominatorTerm", isRequired=true)
        @RuneAttribute(value="denominatorTerm", isRequired=true)
        public DenominatorTerm.DenominatorTermBuilder getDenominatorTerm() {
            return this.denominatorTerm;
        }

        @Override
        public DenominatorTerm.DenominatorTermBuilder getOrCreateDenominatorTerm() {
            DenominatorTerm.DenominatorTermBuilder result = this.denominatorTerm != null ? this.denominatorTerm : (this.denominatorTerm = DenominatorTerm.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="term", isRequired=true)
        @RuneAttribute(value="term", isRequired=true)
        public DerivativeFormulaBuilder setTerm(FormulaTerm _term) {
            this.term = _term == null ? null : _term.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="denominatorTerm", isRequired=true)
        @RuneAttribute(value="denominatorTerm", isRequired=true)
        public DerivativeFormulaBuilder setDenominatorTerm(DenominatorTerm _denominatorTerm) {
            this.denominatorTerm = _denominatorTerm == null ? null : _denominatorTerm.toBuilder();
            return this;
        }

        @Override
        public DerivativeFormula build() {
            return new DerivativeFormulaImpl(this);
        }

        @Override
        public DerivativeFormulaBuilder toBuilder() {
            return this;
        }

        @Override
        public DerivativeFormulaBuilder prune() {
            if (this.term != null && !this.term.prune().hasData()) {
                this.term = null;
            }
            if (this.denominatorTerm != null && !this.denominatorTerm.prune().hasData()) {
                this.denominatorTerm = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getTerm() != null && this.getTerm().hasData()) {
                return true;
            }
            return this.getDenominatorTerm() != null && this.getDenominatorTerm().hasData();
        }

        public DerivativeFormulaBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            DerivativeFormulaBuilder o = (DerivativeFormulaBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTerm(), (RosettaModelObjectBuilder)o.getTerm(), this::setTerm);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDenominatorTerm(), (RosettaModelObjectBuilder)o.getDenominatorTerm(), this::setDenominatorTerm);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            DerivativeFormula _that = this.getType().cast(o);
            if (!Objects.equals(this.term, _that.getTerm())) {
                return false;
            }
            return Objects.equals(this.denominatorTerm, _that.getDenominatorTerm());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.term != null ? this.term.hashCode() : 0);
            _result = 31 * _result + (this.denominatorTerm != null ? this.denominatorTerm.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "DerivativeFormulaBuilder {term=" + this.term + ", denominatorTerm=" + this.denominatorTerm + '}';
        }
    }

    public static interface DerivativeFormulaBuilder
    extends DerivativeFormula,
    RosettaModelObjectBuilder {
        public FormulaTerm.FormulaTermBuilder getOrCreateTerm();

        @Override
        public FormulaTerm.FormulaTermBuilder getTerm();

        public DenominatorTerm.DenominatorTermBuilder getOrCreateDenominatorTerm();

        @Override
        public DenominatorTerm.DenominatorTermBuilder getDenominatorTerm();

        public DerivativeFormulaBuilder setTerm(FormulaTerm var1);

        public DerivativeFormulaBuilder setDenominatorTerm(DenominatorTerm var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("term"), processor, FormulaTerm.FormulaTermBuilder.class, this.getTerm(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("denominatorTerm"), processor, DenominatorTerm.DenominatorTermBuilder.class, this.getDenominatorTerm(), new AttributeMeta[0]);
        }

        public DerivativeFormulaBuilder prune();
    }

    public static class DerivativeFormulaImpl
    implements DerivativeFormula {
        private final FormulaTerm term;
        private final DenominatorTerm denominatorTerm;

        protected DerivativeFormulaImpl(DerivativeFormulaBuilder builder) {
            this.term = Optional.ofNullable(builder.getTerm()).map(f -> f.build()).orElse(null);
            this.denominatorTerm = Optional.ofNullable(builder.getDenominatorTerm()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="term", isRequired=true)
        @RuneAttribute(value="term", isRequired=true)
        public FormulaTerm getTerm() {
            return this.term;
        }

        @Override
        @RosettaAttribute(value="denominatorTerm", isRequired=true)
        @RuneAttribute(value="denominatorTerm", isRequired=true)
        public DenominatorTerm getDenominatorTerm() {
            return this.denominatorTerm;
        }

        @Override
        public DerivativeFormula build() {
            return this;
        }

        @Override
        public DerivativeFormulaBuilder toBuilder() {
            DerivativeFormulaBuilder builder = DerivativeFormula.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(DerivativeFormulaBuilder builder) {
            Optional.ofNullable(this.getTerm()).ifPresent(builder::setTerm);
            Optional.ofNullable(this.getDenominatorTerm()).ifPresent(builder::setDenominatorTerm);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            DerivativeFormula _that = this.getType().cast(o);
            if (!Objects.equals(this.term, _that.getTerm())) {
                return false;
            }
            return Objects.equals(this.denominatorTerm, _that.getDenominatorTerm());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.term != null ? this.term.hashCode() : 0);
            _result = 31 * _result + (this.denominatorTerm != null ? this.denominatorTerm.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "DerivativeFormula {term=" + this.term + ", denominatorTerm=" + this.denominatorTerm + '}';
        }
    }
}

