/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.confirmation.DeclearReason;
import fpml.confirmation.PartyTradeIdentifier;
import fpml.confirmation.meta.DeClearMeta;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="DeClear", builder=DeClearBuilderImpl.class, version="0.17.2")
@RuneDataType(value="DeClear", model="fpml", builder=DeClearBuilderImpl.class, version="0.17.2")
public interface DeClear
extends RosettaModelObject {
    public static final DeClearMeta metaData = new DeClearMeta();

    public List<? extends PartyTradeIdentifier> getTradeIdentifier();

    public ZonedDateTime getEffectiveDate();

    public DeclearReason getReason();

    public DeClear build();

    public DeClearBuilder toBuilder();

    public static DeClearBuilder builder() {
        return new DeClearBuilderImpl();
    }

    default public RosettaMetaData<? extends DeClear> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends DeClear> getType() {
        return DeClear.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("tradeIdentifier"), processor, PartyTradeIdentifier.class, this.getTradeIdentifier(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("reason"), processor, DeclearReason.class, this.getReason(), new AttributeMeta[0]);
    }

    public static class DeClearBuilderImpl
    implements DeClearBuilder {
        protected List<PartyTradeIdentifier.PartyTradeIdentifierBuilder> tradeIdentifier = new ArrayList<PartyTradeIdentifier.PartyTradeIdentifierBuilder>();
        protected ZonedDateTime effectiveDate;
        protected DeclearReason.DeclearReasonBuilder reason;

        @Override
        @RosettaAttribute(value="tradeIdentifier", isRequired=true)
        @RuneAttribute(value="tradeIdentifier", isRequired=true)
        public List<? extends PartyTradeIdentifier.PartyTradeIdentifierBuilder> getTradeIdentifier() {
            return this.tradeIdentifier;
        }

        @Override
        public PartyTradeIdentifier.PartyTradeIdentifierBuilder getOrCreateTradeIdentifier(int index) {
            if (this.tradeIdentifier == null) {
                this.tradeIdentifier = new ArrayList<PartyTradeIdentifier.PartyTradeIdentifierBuilder>();
            }
            return (PartyTradeIdentifier.PartyTradeIdentifierBuilder)this.getIndex(this.tradeIdentifier, index, () -> {
                PartyTradeIdentifier.PartyTradeIdentifierBuilder newTradeIdentifier = PartyTradeIdentifier.builder();
                return newTradeIdentifier;
            });
        }

        @Override
        @RosettaAttribute(value="effectiveDate", isRequired=true)
        @RuneAttribute(value="effectiveDate", isRequired=true)
        public ZonedDateTime getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        @RosettaAttribute(value="reason")
        @RuneAttribute(value="reason")
        public DeclearReason.DeclearReasonBuilder getReason() {
            return this.reason;
        }

        @Override
        public DeclearReason.DeclearReasonBuilder getOrCreateReason() {
            DeclearReason.DeclearReasonBuilder result = this.reason != null ? this.reason : (this.reason = DeclearReason.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="tradeIdentifier", isRequired=true)
        @RuneAttribute(value="tradeIdentifier", isRequired=true)
        public DeClearBuilder addTradeIdentifier(PartyTradeIdentifier _tradeIdentifier) {
            if (_tradeIdentifier != null) {
                this.tradeIdentifier.add(_tradeIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public DeClearBuilder addTradeIdentifier(PartyTradeIdentifier _tradeIdentifier, int idx) {
            this.getIndex(this.tradeIdentifier, idx, () -> _tradeIdentifier.toBuilder());
            return this;
        }

        @Override
        public DeClearBuilder addTradeIdentifier(List<? extends PartyTradeIdentifier> tradeIdentifiers) {
            if (tradeIdentifiers != null) {
                for (PartyTradeIdentifier partyTradeIdentifier : tradeIdentifiers) {
                    this.tradeIdentifier.add(partyTradeIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="tradeIdentifier")
        public DeClearBuilder setTradeIdentifier(List<? extends PartyTradeIdentifier> tradeIdentifiers) {
            this.tradeIdentifier = tradeIdentifiers == null ? new ArrayList<PartyTradeIdentifier.PartyTradeIdentifierBuilder>() : (List)tradeIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="effectiveDate", isRequired=true)
        @RuneAttribute(value="effectiveDate", isRequired=true)
        public DeClearBuilder setEffectiveDate(ZonedDateTime _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="reason")
        @RuneAttribute(value="reason")
        public DeClearBuilder setReason(DeclearReason _reason) {
            this.reason = _reason == null ? null : _reason.toBuilder();
            return this;
        }

        @Override
        public DeClear build() {
            return new DeClearImpl(this);
        }

        @Override
        public DeClearBuilder toBuilder() {
            return this;
        }

        @Override
        public DeClearBuilder prune() {
            this.tradeIdentifier = this.tradeIdentifier.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.reason != null && !this.reason.prune().hasData()) {
                this.reason = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getTradeIdentifier() != null && this.getTradeIdentifier().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getEffectiveDate() != null) {
                return true;
            }
            return this.getReason() != null && this.getReason().hasData();
        }

        public DeClearBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            DeClearBuilder o = (DeClearBuilder)other;
            merger.mergeRosetta(this.getTradeIdentifier(), o.getTradeIdentifier(), this::getOrCreateTradeIdentifier);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getReason(), (RosettaModelObjectBuilder)o.getReason(), this::setReason);
            merger.mergeBasic((Object)this.getEffectiveDate(), (Object)o.getEffectiveDate(), this::setEffectiveDate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            DeClear _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.tradeIdentifier, _that.getTradeIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            return Objects.equals(this.reason, _that.getReason());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.tradeIdentifier != null ? this.tradeIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.reason != null ? this.reason.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "DeClearBuilder {tradeIdentifier=" + this.tradeIdentifier + ", effectiveDate=" + this.effectiveDate + ", reason=" + this.reason + '}';
        }
    }

    public static interface DeClearBuilder
    extends DeClear,
    RosettaModelObjectBuilder {
        public PartyTradeIdentifier.PartyTradeIdentifierBuilder getOrCreateTradeIdentifier(int var1);

        public List<? extends PartyTradeIdentifier.PartyTradeIdentifierBuilder> getTradeIdentifier();

        public DeclearReason.DeclearReasonBuilder getOrCreateReason();

        @Override
        public DeclearReason.DeclearReasonBuilder getReason();

        public DeClearBuilder addTradeIdentifier(PartyTradeIdentifier var1);

        public DeClearBuilder addTradeIdentifier(PartyTradeIdentifier var1, int var2);

        public DeClearBuilder addTradeIdentifier(List<? extends PartyTradeIdentifier> var1);

        public DeClearBuilder setTradeIdentifier(List<? extends PartyTradeIdentifier> var1);

        public DeClearBuilder setEffectiveDate(ZonedDateTime var1);

        public DeClearBuilder setReason(DeclearReason var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("tradeIdentifier"), processor, PartyTradeIdentifier.PartyTradeIdentifierBuilder.class, this.getTradeIdentifier(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("reason"), processor, DeclearReason.DeclearReasonBuilder.class, this.getReason(), new AttributeMeta[0]);
        }

        public DeClearBuilder prune();
    }

    public static class DeClearImpl
    implements DeClear {
        private final List<? extends PartyTradeIdentifier> tradeIdentifier;
        private final ZonedDateTime effectiveDate;
        private final DeclearReason reason;

        protected DeClearImpl(DeClearBuilder builder) {
            this.tradeIdentifier = Optional.ofNullable(builder.getTradeIdentifier()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.effectiveDate = builder.getEffectiveDate();
            this.reason = Optional.ofNullable(builder.getReason()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="tradeIdentifier", isRequired=true)
        @RuneAttribute(value="tradeIdentifier", isRequired=true)
        public List<? extends PartyTradeIdentifier> getTradeIdentifier() {
            return this.tradeIdentifier;
        }

        @Override
        @RosettaAttribute(value="effectiveDate", isRequired=true)
        @RuneAttribute(value="effectiveDate", isRequired=true)
        public ZonedDateTime getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        @RosettaAttribute(value="reason")
        @RuneAttribute(value="reason")
        public DeclearReason getReason() {
            return this.reason;
        }

        @Override
        public DeClear build() {
            return this;
        }

        @Override
        public DeClearBuilder toBuilder() {
            DeClearBuilder builder = DeClear.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(DeClearBuilder builder) {
            Optional.ofNullable(this.getTradeIdentifier()).ifPresent(builder::setTradeIdentifier);
            Optional.ofNullable(this.getEffectiveDate()).ifPresent(builder::setEffectiveDate);
            Optional.ofNullable(this.getReason()).ifPresent(builder::setReason);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            DeClear _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.tradeIdentifier, _that.getTradeIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            return Objects.equals(this.reason, _that.getReason());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.tradeIdentifier != null ? this.tradeIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.reason != null ? this.reason.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "DeClear {tradeIdentifier=" + this.tradeIdentifier + ", effectiveDate=" + this.effectiveDate + ", reason=" + this.reason + '}';
        }
    }
}

