/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.confirmation.CommodityFixedPrice;
import fpml.confirmation.NonNegativeMoney;
import fpml.confirmation.SettlementPeriodsFixedPrice;
import fpml.confirmation.meta.CommodityFixedPriceModelChoiceMeta;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CommodityFixedPriceModelChoice", builder=CommodityFixedPriceModelChoiceBuilderImpl.class, version="0.17.2")
@RuneDataType(value="CommodityFixedPriceModelChoice", model="fpml", builder=CommodityFixedPriceModelChoiceBuilderImpl.class, version="0.17.2")
public interface CommodityFixedPriceModelChoice
extends RosettaModelObject {
    public static final CommodityFixedPriceModelChoiceMeta metaData = new CommodityFixedPriceModelChoiceMeta();

    public CommodityFixedPrice getFixedPrice();

    public BigDecimal getWorldscaleRate();

    public NonNegativeMoney getContractRate();

    public List<? extends SettlementPeriodsFixedPrice> getSettlementPeriodsPrice();

    public CommodityFixedPriceModelChoice build();

    public CommodityFixedPriceModelChoiceBuilder toBuilder();

    public static CommodityFixedPriceModelChoiceBuilder builder() {
        return new CommodityFixedPriceModelChoiceBuilderImpl();
    }

    default public RosettaMetaData<? extends CommodityFixedPriceModelChoice> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CommodityFixedPriceModelChoice> getType() {
        return CommodityFixedPriceModelChoice.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("fixedPrice"), processor, CommodityFixedPrice.class, this.getFixedPrice(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("worldscaleRate"), BigDecimal.class, (Object)this.getWorldscaleRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("contractRate"), processor, NonNegativeMoney.class, this.getContractRate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("settlementPeriodsPrice"), processor, SettlementPeriodsFixedPrice.class, this.getSettlementPeriodsPrice(), new AttributeMeta[0]);
    }

    public static class CommodityFixedPriceModelChoiceBuilderImpl
    implements CommodityFixedPriceModelChoiceBuilder {
        protected CommodityFixedPrice.CommodityFixedPriceBuilder fixedPrice;
        protected BigDecimal worldscaleRate;
        protected NonNegativeMoney.NonNegativeMoneyBuilder contractRate;
        protected List<SettlementPeriodsFixedPrice.SettlementPeriodsFixedPriceBuilder> settlementPeriodsPrice = new ArrayList<SettlementPeriodsFixedPrice.SettlementPeriodsFixedPriceBuilder>();

        @Override
        @RosettaAttribute(value="fixedPrice")
        @RuneAttribute(value="fixedPrice")
        public CommodityFixedPrice.CommodityFixedPriceBuilder getFixedPrice() {
            return this.fixedPrice;
        }

        @Override
        public CommodityFixedPrice.CommodityFixedPriceBuilder getOrCreateFixedPrice() {
            CommodityFixedPrice.CommodityFixedPriceBuilder result = this.fixedPrice != null ? this.fixedPrice : (this.fixedPrice = CommodityFixedPrice.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="worldscaleRate")
        @RuneAttribute(value="worldscaleRate")
        public BigDecimal getWorldscaleRate() {
            return this.worldscaleRate;
        }

        @Override
        @RosettaAttribute(value="contractRate")
        @RuneAttribute(value="contractRate")
        public NonNegativeMoney.NonNegativeMoneyBuilder getContractRate() {
            return this.contractRate;
        }

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateContractRate() {
            NonNegativeMoney.NonNegativeMoneyBuilder result = this.contractRate != null ? this.contractRate : (this.contractRate = NonNegativeMoney.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="settlementPeriodsPrice")
        @RuneAttribute(value="settlementPeriodsPrice")
        public List<? extends SettlementPeriodsFixedPrice.SettlementPeriodsFixedPriceBuilder> getSettlementPeriodsPrice() {
            return this.settlementPeriodsPrice;
        }

        @Override
        public SettlementPeriodsFixedPrice.SettlementPeriodsFixedPriceBuilder getOrCreateSettlementPeriodsPrice(int index) {
            if (this.settlementPeriodsPrice == null) {
                this.settlementPeriodsPrice = new ArrayList<SettlementPeriodsFixedPrice.SettlementPeriodsFixedPriceBuilder>();
            }
            return (SettlementPeriodsFixedPrice.SettlementPeriodsFixedPriceBuilder)this.getIndex(this.settlementPeriodsPrice, index, () -> {
                SettlementPeriodsFixedPrice.SettlementPeriodsFixedPriceBuilder newSettlementPeriodsPrice = SettlementPeriodsFixedPrice.builder();
                return newSettlementPeriodsPrice;
            });
        }

        @Override
        @RosettaAttribute(value="fixedPrice")
        @RuneAttribute(value="fixedPrice")
        public CommodityFixedPriceModelChoiceBuilder setFixedPrice(CommodityFixedPrice _fixedPrice) {
            this.fixedPrice = _fixedPrice == null ? null : _fixedPrice.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="worldscaleRate")
        @RuneAttribute(value="worldscaleRate")
        public CommodityFixedPriceModelChoiceBuilder setWorldscaleRate(BigDecimal _worldscaleRate) {
            this.worldscaleRate = _worldscaleRate == null ? null : _worldscaleRate;
            return this;
        }

        @Override
        @RosettaAttribute(value="contractRate")
        @RuneAttribute(value="contractRate")
        public CommodityFixedPriceModelChoiceBuilder setContractRate(NonNegativeMoney _contractRate) {
            this.contractRate = _contractRate == null ? null : _contractRate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementPeriodsPrice")
        @RuneAttribute(value="settlementPeriodsPrice")
        public CommodityFixedPriceModelChoiceBuilder addSettlementPeriodsPrice(SettlementPeriodsFixedPrice _settlementPeriodsPrice) {
            if (_settlementPeriodsPrice != null) {
                this.settlementPeriodsPrice.add(_settlementPeriodsPrice.toBuilder());
            }
            return this;
        }

        @Override
        public CommodityFixedPriceModelChoiceBuilder addSettlementPeriodsPrice(SettlementPeriodsFixedPrice _settlementPeriodsPrice, int idx) {
            this.getIndex(this.settlementPeriodsPrice, idx, () -> _settlementPeriodsPrice.toBuilder());
            return this;
        }

        @Override
        public CommodityFixedPriceModelChoiceBuilder addSettlementPeriodsPrice(List<? extends SettlementPeriodsFixedPrice> settlementPeriodsPrices) {
            if (settlementPeriodsPrices != null) {
                for (SettlementPeriodsFixedPrice settlementPeriodsFixedPrice : settlementPeriodsPrices) {
                    this.settlementPeriodsPrice.add(settlementPeriodsFixedPrice.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="settlementPeriodsPrice")
        public CommodityFixedPriceModelChoiceBuilder setSettlementPeriodsPrice(List<? extends SettlementPeriodsFixedPrice> settlementPeriodsPrices) {
            this.settlementPeriodsPrice = settlementPeriodsPrices == null ? new ArrayList<SettlementPeriodsFixedPrice.SettlementPeriodsFixedPriceBuilder>() : (List)settlementPeriodsPrices.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public CommodityFixedPriceModelChoice build() {
            return new CommodityFixedPriceModelChoiceImpl(this);
        }

        @Override
        public CommodityFixedPriceModelChoiceBuilder toBuilder() {
            return this;
        }

        @Override
        public CommodityFixedPriceModelChoiceBuilder prune() {
            if (this.fixedPrice != null && !this.fixedPrice.prune().hasData()) {
                this.fixedPrice = null;
            }
            if (this.contractRate != null && !this.contractRate.prune().hasData()) {
                this.contractRate = null;
            }
            this.settlementPeriodsPrice = this.settlementPeriodsPrice.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getFixedPrice() != null && this.getFixedPrice().hasData()) {
                return true;
            }
            if (this.getWorldscaleRate() != null) {
                return true;
            }
            if (this.getContractRate() != null && this.getContractRate().hasData()) {
                return true;
            }
            return this.getSettlementPeriodsPrice() != null && this.getSettlementPeriodsPrice().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public CommodityFixedPriceModelChoiceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CommodityFixedPriceModelChoiceBuilder o = (CommodityFixedPriceModelChoiceBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFixedPrice(), (RosettaModelObjectBuilder)o.getFixedPrice(), this::setFixedPrice);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getContractRate(), (RosettaModelObjectBuilder)o.getContractRate(), this::setContractRate);
            merger.mergeRosetta(this.getSettlementPeriodsPrice(), o.getSettlementPeriodsPrice(), this::getOrCreateSettlementPeriodsPrice);
            merger.mergeBasic((Object)this.getWorldscaleRate(), (Object)o.getWorldscaleRate(), this::setWorldscaleRate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CommodityFixedPriceModelChoice _that = this.getType().cast(o);
            if (!Objects.equals(this.fixedPrice, _that.getFixedPrice())) {
                return false;
            }
            if (!Objects.equals(this.worldscaleRate, _that.getWorldscaleRate())) {
                return false;
            }
            if (!Objects.equals(this.contractRate, _that.getContractRate())) {
                return false;
            }
            return ListEquals.listEquals(this.settlementPeriodsPrice, _that.getSettlementPeriodsPrice());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.fixedPrice != null ? this.fixedPrice.hashCode() : 0);
            _result = 31 * _result + (this.worldscaleRate != null ? this.worldscaleRate.hashCode() : 0);
            _result = 31 * _result + (this.contractRate != null ? this.contractRate.hashCode() : 0);
            _result = 31 * _result + (this.settlementPeriodsPrice != null ? this.settlementPeriodsPrice.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CommodityFixedPriceModelChoiceBuilder {fixedPrice=" + this.fixedPrice + ", worldscaleRate=" + this.worldscaleRate + ", contractRate=" + this.contractRate + ", settlementPeriodsPrice=" + this.settlementPeriodsPrice + '}';
        }
    }

    public static interface CommodityFixedPriceModelChoiceBuilder
    extends CommodityFixedPriceModelChoice,
    RosettaModelObjectBuilder {
        public CommodityFixedPrice.CommodityFixedPriceBuilder getOrCreateFixedPrice();

        @Override
        public CommodityFixedPrice.CommodityFixedPriceBuilder getFixedPrice();

        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateContractRate();

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getContractRate();

        public SettlementPeriodsFixedPrice.SettlementPeriodsFixedPriceBuilder getOrCreateSettlementPeriodsPrice(int var1);

        public List<? extends SettlementPeriodsFixedPrice.SettlementPeriodsFixedPriceBuilder> getSettlementPeriodsPrice();

        public CommodityFixedPriceModelChoiceBuilder setFixedPrice(CommodityFixedPrice var1);

        public CommodityFixedPriceModelChoiceBuilder setWorldscaleRate(BigDecimal var1);

        public CommodityFixedPriceModelChoiceBuilder setContractRate(NonNegativeMoney var1);

        public CommodityFixedPriceModelChoiceBuilder addSettlementPeriodsPrice(SettlementPeriodsFixedPrice var1);

        public CommodityFixedPriceModelChoiceBuilder addSettlementPeriodsPrice(SettlementPeriodsFixedPrice var1, int var2);

        public CommodityFixedPriceModelChoiceBuilder addSettlementPeriodsPrice(List<? extends SettlementPeriodsFixedPrice> var1);

        public CommodityFixedPriceModelChoiceBuilder setSettlementPeriodsPrice(List<? extends SettlementPeriodsFixedPrice> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("fixedPrice"), processor, CommodityFixedPrice.CommodityFixedPriceBuilder.class, this.getFixedPrice(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("worldscaleRate"), BigDecimal.class, (Object)this.getWorldscaleRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("contractRate"), processor, NonNegativeMoney.NonNegativeMoneyBuilder.class, this.getContractRate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("settlementPeriodsPrice"), processor, SettlementPeriodsFixedPrice.SettlementPeriodsFixedPriceBuilder.class, this.getSettlementPeriodsPrice(), new AttributeMeta[0]);
        }

        public CommodityFixedPriceModelChoiceBuilder prune();
    }

    public static class CommodityFixedPriceModelChoiceImpl
    implements CommodityFixedPriceModelChoice {
        private final CommodityFixedPrice fixedPrice;
        private final BigDecimal worldscaleRate;
        private final NonNegativeMoney contractRate;
        private final List<? extends SettlementPeriodsFixedPrice> settlementPeriodsPrice;

        protected CommodityFixedPriceModelChoiceImpl(CommodityFixedPriceModelChoiceBuilder builder) {
            this.fixedPrice = Optional.ofNullable(builder.getFixedPrice()).map(f -> f.build()).orElse(null);
            this.worldscaleRate = builder.getWorldscaleRate();
            this.contractRate = Optional.ofNullable(builder.getContractRate()).map(f -> f.build()).orElse(null);
            this.settlementPeriodsPrice = Optional.ofNullable(builder.getSettlementPeriodsPrice()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="fixedPrice")
        @RuneAttribute(value="fixedPrice")
        public CommodityFixedPrice getFixedPrice() {
            return this.fixedPrice;
        }

        @Override
        @RosettaAttribute(value="worldscaleRate")
        @RuneAttribute(value="worldscaleRate")
        public BigDecimal getWorldscaleRate() {
            return this.worldscaleRate;
        }

        @Override
        @RosettaAttribute(value="contractRate")
        @RuneAttribute(value="contractRate")
        public NonNegativeMoney getContractRate() {
            return this.contractRate;
        }

        @Override
        @RosettaAttribute(value="settlementPeriodsPrice")
        @RuneAttribute(value="settlementPeriodsPrice")
        public List<? extends SettlementPeriodsFixedPrice> getSettlementPeriodsPrice() {
            return this.settlementPeriodsPrice;
        }

        @Override
        public CommodityFixedPriceModelChoice build() {
            return this;
        }

        @Override
        public CommodityFixedPriceModelChoiceBuilder toBuilder() {
            CommodityFixedPriceModelChoiceBuilder builder = CommodityFixedPriceModelChoice.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CommodityFixedPriceModelChoiceBuilder builder) {
            Optional.ofNullable(this.getFixedPrice()).ifPresent(builder::setFixedPrice);
            Optional.ofNullable(this.getWorldscaleRate()).ifPresent(builder::setWorldscaleRate);
            Optional.ofNullable(this.getContractRate()).ifPresent(builder::setContractRate);
            Optional.ofNullable(this.getSettlementPeriodsPrice()).ifPresent(builder::setSettlementPeriodsPrice);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CommodityFixedPriceModelChoice _that = this.getType().cast(o);
            if (!Objects.equals(this.fixedPrice, _that.getFixedPrice())) {
                return false;
            }
            if (!Objects.equals(this.worldscaleRate, _that.getWorldscaleRate())) {
                return false;
            }
            if (!Objects.equals(this.contractRate, _that.getContractRate())) {
                return false;
            }
            return ListEquals.listEquals(this.settlementPeriodsPrice, _that.getSettlementPeriodsPrice());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.fixedPrice != null ? this.fixedPrice.hashCode() : 0);
            _result = 31 * _result + (this.worldscaleRate != null ? this.worldscaleRate.hashCode() : 0);
            _result = 31 * _result + (this.contractRate != null ? this.contractRate.hashCode() : 0);
            _result = 31 * _result + (this.settlementPeriodsPrice != null ? this.settlementPeriodsPrice.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CommodityFixedPriceModelChoice {fixedPrice=" + this.fixedPrice + ", worldscaleRate=" + this.worldscaleRate + ", contractRate=" + this.contractRate + ", settlementPeriodsPrice=" + this.settlementPeriodsPrice + '}';
        }
    }
}

